--[[
Extension for the 'FlieglMain' Specialization for the 1 Axle car trailer.

Author: Ifko[nator]
Date: 21.12.2015
Version: 1.0

History: v 1.0 @ 21.12.2015 - intial release

Website: http://www.modding-welt.com/index.php/BoardList
]]

FlieglMain_Extension_Car_Trailer_1Axle = {};

local currentModName = g_currentModName;

function FlieglMain_Extension_Car_Trailer_1Axle.prerequisitesPresent(specializations)
	if SpecializationUtil.hasSpecialization(FlieglMain, specializations) then
		return true;
	else
		print("[ERROR from the FlieglMain_Extension_Car_Trailer_1Axle.lua]: Missing the specialization 'FlieglMain' in '" .. currentModName .. "'. Script is stopped now!");
		return false;
	end;
end;

function FlieglMain_Extension_Car_Trailer_1Axle:load(xmlFile)
	self.spanngurt = {};
	
	self.spanngurt.transportboxen = {};
	self.spanngurt.transportboxen.box1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box1#index"));
	self.spanngurt.transportboxen.box2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box2#index"));
	
	self.spanngurt.siliermittelTanks = {};
	self.spanngurt.siliermittelTanks.tank1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank1#index"));
	self.spanngurt.siliermittelTanks.tank2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank2#index"));

	self.antirutschmatte = {};
	
	self.antirutschmatte.BM_ModdingPaletten = {};
	self.antirutschmatte.BM_ModdingPaletten.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette1#index"));
	self.antirutschmatte.BM_ModdingPaletten.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette2#index"));
	
	self.gitterBM_ModdingPaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten#gitterIndex"));
	
	self.antirutschmatte.standardPaletten = {};
	self.antirutschmatte.standardPaletten.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette1#index"));
	self.antirutschmatte.standardPaletten.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette2#index"));
	
	self.gitterStandardPaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten#gitterIndex"));
	
	self.antirutschmatte.verbrauchsgueter = {};
	self.antirutschmatte.verbrauchsgueter.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette1#index"));
	self.antirutschmatte.verbrauchsgueter.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette2#index"));
end;

function FlieglMain_Extension_Car_Trailer_1Axle:delete()
end;

function FlieglMain_Extension_Car_Trailer_1Axle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FlieglMain_Extension_Car_Trailer_1Axle:keyEvent(unicode, sym, modifier, isDown)
end;

function FlieglMain_Extension_Car_Trailer_1Axle:update(dt)
end;

function FlieglMain_Extension_Car_Trailer_1Axle:updateTick(dt)
	--## set help line's for the different product's 
	if self.choosenProductType[self.productType][1] == g_i18n:getText("WOOLPALLET") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BUYABLE_BLADES")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("CONSUMPTION_GOODS")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("PALLET")
	then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 2 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.28, 0, 0.82);
			setTranslation(self.helpLineLeftStart2, 2.72, 0, 0.82);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.28, 0, 0.82); 
			setTranslation(self.helpLineRightStart2, -2.72, 0, 0.82);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 0.73, 0, -2.18);
			setTranslation(self.helpLineBackEnd2, -0.73, 0, -2.18);
		else
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.28, 0, -0.58);
			setTranslation(self.helpLineLeftStart2, 2.72, 0, -0.58);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.28, 0, -0.58); 
			setTranslation(self.helpLineRightStart2, -2.72, 0, -0.58);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 0.73, 0, -3.58);
			setTranslation(self.helpLineBackEnd2, -0.73, 0, -3.58);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.28, 0, 1.98);
		setTranslation(self.helpLineLeftEnd2, 2.72, 0, 1.98);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.28, 0, 1.98);
		setTranslation(self.helpLineRightEnd2, -2.72, 0, 1.98);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 0.73, 0, -1.02);
		setTranslation(self.helpLineBackStart2, -0.73, 0, -1.02);
		
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_PALLETS") then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 2 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.25, 0, 0.9);
			setTranslation(self.helpLineLeftStart2, 2.75, 0, 0.9);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.25, 0, 0.9); 
			setTranslation(self.helpLineRightStart2, -2.75, 0, 0.9);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.21, 0, -2.12);
			setTranslation(self.helpLineBackEnd2, -1.21, 0, -2.12);
		else
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.25, 0, -0.5);
			setTranslation(self.helpLineLeftStart2, 2.75, 0, -0.5);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.25, 0, -0.5); 
			setTranslation(self.helpLineRightStart2, -2.75, 0, -0.5);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.21, 0, -3.5);
			setTranslation(self.helpLineBackEnd2, -1.21, 0, -3.5);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.25, 0, 1.92);
		setTranslation(self.helpLineLeftEnd2, 2.75, 0, 1.92);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.25, 0, 1.92);
		setTranslation(self.helpLineRightEnd2, -2.75, 0, 1.92);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.21, 0, -1.1);
		setTranslation(self.helpLineBackStart2, -1.21, 0, -1.1);

	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("TRANSPORTBOX") then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 2 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.14, 0, 0.7);
			setTranslation(self.helpLineLeftStart2, 2.87, 0, 0.7);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.14, 0, 0.7); 
			setTranslation(self.helpLineRightStart2, -2.87, 0, 0.7);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 0.87, 0, -2.27);
			setTranslation(self.helpLineBackEnd2, -0.87, 0, -2.27);
		else
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.14, 0, -0.7);
			setTranslation(self.helpLineLeftStart2, 2.87, 0, -0.7);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.14, 0, -0.7); 
			setTranslation(self.helpLineRightStart2, -2.87, 0, -0.7);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 0.87, 0, -3.7);
			setTranslation(self.helpLineBackEnd2, -0.87, 0, -3.7);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.14, 0, 2.03);
		setTranslation(self.helpLineLeftEnd2, 2.87, 0, 2.03);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.14, 0, 2.03);
		setTranslation(self.helpLineRightEnd2, -2.87, 0, 2.03);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 0.87, 0, -0.97);
		setTranslation(self.helpLineBackStart2, -0.87, 0, -0.97); 
		
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("SILAGE_ADDITIVES_TANK") then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 2 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.175, 0, 0.73);
			setTranslation(self.helpLineLeftStart2, 2.72, 0, 0.73);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.175, 0, 0.73); 
			setTranslation(self.helpLineRightStart2, -2.72, 0, 0.73);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 0.73, 0, -2.25);
			setTranslation(self.helpLineBackEnd2, -0.83, 0, -2.25);
		else
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.175, 0, -0.66);
			setTranslation(self.helpLineLeftStart2, 2.72, 0, -0.66);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.715, 0, -0.66); 
			setTranslation(self.helpLineRightStart2, -2.72, 0, -0.66);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 0.73, 0, -3.66);
			setTranslation(self.helpLineBackEnd2, -0.83, 0, -3.66);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.175, 0, 2.05);
		setTranslation(self.helpLineLeftEnd2, 2.72, 0, 2.05);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.175, 0, 2.05);
		setTranslation(self.helpLineRightEnd2, -2.72, 0, 2.05);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 0.73, 0, -0.95);
		setTranslation(self.helpLineBackStart2, -0.83, 0, -0.95);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("TRANSPORTBOX") then
		setVisibility(self.spanngurt.transportboxen.box1, self.fillLevel == 1);
		setVisibility(self.spanngurt.transportboxen.box2, self.fillLevel == 2);
	else
		setVisibility(self.spanngurt.transportboxen.box1, false);
		setVisibility(self.spanngurt.transportboxen.box2, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("SILAGE_ADDITIVES_TANK") then
		setVisibility(self.spanngurt.siliermittelTanks.tank1, self.fillLevel == 1);
		setVisibility(self.spanngurt.siliermittelTanks.tank2, self.fillLevel == 2);
	else
		setVisibility(self.spanngurt.siliermittelTanks.tank1, false);
		setVisibility(self.spanngurt.siliermittelTanks.tank2, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_PALLETS") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BUYABLE_BLADES")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("CONSUMPTION_GOODS")
	then
		if self.currentUnloadSide[self.unloadSide][1] == g_i18n:getText("UNLOAD_TRAILER") then
			if self.fillLevel > 0 then
				setVisibility(self.gitterBM_ModdingPaletten, true);
			else
				setVisibility(self.gitterBM_ModdingPaletten, false);
			end;
		else	
			setVisibility(self.gitterBM_ModdingPaletten, true);
		end;
	else
		setVisibility(self.gitterBM_ModdingPaletten, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_PALLETS") then
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette1, self.fillLevel == 1);
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette2, self.fillLevel == 2);
	else
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette1, false);
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette2, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("WOOLPALLET") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BUYABLE_BLADES")
	then
		setVisibility(self.antirutschmatte.standardPaletten.palette1, self.fillLevel == 1);
		setVisibility(self.antirutschmatte.standardPaletten.palette2, self.fillLevel == 2);
	else
		setVisibility(self.antirutschmatte.standardPaletten.palette1, false);
		setVisibility(self.antirutschmatte.standardPaletten.palette2, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("CONSUMPTION_GOODS") then
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette1, self.fillLevel == 1);
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette2, self.fillLevel == 2);
	else
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette1, false);
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette2, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("WOOLPALLET") then
		if self.currentUnloadSide[self.unloadSide][1] == g_i18n:getText("UNLOAD_TRAILER") then
			setVisibility(self.gitterStandardPaletten, self.fillLevel > 0);
		else	
			setVisibility(self.gitterStandardPaletten, true);
		end;
	else
		setVisibility(self.gitterStandardPaletten, false);
	end;
end;

function FlieglMain_Extension_Car_Trailer_1Axle:draw()
end;