WeightStation = {}
WeightStation.modDir = g_currentModDirectory
WeightStation_mt = Class(WeightStation)
weightSOV = {}
weightSOV.modDir = g_currentModDirectory
weightSOVEvent = {}
weightSOVEvent_mt = Class(weightSOVEvent, Event)
weightSyncRequest = {}
weightSyncRequest_mt = Class(weightSyncRequest, Event)
weightStationSyncEvent = {}
weightStationSyncEvent_mt = Class(weightStationSyncEvent, Event)
InitEventClass(weightStationSyncEvent, "weightStationSyncEvent")
InitEventClass(weightSOVEvent, "weightSOVEvent")
InitEventClass(weightSyncRequest, "weightSyncRequest")
local timerDef = 70

function weightSOV:loadMap(name)
  g_currentMission.weightSOVActive = -1
  self.weightSOV_hud = createImageOverlay(Utils.getFilename("WageFrameSOV.dds", g_currentMission.weightStationHudPath))
  self.weightSOVw = 0.26
  self.weightSOVH = 0.55
  self.weightSOVX = 0.37
  self.weightSOVY = 0.3
  self.weightSOVUser = {}
  self.weightSOVtmr = 0
  g_currentMission.weightSOVlastUser = 0
  g_currentMission.weightSOVPage = 0
  g_currentMission.weightSOVReset = false
  g_currentMission.weightRequestCheck = 0
  self.lastUserCount = Utils.getNoNil(table.getn(g_currentMission.users), 1)
end
function weightSOV:deleteMap()
end
function weightSOV:readStream(streamId, connection)
  self.mustReset = streamReadBool(streamId)
end
function weightSOV:writeStream(streamId, connection)
  streamWriteBool(streamId, self.mustReset)
end
function weightSOV:mouseEvent(posX, posY, isDown, isUp, button)
end
function weightSOV:keyEvent(unicode, sym, modifier, isDown)
end
function weightSOV:update(dt)
  if InputBinding.hasEvent(InputBinding.MAPWEIGHTSTATION_SHOWOVERVIEW) then
    g_currentMission.weightSOVActive = g_currentMission.weightSOVActive + 1
    if g_currentMission.weightSOVActive > 0 then
      g_currentMission.weightSOVlastUser = g_currentMission.weightSOVlastUser + 1
      if g_currentMission.weightSOVlastUser > table.getn(self.weightSOVUser) then
        g_currentMission.weightSOVActive = -1
        g_currentMission.weightSOVPage = 0
      end
    end
  end
  if InputBinding.hasEvent(InputBinding.MAPWEIGHTSTATION_SHOWOVERVIEW_CLOSE) then
    g_currentMission.weightSOVActive = -1
    g_currentMission.weightSOVPage = 0
  end
  if g_currentMission.weightSOVReset then
    g_currentMission.weightSOVReset = false
    for j = 1, table.getn(g_currentMission.WeightStation) do
      if 0 < g_currentMission.WeightStation[j].playerCount then
        g_currentMission.WeightStation[j].playerCount = 0
        g_currentMission.WeightStation[j].player = {}
      end
    end
    g_currentMission.weightSOVlastUser = 0
    if g_currentMission.weightSOVActive > -1 then
      g_currentMission.weightSOVActive = 0
      g_currentMission.weightSOVPage = 0
    end
  end
  if InputBinding.hasEvent(InputBinding.MAPWEIGHTSTATION_RESET) then
    g_currentMission.weightSOVReset = true
    if g_server ~= nil and g_currentMission.missionDynamicInfo.isMultiplayer then
      g_server:broadcastEvent(weightSOVEvent:new(g_currentMission.weightSOVReset))
    else
      g_client:getServerConnection():sendEvent(weightSOVEvent:new(g_currentMission.weightSOVReset))
    end
  end
  if g_currentMission.weightSOVActive > -1 and self.weightSOVtmr == 0 then
    self.weightSOVtmr = 30
    self.weightSOVUser = {}
    local usr = 0
    if g_currentMission.WeightStation ~= nil then
      for j = 1, table.getn(g_currentMission.WeightStation) do
        if 0 < g_currentMission.WeightStation[j].playerCount then
          local wage = g_i18n:getText(g_currentMission.WeightStation[j].name)
          for k = 1, g_currentMission.WeightStation[j].playerCount do
            local name = g_currentMission.WeightStation[j].player[k].name
            local weight = g_currentMission.WeightStation[j].player[k].weight
            local insertUsr = true
            if 0 < table.getn(self.weightSOVUser) then
              for a = 1, table.getn(self.weightSOVUser) do
                if self.weightSOVUser[a].name == name then
                  insertUsr = false
                  self.weightSOVUser[a].weight = weight + self.weightSOVUser[a].weight
                  local newWage = table.getn(self.weightSOVUser[a].wage) + 1
                  self.weightSOVUser[a].wage[newWage] = {}
                  self.weightSOVUser[a].wage[newWage].name = wage
                  self.weightSOVUser[a].wage[newWage].weight = weight
                end
              end
            end
            if insertUsr then
              usr = usr + 1
              self.weightSOVUser[usr] = {}
              self.weightSOVUser[usr].name = name
              self.weightSOVUser[usr].weight = weight
              self.weightSOVUser[usr].wage = {}
              self.weightSOVUser[usr].wage[1] = {}
              self.weightSOVUser[usr].wage[1].name = wage
              self.weightSOVUser[usr].wage[1].weight = weight
            end
          end
        end
      end
    end
  elseif g_currentMission.weightSOVActive > -1 then
    self.weightSOVtmr = self.weightSOVtmr - 1
  else
    self.weightSOVtmr = 0
    g_currentMission.weightSOVlastUser = 0
  end
end
function weightSOV:updateTick(dt)
end
function weightSOV:draw()
  if g_currentMission.weightSOVActive > -1 then
    renderOverlay(self.weightSOV_hud, self.weightSOVX, self.weightSOVY, self.weightSOVw, self.weightSOVH)
    local plyOverall = 0
    local yPos = 0.764
    local xPos = 0.398
    local tSize = 0.016
    setTextBold(false)
    setTextAlignment(RenderText.ALIGN_CENTER)
    setTextColor(1, 1, 0.6, 1)
    local maxPages = math.ceil(Utils.getNoNil(table.getn(self.weightSOVUser), 1) / 12)
    if g_currentMission.weightSOVActive > 0 and maxPages > g_currentMission.weightSOVPage then
      g_currentMission.weightSOVActive = 0
      g_currentMission.weightSOVPage = g_currentMission.weightSOVPage + 1
    end
    if g_currentMission.weightSOVActive == 0 then
      renderText(xPos + 0.095, yPos, tSize + 0.002, g_i18n:getText("wage_string4"))
      yPos = yPos - 0.07
      setTextColor(0.5, 1, 0.5, 1)
      if 0 >= g_currentMission.weightSOVPage then
        g_currentMission.weightSOVPage = 1
      end
      local startUser = math.max(g_currentMission.weightSOVPage - 1, 0) * 12 + 1
      local lastUser = startUser + 11
      if lastUser > table.getn(self.weightSOVUser) then
        lastUser = table.getn(self.weightSOVUser)
      end
      for j = startUser, lastUser do
        setTextAlignment(RenderText.ALIGN_LEFT)
        renderText(xPos, yPos, tSize, "-> " .. self.weightSOVUser[j].name)
        setTextAlignment(RenderText.ALIGN_RIGHT)
        renderText(xPos + 0.2, yPos, tSize, tostring(math.floor(self.weightSOVUser[j].weight / 100) / 10) .. " t")
        yPos = yPos - 0.025
      end
      g_currentMission.weightSOVlastUser = 0
    else
      renderText(xPos + 0.095, yPos, tSize + 0.002, string.format(g_i18n:getText("wage_string5"), self.weightSOVUser[g_currentMission.weightSOVlastUser].name .. " (" .. tostring(g_currentMission.weightSOVlastUser) .. " / " .. tostring(table.getn(self.weightSOVUser)) .. ")"))
      yPos = yPos - 0.07
      setTextColor(0.5, 1, 0.5, 1)
      for j = 1, table.getn(self.weightSOVUser[g_currentMission.weightSOVlastUser].wage) do
        setTextAlignment(RenderText.ALIGN_LEFT)
        renderText(xPos, yPos, tSize, "-> " .. self.weightSOVUser[g_currentMission.weightSOVlastUser].wage[j].name)
        setTextAlignment(RenderText.ALIGN_RIGHT)
        renderText(xPos + 0.2, yPos, tSize, tostring(math.floor(self.weightSOVUser[g_currentMission.weightSOVlastUser].wage[j].weight / 100) / 10) .. " t")
        yPos = yPos - 0.025
      end
      setTextColor(1, 1, 0.6, 1)
      yPos = yPos - 0.025
      setTextAlignment(RenderText.ALIGN_LEFT)
      renderText(xPos, yPos, tSize, " == " .. self.weightSOVUser[g_currentMission.weightSOVlastUser].name)
      setTextAlignment(RenderText.ALIGN_RIGHT)
      renderText(xPos + 0.2, yPos, tSize, tostring(math.floor(self.weightSOVUser[g_currentMission.weightSOVlastUser].weight / 100) / 10) .. " t")
    end
    setTextColor(1, 1, 1, 1)
    setTextAlignment(RenderText.ALIGN_LEFT)
  end
end
function WeightStation.onCreate(id)
  g_currentMission:addUpdateable(WeightStation:new(id))
end
function WeightStation:new(id, customMt)
  local instance = {}
  if customMt ~= nil then
    setmetatable(instance, customMt)
  else
    setmetatable(instance, WeightStation_mt)
  end
  instance.triggerId = id
  instance.triggerId = id
  addTrigger(id, "triggerCallback", instance)
  local name = getUserAttribute(id, "name")
  if g_currentMission.WeightStation == nil then
    g_currentMission.WeightStation = {}
  end
  table.insert(g_currentMission.WeightStation, self)
  local stationId = table.getn(g_currentMission.WeightStation)
  g_currentMission.WeightStation[stationId] = {}
  g_currentMission.WeightStation[stationId].id = id
  g_currentMission.WeightStation[stationId].showHud = false
  g_currentMission.WeightStation[stationId].name = name
  g_currentMission.WeightStation[stationId].overallWeight = 0
  g_currentMission.WeightStation[stationId].playerCount = 0
  g_currentMission.WeightStation[stationId].player = {}
  local x, y, z = getWorldTranslation(id)
  if x < 0 then
    x = 0 - x
  end
  if y < 0 then
    y = 0 - y
  end
  if z < 0 then
    z = 0 - z
  end
  local sId = math.floor(x * 100) + math.floor(y * 100) + math.floor(z * 100)
  sId = math.floor(sId * 3.5)
  g_currentMission.WeightStation[stationId].sId = sId
  g_currentMission.WeightStation[stationId].requestSend = false
  local savegameIndex = g_currentMission.missionInfo.savegameIndex;
  local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
  if savegameFolderPath == nil then
		savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), savegameIndex);
  end;
  if fileExists(savegameFolderPath .. '/careerSavegame.xml') then -- savegame isn't corrupted and has been saved correctly
		local name = "WeightStation";
	if fileExists(savegameFolderPath .. '/WeightStation.xml') then
		--print("WeightStation:: loading "..savegameFolderPath .. '/WeightStation.xml')
	local xml = loadXMLFile("WeightStation", savegameFolderPath .. "/WeightStation.xml", name);
	local tmax = table.getn(g_currentMission.WeightStation)
    local statName
    for k = 1, tmax do
      statName = g_currentMission.WeightStation[k].name
      g_currentMission.WeightStation[k].overallWeight = Utils.getNoNil(getXMLFloat(xml, "WeightStation." .. tostring(statName) .. ".overallWeight"), 0)
      g_currentMission.WeightStation[k].playerCount = Utils.getNoNil(getXMLInt(xml, "WeightStation." .. tostring(statName) .. ".playerCount"), 0)
      if 0 < g_currentMission.WeightStation[k].playerCount then
        for i = 1, g_currentMission.WeightStation[k].playerCount do
          table.insert(g_currentMission.WeightStation[k].player, i)
          g_currentMission.WeightStation[k].player[i] = {}
          g_currentMission.WeightStation[k].player[i].name = Utils.getNoNil(getXMLString(xml, "WeightStation." .. tostring(statName) .. ".player" .. i .. ".name"), "Unknown")
          g_currentMission.WeightStation[k].player[i].weight = Utils.getNoNil(getXMLFloat(xml, "WeightStation." .. tostring(statName) .. ".player" .. i .. ".weight"), 0)
        end
      end
    
	end
	
    delete(xml)
	end
 end
  local gcM = g_currentMission.WeightStation[stationId]
  gcM.warnMessage = nil
  gcM.showWarn = false
  gcM.timerSet = 0
  gcM.timerCnt = 0
  gcM.sumMass = 0
  gcM.sumMass2 = 0
  gcM.zwMass = 0
  gcM.playerName = nil
  gcM.senke = {}
  gcM.senke.index = nil
  gcM.senke.weight = 0
  gcM.senke.weightOld = 0
  sIdx = getUserAttribute(gcM.id, "senkeIndex")
  if sIdx ~= nil then
    gcM.senke.index = Utils.indexToObject(gcM.id, sIdx)
    gcM.senke.max = Utils.getNoNil(getUserAttribute(gcM.id, "senkeMax"), 0.13)
    gcM.senke.min = Utils.getNoNil(getUserAttribute(gcM.id, "senkeMin"), 0)
  end
  gcM.digits = {}
  gcM.digits[1] = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "digit1"))
  gcM.digits[2] = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "digit2"))
  gcM.digits[3] = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "digit3"))
  gcM.digits[4] = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "digit4"))
  gcM.digits[5] = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "digit5"))
  gcM.digitPosition = {}
  gcM.digitPosition["0"] = -1
  gcM.digitPosition["1"] = -0.105
  gcM.digitPosition["2"] = -0.208
  gcM.digitPosition["3"] = -0.306
  gcM.digitPosition["4"] = -0.41
  gcM.digitPosition["5"] = -0.517
  gcM.digitPosition["6"] = -0.613
  gcM.digitPosition["7"] = -0.719
  gcM.digitPosition["8"] = -0.817
  gcM.digitPosition["9"] = -0.926
  gcM.lights = {}
  gcM.lights[1] = {}
  gcM.lights[1].red = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "Ampel1Red"))
  gcM.lights[1].yellow = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "Ampel1Yellow"))
  gcM.lights[1].green = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "Ampel1Green"))
  gcM.lights[2] = {}
  gcM.lights[2].red = Utils.indexToObject(id, getUserAttribute(gcM.id, "Ampel2Red"))
  gcM.lights[2].yellow = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "Ampel2Yellow"))
  gcM.lights[2].green = Utils.indexToObject(gcM.id, getUserAttribute(gcM.id, "Ampel2Green"))
  gcM.vehiclesInTrigger = {}
  instance.stationId = 0
  instance.requestTimer = 30
  instance.isEnabled = true
  return instance
end

function WeightStation:delete()
  removeTrigger(self.triggerId)
end
function WeightStation:update(dt)
  --g_currentMission.hudWarningBaseOverlay.y = 0.885
  --g_currentMission.hudWarningBaseOverlay.x = 0.435
  --g_currentMission.hudWarningBasePosY = 0.9
  --g_currentMission.hudWarningBasePosX = 0.41
  g_currentMission.hudWarningBaseOverlay.y = 0.4075
  g_currentMission.hudWarningBaseOverlay.x = 0.3125
  g_currentMission.hudWarningBasePosY = 0.4575
  g_currentMission.hudWarningBasePosX = 0.3055
  if self.stationId == nil or self.stationId ~= nil and self.stationId == 0 then
    local tmax = table.getn(g_currentMission.WeightStation)
    for i = 1, tmax do
      if g_currentMission.WeightStation[i] ~= nil and g_currentMission.WeightStation[i].id == self.triggerId then
        self.stationId = i
      end
    end
  end
  local gcM = g_currentMission.WeightStation[self.stationId]
  if g_currentMission.missionDynamicInfo.isMultiplayer then
    if g_server ~= nil then
      if 0 < g_currentMission.weightRequestCheck and gcM.requestSend then
        g_currentMission.weightRequestCheck = g_currentMission.weightRequestCheck - 1
        gcM.requestSend = false
        local dataP = ""
        local dataW = ""
        for i = 1, gcM.playerCount do
          dataP = dataP .. gcM.player[i].name .. ";"
          dataW = dataW .. gcM.player[i].weight .. ";"
        end
        g_server:broadcastEvent(weightStationSyncEvent:new(gcM.sId, gcM.overallWeight, gcM.playerCount, dataP, dataW))
      end
    elseif self.requestTimer == 0 then
      self.requestTimer = -1
      g_client:getServerConnection():sendEvent(weightSyncRequest:new(gcM.sId))
    elseif 0 < self.requestTimer then
      self.requestTimer = self.requestTimer - 1
    end
  end
  if gcM.senke.weight ~= gcM.senke.weightOld then
    local yChange = (gcM.senke.max - gcM.senke.min) / 100
    local wChange = gcM.senke.weight / 100
    local x, y, z = getTranslation(gcM.senke.index)
    local posy = gcM.senke.max - (gcM.senke.max - gcM.senke.min) / 120 * gcM.senke.weight
    if gcM.senke.weight > gcM.senke.weightOld then
      y = y - yChange
      gcM.senke.weightOld = gcM.senke.weightOld + wChange
      if posy < y then
        posy = y
      end
    elseif gcM.senke.weight < gcM.senke.weightOld then
      y = y + yChange
      gcM.senke.weightOld = gcM.senke.weightOld - wChange
      if posy > y then
        posy = y
      end
    end
    if posy < gcM.senke.min then
      posy = gcM.senke.min
      gcM.senke.weightOld = gcM.senke.weight
    elseif posy > gcM.senke.max then
      posy = gcM.senke.max
      gcM.senke.weightOld = gcM.senke.weight
    end
    setTranslation(gcM.senke.index, x, posy, z)
  end
  local schowMe = false
  if self.isEnabled then
    if gcM.timerSet == 0 then
      setVisibility(gcM.lights[2].red, false)
      setVisibility(gcM.lights[2].yellow, false)
      setVisibility(gcM.lights[2].green, false)
      setVisibility(gcM.lights[1].red, false)
      setVisibility(gcM.lights[1].yellow, false)
      setVisibility(gcM.lights[1].green, true)
    elseif gcM.timerSet == 1 then
      setVisibility(gcM.lights[2].red, true)
      setVisibility(gcM.lights[2].yellow, false)
      setVisibility(gcM.lights[2].green, false)
      setVisibility(gcM.lights[1].red, false)
      setVisibility(gcM.lights[1].yellow, true)
      setVisibility(gcM.lights[1].green, false)
    elseif gcM.timerSet == 2 then
      setVisibility(gcM.lights[2].red, true)
      setVisibility(gcM.lights[2].yellow, true)
      setVisibility(gcM.lights[2].green, false)
      setVisibility(gcM.lights[1].red, true)
      setVisibility(gcM.lights[1].yellow, false)
      setVisibility(gcM.lights[1].green, false)
    elseif gcM.timerSet == 4 then
      setVisibility(gcM.lights[2].red, false)
      setVisibility(gcM.lights[2].yellow, true)
      setVisibility(gcM.lights[2].green, false)
      setVisibility(gcM.lights[1].red, true)
      setVisibility(gcM.lights[1].yellow, true)
      setVisibility(gcM.lights[1].green, false)
    elseif gcM.timerSet == 3 then
      setVisibility(gcM.lights[2].red, false)
      setVisibility(gcM.lights[2].yellow, false)
      setVisibility(gcM.lights[2].green, true)
      setVisibility(gcM.lights[1].red, false)
      setVisibility(gcM.lights[1].yellow, true)
      setVisibility(gcM.lights[1].green, false)
    end
    if 1 <= gcM.timerSet then
      gcM.showHud = true
      if gcM.timerSet == 2 or gcM.timerSet == 4 then
        if gcM.timerSet == 2 then
          gcM.zwMass = gcM.sumMass
          if gcM.timerCnt < timerDef * 0.9 then
            gcM.zwMass = math.random(gcM.sumMass - gcM.sumMass / gcM.timerCnt, gcM.sumMass + gcM.sumMass / gcM.timerCnt)
          end
        elseif gcM.timerSet == 4 then
          if gcM.timerCnt < timerDef * 0.9 then
            local diff = gcM.zwMass - gcM.sumMass2
            local fac = timerDef * 0.91 - gcM.timerCnt
            gcM.zwMass = gcM.zwMass - diff / fac
          else
            gcM.zwMass = gcM.sumMass2
          end
        end
        if gcM.timerSet == 2 then
          gcM.showWarn = true
          gcM.warnMessage = g_i18n:getText("wage_warn1")
        elseif gcM.timerSet == 4 then
          gcM.showWarn = true
          gcM.warnMessage = g_i18n:getText("wage_warn2")
        end
        if math.random(1, 10) > 6 then
          schowMe = true
        end
        if schowMe == true then
          self:setDigitNumbers(gcM.zwMass)
        end
        if gcM.timerCnt >= timerDef then
          if gcM.timerSet == 2 then
            gcM.zwMass = gcM.sumMass
            gcM.timerSet = 4
          elseif gcM.timerSet == 4 then
            gcM.zwMass = gcM.sumMass2
            gcM.sumMass = gcM.sumMass2
            gcM.timerSet = 3
            gcM.warnMessage = g_i18n:getText("wage_ready")
          end
          gcM.timerCnt = 0
          gcM.showWarn = true
          self:setDigitNumbers(gcM.zwMass)
        else
          gcM.timerCnt = gcM.timerCnt + 1
        end
      elseif gcM.timerSet == 3 then
        if 0 < gcM.zwMass then
          mustAdded = true
          gcM.overallWeight = gcM.overallWeight + gcM.sumMass
          if 0 < gcM.playerCount then
            for x = 1, gcM.playerCount do
              if gcM.playerName == gcM.player[x].name then
                mustAdded = false
                gcM.player[x].name = gcM.playerName
                gcM.player[x].weight = gcM.player[x].weight + gcM.sumMass
              end
            end
          end
          if mustAdded == true then
            local cnt = gcM.playerCount + 1
            gcM.playerCount = cnt
            table.insert(gcM.player, cnt)
            gcM.player[cnt] = {}
            gcM.player[cnt].name = gcM.playerName
            gcM.player[cnt].weight = gcM.sumMass
          end
          gcM.zwMass = 0
        end
        if table.getn(gcM.vehiclesInTrigger) == nil or table.getn(gcM.vehiclesInTrigger) == 0 then
          gcM.timerSet = 0
          gcM.sumMass = 0
          gcM.sumMass2 = 0
          self:setDigitNumbers(gcM.sumMass)
          gcM.senke.weight = 0
          gcM.showWarn = false
          weightStationSyncEvent:new(gcM.name, gcM.overallWeight, gcM.playerCount, gcM.player)
        end
      end
      if table.getn(gcM.vehiclesInTrigger) ~= nil and 0 < table.getn(gcM.vehiclesInTrigger) then
        for i = 1, table.getn(gcM.vehiclesInTrigger) do
          local vehicle = g_currentMission.nodeToVehicle[gcM.vehiclesInTrigger[i]]
          if vehicle ~= nil then
            if SpecializationUtil.hasSpecialization(Steerable, vehicle.specializations) then
              gcM.playerName = vehicle.controllerName
              if gcM.timerSet ~= 3 then
                local lSpeed = vehicle.lastSpeed * 3600
                if lSpeed <= 0.5 then
                  if gcM.timerSet == 1 then
                    gcM.timerSet = 2
                  end
                else
                  gcM.sumMass = 0
                  gcM.sumMass2 = 0
                  gcM.timerSet = 1
                  gcM.timerCnt = 0
                end
              end
            end
            if gcM.timerSet == 2 and gcM.timerCnt == 1 then
              local mass = 0
              for g, component in pairs(vehicle.components) do
                local vehMass = getMass(component.node)
                mass = mass + vehMass
              end
              gcM.sumMass = gcM.sumMass + mass * 1000
              if SpecializationUtil.hasSpecialization(Fillable, vehicle.specializations) then
                local tttmp = vehicle.fillLevel * (vehicle.massPerLiter or 0) * 1000 * (10 / g_currentMission.fruitWeightFactor)				
                gcM.sumMass = gcM.sumMass + tttmp
                gcM.sumMass2 = gcM.sumMass2 + tttmp
              end
            end
          end
        end
      else
        gcM.timerSet = 0
        gcM.timerCnt = 0
        gcM.showWarn = false
        gcM.sumMass = 0
        gcM.sumMass2 = 0
        gcM.zwMass = 0
        schowMe = false
        self:setDigitNumbers(gcM.sumMass)
      end
    else
      gcM.showHud = false
      gcM.timerSet = 0
      gcM.timerCnt = 0
      gcM.showWarn = false
      gcM.sumMass = 0
      gcM.sumMass2 = 0
      gcM.zwMass = 0
      schowMe = false
      self:setDigitNumbers(gcM.sumMass)
    end
  end
end
function WeightStation:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  local gcM = g_currentMission.WeightStation[self.stationId]
  if self.isEnabled then
    if onEnter then
      local doInsert = true
      if table.getn(gcM.vehiclesInTrigger) ~= nil and table.getn(gcM.vehiclesInTrigger) > 0 then
        for i = 1, table.getn(gcM.vehiclesInTrigger) do
          if gcM.vehiclesInTrigger[i] == otherId then
            doInsert = false
          elseif gcM.vehiclesInTrigger[i] ~= nil and otherId ~= nil and g_currentMission.nodeToVehicle[gcM.vehiclesInTrigger[i]] ~= nil and g_currentMission.nodeToVehicle[otherId] ~= nil and g_currentMission.nodeToVehicle[gcM.vehiclesInTrigger[i]].componentJoints[1] == g_currentMission.nodeToVehicle[otherId].componentJoints[1] and g_currentMission.nodeToVehicle[gcM.vehiclesInTrigger[i]].modName == g_currentMission.nodeToVehicle[otherId].modName then
            doInsert = false
          end
        end
      end
      if doInsert == true then
        local vehicle = g_currentMission.nodeToVehicle[otherId]
        if vehicle ~= nil then
          if gcM.senke.index ~= nil then
            local mass = 0
            for g, component in pairs(vehicle.components) do
              local vehMass = getMass(component.node)
              mass = mass + vehMass
            end
            if SpecializationUtil.hasSpecialization(Fillable, vehicle.specializations) then
              mass = mass + vehicle.fillLevel * vehicle.massPerLiter * 10
            end
            gcM.senke.weight = gcM.senke.weight + mass
          end
          table.insert(gcM.vehiclesInTrigger, otherId)
        end
      end
      gcM.timerSet = 1
    elseif onLeave and table.getn(gcM.vehiclesInTrigger) ~= nil and table.getn(gcM.vehiclesInTrigger) > 0 then
      for i = 1, table.getn(gcM.vehiclesInTrigger) do
        if gcM.vehiclesInTrigger[i] == otherId then
          table.remove(gcM.vehiclesInTrigger, i)
          local vehicle = g_currentMission.nodeToVehicle[otherId]
          if gcM.senke.index ~= nil then
            local mass = 0
            for g, component in pairs(vehicle.components) do
              local vehMass = getMass(component.node)
              mass = mass + vehMass
            end
            if SpecializationUtil.hasSpecialization(Fillable, vehicle.specializations) then
              mass = mass + vehicle.fillLevel * vehicle.massPerLiter * 10
            end
            gcM.senke.weight = gcM.senke.weight - mass
          end
        end
      end
    end
  end
end
function WeightStation:setDigitNumbers(mass)
  local mass = mass
  local gcM = g_currentMission.WeightStation[self.stationId]
  local massUnits = string.format("%d", mass)
  local digit1 = "0"
  local digit2 = "0"
  local digit3 = "0"
  local digit4 = "0"
  local digit5 = "0"
  if mass >= 0 then
    digit5 = string.sub(massUnits, 1, 1)
  end
  if mass >= 10 then
    digit4 = string.sub(massUnits, 1, 1)
    digit5 = string.sub(massUnits, 2, 2)
  end
  if mass >= 100 then
    digit3 = string.sub(massUnits, 1, 1)
    digit4 = string.sub(massUnits, 2, 2)
    digit5 = string.sub(massUnits, 3, 3)
  end
  if mass >= 1000 then
    digit2 = string.sub(massUnits, 1, 1)
    digit3 = string.sub(massUnits, 2, 2)
    digit4 = string.sub(massUnits, 3, 3)
    digit5 = string.sub(massUnits, 4, 4)
  end
  if mass >= 10000 then
    digit1 = string.sub(massUnits, 1, 1)
    digit2 = string.sub(massUnits, 2, 2)
    digit3 = string.sub(massUnits, 3, 3)
    digit4 = string.sub(massUnits, 4, 4)
    digit5 = string.sub(massUnits, 5, 5)
  end
  setShaderParameter(gcM.digits[5], "Position", gcM.digitPosition[digit5], 0, 0, 0, false)
  setShaderParameter(gcM.digits[4], "Position", gcM.digitPosition[digit4], 0, 0, 0, false)
  setShaderParameter(gcM.digits[3], "Position", gcM.digitPosition[digit3], 0, 0, 0, false)
  setShaderParameter(gcM.digits[2], "Position", gcM.digitPosition[digit2], 0, 0, 0, false)
  setShaderParameter(gcM.digits[1], "Position", gcM.digitPosition[digit1], 0, 0, 0, false)
end
function WeightStation:saveWeight()
	if g_currentMission.WeightStation ~= nil then
		local savegameIndex = g_currentMission.missionInfo.savegameIndex;
		local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
		
		if savegameFolderPath == nil then
			savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), savegameIndex);
		end;
	
		if fileExists(savegameFolderPath .. '/careerSavegame.xml') then -- savegame isn't corrupted and has been saved correctly
			local name = "WeightStation";
			--print("WeightStation:: Saving to "..savegameFolderPath .. "/WeightStation.xml")
		
			local xml = createXMLFile("WeightStation", savegameFolderPath .. "/WeightStation.xml", name);
			
			for i = 1, table.getn(g_currentMission.WeightStation) do
				if g_currentMission.WeightStation[i] ~= nil then
					local name = g_currentMission.WeightStation[i].name
					name = "WeightStation." .. name
					setXMLFloat(xml, name .. ".overallWeight", g_currentMission.WeightStation[i].overallWeight)
					setXMLInt(xml, name .. ".playerCount", g_currentMission.WeightStation[i].playerCount)
					if 0 < g_currentMission.WeightStation[i].playerCount then
						--print(string.format("WeightStation[i].playerCount"));
						for x = 1, g_currentMission.WeightStation[i].playerCount do
							setXMLString(xml, name .. ".player" .. x .. ".name", g_currentMission.WeightStation[i].player[x].name)
							setXMLFloat(xml, name .. ".player" .. x .. ".weight", g_currentMission.WeightStation[i].player[x].weight)
						end;
					end;
				end;
			end;
		
			saveXMLFile(xml)
			delete(xml)
		end;
	end;
end;
g_careerScreen.saveSavegame = Utils.appendedFunction(g_careerScreen.saveSavegame, WeightStation.saveWeight);

function WeightStation:getFilesCallback(savegameFolderPath)
  if savegameFolderPath == "WeightStations.xml" then
    self.fileFound = true
  end
end
function weightSOVEvent:emptyNew()
  local self = Event:new(weightSOVEvent_mt)
  return self
end
function weightSOVEvent:new(mReset)
  local self = weightSOVEvent:emptyNew()
  self.mReset = mReset
  return self
end
function weightSOVEvent:readStream(streamId, connection)
  self.mReset = streamReadBool(streamId)
  self:run(connection)
end
function weightSOVEvent:writeStream(streamId, connection)
  streamWriteBool(streamId, self.mReset)
end
function weightSOVEvent:run(connection)
  g_currentMission.weightSOVReset = self.mReset
end
function weightSyncRequest:emptyNew()
  local self = Event:new(weightSyncRequest_mt)
  return self
end
function weightSyncRequest:new(rStation)
  local self = weightSyncRequest:emptyNew()
  self.rStation = rStation
  return self
end
function weightSyncRequest:readStream(streamId, connection)
  self.rStation = streamReadInt32(streamId)
  self:run(connection)
end
function weightSyncRequest:writeStream(streamId, connection)
  streamWriteInt32(streamId, self.rStation)
end
function weightSyncRequest:run(connection)
  if not connection:getIsServer() and g_currentMission.WeightStation ~= nil and table.getn(g_currentMission.WeightStation) > 0 then
    for i = 1, table.getn(g_currentMission.WeightStation) do
      if g_currentMission.WeightStation[i].sId == self.rStation then
        g_currentMission.WeightStation[i].requestSend = true
        g_currentMission.weightRequestCheck = g_currentMission.weightRequestCheck + 1
      end
    end
  end
end
function weightStationSyncEvent:emptyNew()
  local self = Event:new(weightStationSyncEvent_mt)
  return self
end
function weightStationSyncEvent:new(wSId, wOWeight, wPCount, wDataP, wDataW)
  local self = weightStationSyncEvent:emptyNew()
  self.wSId = wSId
  self.wOWeight = wOWeight
  self.wPCount = wPCount
  self.wDataP = wDataP
  self.wDataW = wDataW
  return self
end
function weightStationSyncEvent:readStream(streamId, connection)
  self.wSId = streamReadInt32(streamId)
  self.wOWeight = streamReadFloat32(streamId)
  self.wPCount = streamReadInt32(streamId)
  self.wDataP = streamReadString(streamId)
  self.wDataW = streamReadString(streamId)
  self:run(connection)
end
function weightStationSyncEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, self.wSId)
  streamWriteFloat32(streamId, self.wOWeight)
  streamWriteInt32(streamId, self.wPCount)
  streamWriteString(streamId, self.wDataP)
  streamWriteString(streamId, self.wDataW)
end
function weightStationSyncEvent:run(connection)
  if connection:getIsServer() then
    local wS = g_currentMission.WeightStation
    if wS ~= nil and type(wS) == "table" and table.getn(wS) > 0 then
      for i = 1, table.getn(wS) do
        if self.wSId == wS[i].sId then
          wS[i].overallWeight = self.wOWeight
          wS[i].player = {}
          if 0 < self.wPCount then
            local names = Utils.splitString(";", self.wDataP)
            local weights = Utils.splitString(";", self.wDataW)
            for a = 1, self.wPCount do
              wS[i].player[a] = {}
              wS[i].player[a].name = names[a]
              wS[i].player[a].weight = tonumber(weights[a])
            end
          end
          wS[i].playerCount = self.wPCount
        end
      end
    end
  end
end
--print(" -> WeightStation Version 4.3.0 by Blacky_BPG Trigger and Events loaded Mody By Chrisu70")
g_onCreateUtil.addOnCreateFunction("WeightStationOnCreate", WeightStation.onCreate)
addModEventListener(weightSOV)
