weightFix = {}
weightFix.stat = {}
weightFix.modDir = g_currentModDirectory
printTimer = 0
printStats = false
function weightFix.prerequisitesPresent(specializations)
  return true
end
function weightFix:load(xmlFile)
  self.oldmassPerFillLevel = self.massPerFillLevel
  self.oldFillType = Fillable.FILLTYPE_UNKNOWN
  self.setWeightFix = SpecializationUtil.callSpecializationsFunction("setWeightFix")
  self.fixTrailerScale = nil
  if self.tsHudOverlay ~= nil then
    self.fixTrailerScale = true
    self.tsXPos = self.xPos
    self.tsYPos = self.yPos
    self.xPos = -0.5
    self.yPos = -0.5
  end
end
function weightFix:delete()
end
function weightFix:draw()
  if self:getIsActive() and self.isClient and self.fixTrailerScale ~= nil and self.fixTrailerScale then
    local mass = self.fillLevel * self.massPerLiter * 1000 * 5.555555555555555
    local fillLevelString = string.format("%d kg", mass)
    setTextAlignment(RenderText.ALIGN_RIGHT)
    setTextBold(true)
    setTextColor(0, 0, 0, 1)
    renderText(self.tsXPos + 0.102 + 0.11855, self.tsYPos + 0.008, 0.02, fillLevelString)
    setTextColor(1, 1, 1, 1)
    renderText(self.tsXPos + 0.102 + 0.11855, self.tsYPos + 0.01, 0.02, fillLevelString)
    setTextAlignment(RenderText.ALIGN_LEFT)
    setTextBold(false)
  end
end
function weightFix:readStream(streamId, connection)
  self.massPerLiter = streamReadFloat32(streamId)
end
function weightFix:writeStream(streamId, connection)
  streamWriteFloat32(streamId, self.massPerLiter)
end
function weightFix:setWeightFix(massPerLiter, noEventSend, fwFactor)
  self.massPerLiter = massPerLiter
  self.oldmassPerFillLevel = massPerLiter
  weightFixEvent.sendEvent(self, massPerLiter, noEventSend, 0)
end
function weightFix:mouseEvent(posX, posY, isDown, isUp, button)
end
function weightFix:keyEvent(unicode, sym, modifier, isDown)
end
function weightFix:update(dt)
  if self:getIsActive() and self.isClient and self.tsHudOverlay ~= nil and self.fixTrailerScale == nil then
    self.fixTrailerScale = true
    self.tsXPos = self.xPos
    self.tsYPos = self.yPos
    self.xPos = -0.5
    self.yPos = -0.5
  end
  local massPerFillLevel = g_currentMission.fruitWeightFactor / 1000000
  if self.shovelTipTrigger ~= nil or self.shovelTipReferenceNode ~= nil then
    massPerFillLevel = 1.0E-6
  end
  self.massPerFillLevel = nil
  self.oldmassPerFillLevel = self.massPerLiter
  if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and self.currentFillType ~= self.oldFillType then
    self.oldFillType = self.currentFillType
    if self.currentFillType == Fillable.FILLTYPE_WHEAT then
      massPerFillLevel = massPerFillLevel * 79
    elseif self.currentFillType == Fillable.FILLTYPE_OAT then
      massPerFillLevel = massPerFillLevel * 54
    elseif self.currentFillType == Fillable.FILLTYPE_RYE then
      massPerFillLevel = massPerFillLevel * 73
    elseif self.currentFillType == Fillable.FILLTYPE_DINKEL then
      massPerFillLevel = massPerFillLevel * 42
	elseif self.currentFillType == Fillable.FILLTYPE_SUNFLOWER then
      massPerFillLevel = massPerFillLevel * 42
    elseif self.currentFillType == Fillable.FILLTYPE_MILLET then
      massPerFillLevel = massPerFillLevel * 58
    elseif self.currentFillType == Fillable.FILLTYPE_DINKEL_WINDROW then
      massPerFillLevel = massPerFillLevel * 3.8
    elseif self.currentFillType == Fillable.FILLTYPE_RYE_WINDROW then
      massPerFillLevel = massPerFillLevel * 4.0
    elseif self.currentFillType == Fillable.FILLTYPE_OAT_WINDROW then
      massPerFillLevel = massPerFillLevel * 4.5
    elseif self.currentFillType == Fillable.FILLTYPE_WHEAT_WINDROW then
      massPerFillLevel = massPerFillLevel * 4.0
    elseif self.currentFillType == Fillable.FILLTYPE_BARLEY_WINDROW then
      massPerFillLevel = massPerFillLevel * 3.6
    elseif self.currentFillType == Fillable.FILLTYPE_BARLEY then
      massPerFillLevel = massPerFillLevel * 71
    elseif self.currentFillType == Fillable.FILLTYPE_GRASS_WINDROW then
      massPerFillLevel = massPerFillLevel * 5.0
    elseif self.currentFillType == Fillable.FILLTYPE_GRASS then
      massPerFillLevel = massPerFillLevel * 25
    elseif self.currentFillType == Fillable.FILLTYPE_RAPE then
      massPerFillLevel = massPerFillLevel * 64
    elseif self.currentFillType == Fillable.FILLTYPE_MAIZE then
      massPerFillLevel = massPerFillLevel * 82
    elseif self.currentFillType == Fillable.FILLTYPE_MANURE then
      massPerFillLevel = massPerFillLevel * 65
    elseif self.currentFillType == Fillable.FILLTYPE_FERTILIZER then
      massPerFillLevel = massPerFillLevel * 128
    elseif self.currentFillType == Fillable.FILLTYPE_CHAFF then
      massPerFillLevel = massPerFillLevel * 40
    elseif self.currentFillType == Fillable.FILLTYPE_LIQUIDMANURE then
      massPerFillLevel = massPerFillLevel * 92
    elseif self.currentFillType == Fillable.FILLTYPE_DRYGRASS_WINDROW then
      massPerFillLevel = massPerFillLevel * 5.0
    elseif self.currentFillType == Fillable.FILLTYPE_DRYGRASS then
      massPerFillLevel = massPerFillLevel * 5.0
    elseif self.currentFillType == Fillable.FILLTYPE_POTATO then
      massPerFillLevel = massPerFillLevel * 67
    elseif self.currentFillType == Fillable.FILLTYPE_SUGARBEET then
      massPerFillLevel = massPerFillLevel * 69
    elseif self.currentFillType == Fillable.FILLTYPE_SILAGE then
      massPerFillLevel = massPerFillLevel * 40
    elseif self.currentFillType == Fillable.FILLTYPE_FORAGE then
      massPerFillLevel = massPerFillLevel * 40
    elseif self.currentFillType == Fillable.FILLTYPE_FORAGE_MIXING then
      massPerFillLevel = massPerFillLevel * 20
    elseif self.currentFillType == Fillable.FILLTYPE_SEEDS then
      massPerFillLevel = massPerFillLevel * 81
    elseif self.currentFillType == Fillable.FILLTYPE_WATER then
      massPerFillLevel = massPerFillLevel * 100
    elseif self.currentFillType == Fillable.FILLTYPE_FUEL then
      massPerFillLevel = massPerFillLevel * 128
    elseif self.currentFillType == Fillable.FILLTYPE_CARROT then
      massPerFillLevel = massPerFillLevel * 64
    elseif self.currentFillType == Fillable.FILLTYPE_MOHN then
      massPerFillLevel = massPerFillLevel * 59
    elseif self.currentFillType == Fillable.FILLTYPE_ONION then
      massPerFillLevel = massPerFillLevel * 61
    elseif self.currentFillType == Fillable.FILLTYPE_MILK then
      massPerFillLevel = massPerFillLevel * 103
    elseif self.currentFillType == Fillable.FILLTYPE_SOYBEAN then
      massPerFillLevel = massPerFillLevel * 80
	elseif self.currentFillType == Fillable.FILLTYPE_PIG then
      massPerFillLevel = massPerFillLevel * 10000
	elseif self.currentFillType == Fillable.FILLTYPE_BEEF then
      massPerFillLevel = massPerFillLevel * 75000
	elseif self.currentFillType == Fillable.FILLTYPE_WOODCHIPS then
      massPerFillLevel = massPerFillLevel * 24
	elseif self.currentFillType == Fillable.FILLTYPE_PELLETS then
      massPerFillLevel = massPerFillLevel * 76
	elseif self.currentFillType == Fillable.FILLTYPE_BEETPULP then
      massPerFillLevel = massPerFillLevel * 70
    else
      massPerFillLevel = massPerFillLevel * 60
    end
    self.massPerLiter = massPerFillLevel
    self:setWeightFix(massPerFillLevel)
  end
end
function weightFix:updateTick(dt)
end
function weightFix:onLeave()
end
function weightFix:onEnter()
end
weightFixEvent = {}
weightFixEvent_mt = Class(weightFixEvent, Event)
InitEventClass(weightFixEvent, "weightFixEvent")
function weightFixEvent:emptyNew()
  local self = Event:new(weightFixEvent_mt)
  self.className = "weightFixEvent"
  return self
end
function weightFixEvent:new(vehicle, massPerFillLevel, fwFactor)
  self.vehicle = vehicle
  self.massPerFillLevel = massPerFillLevel
  return self
end
function weightFixEvent:readStream(streamId, connection)
  local id = streamReadInt32(streamId)
  self.massPerFillLevel = streamReadFloat32(streamId)
  self.fwFactor = streamReadFloat32(streamId)
  self.vehicle = networkGetObject(id)
  self:run(connection)
end
function weightFixEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.vehicle))
  streamWriteFloat32(streamId, self.massPerFillLevel)
  streamWriteFloat32(streamId, self.fwFactor)
end
function weightFixEvent:run(connection)
  if self.vehicle ~= nil then
    if not connection:getIsServer() then
      g_server:broadcastEvent(weightFixEvent:new(self.vehicle, self.massPerFillLevel, 0), nil, connection, self.vehicle)
    end
    self.vehicle:setWeightFix(self.massPerFillLevel, true, 0)
  end
end
function weightFixEvent.sendEvent(vehicle, massPerFillLevel, noEventSend, fwFactor)
  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(weightFixEvent:new(vehicle, massPerFillLevel, 0), nil, nil, vehicle)
    else
      g_client:getServerConnection():sendEvent(weightFixEvent:new(vehicle, massPerFillLevel, 0))
    end
  end
end
nameFix = {}
function nameFix.prerequisitesPresent(specialization)
  return true
end
function nameFix:load(xmlFile)
  g_currentMission.modNameFixCounter = Utils.getNoNil(g_currentMission.modNameFixCounter, 0) + 1
  local name = getXMLString(xmlFile, "vehicle.name.de")
  name = Utils.getNoNil(name, getXMLString(xmlFile, "vehicle.name.en"))
  name = Utils.getNoNil(getXMLString(xmlFile, "vehicle.name"), name)
  name = Utils.getNoNil(name, "Vehicle_" .. tostring(g_currentMission.modNameFixCounter))
  self.modName = name
end
function nameFix:delete()
end
function nameFix:readStream(streamId, connection)
end
function nameFix:writeStream(streamId, connection)
end
function nameFix:mouseEvent(posX, posY, isDown, isUp, button)
end
function nameFix:keyEvent(unicode, sym, modifier, isDown)
end
function nameFix:update(dt)
end
function nameFix:updateTick(dt)
end
function nameFix:onLeave()
end
function nameFix:onEnter()
end
function nameFix:draw()
end
weightStationVehicle = {}
weightStationVehicle.stat = {}
weightStationVehicle.modDir = g_currentModDirectory
function weightStationVehicle.prerequisitesPresent(specializations)
  return true
end
function weightStationVehicle:load(xmlFile)
  self.MapWeightStation = 0
  self.showWaageStatistics = false
  self.mpwt = 0
  self.mpwtm = ""
  self.wsvPage = 0
  self.isSelectable = true
end
function weightStationVehicle:delete()
end
function weightStationVehicle:readStream(streamId, connection)
end
function weightStationVehicle:writeStream(streamId, connection)
end
function weightStationVehicle:mouseEvent(posX, posY, isDown, isUp, button)
end
function weightStationVehicle:keyEvent(unicode, sym, modifier, isDown)
end
function weightStationVehicle:update(dt)
  if self:getIsActive() and self:getIsActiveForSound() and g_gui.currentGuiName == "" and self.isClient then
    if InputBinding.hasEvent(InputBinding.MAPWEIGHTSTATION_SHOW) then
      self.showWaageStatistics = not self.showWaageStatistics
    end
    local isSet = false
    if g_currentMission.WeightStation ~= nil then
      for i = 1, table.getn(g_currentMission.WeightStation) do
        if table.getn(g_currentMission.WeightStation[i].vehiclesInTrigger) ~= nil and table.getn(g_currentMission.WeightStation[i].vehiclesInTrigger) > 0 then
          for k = 1, table.getn(g_currentMission.WeightStation[i].vehiclesInTrigger) do
            local vehicle = g_currentMission.nodeToVehicle[g_currentMission.WeightStation[i].vehiclesInTrigger[k]]
            if vehicle ~= nil and vehicle == self then
              --if vehicle.forceIsActive == true or vehicle.drive == true or vehicle.steeringEnabled == false then
			  if vehicle.drive == true or vehicle.steeringEnabled == false then
                g_currentMission.WeightStation[i].playerName = g_i18n:getText("wage_helper")
              elseif self.controllerName == g_currentMission.WeightStation[i].playerName then
                self.MapWeightStation = i
                isSet = true
              end
            end
          end
        end
      end
      if isSet == false then
        self.MapWeightStation = 0
      end
    end
  end
end
function weightStationVehicle:updateTick(dt)
end
function weightStationVehicle:onLeave()
end
function weightStationVehicle:onEnter()
end
function weightStationVehicle:draw()
  if self.isClient then
    if self.mpwt > self.time then
      g_currentMission:addWarning(self.mpwtm, 0.018, 0.033)
    end
    if g_currentMission.WeightStation ~= nil then
      if self.showWaageStatistics == false then
        do
          local i = self.MapWeightStation
          self.showWaageStatistics = false
          if i > 0 then
            if self.steeringEnabled == false then
              g_currentMission.WeightStation[i].playerName = g_i18n:getText("wage_helper")
            end
            if g_currentMission.WeightStation[i].showWarn == true then
              g_currentMission:addWarning(g_currentMission.WeightStation[i].warnMessage, 0.018, 0.033)
            end
            if g_currentMission.WeightStation[i].showHud == true then
              local plyName = g_currentMission.WeightStation[i].playerName
              local plyOverall = 0
              Motorized.Wage_hud:render()
              local yPos = 0.764
              local xPos = 0.777
              local tSize = 0.016
              setTextBold(false)
              setTextAlignment(RenderText.ALIGN_CENTER)
              setTextColor(1, 1, 0.6, 1)
              renderText(xPos + 0.095, yPos, tSize + 0.002, string.format(g_i18n:getText("wage_string3"), tostring(g_i18n:getText(g_currentMission.WeightStation[i].name))))
              yPos = yPos - 0.05
              setTextAlignment(RenderText.ALIGN_LEFT)
              setTextColor(0.5, 1, 0.5, 1)
              renderText(xPos, yPos, tSize, "Gesamtmenge:")
              setTextAlignment(RenderText.ALIGN_RIGHT)
              renderText(xPos + 0.19, yPos, tSize + 0.001, tostring(math.floor(g_currentMission.WeightStation[i].overallWeight / 100) / 10) .. " t")
              yPos = yPos - 0.025
              setTextAlignment(RenderText.ALIGN_LEFT)
              renderText(xPos, yPos, tSize, "Gewogen von:")
              yPos = yPos - 0.02
              if 0 < g_currentMission.WeightStation[i].playerCount then
                if g_currentMission.weightSOVActive > -1 then
                  g_currentMission.weightSOVActive = -1
                  g_currentMission.weightSOVPage = 0
                  g_currentMission.weightSOVPage = 1
                  self.wsvPage = self.wsvPage + 1
                end
                local maxPages = math.ceil(Utils.getNoNil(g_currentMission.WeightStation[i].playerCount, 1) / 9)
                local startUser = math.max(self.wsvPage - 1, 0) * 9 + 1
                local lastUser = startUser + 8
                if lastUser > g_currentMission.WeightStation[i].playerCount then
                  lastUser = g_currentMission.WeightStation[i].playerCount
                end
                if 0 >= self.wsvPage then
                  self.wsvPage = 1
                end
                if maxPages < self.wsvPage then
                  self.wsvPage = 1
                end
                for k = startUser, lastUser do
                  setTextAlignment(RenderText.ALIGN_LEFT)
                  renderText(xPos, yPos, tSize, "-> " .. tostring(g_currentMission.WeightStation[i].player[k].name))
                  setTextAlignment(RenderText.ALIGN_RIGHT)
                  renderText(xPos + 0.19, yPos, tSize, tostring(math.floor(g_currentMission.WeightStation[i].player[k].weight / 100) / 10) .. " t")
                  yPos = yPos - 0.025
                end
              end
              if plyName ~= nil then
                for j = 1, table.getn(g_currentMission.WeightStation) do
                  if 0 < g_currentMission.WeightStation[j].playerCount then
                    for k = 1, g_currentMission.WeightStation[j].playerCount do
                      if g_currentMission.WeightStation[j].player[k].name == plyName then
                        plyOverall = plyOverall + g_currentMission.WeightStation[j].player[k].weight
                      end
                    end
                  end
                end
                setTextAlignment(RenderText.ALIGN_LEFT)
                renderText(xPos, 0.44, tSize + 0.002, g_i18n:getText("wage_string2"))
                setTextAlignment(RenderText.ALIGN_LEFT)
                renderText(xPos, 0.415, tSize, tostring(plyName))
                setTextAlignment(RenderText.ALIGN_RIGHT)
                renderText(xPos + 0.19, 0.415, tSize, tostring(math.floor(plyOverall / 100) / 10) .. " t")
              end
            end
          end
          self.showWaageStatistics = false
        end
      else
        local plyName = self.controllerName
        local plyOverall = 0
        Motorized.Wage_hud:render()
        local yPos = 0.764
        local xPos = 0.777
        local tSize = 0.016
        setTextBold(false)
        setTextAlignment(RenderText.ALIGN_CENTER)
        setTextColor(1, 1, 0.6, 1)
        renderText(xPos + 0.095, yPos, tSize + 0.002, g_i18n:getText("wage_string1"))
        yPos = yPos - 0.04
        setTextColor(0.5, 1, 0.5, 1)
        for j = 1, table.getn(g_currentMission.WeightStation) do
          if 0 < g_currentMission.WeightStation[j].playerCount then
            for k = 1, g_currentMission.WeightStation[j].playerCount do
              if g_currentMission.WeightStation[j].player[k].name == plyName then
                local waageWeight = g_currentMission.WeightStation[j].player[k].weight
                plyOverall = plyOverall + waageWeight
                setTextAlignment(RenderText.ALIGN_LEFT)
                renderText(xPos, yPos, tSize, "-> " .. g_i18n:getText(g_currentMission.WeightStation[j].name))
                setTextAlignment(RenderText.ALIGN_RIGHT)
                renderText(xPos + 0.19, yPos, tSize, tostring(math.floor(waageWeight / 100) / 10) .. " t")
                yPos = yPos - 0.025
              end
            end
          end
        end
        if plyOverall ~= nil and plyOverall ~= 0 then
          setTextAlignment(RenderText.ALIGN_LEFT)
          renderText(xPos, 0.44, tSize + 0.002, g_i18n:getText("wage_string2"))
          setTextAlignment(RenderText.ALIGN_LEFT)
          renderText(xPos, 0.415, tSize, tostring(plyName))
          setTextAlignment(RenderText.ALIGN_RIGHT)
          renderText(xPos + 0.19, 0.415, tSize, tostring(math.floor(plyOverall / 100) / 10) .. " t")
        end
      end
      setTextColor(1, 1, 1, 1)
      setTextAlignment(RenderText.ALIGN_LEFT)
    end
  end
end
--print(" -> WeightStation and FruitWeight Fix Specialistaion Version 4.3.0 by Blacky_BPG")
function weightStationVehicle:setweightStationVehicleMode(ignition, noEventSend)
end
