--[[ add Fill Types

	Author: 	Ifko[nator]
	Datum: 		25.10.2015
	Version: 	2.1

	History: 	V 1.0 @ 20.12.2014 - intial release
				V 1.5 @ 31.12.2014 - added: 'manure', 'wheat_windrow', 'barley_windrow', 'dryGrass_windrow' and 'grass_windrow'.
				V 1.6 @ 24.01.2015 - added: 'compost'. 'rye', 'oat' and 'sunflower' is To Do .. 
				V 1.8 @ 31.01.2015 - 'rye', 'oat' and 'sunflower' is done and i still waiting for the ScriptDocu by GIANTS for the new BaleRegister for 'rye_windrow' and 'oat_windrow' ..
				V 1.9 @ 13.04.2015 - added: 'beetPulp'.
				V 2.0 @ 15.05.2015 - added: 'fertilizer' and 'kalk'.
				V 2.1 @ 25.10.2015 - added: 'seeds2'
				
	Dieses Script fügt allen Anhängern und Schaufeln, die Häckselgut (chaff) laden können Mischfutter (forage), Silage (silage) und Hackschnitzel (woodChips) hinzu. Sollte schon einer der drei Fruchtarten verbaut sein, wird er selbstverständlich nicht mehr neu hinzugefügt.
	Auch die Particlesysteme werden angepasst. Sollte der Anhänger oder die Schaufel ein Particlesystem für Silage eingetragen haben, wird dieses auch für das Mischfutter verwendet. Sollte das nicht der Fall sein, wird für beide das Häckselgut Particlesystem verwendet. Sofern dies verfügbar ist, versteht sich.. :D Sollte der Anhänger oder die Schaufel noch kein Particlesystem für Hackschnitzel haben, so wird das Häckselgut Particlesystem verwendet.

	Neu ab V 1.5:
	- Alle Anhänger/Schaufeln, die Häckselgut laden können, können nun auch Gras laden, (grass_windrow, dryGrass_windrow). 
	- Alle Anhänger/Schaufeln, die Hackschnitzel laden können, können nun auch Stroh laden, (wheat_windrow, barley_windrow).
	- Alle Anhänger/Schaufeln, die Silage laden können, ausnahme Ladewagen/Häckseltransportwagen, können nun auch Mist laden, (manure). 
	
	Neu ab V 1.6:
	- Alle Anhänger/Schaufeln, die Silage laden können, können nun auch Kompost laden, (compost).
	
	Neu ab V 1.8:
	- Alle Anhänger/Schaufeln, die Weizen laden können, können nun auch Roggen, Hafer und Sonnenblumen laden, (rye, oat and sunflower).
	
	Neu ab V 1.9:
	- Alle Anhänger/Schaufeln, die Zuckerrüben laden können, können nun auch Rübenschnitzel laden, (beetPulp).
	
	Neu ab V 2.0:
	- Alle Anhänger/Schaufeln, die Weizen laden können, können nun auch Dünger und Kalk laden, (fertilizer and kalk).
	
	Fixes ab v 1.5:
	- Die Probleme beim Speichern oder Beenden, die einige bei der V1 hatten, sollten nun Geschichte sein. Sollte das nicht der Fall sein, bin ich echt ratlos.
]]

local addFillTypesDirectory = g_currentModDirectory;

local modDesc = loadXMLFile("modDesc", addFillTypesDirectory .. "modDesc.xml");
local version = getXMLString(modDesc, "modDesc.version");

local currentMap = "Unknown";

print("### addFillTypes Script by Ifko[nator] in der Version: '" .. version .. "' erfolgreich geladen!");

local oldFSBaseMission_loadMap = FSBaseMission.loadMap;
FSBaseMission.loadMap = function(a, b, c, d, e)
	currentMap = a.missionInfo.map.title;
	
	local kalk = Fillable.fillTypeNameToInt["kalk"];
	
	
	if kalk == nil then
		FruitUtil.registerFruitType(g_i18n:getText("kalk"), false, false, true, 1, 100, 2, 1, 1, nil);
		print("[INFO from the addFillTypes.lua]: Register 'kalk' on the '" .. currentMap .. "' Map.");
	end;
	
	ra, rb, rc, rd, re = oldFSBaseMission_loadMap(a, b, c, d, e);
	
	return ra, rb, rc, rd, re;
end;

local oldFillableLoad = Fillable.load;
Fillable.load = function(self, xmlFile)
	oldFillableLoad(self, xmlFile);
	local oat = g_currentMission.fruits[FruitUtil.FRUITTYPE_OAT] and Fillable.fillTypeNameToInt["oat"];
	local rye = g_currentMission.fruits[FruitUtil.FRUITTYPE_RYE] and Fillable.fillTypeNameToInt["rye"];
	local sunflower = g_currentMission.fruits[FruitUtil.FRUITTYPE_SUNFLOWER] and Fillable.fillTypeNameToInt["sunflower"];
	local compost = Fillable.fillTypeNameToInt["compost"];
	local beetPulp = Fillable.fillTypeNameToInt["beetPulp"];
	local seeds2 = Fillable.fillTypeNameToInt["seeds2"];
	
	local trailerHasFillVolume = getXMLString(xmlFile, "vehicle.fillVolumes.fillVolume#index");
	
	--if trailerHasFillVolume ~= nil then
		if self.fillTypes[Fillable.FILLTYPE_CHAFF] then
			if self.fillTypes[Fillable.FILLTYPE_FORAGE] == nil then
				self.fillTypes[Fillable.FILLTYPE_FORAGE] = true;
			end;
		
			if self.fillTypes[Fillable.FILLTYPE_SILAGE] == nil then
				self.fillTypes[Fillable.FILLTYPE_SILAGE] = true;
			end;
		
			if self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] == nil then
				self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] = true;
			end;
		
			if self.fillTypes[Fillable.FILLTYPE_DRYGRASS_WINDROW] == nil then
				self.fillTypes[Fillable.FILLTYPE_DRYGRASS_WINDROW] = true;
			end;
		
			if self.fillTypes[Fillable.FILLTYPE_GRASS_WINDROW] == nil then
				self.fillTypes[Fillable.FILLTYPE_GRASS_WINDROW] = true;
			end;
			
			if self.fillTypes[Fillable.FILLTYPE_KALK] == nil then
				self.fillTypes[Fillable.FILLTYPE_KALK] = true;
			end;
			
			if self.fillTypes[Fillable.FILLTYPE_FERTILIZER] == nil then
				self.fillTypes[Fillable.FILLTYPE_FERTILIZER] = true;
			end;
			
			if seeds2 ~= nil then
				if self.fillTypes[Fillable.FILLTYPE_SEEDS2] == nil then
					self.fillTypes[Fillable.FILLTYPE_SEEDS2] = true;
				end;
			else
				print("[INFO from the addFillTypes.lua]: 'seeds2' is not available on the '" .. currentMap .. "' Map and was not added to: '" .. self.configFileName .. "'.");
			end;
		end;
		
		if self.fillTypes[Fillable.FILLTYPE_WHEAT] then
			if self.fillTypes[Fillable.FILLTYPE_SILAGE] then
				if self.fillTypes[Fillable.FILLTYPE_MANURE] == nil then
					self.fillTypes[Fillable.FILLTYPE_MANURE] = true;
				end;
				
				if compost ~= nil then
					if self.fillTypes[Fillable.FILLTYPE_COMPOST] == nil then
						self.fillTypes[Fillable.FILLTYPE_COMPOST] = true;
					end;
				else
					print("[INFO from the addFillTypes.lua]: 'compost' is not available on the '" .. currentMap .. "' Map and was not added to: '" .. self.configFileName .. "'.");
				end;
			end;
			
			if oat ~= nil then
				if self.fillTypes[Fillable.FILLTYPE_OAT] == nil then
					self.fillTypes[Fillable.FILLTYPE_OAT] = true;
				end;
			else
				print("[INFO from the addFillTypes.lua]: 'oat' is not available on the '" .. currentMap .. "' Map and was not added to: '" .. self.configFileName .. "'.");
			end;
			
			if rye ~= nil then
				if self.fillTypes[Fillable.FILLTYPE_RYE] == nil then
					self.fillTypes[Fillable.FILLTYPE_RYE] = true;
				end;
			else
				print("[INFO from the addFillTypes.lua]: 'rye' is not available on the '" .. currentMap .. "' Map and was not added to: '" .. self.configFileName .. "'.");
			end;
			
			if sunflower ~= nil then
				if self.fillTypes[Fillable.FILLTYPE_SUNFLOWER] == nil then
					self.fillTypes[Fillable.FILLTYPE_SUNFLOWER] = true;
				end;
			else
				print("[INFO from the addFillTypes.lua]: 'sunflower' is not available on the '" .. currentMap .. "' Map and was not added to: '" .. self.configFileName .. "'.");
			end;
		end;
		
		if self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] == nil then
			self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] = true;
		end;
		
		if self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] then
			if self.fillTypes[Fillable.FILLTYPE_WHEAT_WINDROW] == nil then
				self.fillTypes[Fillable.FILLTYPE_WHEAT_WINDROW] = true;
			end;
		
			if self.fillTypes[Fillable.FILLTYPE_BARLEY_WINDROW] == nil then
				self.fillTypes[Fillable.FILLTYPE_BARLEY_WINDROW] = true;
			end;
		end;
		
		if self.fillTypes[Fillable.FILLTYPE_SUGARBEET] then
			if beetPulp ~= nil then
				if self.fillTypes[Fillable.FILLTYPE_BEETPULP] == nil then
					self.fillTypes[Fillable.FILLTYPE_BEETPULP] = true;
				end;
			else
				print("[INFO from the addFillTypes.lua]: 'beetPulp' is not available on the '" .. currentMap .. "' Map and was not added to: '" .. self.configFileName .. "'.");
			end;
		end;
	--else
		--print("[INFO from the addFillTypes.lua]: In the XML File: '" .. self.configFileName .. "' is the TAG 'vehicle.fillVolumes.fillVolume#index' missing.");
		--print("[INFO from the addFillTypes.lua]: This Script will no Filltypes add to this trailer/shovel!")
	--end;
end; 

local oldTrailerLoad = Trailer.load;
Trailer.load = function(self, xmlFile)
	oldTrailerLoad(self, xmlFile);

	if self.tipAnimations ~= nil then
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local forage = Fillable.fillTypeNameToInt["forage"];
		local silage = Fillable.fillTypeNameToInt["silage"];
		local woodChips = Fillable.fillTypeNameToInt["woodChips"];
		local manure = Fillable.fillTypeNameToInt["manure"];
		local dryGrass_windrow = Fillable.fillTypeNameToInt["dryGrass_windrow"];
		local grass_windrow = Fillable.fillTypeNameToInt["grass_windrow"];
		local wheat_windrow = Fillable.fillTypeNameToInt["wheat_windrow"];
		local barley_windrow = Fillable.fillTypeNameToInt["barley_windrow"];
		local compost = Fillable.fillTypeNameToInt["compost"];
		local oat = Fillable.fillTypeNameToInt["oat"];
		local rye = Fillable.fillTypeNameToInt["rye"];
		local sunflower = Fillable.fillTypeNameToInt["sunflower"];
		local beetPulp = Fillable.fillTypeNameToInt["beetPulp"];
		local fertilizer = Fillable.fillTypeNameToInt["fertilizer"];
		local kalk = Fillable.fillTypeNameToInt["kalk"];
		local seeds2 = Fillable.fillTypeNameToInt["seeds2"];
		
		for a = 1, #(self.tipAnimations) do
			if self.tipAnimations[a].dischargeParticleSystems[chaff] ~= nil then
				if self.tipAnimations[a].dischargeParticleSystems[silage] == nil then
					if self.fillTypes[Fillable.FILLTYPE_SILAGE] then 
						self.tipAnimations[a].dischargeParticleSystems[silage] = self.tipAnimations[a].dischargeParticleSystems[chaff];
					end;
					
					if self.tipAnimations[a].dischargeParticleSystems[forage] == nil and self.fillTypes[Fillable.FILLTYPE_FORAGE] then 
						self.tipAnimations[a].dischargeParticleSystems[forage] = self.tipAnimations[a].dischargeParticleSystems[chaff];
					end;
					
					if self.tipAnimations[a].dischargeParticleSystems[manure] == nil and self.fillTypes[Fillable.FILLTYPE_MANURE] then 
						self.tipAnimations[a].dischargeParticleSystems[manure] = self.tipAnimations[a].dischargeParticleSystems[chaff];
					end;
					
					if self.tipAnimations[a].dischargeParticleSystems[compost] == nil and self.fillTypes[Fillable.FILLTYPE_COMPOST] then 
						self.tipAnimations[a].dischargeParticleSystems[compost] = self.tipAnimations[a].dischargeParticleSystems[chaff];
					end;
				else
					if self.tipAnimations[a].dischargeParticleSystems[forage] == nil and self.fillTypes[Fillable.FILLTYPE_FORAGE] then 
						self.tipAnimations[a].dischargeParticleSystems[forage] = self.tipAnimations[a].dischargeParticleSystems[silage];
					end;
					
					if self.tipAnimations[a].dischargeParticleSystems[manure] == nil and self.fillTypes[Fillable.FILLTYPE_MANURE] then 
						self.tipAnimations[a].dischargeParticleSystems[manure] = self.tipAnimations[a].dischargeParticleSystems[silage];
					end;
					
					if self.tipAnimations[a].dischargeParticleSystems[compost] == nil and self.fillTypes[Fillable.FILLTYPE_COMPOST] then 
						self.tipAnimations[a].dischargeParticleSystems[compost] = self.tipAnimations[a].dischargeParticleSystems[silage];
					end;
				end;
	
				if self.tipAnimations[a].dischargeParticleSystems[woodChips] == nil and self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] then 
					self.tipAnimations[a].dischargeParticleSystems[woodChips] = self.tipAnimations[a].dischargeParticleSystems[chaff];
				end;
	
				if self.tipAnimations[a].dischargeParticleSystems[dryGrass_windrow] == nil and self.fillTypes[Fillable.FILLTYPE_DRYGRASS_WINDROW] then 
					self.tipAnimations[a].dischargeParticleSystems[dryGrass_windrow] = self.tipAnimations[a].dischargeParticleSystems[chaff];
				end;
	
				if self.tipAnimations[a].dischargeParticleSystems[grass_windrow] == nil and self.fillTypes[Fillable.FILLTYPE_GRASS_WINDROW] then 
					self.tipAnimations[a].dischargeParticleSystems[grass_windrow] = self.tipAnimations[a].dischargeParticleSystems[chaff];
				end;
			end;
	
			if self.tipAnimations[a].dischargeParticleSystems[woodChips] ~= nil then
				if self.tipAnimations[a].dischargeParticleSystems[wheat_windrow] == nil and self.fillTypes[Fillable.FILLTYPE_WHEAT_WINDROW] then 
					self.tipAnimations[a].dischargeParticleSystems[wheat_windrow] = self.tipAnimations[a].dischargeParticleSystems[woodChips];
				end;
	
				if self.tipAnimations[a].dischargeParticleSystems[barley_windrow] == nil and self.fillTypes[Fillable.FILLTYPE_BARLEY_WINDROW] then 
					self.tipAnimations[a].dischargeParticleSystems[barley_windrow] = self.tipAnimations[a].dischargeParticleSystems[woodChips];
				end;
				
				if self.tipAnimations[a].dischargeParticleSystems[beetPulp] == nil and self.fillTypes[Fillable.FILLTYPE_BEETPULP] then 
					self.tipAnimations[a].dischargeParticleSystems[beetPulp] = self.tipAnimations[a].dischargeParticleSystems[woodChips];
				end;
			end;
			
			--## New in FS 15
			--## IMPORTANT!! Map needs the Material Holder for the 'rye', 'oat' and 'sunflower' tipEffect !
			if self.tipAnimations[a].tipEffectFillTypes ~= nil then
				if self.tipAnimations[a].tipEffectFillTypes[sunflower] == nil and self.fillTypes[Fillable.FILLTYPE_SUNFLOWER] then 
					self.tipAnimations[a].tipEffectFillTypes[sunflower] = true;
				end;
	
				if self.tipAnimations[a].tipEffectFillTypes[rye] == nil and self.fillTypes[Fillable.FILLTYPE_RYE] then 
					self.tipAnimations[a].tipEffectFillTypes[rye] = true;
				end;
					
				if self.tipAnimations[a].tipEffectFillTypes[oat] == nil and self.fillTypes[Fillable.FILLTYPE_OAT] then 
					self.tipAnimations[a].tipEffectFillTypes[oat] = true;
				end;
				
				if self.tipAnimations[a].tipEffectFillTypes[fertilizer] == nil and self.fillTypes[Fillable.FILLTYPE_FERTILIZER] then 
					self.tipAnimations[a].tipEffectFillTypes[fertilizer] = true;
				end;
				
				if self.tipAnimations[a].tipEffectFillTypes[kalk] == nil and self.fillTypes[Fillable.FILLTYPE_KALK] then 
					self.tipAnimations[a].tipEffectFillTypes[kalk] = true;
				end;
				
				if self.tipAnimations[a].tipEffectFillTypes[seeds2] == nil and self.fillTypes[Fillable.FILLTYPE_SEEDS2] then 
					self.tipAnimations[a].tipEffectFillTypes[seeds2] = true;
				end;
			end;
		end;
	end;
end;	
	
local oldTrailerDelete = Trailer.delete;
Trailer.delete = function(self)
	if self.tipAnimations ~= nil then
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local forage = Fillable.fillTypeNameToInt["forage"];
		local silage = Fillable.fillTypeNameToInt["silage"];
		local woodChips = Fillable.fillTypeNameToInt["woodChips"];
		local manure = Fillable.fillTypeNameToInt["manure"];
		local dryGrass_windrow = Fillable.fillTypeNameToInt["dryGrass_windrow"];
		local grass_windrow = Fillable.fillTypeNameToInt["grass_windrow"];
		local wheat_windrow = Fillable.fillTypeNameToInt["wheat_windrow"];
		local barley_windrow = Fillable.fillTypeNameToInt["barley_windrow"];
		local compost = Fillable.fillTypeNameToInt["compost"];
		local oat = Fillable.fillTypeNameToInt["oat"];
		local rye = Fillable.fillTypeNameToInt["rye"];
		local sunflower = Fillable.fillTypeNameToInt["sunflower"];
		local beetPulp = Fillable.fillTypeNameToInt["beetPulp"];
		local fertilizer = Fillable.fillTypeNameToInt["fertilizer"];
		local kalk = Fillable.fillTypeNameToInt["kalk"];
		local seeds2 = Fillable.fillTypeNameToInt["seeds2"];
		
		for a = 1, #(self.tipAnimations) do
			if self.tipAnimations[a].dischargeParticleSystems[forage] == self.tipAnimations[a].dischargeParticleSystems[(silage or chaff)] and self.fillTypes[Fillable.FILLTYPE_FORAGE] then
				self.tipAnimations[a].dischargeParticleSystems[forage] = nil;
			end;
	
			if self.tipAnimations[a].dischargeParticleSystems[woodChips] == self.tipAnimations[a].dischargeParticleSystems[chaff] and self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] then
				self.tipAnimations[a].dischargeParticleSystems[woodChips] = nil;
			end;
	
			if self.tipAnimations[a].dischargeParticleSystems[silage] == self.tipAnimations[a].dischargeParticleSystems[chaff] and self.fillTypes[Fillable.FILLTYPE_SILAGE] then
				self.tipAnimations[a].dischargeParticleSystems[silage] = nil;
			end;
	
			if self.tipAnimations[a].dischargeParticleSystems[manure] == self.tipAnimations[a].dischargeParticleSystems[(silage or chaff)] and self.fillTypes[Fillable.FILLTYPE_MANURE] then
				self.tipAnimations[a].dischargeParticleSystems[manure] = nil;
			end;
	
			if self.tipAnimations[a].dischargeParticleSystems[dryGrass_windrow] == self.tipAnimations[a].dischargeParticleSystems[chaff] and self.fillTypes[Fillable.FILLTYPE_DRYGRASS_WINDROW] then
				self.tipAnimations[a].dischargeParticleSystems[dryGrass_windrow] = nil;
			end;
	
			if self.tipAnimations[a].dischargeParticleSystems[grass_windrow] == self.tipAnimations[a].dischargeParticleSystems[chaff] and self.fillTypes[Fillable.FILLTYPE_GRASS_WINDROW] then
				self.tipAnimations[a].dischargeParticleSystems[grass_windrow] = nil;
			end;
	
			if self.tipAnimations[a].dischargeParticleSystems[wheat_windrow] == self.tipAnimations[a].dischargeParticleSystems[woodChips] and self.fillTypes[Fillable.FILLTYPE_WHEAT_WINDROW] then
				self.tipAnimations[a].dischargeParticleSystems[wheat_windrow] = nil;
			end;
	
			if self.tipAnimations[a].dischargeParticleSystems[barley_windrow] == self.tipAnimations[a].dischargeParticleSystems[woodChips] and self.fillTypes[Fillable.FILLTYPE_BARLEY_WINDROW] then
				self.tipAnimations[a].dischargeParticleSystems[barley_windrow] = nil;
			end;
			
			if self.tipAnimations[a].dischargeParticleSystems[compost] == self.tipAnimations[a].dischargeParticleSystems[(silage or chaff)] and self.fillTypes[Fillable.FILLTYPE_COMPOST] then
				self.tipAnimations[a].dischargeParticleSystems[compost] = nil;
			end;
			
			if self.tipAnimations[a].dischargeParticleSystems[beetPulp] == self.tipAnimations[a].dischargeParticleSystems[woodChips] and self.fillTypes[Fillable.FILLTYPE_BEETPULP] then
				self.tipAnimations[a].dischargeParticleSystems[beetPulp] = nil;
			end;
			
			--## New in FS 15
			if self.tipAnimations[a].tipEffectFillTypes ~= nil then
				if self.tipAnimations[a].tipEffectFillTypes[sunflower] and self.fillTypes[Fillable.FILLTYPE_SUNFLOWER] then
					self.tipAnimations[a].tipEffectFillTypes[sunflower] = nil;
				end;
				
				if self.tipAnimations[a].tipEffectFillTypes[rye] and self.fillTypes[Fillable.FILLTYPE_RYE] then
					self.tipAnimations[a].tipEffectFillTypes[rye] = nil;
				end;
				
				if self.tipAnimations[a].tipEffectFillTypes[oat] and self.fillTypes[Fillable.FILLTYPE_OAT] then
					self.tipAnimations[a].tipEffectFillTypes[oat] = nil;
				end;
				
				if self.tipAnimations[a].tipEffectFillTypes[fertilizer] == nil and self.fillTypes[Fillable.FILLTYPE_FERTILIZER] then 
					self.tipAnimations[a].tipEffectFillTypes[fertilizer] = nil;
				end;
				
				if self.tipAnimations[a].tipEffectFillTypes[kalk] == nil and self.fillTypes[Fillable.FILLTYPE_KALK] then 
					self.tipAnimations[a].tipEffectFillTypes[kalk] = nil;
				end;
				
				if self.tipAnimations[a].tipEffectFillTypes[seeds2] == nil and self.fillTypes[Fillable.FILLTYPE_SEEDS2] then 
					self.tipAnimations[a].tipEffectFillTypes[seeds2] = nil;
				end;
			end;
		end;
		oldTrailerDelete(self);
	end;
end;
	
local oldShovelLoad = Shovel.load;
Shovel.load = function(self, xmlFile)
	oldShovelLoad(self, xmlFile);

	if self.emptyParticleSystems ~= nil then
		local forage = Fillable.fillTypeNameToInt["forage"];
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local manure = Fillable.fillTypeNameToInt["manure"];
		local woodChips = Fillable.fillTypeNameToInt["woodChips"];
		local dryGrass_windrow = Fillable.fillTypeNameToInt["dryGrass_windrow"];
		local grass_windrow = Fillable.fillTypeNameToInt["grass_windrow"];
		local wheat_windrow = Fillable.fillTypeNameToInt["wheat_windrow"];
		local barley_windrow = Fillable.fillTypeNameToInt["barley_windrow"];
		local compost = Fillable.fillTypeNameToInt["compost"];
		local oat = Fillable.fillTypeNameToInt["oat"];
		local rye = Fillable.fillTypeNameToInt["rye"];
		local sunflower = Fillable.fillTypeNameToInt["sunflower"];
		local beetPulp = Fillable.fillTypeNameToInt["beetPulp"];
		local fertilizer = Fillable.fillTypeNameToInt["fertilizer"];
		local kalk = Fillable.fillTypeNameToInt["kalk"];
		local seeds2 = Fillable.fillTypeNameToInt["seeds2"];
	
		if self.emptyParticleSystems[chaff] ~= nil then
			if self.emptyParticleSystems[manure] ~= nil then
				if self.emptyParticleSystems[forage] == nil and self.fillTypes[Fillable.FILLTYPE_FORAGE] then
					self.emptyParticleSystems[forage] = self.emptyParticleSystems[manure];
				end;
				
				if self.emptyParticleSystems[compost] == nil and self.fillTypes[Fillable.FILLTYPE_COMPOST] then
					self.emptyParticleSystems[compost] = self.emptyParticleSystems[manure];
				end;
			else
				if self.fillTypes[Fillable.FILLTYPE_MANURE] then
					self.emptyParticleSystems[manure] = self.emptyParticleSystems[chaff];
				end;
				
				if self.emptyParticleSystems[forage] == nil and self.fillTypes[Fillable.FILLTYPE_FORAGE] then
					self.emptyParticleSystems[forage] = self.emptyParticleSystems[chaff];
				end;
	
				if self.emptyParticleSystems[compost] == nil and self.fillTypes[Fillable.FILLTYPE_COMPOST] then
					self.emptyParticleSystems[compost] = self.emptyParticleSystems[chaff];
				end;
			end;
	
			if self.emptyParticleSystems[woodChips] == nil and self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] then
				self.emptyParticleSystems[woodChips] = self.emptyParticleSystems[chaff];
			end;
	
			if self.emptyParticleSystems[dryGrass_windrow] == nil and self.fillTypes[Fillable.FILLTYPE_DRYGRASS_WINDROW] then
				self.emptyParticleSystems[dryGrass_windrow] = self.emptyParticleSystems[chaff];
			end;
	
			if self.emptyParticleSystems[grass_windrow] == nil and self.fillTypes[Fillable.FILLTYPE_GRASS_WINDROW] then
				self.emptyParticleSystems[grass_windrow] = self.emptyParticleSystems[chaff];
			end;
		end;
	
		if self.emptyParticleSystems[woodChips] ~= nil then
			if self.emptyParticleSystems[wheat_windrow] == nil and self.fillTypes[Fillable.FILLTYPE_WHEAT_WINDROW] then
				self.emptyParticleSystems[wheat_windrow] = self.emptyParticleSystems[woodChips];
			end;
	
			if self.emptyParticleSystems[barley_windrow] == nil and self.fillTypes[Fillable.FILLTYPE_BARLEY_WINDROW] then
				self.emptyParticleSystems[barley_windrow] = self.emptyParticleSystems[woodChips];
			end;
			
			if self.emptyParticleSystems[beetPulp] == nil and self.fillTypes[Fillable.FILLTYPE_BEETPULP] then
				self.emptyParticleSystems[beetPulp] = self.emptyParticleSystems[woodChips];
			end;
		end;
		
		--## New in FS 15
		--## IMPORTANT!! Map needs the Material Holder for the 'rye', 'oat' and 'sunflower' shovelEmptyEffect !
		if self.shovelEmptyEffectFillTypes ~= nil then
			if self.shovelEmptyEffectFillTypes[sunflower] == nil and self.fillTypes[Fillable.FILLTYPE_SUNFLOWER] then
				self.shovelEmptyEffectFillTypes[sunflower] = true;
			end;
			
			if self.shovelEmptyEffectFillTypes[rye] == nil and self.fillTypes[Fillable.FILLTYPE_RYE] then
				self.shovelEmptyEffectFillTypes[rye] = true;
			end;
				
			if self.shovelEmptyEffectFillTypes[oat] == nil and self.fillTypes[Fillable.FILLTYPE_OAT] then
				self.shovelEmptyEffectFillTypes[oat] = true;
			end;
			
			if self.shovelEmptyEffectFillTypes[fertilizer] == nil and self.fillTypes[Fillable.FILLTYPE_FERTILIZER] then 
				self.shovelEmptyEffectFillTypes[fertilizer] = true;
			end;
				
			if self.shovelEmptyEffectFillTypes[kalk] == nil and self.fillTypes[Fillable.FILLTYPE_KALK] then 
				self.shovelEmptyEffectFillTypes[kalk] = true;
			end;
			
			if self.shovelEmptyEffectFillTypes[seeds2] == nil and self.fillTypes[Fillable.FILLTYPE_SEEDS2] then 
				self.shovelEmptyEffectFillTypes[seeds2] = true;
			end;
		end;
	end;
end;

local oldShovelDelete = Shovel.delete;
Shovel.delete = function(self)
	if self.emptyParticleSystems ~= nil then
		local forage = Fillable.fillTypeNameToInt["forage"];
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local manure = Fillable.fillTypeNameToInt["manure"];
		local woodChips = Fillable.fillTypeNameToInt["woodChips"];
		local dryGrass_windrow = Fillable.fillTypeNameToInt["dryGrass_windrow"];
		local grass_windrow = Fillable.fillTypeNameToInt["grass_windrow"];
		local wheat_windrow = Fillable.fillTypeNameToInt["wheat_windrow"];
		local barley_windrow = Fillable.fillTypeNameToInt["barley_windrow"];
		local compost = Fillable.fillTypeNameToInt["compost"];
		local oat = Fillable.fillTypeNameToInt["oat"];
		local rye = Fillable.fillTypeNameToInt["rye"];
		local sunflower = Fillable.fillTypeNameToInt["sunflower"];
		local beetPulp = Fillable.fillTypeNameToInt["beetPulp"];
		local fertilizer = Fillable.fillTypeNameToInt["fertilizer"];
		local kalk = Fillable.fillTypeNameToInt["kalk"];
		local seeds2 = Fillable.fillTypeNameToInt["seeds2"];
		
		if self.emptyParticleSystems[forage] == self.emptyParticleSystems[(manure or chaff)] and self.fillTypes[Fillable.FILLTYPE_FORAGE] then
			self.emptyParticleSystems[forage] = nil;
		end;
		
		if self.emptyParticleSystems[compost] == self.emptyParticleSystems[(manure or chaff)] and self.fillTypes[Fillable.FILLTYPE_COMPOST] then
			self.emptyParticleSystems[compost] = nil;
		end;
	
		if self.emptyParticleSystems[woodChips] == self.emptyParticleSystems[chaff] and self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] then
			self.emptyParticleSystems[woodChips] = nil;
		end;
	
		if self.emptyParticleSystems[dryGrass_windrow] == self.emptyParticleSystems[chaff] and self.fillTypes[Fillable.FILLTYPE_DRYGRASS_WINDROW] then
			self.emptyParticleSystems[dryGrass_windrow] = nil;
		end;
	
		if self.emptyParticleSystems[grass_windrow] == self.emptyParticleSystems[chaff] and self.fillTypes[Fillable.FILLTYPE_GRASS_WINDROW] then
			self.emptyParticleSystems[grass_windrow] = nil;
		end;
	
		if self.emptyParticleSystems[wheat_windrow] == self.emptyParticleSystems[woodChips] and self.fillTypes[Fillable.FILLTYPE_WHEAT_WINDROW] then
			self.emptyParticleSystems[wheat_windrow] = nil;
		end;
	
		if self.emptyParticleSystems[barley_windrow] == self.emptyParticleSystems[woodChips] and self.fillTypes[Fillable.FILLTYPE_BARLEY_WINDROW] then
			self.emptyParticleSystems[barley_windrow] = nil;
		end;
		
		if self.emptyParticleSystems[beetPulp] == self.emptyParticleSystems[woodChips] and self.fillTypes[Fillable.FILLTYPE_BEETPULP] then
			self.emptyParticleSystems[beetPulp] = nil;
		end;
		
		--## New in FS 15
		if self.shovelEmptyEffectFillTypes ~= nil then
			if self.shovelEmptyEffectFillTypes[sunflower] and self.fillTypes[Fillable.FILLTYPE_SUNFLOWER] then
				self.shovelEmptyEffectFillTypes[sunflower] = nil;
			end;
			
			if self.shovelEmptyEffectFillTypes[rye] and self.fillTypes[Fillable.FILLTYPE_RYE] then
				self.shovelEmptyEffectFillTypes[rye] = nil;
			end;
			
			if self.shovelEmptyEffectFillTypes[oat] and self.fillTypes[Fillable.FILLTYPE_OAT] then
				self.shovelEmptyEffectFillTypes[oat] = nil;
			end;
			
			if self.shovelEmptyEffectFillTypes[fertilizer] == nil and self.fillTypes[Fillable.FILLTYPE_FERTILIZER] then 
				self.shovelEmptyEffectFillTypes[fertilizer] = nil;
			end;
				
			if self.shovelEmptyEffectFillTypes[kalk] == nil and self.fillTypes[Fillable.FILLTYPE_KALK] then 
				self.shovelEmptyEffectFillTypes[kalk] = nil;
			end;
			
			if self.shovelEmptyEffectFillTypes[seeds2] == nil and self.fillTypes[Fillable.FILLTYPE_SEEDS2] then 
				self.shovelEmptyEffectFillTypes[seeds2] = nil;
			end;
		end;
		
		oldShovelDelete(self);
	end;
end;