local metadata = {
"## Interface: 2.1.0.2 RC3",
"## Title: FermentingSilo",
"## Notes: Map FermentingSilo",
"## Author: Marhu",
"## Version: 1.2.3",
"## Date: 21.06.2014",
"## Web: http://marhu.net"
}

local function Debug(printDebug,who,...)
	if printDebug then
		if who == 2 then
			if g_currentMission.aaa_table then
				local data = {meta = metadata,who = who}
				g_currentMission.aaa_table:Debug(data,...)
			end;
		else
			local text, TITLE, VERSION = "","Marhus Mod",""
			for i = 1, select("#", ...) do
				if type(select(i, ...)) == "boolean" then
					text = text..(select(i, ...) and "true" or "false").." ";
				else text = text..(select(i, ...) or "nil").." "; end;
			end
			for i = 1, table.getn(metadata) do
				local nBeginn, nEnde = string.find(metadata[i],"## Title: ");
				if nEnde then TITLE = string.sub (metadata[i], nEnde); end;
				local nBeginn, nEnde = string.find(metadata[i],"## Version: ");
				if nEnde then VERSION = " v"..string.sub (metadata[i], nEnde); end;
			end;
			print(TITLE..VERSION..": "..text);
		end;
	end;
end;

FermentingSilo = {};
FermentingSilo.ModDir = g_currentModDirectory
FermentingSilo_mt = nil

local nBeginn, nEnde = string.find(FermentingSilo.ModDir,"FermentingSilo");
if nBeginn then
	FermentingSilo_mt = Class(FermentingSilo, Placeable);
else
	FermentingSilo.RunAsGE = true;
	FermentingSilo_mt = Class(FermentingSilo, Object);
end

InitObjectClass(FermentingSilo, "FermentingSilo");

function FermentingSilo.onCreate(id)
	local object = FermentingSilo:new(g_server ~= nil, g_client ~= nil)
	if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object);
        object:register(true);
		--print(string.format("FermentingSilo.onCreate %d - %s",id,getName(id)))
    else
        object:delete();
    end;
		
end;

function FermentingSilo:new(isServer, isClient, customMt)
  
	local mt = customMt;
    if mt == nil then
          mt = FermentingSilo_mt;
    end;
  
	local self = {};
	if FermentingSilo.RunAsGE then
		self = Object:new(isServer, isClient, mt)
	else
		self = Placeable:new(isServer, isClient, mt);
		registerObjectClassName(self, "FermentingSilo");
	end;
		
	self.updateMs = 0;
	self.updateMin = 0;
	self.updateIntervall = 1;
	self.FillLvl = 0;
	self.SilageLvl = 0;
	self.trailerTipTrigger = {}
			
	return self;
end;
 
function FermentingSilo:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)

	if not FermentingSilo.RunAsGE then
		if not FermentingSilo:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
			return false;
		end;
	else
		self.nodeId = xmlFilename;
    end;
		
	if not moveMode then
	
		self.db = {name = "FermentingSilo",debug = false};
		if g_currentMission.DatenBank then g_currentMission.DatenBank.Add(self,self.db); end;
		self.optionen = {
			name = "FermentingSilo",
			desc = "FermentingSilo",
			type = 'group',
			args = {
				debuging = {name = "Debug",	desc = "Print Debug Info in the Log.txt",type = 'toggle',get = function() return self.db.debug end,set = function(info, newValue)self.db.debug = newValue;end;};
			};};
		
		self.name = getName(self.nodeId);
		Debug(self.db.debug,1,string.format("FermentingSilo(%s) load as GE %s",self.name,tostring(FermentingSilo.RunAsGE)));
		if g_i18n:hasModText(self.name) then
			self.name = g_i18n:getText(self.name)
		end;
		
		self.updateTick = FermentingSilo.updateTick;
		self.getNoAllowedText = FermentingSilo.getNoAllowedText;
		self.getHasSpaceForTipping = FermentingSilo.getHasSpaceForTipping;
		self.updateTrailerTipping = FermentingSilo.updateTrailerTipping;
		self.getTipTriggerFillLevel = FermentingSilo.getTipTriggerFillLevel;
		self.getTipInfoForTrailer = FermentingSilo.getTipInfoForTrailer;
		self.updatePlane = FermentingSilo.updatePlane;
		
		self.priceMultiplier = 0;

		self.silagePerHour = Utils.getNoNil(getUserAttribute(self.nodeId, "silagePerHour"),10000);
		
		local TipTriggerIndex = getUserAttribute(self.nodeId, "TipTriggerIndex");
		if TipTriggerIndex then
			local tipTriggersId = Utils.indexToObject(self.nodeId, TipTriggerIndex);
					
			local acceptedFillTypes = {}
			local fillTypes = getUserAttribute(tipTriggersId, "fillTypes");
			if fillTypes == nil then
				fillTypes = getUserAttribute(tipTriggersId, "fruitTypes");
			end
			if fillTypes ~= nil then
				local types = Utils.splitString(" ", fillTypes);
				for k,v in pairs(types) do
					local desc = Fillable.fillTypeNameToDesc[v];
					if desc ~= nil then
						acceptedFillTypes[desc.index] = true;
						self.L_FillLvl = Fillable.fillTypeIndexToDesc[desc.index].nameI18N
					else
						print("Error: (FermentingSilo) invalid fillType "..v.." in "..getName(tipTriggersId));
					end;
				end;
			end;
			
			local tipTrigger = FeedingTroughTipTrigger:new(self.isServer, self.isClient);
			local priceMultipliersString = getUserAttribute(tipTriggersId, "priceMultipliers");
			if priceMultipliersString == nil or priceMultipliersString == "" then
				tipTrigger.priceMultipliers = {};
				tipTrigger.acceptedFillTypes = acceptedFillTypes;
			end
			tipTrigger:load(tipTriggersId,self);
			--g_currentMission:addOnCreateLoadedObject(tipTrigger);
			tipTrigger:register(true);
			
			removeTrigger(tipTrigger.triggerId);
			addTrigger(tipTrigger.triggerId , "TipTriggerCallback", self);
			
			tipTrigger.capacity = Utils.getNoNil(getUserAttribute(tipTriggersId, "capacity"),100000)
			if tipTrigger.fillPlane ~= nil then
				tipTrigger.Plane = tipTrigger.fillPlane;
				tipTrigger.fillPlane = nil;
			end;
			
			local BaleTriggerIndex = getUserAttribute(tipTriggersId, "BaleTriggerIndex");
			if BaleTriggerIndex then
				local BaleTriggerId = Utils.indexToObject(tipTriggersId, BaleTriggerIndex);
				if BaleTriggerId then
					tipTrigger.BaleTrigger = BaleTriggerId
					addTrigger(tipTrigger.BaleTrigger, "BaleTriggerCallback", self);
				end;
			end;
			-- Save Orginal PriceMultipliers
			tipTrigger.org_priceMultipliers = {}
			for typ, multi in pairs (tipTrigger.priceMultipliers) do
				tipTrigger.org_priceMultipliers[typ] = multi
			end;
			
			self.TipTrigger = tipTrigger;
			--print(table.show(self.TipTrigger,"self.TipTrigger"))
			
			local LvLIndicatorIndex = getUserAttribute(self.nodeId, "LvLIndicator");
			if LvLIndicatorIndex then
				--print("LvLIndicator")
				local LvLIndicator = Utils.indexToObject(self.nodeId, LvLIndicatorIndex);
				self.LvLIndicator = {}
				local movingIndex1 = getUserAttribute(LvLIndicator, "movingIndex1");
				local movingIndex2 = getUserAttribute(LvLIndicator, "movingIndex2");
				if movingIndex1 ~= nil and movingIndex2 ~= nil then
					self.LvLIndicator.movingId1 = Utils.indexToObject(LvLIndicator, movingIndex1);
					self.LvLIndicator.movingId2 = Utils.indexToObject(LvLIndicator, movingIndex2);
					if self.LvLIndicator.movingId1 ~= nil and self.LvLIndicator.movingId2 ~= nil then
						self.LvLIndicator.moveMinY = Utils.getNoNil(getUserAttribute(LvLIndicator, "moveMinY"), 0);
						self.LvLIndicator.moveMaxY = Utils.getNoNil(getUserAttribute(LvLIndicator, "moveMaxY"), 0);
						self.LvLIndicator.moveScale = (self.LvLIndicator.moveMaxY-self.LvLIndicator.moveMinY) / self.TipTrigger.capacity;
						self.LvLIndicator.IsDouble = getUserAttribute(LvLIndicator, "IsDouble");
					end;
				end;
			end;
		end;
			
		local SilageTriggerIndex = getUserAttribute(self.nodeId, "SilageTriggerIndex");
		if SilageTriggerIndex ~= nil then   
			local SilageTrigger = Utils.indexToObject(self.nodeId, SilageTriggerIndex);
			if SilageTrigger ~= nil then
				local trigger = SiloTrigger:new(self.isServer, self.isClient);
				local output = getUserAttribute(self.nodeId, "Output");
				local desc = Fillable.fillTypeNameToDesc[output];
				if desc ~= nil then
					trigger:load(SilageTrigger);
					trigger:register(true);
					trigger.fillType = desc.index
					self.L_Silage = Fillable.fillTypeIndexToDesc[desc.index].nameI18N
					self.SilageTrigger = trigger
					function self.SilageTrigger:update(dt) end;
					self.org_priceMultiplier = Utils.getNoNil(getUserAttribute(self.nodeId, "priceMultiplier"),0)
					self.priceMultiplier = Utils.getNoNil(getUserAttribute(self.nodeId, "priceMultiplier"),0)
				else
					print("Error: (FermentingSilo) invalid fillType "..output.." in "..getName(self.nodeId));
				end;
			end;
		end;
		
		local PlayerTriggerIndex = getUserAttribute(self.nodeId,"Interact");
		if PlayerTriggerIndex then
			local PlayerTrigger = Utils.indexToObject(self.nodeId, PlayerTriggerIndex);
			if PlayerTrigger then
				self.PlayerTrigger = PlayerTrigger;
				addTrigger(self.PlayerTrigger, "PlayerTriggerCallback", self);
			end;
		end;

		if not FermentingSilo.RunAsGE then
			local xmlFile = loadXMLFile("TempXML", xmlFilename);
			local AreaStart = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.Area#index"));
			if AreaStart ~= nil then
				self.Area = {}
				self.Area.start  = AreaStart;
				self.Area.width	 = getChildAt(AreaStart,0);
				self.Area.height = getChildAt(AreaStart,1);
				local x,_,z = getWorldTranslation(self.Area.start);
				local x1,_,z1 = getWorldTranslation(self.Area.width);
				local x2,_,z2 = getWorldTranslation(self.Area.height);
				Utils.updateDestroyCommonArea(x, z, x1, z1, x2, z2);
			end;
			delete(xmlFile);
		end;

		self.FermentingSiloDirtyFlag = self:getNextDirtyFlag();

		self.isEnabled = true

		if FermentingSilo.RunAsGE then
			g_currentMission:addNodeObject(self.nodeId, self);
			g_currentMission:addOnCreateLoadedObjectToSave(self);
		end;
	end;
	
	return true;
end;

function FermentingSilo:getSaveAttributesAndNodes(nodeIdent)

	local attributes, nodes = "","";
	
	if not FermentingSilo.RunAsGE then
		attributes, nodes = FermentingSilo:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	end;
	
	local attributes = attributes..' FillLvl="'..self.FillLvl..'" SilageLvl="'..self.SilageLvl..'"';
   
    return attributes,nodes;
end

function FermentingSilo:loadFromAttributesAndNodes(xmlFile, Key)
	if not FermentingSilo.RunAsGE and not FermentingSilo:superClass().loadFromAttributesAndNodes(self, xmlFile, Key) then
		return false;
	end;
	
	self.FillLvl = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#FillLvl"),0);
	self.SilageLvl = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#SilageLvl"),0);
	
	self.updateIndicator = true
	return true;
end

function FermentingSilo:readStream(streamId, connection)
	FermentingSilo:superClass().readStream(self, streamId, connection);
	
	if connection:getIsServer() then
		local isFilling = streamReadBool(streamId);
        if isFilling then
            self.SilageTrigger:startFill();
        else
            self.SilageTrigger:stopFill();
        end;
		self.FillLvl = streamReadFloat32(streamId);
		self.SilageLvl = streamReadFloat32(streamId);
		if self.TipTrigger and self.TipTrigger.Plane then
			local x,y,z = getTranslation(self.TipTrigger.Plane);
            y = streamReadFloat32(streamId);
            setTranslation(self.TipTrigger.Plane, x, y, z);
		end;
		self.updateIndicator = true;
	end;
end;
 
function FermentingSilo:writeStream(streamId, connection)
	FermentingSilo:superClass().writeStream(self, streamId, connection);
	
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.SilageTrigger.isFilling)
		streamWriteFloat32(streamId, self.FillLvl);
		streamWriteFloat32(streamId, self.SilageLvl);
		if self.TipTrigger and self.TipTrigger.Plane then
			local x,y,z = getTranslation(self.TipTrigger.Plane);
			streamWriteFloat32(streamId, y);
		end;
	end;
end

function FermentingSilo:readUpdateStream(streamId, timestamp, connection)
	FermentingSilo:superClass().readUpdateStream(self, streamId, timestamp, connection);
	
	if connection:getIsServer() then
		local isFilling = streamReadBool(streamId);
        if isFilling then
            self.SilageTrigger:startFill();
        else
            self.SilageTrigger:stopFill();
        end;
		self.FillLvl = streamReadFloat32(streamId);
		self.SilageLvl = streamReadFloat32(streamId);
		if self.TipTrigger and self.TipTrigger.Plane then
			local x,y,z = getTranslation(self.TipTrigger.Plane);
            y = streamReadFloat32(streamId);
            setTranslation(self.TipTrigger.Plane, x, y, z);
		end;
		self.updateIndicator = true;
	end;
end;

function FermentingSilo:writeUpdateStream(streamId, connection, dirtyMask)
	FermentingSilo:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
		
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.SilageTrigger.isFilling)
		streamWriteFloat32(streamId, self.FillLvl);
		streamWriteFloat32(streamId, self.SilageLvl);
		if self.TipTrigger and self.TipTrigger.Plane then
			local x,y,z = getTranslation(self.TipTrigger.Plane);
			streamWriteFloat32(streamId, y);
		end;
	end;
end;

function FermentingSilo:delete()
	if self.PlayerTrigger then removeTrigger(self.PlayerTrigger); end;
	if self.nodeId ~= 0 then g_currentMission:removeNodeObject(self.nodeId); end;
	if FermentingSilo.RunAsGE then g_currentMission:removeOnCreateLoadedObjectToSave(self);end;
	unregisterObjectClassName(self);
	FermentingSilo:superClass().delete(self);
end;

function FermentingSilo:deleteFinal()
    FermentingSilo:superClass().deleteFinal(self);
end;

function FermentingSilo:update(dt)

	if not self.menueaddet then	self.menueaddet = true;	if g_currentMission.ModMenue then g_currentMission.ModMenue:Add(self.optionen);end;end;
	
	if self.isServer and self.SilageTrigger then
		local trailer = self.SilageTrigger.siloTrailer;
		if self.SilageTrigger.fill >= 4 and trailer ~= nil and not self.SilageTrigger.fillDone then
			trailer:resetFillLevelIfNeeded(self.SilageTrigger.fillType);
			local fillLevel = trailer:getFillLevel(self.SilageTrigger.fillType);
			if self.SilageLvl > 0 and trailer:allowFillType(self.SilageTrigger.fillType, false) then
				local deltaFillLevel = math.min(self.SilageTrigger.fillLitersPerSecond*0.001*dt, self.SilageLvl);
				trailer:setFillLevel(fillLevel+deltaFillLevel, self.SilageTrigger.fillType);
				local newFillLevel = trailer:getFillLevel(self.SilageTrigger.fillType);
					
				if fillLevel ~= newFillLevel then
					self.SilageLvl = math.max(self.SilageLvl-(newFillLevel-fillLevel), 0);
					self.SilageTrigger:startFill();
					if self.priceMultiplier ~= 0 then
						local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1); -- 1  2  4
			 			local money = Fillable.fillTypeIndexToDesc[self.SilageTrigger.fillType].pricePerLiter * self.priceMultiplier * difficultyMultiplier * -(newFillLevel-fillLevel);
						g_currentMission:addSharedMoney(money);
					end
					self.SendUpdate = true;
					self.updateIndicator = true;
				else
					self.SilageTrigger.fillDone = true; -- trailer is full
					self.SilageTrigger:stopFill();
				end;

			else
				self.SilageTrigger.fillDone = true; -- silo is empty or trailer does not support fill type
				self.SilageTrigger:stopFill();
			end;
		end;
	end;

	if self.changeAllowed then
	
		local Percentage = math.abs((self.FillLvl+self.SilageLvl) / self.TipTrigger.capacity * 100);
		g_currentMission:addExtraPrintText(self.name.." "..string.format("%d (%d%%)",self.FillLvl+self.SilageLvl ,Percentage));
		
		local text = string.format("%s",self.L_FillLvl.." [l]");
		local Percentage = math.abs(self.FillLvl / self.TipTrigger.capacity * 100);
		text = text.." "..string.format("%d (%d%%)",self.FillLvl ,Percentage);
		g_currentMission:addExtraPrintText(text);
		
		local text = string.format("%s",self.L_Silage.." [l]");
		local Percentage = math.abs(self.SilageLvl / self.TipTrigger.capacity * 100);
		text = text.." "..string.format("%d (%d%%)",self.SilageLvl ,Percentage);
		g_currentMission:addExtraPrintText(text);
		
		if not g_currentMission.controlPlayer then
			self.changeAllowed = false;
		end;
	end;
	
end;

function FermentingSilo:updateTick(dt)
	
	self.updateMs = self.updateMs + (dt * g_currentMission.missionStats.timeScale);
	if self.updateMs >= 60000   then
		self.updateMs = self.updateMs - 60000;
		self.updateMin = self.updateMin + 1;
		if self.updateMin >= self.updateIntervall then
			self.updateMin = self.updateMin - self.updateIntervall
			if self.isServer then
				
				local need = (self.silagePerHour/60 * self.updateIntervall) --Bedarf pro intervall 
				if self.TipTrigger and self.TipTrigger.capacity then
					need = math.min(need, self.FillLvl,self.TipTrigger.capacity-self.SilageLvl);
				else
					need = 0;
				end;
				
				self.FillLvl = self.FillLvl - need;				
				self.SilageLvl = self.SilageLvl + need; -- add forage 
				
				self.SendUpdate = true;
				self.updateIndicator = true;
			end;
		end;
	end;
    
	if self.updateIndicator then
		
		self.updateIndicator = nil;
		
		if self.LvLIndicator and self.LvLIndicator.moveScale ~= nil then

			local x1,y1,z1 = getTranslation(self.LvLIndicator.movingId1);
			local x2,y2,z2 = getTranslation(self.LvLIndicator.movingId2);
			
			y1 = math.min(self.LvLIndicator.moveMinY+(self.FillLvl+self.SilageLvl)*self.LvLIndicator.moveScale, self.LvLIndicator.moveMaxY);
			y2 = math.min(self.LvLIndicator.moveMinY+self.SilageLvl*self.LvLIndicator.moveScale, self.LvLIndicator.moveMaxY);
			
			setTranslation(self.LvLIndicator.movingId1, x1, y1, z1);
			setTranslation(self.LvLIndicator.movingId2, x2, y2, z2);
			
			if self.isServer then
				self.SendUpdate = true;
			end;
		end;
	end;
	
	if self.TipTrigger.Plane ~= nil   then
        local x,y,z = getTranslation(self.TipTrigger.Plane);
        local newY = math.max(y-dt*self.TipTrigger.moveBackScale, self.TipTrigger.moveMinY);
        setTranslation(self.TipTrigger.Plane, x, newY, z);
    end;
	
	local HourUpdate = false;
    if g_currentMission.environment.currentHour ~= self.LastHour then
		self.LastHour = g_currentMission.environment.currentHour;
		HourUpdate = true;
	end;
	
	if HourUpdate == true then
		local fac = Utils.lerp(1.25, 0.75, self.FillLvl/self.TipTrigger.capacity)
		for acceptedFillTypes, v in pairs(self.TipTrigger.acceptedFillTypes) do 
			local multi = self.TipTrigger.org_priceMultipliers[acceptedFillTypes]
			if multi ~= nil then
				self.TipTrigger.priceMultipliers[acceptedFillTypes] = multi * fac
			end;
		end;
			
		local fac = Utils.lerp(1.25, 0.75, self.SilageLvl/self.TipTrigger.capacity)
		self.priceMultiplier = self.org_priceMultiplier * fac
	end;
	
	if self.isServer and self.SendUpdate then
		self.SendUpdate = false;
		self:raiseDirtyFlags(self.FermentingSiloDirtyFlag);
	end
end;

function FermentingSilo:getNoAllowedText(trailer)
	if trailer.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
		
		if not self.trailerTipTrigger[trailer].acceptedFillTypes[trailer.currentFillType] then
			return Fillable.fillTypeIndexToDesc[trailer.currentFillType].nameI18N .. g_i18n:getText("notAcceptedHere");
		else
			return g_i18n:getText("Here_is_no_space");
		end
	end
	
	return nil;
end;

function FermentingSilo:getHasSpaceForTipping(fillType)
	
	if self.TipTrigger.acceptedFillTypes[fillType] then
		if self.TipTrigger.capacity <= self.FillLvl + self.SilageLvl then
			return false;
		end;
	end;
	return true;			
end;	

function FermentingSilo:getTipInfoForTrailer(trailer, tipReferencePointIndex)
    
	local minDistance, bestPoint, trigger = math.huge, nil, nil
	
	local distance, Point = self.TipTrigger:getTipDistanceFromTrailer(trailer, tipReferencePointIndex);
	if distance < minDistance then
		minDistance = distance;
		bestPoint = Point;
	end;

	self.trailerTipTrigger[trailer] = self.TipTrigger;
	
	local isAllowed = true;
	if not self.TipTrigger.acceptedFillTypes[trailer.currentFillType] then
		isAllowed = false;
	elseif not self:getHasSpaceForTipping(trailer.currentFillType) then
		isAllowed = false;
	end
	
    return isAllowed, minDistance, bestPoint;
end	
	
function FermentingSilo:updateTrailerTipping(trailer, fillDelta, fillType, trigger)
	
	if fillDelta < 0 then
		self.FillLvl = self.FillLvl - fillDelta;
	
		self:updatePlane(fillDelta)
		self.updateIndicator = true;
		
		local priceMultiplier = self.TipTrigger.priceMultipliers[fillType];
		if priceMultiplier ~= nil then
			
			-- update total amount of this fill type
			local desc = Fillable.fillTypeIndexToDesc[fillType];
			desc.totalAmount = desc.totalAmount - fillDelta;
 
			local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1); -- 1  2  4
			local greatDemandMultiplier = 1;
  
			-- check if a great demand pertaining to this fill type / station is currently running
			local greatDemand = g_currentMission.economyManager:getCurrentGreatDemand(self.TipTrigger.stationName, fillType);
			if greatDemand ~= nil then
			  greatDemandMultiplier = greatDemand.demandMultiplier;
			end;
  
			local money = Fillable.fillTypeIndexToDesc[fillType].pricePerLiter * priceMultiplier * difficultyMultiplier * greatDemandMultiplier * -fillDelta;
			--g_currentMission.missionStats.money = g_currentMission.missionStats.money + money;
			g_currentMission:addSharedMoney(money, "harvestIncome");
        end;  
	end;
end;

function FermentingSilo:getTipTriggerFillLevel(trigger)
	
	return self.FillLvl;
end

function FermentingSilo:updatePlane(delta)
	if self.TipTrigger and self.TipTrigger.Plane ~= nil and self.isServer then
        local x,y,z = getTranslation(self.TipTrigger.Plane);
        local newY = math.min(y-delta*self.TipTrigger.moveScale, self.TipTrigger.moveMaxY);
        setTranslation(self.TipTrigger.Plane, x, newY, z);
    end;
end

function FermentingSilo:BaleTriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	-- not yet included.
end;

function FermentingSilo:TipTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
		
	local trailer = g_currentMission.objectToTrailer[otherShapeId];
	if trailer ~= nil and trailer.allowTipDischarge then
		if onEnter then
			if g_currentMission.trailerTipTriggers[trailer] == nil then
				g_currentMission.trailerTipTriggers[trailer] = {};
			end;
			table.insert(g_currentMission.trailerTipTriggers[trailer], self);
		elseif onLeave then
			local triggers = g_currentMission.trailerTipTriggers[trailer];
			if triggers ~= nil then
				for i=1, table.getn(triggers) do
					if triggers[i] == self then
						table.remove(triggers, i);
						if table.getn(triggers) == 0 then
							g_currentMission.trailerTipTriggers[trailer] = nil;
						end;
						break;
					end;
				end;
			end;
		end;
	end;
end;

function FermentingSilo:PlayerTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	
	if (g_currentMission.controlPlayer and g_currentMission.player and otherId == g_currentMission.player.rootNode) then
		if (onEnter) then 
            self.changeAllowed = true;
        elseif (onLeave) then
            self.changeAllowed = false;
        end;
	end;
	
end;

if FermentingSilo.RunAsGE then
	g_onCreateUtil.addOnCreateFunction("FermentingSilo", FermentingSilo.onCreate);
else
	registerPlaceableType("FermentingSilo", FermentingSilo);
end;
 
-- Fix Game Error Vehikles.xml bei new Objekt (Hahn Bug)
local org_AnimalHusbandry_addAnimals = AnimalHusbandry.addAnimals;
AnimalHusbandry.addAnimals = function(a, b, c, d, e)
	if c ~= 1 or a.typeName == "chicken" then
		org_AnimalHusbandry_addAnimals(a, b, c, d, e)
	end;
end;
