--[[
Specialization to show a manure dust on a fillable vehicle

Author:		Ifko[nator]
Date:		24.10.2015
Version:	1.0
]]

ManureDust = {};

function ManureDust.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function ManureDust:load(xmlFile)
	self.manureDusts = {};
	
	local dustNumber = 0;
	while true do
		local key = string.format("vehicle.manureDusts.manureDust(%d)", dustNumber);
		local node = getXMLString(xmlFile, key .. "#index");
		
		if node == nil then
			break;
		end;
		
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local manureDust = {};
			manureDust.particleSystem = {};
			manureDust.node = node;
			StaticParticleSystem.loadParticleSystem(xmlFile, manureDust.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.manureDusts, manureDust);
		end;
		dustNumber = dustNumber + 1;
	end;
	
	--## second PS for more dust when cover is opening
	self.manureDustsCopy = {};
	
	local copyDustNumber = 0;
	while true do
		local keyCopy = string.format("vehicle.manureDusts.manureDust(%d)", copyDustNumber);
		local nodeCopy = getXMLString(xmlFile, keyCopy .. "#index");
		
		if nodeCopy == nil then
			break;
		end;
		
		nodeCopy = Utils.indexToObject(self.components, nodeCopy);
		if nodeCopy ~= nil then
			local manureDustCopy = {};
			manureDustCopy.particleSystem = {};
			manureDustCopy.node = nodeCopy;
			StaticParticleSystem.loadParticleSystem(xmlFile, manureDustCopy.particleSystem, keyCopy, self.components, false, nil, self.baseDirectory);
			table.insert(self.manureDustsCopy, manureDustCopy);
		end;
		copyDustNumber = copyDustNumber + 1;
	end;
	
	self.openedCoverTime = 200;
end;	
	
function ManureDust:delete()
	for k, manureDust in pairs(self.manureDusts) do
		Utils.deleteParticleSystem(manureDust.particleSystem);
	end;
	
	for k, manureDustCopy in pairs(self.manureDustsCopy) do
		Utils.deleteParticleSystem(manureDustCopy.particleSystem);
	end;
end;

function ManureDust:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManureDust:keyEvent(unicode, sym, modifier, isDown)
end;

function ManureDust:update(dt)	
	if self.isCoverOpen == nil then
		--## cover specialization is not available
		self.isCoverOpen = true;
	end;
	
	if self.isCoverOpen then
		if self.openedCoverTime < 200 then
			self.openedCoverTime = self.openedCoverTime + 1;
		end;
	else
		self.openedCoverTime = 0;
	end;
	
	for _, manureDust in pairs(self.manureDusts) do
		if self.fillLevel > 0 and self.currentFillType == Fillable.FILLTYPE_MANURE then
			Utils.setEmittingState(manureDust.particleSystem, true);
		else
			Utils.setEmittingState(manureDust.particleSystem, false);
		end;
		
		--## blend out and in the particle system faster
		setVisibility(manureDust.node, self.isCoverOpen);	
	end;
	
	for _, manureDustCopy in pairs(self.manureDustsCopy) do
		if self.fillLevel > 0 and self.currentFillType == Fillable.FILLTYPE_MANURE and self.openedCoverTime < 200 then
			Utils.setEmittingState(manureDustCopy.particleSystem, true);
		else
			Utils.setEmittingState(manureDustCopy.particleSystem, false);
		end;
		
		--## blend out and in the particle system faster
		setVisibility(manureDustCopy.node, self.isCoverOpen);
	end;
end;

function ManureDust:draw()
	--[[setTextAlignment(RenderText.ALIGN_CENTER) 
	renderText(0.5, 0.5, 0.025, "openedCoverTime = " .. self.openedCoverTime .. ".");]]
end;

----------------------------------------------------------------------------
StaticParticleSystem = {};

function StaticParticleSystem.loadParticleSystem(xmlFile, particleSystemTable, baseString, component, currentEmittingState, defaultParticleSystem, directory)
	local defaultLinkNode = component;
	if type(component) == "table" then
		defaultLinkNode = component[1].node;
	end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(component, getXMLString(xmlFile, baseString .. "#index")), defaultLinkNode);
	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = defaultParticleSystem;
	end
	if psFile == nil then
		return;
	end
	psFile = Utils.getFilename(psFile, directory);
	local rootNode = loadI3DFile(psFile);
	if rootNode == 0 then
		print("[ERROR der ManureDust.lua]: Das ParticleSystem '" .. psFile .. "' konnte nicht geladen werden. Dieses ParticleSystem ist daher inakiv.");
		return;
	end
	link(linkNode, rootNode);
	for i=0, getNumOfChildren(rootNode)-1 do
		local child = getChildAt(rootNode, i);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 then
				if getClassName(geometry) == "ParticleSystem" then
					table.insert(particleSystemTable, {geometry = geometry, shape = child});
					if currentEmittingState ~= nil then
						setEmittingState(geometry, currentEmittingState);
					end;
				end;
			end;
		end;
	end;
	return rootNode;
end;