--[[
Specialization to animate two springs on a trailer attacher

Author:		Ifko[nator]
Date:		24.10.2015
Version:	1.0
]]


Spring = {};

function Spring.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Spring:load(xmlFile)
	self.springLeft = {};
	self.springLeft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spring.springLeft#index"));
	local x,y,z = getRotation(self.springLeft.node);
	
	self.springLeft.part = {x,y,z};
	self.springLeft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spring.springLeft#part"));
	x,y,z = getTranslation(self.springLeft.part);
	
	self.springLeft.fixPoint = {x,y,z};
	self.springLeft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spring.springLeft#fixPoint"));
	
	local ax, ay, az = getWorldTranslation(self.springLeft.part);
	local bx, by, bz = getWorldTranslation(self.springLeft.fixPoint);		
	self.springLeft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.springLeft.target = {x,y,z};
	self.springLeft.target = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spring.springLeft#target"));
	
	---------------------------------------------------------------------------------------------------------------------------------
	
	self.springRight = {};
	self.springRight.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spring.springRight#index"));
	x,y,z = getRotation(self.springRight.node);
	
	self.springRight.part = {x,y,z};
	self.springRight.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spring.springRight#part"));
	x,y,z = getTranslation(self.springRight.part);
	
	self.springRight.fixPoint = {x,y,z};
	self.springRight.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spring.springRight#fixPoint"));
	
	ax, ay, az = getWorldTranslation(self.springRight.part);
	bx, by, bz = getWorldTranslation(self.springRight.fixPoint);		
	self.springRight.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.springRight.target = {x,y,z};
	self.springRight.target = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spring.springRight#target"));
	
	------------------------------------------------------------------------------------------------------------------------------------
	
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(2), Utils.degToRad(2));	
end;	
	

function Spring:delete()
end;

function Spring:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Spring:keyEvent(unicode, sym, modifier, isDown)
end;

function Spring:update(dt)	
	if self.springLeft.target ~= nil and self.springRight.target ~= nil then		
		local ax, ay, az = getWorldTranslation(self.springLeft.node);
		local bx, by, bz = getWorldTranslation(self.springLeft.target);
		local x, y, z = worldDirectionToLocal(getParent(self.springLeft.node), bx-ax, by-ay, bz-az);
		
		local upX, upY, upZ = 0,1,0;
		if math.abs(y) > 0.99*Utils.vector3Length(x, y, z) then
			upY = 0;
			if y > 0 then
				upZ = 1;
			else
				upZ = -1;
			end;
		end;
		
		setDirection(self.springLeft.node, x, y, z, upX, upY, upZ);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		setTranslation(self.springLeft.part, 0, 0, distance-self.springLeft.distance);
		
		--------------------------------------------------------------------------------------------------------
		
		local ax2, ay2, az2 = getWorldTranslation(self.springRight.node);
		local bx2, by2, bz2 = getWorldTranslation(self.springRight.target);
		local x2, y2, z2 = worldDirectionToLocal(getParent(self.springRight.node), bx2-ax2, by2-ay2, bz2-az2);
		
		local upX2, upY2, upZ2 = 0,1,0;
		if math.abs(y2) > 0.99*Utils.vector3Length(x2, y2, z2) then
			upY2 = 0;
			if y2 > 0 then
				upZ2 = 1;
			else
				upZ2 = -1;
			end;
		end;
		
		setDirection(self.springRight.node, x2, y2, z2, upX2, upY2, upZ2);
		local distance2 = Utils.vector3Length(ax2-bx2, ay2-by2, az2-bz2);
		setTranslation(self.springRight.part, 0, 0, distance2-self.springRight.distance);
	end;		
end;

function Spring:draw()
end;

function Spring:onAttach()
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-65), Utils.degToRad(65));	
end;

function Spring:onDetach()
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(0), Utils.degToRad(0));	
end;