--[[
Extension for the 'FlieglMain' Specialization for the DPW 150.

Author: Ifko[nator]
Date: 16.09.2015
Version: 1.0

History: V 1.0 @ 16.09.2015 - intial release

Website: http://www.modding-welt.com/index.php/BoardList
]]

FlieglMain_Extension_DPW150 = {};

function FlieglMain_Extension_DPW150.prerequisitesPresent(specializations)
	if SpecializationUtil.hasSpecialization(FlieglMain, specializations) then
		return true;
	else
		print("[ERROR from the FlieglMain_Extension_DPW150.lua]: Missing the specialization 'FlieglMain' in: '" .. self.configFileName .. "'. Script is stopped now!");
		return false;
	end;
end;

function FlieglMain_Extension_DPW150:load(xmlFile)
	self.variableBodyParts = {};
	
	self.variableBodyParts.collisionFront = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.variableBodyParts.collision#indexFront"));
	self.variableBodyParts.collisionBack = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.variableBodyParts.collision#indexBack"));
	
	self.variableBodyParts.variableBodyPart1 = {};
	self.variableBodyParts.variableBodyPart1.visibleIndex1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.variableBodyParts.variableBodyPart1#visibleIndex1"));
	self.variableBodyParts.variableBodyPart1.visibleIndex2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.variableBodyParts.variableBodyPart1#visibleIndex2"));
	
	self.variableBodyParts.variableBodyPart2 = {};
	self.variableBodyParts.variableBodyPart2.visibleIndex1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.variableBodyParts.variableBodyPart2#visibleIndex1"));
	self.variableBodyParts.variableBodyPart2.visibleIndex2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.variableBodyParts.variableBodyPart2#visibleIndex2"));
	
	self.spanngurt = {};
	
	self.spanngurt.quaderballen = {};
	self.spanngurt.quaderballen.ballen1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen1#index"));
	self.spanngurt.quaderballen.ballen2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen2#index"));
	self.spanngurt.quaderballen.ballen3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen3#index"));
	self.spanngurt.quaderballen.ballen4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen4#index"));
	self.spanngurt.quaderballen.ballen5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen5#index"));
	self.spanngurt.quaderballen.ballen6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen6#index"));
	self.spanngurt.quaderballen.ballen7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen7#index"));
	self.spanngurt.quaderballen.ballen8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen8#index"));
	self.spanngurt.quaderballen.ballen9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen9#index"));
	self.spanngurt.quaderballen.ballen10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen10#index"));
	self.spanngurt.quaderballen.ballen11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen11#index"));
	self.spanngurt.quaderballen.ballen12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen12#index"));
	self.spanngurt.quaderballen.ballen13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen13#index"));
	self.spanngurt.quaderballen.ballen14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen14#index"));
	self.spanngurt.quaderballen.ballen15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen15#index"));
	self.spanngurt.quaderballen.ballen16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen16#index"));
	self.spanngurt.quaderballen.ballen17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen17#index"));
	self.spanngurt.quaderballen.ballen18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteQuaderballen.ballen18#index"));
	
	self.spanngurt.standardRundballen = {};
	self.spanngurt.standardRundballen.ballen1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen1#index"));
	self.spanngurt.standardRundballen.ballen2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen2#index"));
	self.spanngurt.standardRundballen.ballen3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen3#index"));
	self.spanngurt.standardRundballen.ballen4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen4#index"));
	self.spanngurt.standardRundballen.ballen5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen5#index"));
	self.spanngurt.standardRundballen.ballen6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen6#index"));
	self.spanngurt.standardRundballen.ballen7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen7#index"));
	self.spanngurt.standardRundballen.ballen8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen8#index"));
	self.spanngurt.standardRundballen.ballen9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen9#index"));
	self.spanngurt.standardRundballen.ballen10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen10#index"));
	self.spanngurt.standardRundballen.ballen11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen11#index"));
	self.spanngurt.standardRundballen.ballen12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen12#index"));
	self.spanngurt.standardRundballen.ballen13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen13#index"));
	self.spanngurt.standardRundballen.ballen14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen14#index"));
	self.spanngurt.standardRundballen.ballen15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen15#index"));
	self.spanngurt.standardRundballen.ballen16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen16#index"));
	self.spanngurt.standardRundballen.ballen17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen17#index"));
	self.spanngurt.standardRundballen.ballen18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen18#index"));
	self.spanngurt.standardRundballen.ballen19 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen19#index"));
	self.spanngurt.standardRundballen.ballen20 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen20#index"));
	self.spanngurt.standardRundballen.ballen21 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen21#index"));
	self.spanngurt.standardRundballen.ballen22 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteStandardRundballen.ballen22#index"));
	
	self.spanngurt.baumsetzlingpaletten = {};
	self.spanngurt.baumsetzlingpaletten.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBaumsetzlingpaletten.palette1#index"));
	self.spanngurt.baumsetzlingpaletten.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBaumsetzlingpaletten.palette2#index"));
	self.spanngurt.baumsetzlingpaletten.palette3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBaumsetzlingpaletten.palette3#index"));
	self.spanngurt.baumsetzlingpaletten.palette4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBaumsetzlingpaletten.palette4#index"));
	self.spanngurt.baumsetzlingpaletten.palette5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBaumsetzlingpaletten.palette5#index"));
	self.spanngurt.baumsetzlingpaletten.palette6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBaumsetzlingpaletten.palette6#index"));
	self.spanngurt.baumsetzlingpaletten.palette7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBaumsetzlingpaletten.palette7#index"));
	self.spanngurt.baumsetzlingpaletten.palette8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBaumsetzlingpaletten.palette8#index"));
	
	self.spanngurt.grosseBaumsetzlingpaletten = {};
	self.spanngurt.grosseBaumsetzlingpaletten.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteGrosseBaumsetzlingpaletten.palette1#index"));
	self.spanngurt.grosseBaumsetzlingpaletten.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteGrosseBaumsetzlingpaletten.palette2#index"));
	self.spanngurt.grosseBaumsetzlingpaletten.palette3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteGrosseBaumsetzlingpaletten.palette3#index"));
	self.spanngurt.grosseBaumsetzlingpaletten.palette4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteGrosseBaumsetzlingpaletten.palette4#index"));
	self.spanngurt.grosseBaumsetzlingpaletten.palette5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteGrosseBaumsetzlingpaletten.palette5#index"));
	self.spanngurt.grosseBaumsetzlingpaletten.palette6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteGrosseBaumsetzlingpaletten.palette6#index"));
	
	self.spanngurt.holzpaletten = {};
	self.spanngurt.holzpaletten.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteHolzpaletten.palette1#index"));
	self.spanngurt.holzpaletten.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteHolzpaletten.palette2#index"));
	self.spanngurt.holzpaletten.palette3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteHolzpaletten.palette3#index"));
	self.spanngurt.holzpaletten.palette4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteHolzpaletten.palette4#index"));
	
	self.spanngurt.kartoffelpaletten = {};
	self.spanngurt.kartoffelpaletten.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteKartoffelpaletten.palette1#index"));
	self.spanngurt.kartoffelpaletten.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteKartoffelpaletten.palette2#index"));
	self.spanngurt.kartoffelpaletten.palette3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteKartoffelpaletten.palette3#index"));
	self.spanngurt.kartoffelpaletten.palette4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteKartoffelpaletten.palette4#index"));
	self.spanngurt.kartoffelpaletten.palette5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteKartoffelpaletten.palette5#index"));
	self.spanngurt.kartoffelpaletten.palette6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteKartoffelpaletten.palette6#index"));
	self.spanngurt.kartoffelpaletten.palette7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteKartoffelpaletten.palette7#index"));
	self.spanngurt.kartoffelpaletten.palette8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteKartoffelpaletten.palette8#index"));
	
	self.spanngurt.transportboxen = {};
	self.spanngurt.transportboxen.box1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box1#index"));
	self.spanngurt.transportboxen.box2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box2#index"));
	self.spanngurt.transportboxen.box3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box3#index"));
	self.spanngurt.transportboxen.box4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box4#index"));
	self.spanngurt.transportboxen.box5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box5#index"));
	self.spanngurt.transportboxen.box6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box6#index"));
	self.spanngurt.transportboxen.box7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box7#index"));
	self.spanngurt.transportboxen.box8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box8#index"));
	self.spanngurt.transportboxen.box9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box9#index"));
	self.spanngurt.transportboxen.box10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box10#index"));
	self.spanngurt.transportboxen.box11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box11#index"));
	self.spanngurt.transportboxen.box12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box12#index"));
	self.spanngurt.transportboxen.box13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box13#index"));
	self.spanngurt.transportboxen.box14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box14#index"));
	self.spanngurt.transportboxen.box15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box15#index"));
	self.spanngurt.transportboxen.box16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box16#index"));
	
	self.spanngurt.siliermittelTanks = {};
	self.spanngurt.siliermittelTanks.tank1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank1#index"));
	self.spanngurt.siliermittelTanks.tank2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank2#index"));
	self.spanngurt.siliermittelTanks.tank3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank3#index"));
	self.spanngurt.siliermittelTanks.tank4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank4#index"));
	self.spanngurt.siliermittelTanks.tank5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank5#index"));
	self.spanngurt.siliermittelTanks.tank6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank6#index"));
	self.spanngurt.siliermittelTanks.tank7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank7#index"));
	self.spanngurt.siliermittelTanks.tank8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank8#index"));
	
	self.spanngurt.H_MilchKannen = {};
	self.spanngurt.H_MilchKannen.kanne1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne1#index"));
	self.spanngurt.H_MilchKannen.kanne2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne2#index"));
	self.spanngurt.H_MilchKannen.kanne3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne3#index"));
	self.spanngurt.H_MilchKannen.kanne4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne4#index"));
	self.spanngurt.H_MilchKannen.kanne5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne5#index"));
	self.spanngurt.H_MilchKannen.kanne6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne6#index"));
	self.spanngurt.H_MilchKannen.kanne7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne7#index"));
	self.spanngurt.H_MilchKannen.kanne8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne8#index"));
	self.spanngurt.H_MilchKannen.kanne9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne9#index"));
	self.spanngurt.H_MilchKannen.kanne10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne10#index"));
	self.spanngurt.H_MilchKannen.kanne11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne11#index"));
	self.spanngurt.H_MilchKannen.kanne12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne12#index"));
	self.spanngurt.H_MilchKannen.kanne13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne13#index"));
	self.spanngurt.H_MilchKannen.kanne14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne14#index"));
	self.spanngurt.H_MilchKannen.kanne15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne15#index"));
	self.spanngurt.H_MilchKannen.kanne16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne16#index"));
	self.spanngurt.H_MilchKannen.kanne17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne17#index"));
	self.spanngurt.H_MilchKannen.kanne18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne18#index"));
	self.spanngurt.H_MilchKannen.kanne19 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne19#index"));
	self.spanngurt.H_MilchKannen.kanne20 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne20#index"));
	self.spanngurt.H_MilchKannen.kanne21 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteH_MilchKannen.kanne21#index"));
	
	--## BM Modding Bale support..
	self.spanngurt.BM_ModdingRundballen130Gewickelt = {};
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen1#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen2#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen3#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen4#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen5#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen6#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen7#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen8#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen9#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen10#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen11#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen12#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen13#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen14#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen15#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen16#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen17#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen18#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen19 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen19#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen20 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen20#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen21 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen21#index"));
	self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen22 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Gewickelt.ballen22#index"));
	
	self.spanngurt.BM_ModdingRundballen130Ungewickelt = {};
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen1#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen2#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen3#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen4#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen5#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen6#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen7#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen8#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen9#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen10#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen11#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen12#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen13#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen14#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen15#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen16#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen17#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen18#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen19 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen19#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen20 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen20#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen21 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen21#index"));
	self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen22 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen130Ungewickelt.ballen22#index"));
	
	self.spanngurt.BM_ModdingRundballen140Gewickelt = {};
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen1#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen2#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen3#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen4#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen5#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen6#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen7#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen8#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen9#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen10#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen11#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen12#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen13#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen14#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen15#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen16#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen17#index"));
	self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Gewickelt.ballen18#index"));
	
	self.spanngurt.BM_ModdingRundballen140Ungewickelt = {};
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen1#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen2#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen3#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen4#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen5#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen6#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen7#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen8#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen9#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen10#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen11#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen12#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen13#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen14#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen15#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen16#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen17#index"));
	self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen140Ungewickelt.ballen18#index"));
	
	self.spanngurt.BM_ModdingRundballen150Gewickelt = {};
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen1#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen2#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen3#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen4#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen5#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen6#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen7#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen8#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen9#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen10#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen11#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen12#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen13#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen14#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen15#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen16#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen17#index"));
	self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Gewickelt.ballen18#index"));
	
	self.spanngurt.BM_ModdingRundballen150Ungewickelt = {};
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen1#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen2#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen3#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen4#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen5#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen6#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen7#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen8#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen9#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen10#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen11#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen12#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen13#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen14#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen15#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen16#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen17#index"));
	self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteBM_ModdingRundballen150Ungewickelt.ballen18#index"));
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	self.antirutschmatte = {};
	
	self.antirutschmatte.BM_ModdingPaletten = {};
	self.antirutschmatte.BM_ModdingPaletten.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette1#index"));
	self.antirutschmatte.BM_ModdingPaletten.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette2#index"));
	self.antirutschmatte.BM_ModdingPaletten.palette3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette3#index"));
	self.antirutschmatte.BM_ModdingPaletten.palette4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette4#index"));
	self.antirutschmatte.BM_ModdingPaletten.palette5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette5#index"));
	self.antirutschmatte.BM_ModdingPaletten.palette6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette6#index"));
	self.antirutschmatte.BM_ModdingPaletten.palette7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette7#index"));
	self.antirutschmatte.BM_ModdingPaletten.palette8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten.palette8#index"));
	
	self.gitterBM_ModdingPaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenBM_ModdingPaletten#gitterIndex"));
	
	self.antirutschmatte.standardPaletten = {};
	self.antirutschmatte.standardPaletten.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette1#index"));
	self.antirutschmatte.standardPaletten.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette2#index"));
	self.antirutschmatte.standardPaletten.palette3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette3#index"));
	self.antirutschmatte.standardPaletten.palette4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette4#index"));
	self.antirutschmatte.standardPaletten.palette5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette5#index"));
	self.antirutschmatte.standardPaletten.palette6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette6#index"));
	self.antirutschmatte.standardPaletten.palette7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette7#index"));
	self.antirutschmatte.standardPaletten.palette8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten.palette8#index"));
	
	self.gitterStandardPaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten#gitterIndex"));
	self.gitterWollPaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenStandardPaletten#gitterWPIndex"));
	
	self.antirutschmatte.verbrauchsgueter = {};
	self.antirutschmatte.verbrauchsgueter.palette1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette1#index"));
	self.antirutschmatte.verbrauchsgueter.palette2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette2#index"));
	self.antirutschmatte.verbrauchsgueter.palette3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette3#index"));
	self.antirutschmatte.verbrauchsgueter.palette4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette4#index"));
	self.antirutschmatte.verbrauchsgueter.palette5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette5#index"));
	self.antirutschmatte.verbrauchsgueter.palette6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette6#index"));
	self.antirutschmatte.verbrauchsgueter.palette7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette7#index"));
	self.antirutschmatte.verbrauchsgueter.palette8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.antirutschmatten.antirutschmattenVerbrauchsgueter.palette8#index"));
end;

function FlieglMain_Extension_DPW150:delete()
end;

function FlieglMain_Extension_DPW150:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FlieglMain_Extension_DPW150:keyEvent(unicode, sym, modifier, isDown)
end;

function FlieglMain_Extension_DPW150:update(dt)
end;

function FlieglMain_Extension_DPW150:updateTick(dt)
	--## set help line's for the different product's 
	if self.choosenProductType[self.productType][1] == g_i18n:getText("WOOLPALLET") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BUYABLE_BLADES")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("CONSUMPTION_GOODS")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("EGGPALLET")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("GREENHOUSEPALLET")
	then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.519, 0, 2.852);
			setTranslation(self.helpLineLeftStart2, 4.3, 0, 2.852);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.519, 0, 2.852); 
			setTranslation(self.helpLineRightStart2, -4.3, 0, 2.852);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.383, 0, -5.669);
			setTranslation(self.helpLineBackEnd2, -1.383, 0, -5.669);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.519, 0, 1.078);
			setTranslation(self.helpLineLeftStart2, 4.3, 0, 1.078);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.519, 0, 1.078);
			setTranslation(self.helpLineRightStart2, -4.3, 0, 1.078);	

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.383, 0, -7.396);
			setTranslation(self.helpLineBackEnd2, -1.383, 0, -7.396);
		elseif self.fillLevel < 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.519, 0, -0.64);
			setTranslation(self.helpLineLeftStart2, 4.3, 0, -0.64);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.519, 0, -0.64); 
			setTranslation(self.helpLineRightStart2, -4.3, 0, -0.64);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.383, 0, -9.144);
			setTranslation(self.helpLineBackEnd2, -1.383, 0, -9.144);
		elseif self.fillLevel >= 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.519, 0, -2.379);
			setTranslation(self.helpLineLeftStart2, 4.3, 0, -2.379);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.519, 0, -2.379); 
			setTranslation(self.helpLineRightStart2, -4.3, 0, -2.379);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.383, 0, -10.848);
			setTranslation(self.helpLineBackEnd2, -1.383, 0, -10.848);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.519, 0, 4.556);
		setTranslation(self.helpLineLeftEnd2, 4.3, 0, 4.556);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.519, 0, 4.556);
		setTranslation(self.helpLineRightEnd2, -4.3, 0, 4.556);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.383, 0, -3.962);
		setTranslation(self.helpLineBackStart2, -1.383, 0, -3.962);
		
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_PALLETS") then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.691, 0, 2.957);
			setTranslation(self.helpLineLeftStart2, 4.1, 0, 2.957);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.691, 0, 2.957); 
			setTranslation(self.helpLineRightStart2, -4.1, 0, 2.957);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.21, 0, -5.55);
			setTranslation(self.helpLineBackEnd2, -1.21, 0, -5.55);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.691, 0, 1.2);
			setTranslation(self.helpLineLeftStart2, 4.1, 0, 1.2);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.691, 0, 1.2);
			setTranslation(self.helpLineRightStart2, -4.1, 0, 1.2);	

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.21, 0, -7.31);
			setTranslation(self.helpLineBackEnd2, -1.21, 0, -7.31);
		elseif self.fillLevel < 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.691, 0, -0.54);
			setTranslation(self.helpLineLeftStart2, 4.1, 0, -0.54);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.691, 0, -0.54); 
			setTranslation(self.helpLineRightStart2, -4.1, 0, -0.54);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.21, 0, -9.05);
			setTranslation(self.helpLineBackEnd2, -1.21, 0, -9.05);
		elseif self.fillLevel >= 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.691, 0, -2.25);
			setTranslation(self.helpLineLeftStart2, 4.1, 0, -2.25);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.691, 0, -2.25); 
			setTranslation(self.helpLineRightStart2, -4.1, 0, -2.25);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.21, 0, -10.77);
			setTranslation(self.helpLineBackEnd2, -1.21, 0, -10.77);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.691, 0, 4.45);
		setTranslation(self.helpLineLeftEnd2, 4.1, 0, 4.45);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.691, 0, 4.45);
		setTranslation(self.helpLineRightEnd2, -4.1, 0, 4.45);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.21, 0, -4.05);
		setTranslation(self.helpLineBackStart2, -1.21, 0, -4.05);

	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("BOARDPALLET") then
	
		--## left help line's
		setTranslation(self.helpLineLeftStart, 1.556, 0, -0.469);
		setTranslation(self.helpLineLeftEnd, 1.556, 0, 3.323);
		
		setTranslation(self.helpLineLeftStart2, 4.22, 0, -0.469);
		setTranslation(self.helpLineLeftEnd2, 4.22, 0, 3.977);
		
		--## right help line's
		setTranslation(self.helpLineRightStart, -1.556, 0, -0.469); 
		setTranslation(self.helpLineRightEnd, -1.556, 0, 3.977);
		
		setTranslation(self.helpLineRightStart2, -4.22, 0, -0.469);
		setTranslation(self.helpLineRightEnd2, -4.22, 0, 3.977);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.35, 0, -4.527);
		setTranslation(self.helpLineBackEnd, 1.35, 0, -8.954);
		
		setTranslation(self.helpLineBackStart2, -1.35, 0, -4.527); 
		setTranslation(self.helpLineBackEnd2, -1.35, 0, -8.954);
	
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("WASHEDPOTATOPALLET") then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.334, 0, 1.233);
			setTranslation(self.helpLineLeftStart2, 4.52, 0, 1.233);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.334, 0, 1.233); 
			setTranslation(self.helpLineRightStart2, -4.52, 0, 1.233);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.602, 0, -7.265);
			setTranslation(self.helpLineBackEnd2, -1.602, 0, -7.265);
		elseif self.fillLevel >= 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.334, 0, -2.065);
			setTranslation(self.helpLineLeftStart2, 4.52, 0, -2.065);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.334, 0, -2.065); 
			setTranslation(self.helpLineRightStart2, -4.52, 0, -2.065);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.602, 0, -10.567);
			setTranslation(self.helpLineBackEnd2, -1.602, 0, -10.567);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.334, 0, 4.354);
		setTranslation(self.helpLineLeftEnd2, 4.52, 0, 4.354);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.334, 0, 4.354);
		setTranslation(self.helpLineRightEnd2, -4.52, 0, 4.354);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.602, 0, -4.153);
		setTranslation(self.helpLineBackStart2, -1.602, 0, -4.153); 
		
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("STRAW_SQUAREBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("HAY_SQUAREBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("MIX_SQUAREBALE") 
	then

		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.665, 0, 2.306);
			setTranslation(self.helpLineLeftStart2, 4.12, 0, 2.306);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.665, 0, 2.306);
			setTranslation(self.helpLineRightStart2, -4.12, 0, 2.306);	

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.242, 0, -6.177);
			setTranslation(self.helpLineBackEnd2, -1.242, 0, -6.177);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.665, 0, -0.143);
			setTranslation(self.helpLineLeftStart2, 4.12, 0, -0.143);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.665, 0, -0.143);
			setTranslation(self.helpLineRightStart2, -4.12, 0, -0.143);	

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.242, 0, -8.631);
			setTranslation(self.helpLineBackEnd2, -1.242, 0, -8.631);
		elseif self.fillLevel >= 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.665, 0, -2.803);
			setTranslation(self.helpLineLeftStart2, 4.12, 0, -2.803);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.665, 0, -2.803);
			setTranslation(self.helpLineRightStart2, -4.12, 0, -2.803);	

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.242, 0, -11.33);
			setTranslation(self.helpLineBackEnd2, -1.242, 0, -11.33);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.665, 0, 4.506);
		setTranslation(self.helpLineLeftEnd2, 4.12, 0, 4.506);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.665, 0, 4.506);
		setTranslation(self.helpLineRightEnd2, -4.12, 0, 4.506);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.242, 0, -4.019);
		setTranslation(self.helpLineBackStart2, -1.242, 0, -4.019); 
		
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_STRAW_ROUNDBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_HAY_ROUNDBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_GRASS_ROUNDBALE")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_SILAGE_ROUNDBALE") 			
		or self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_MIX_ROUNDBALE") 
		
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_STRAW_ROUNDBALE_130") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_HAY_ROUNDBALE_130") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_GRASS_ROUNDBALE_130")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_SILAGE_ROUNDBALE_130") 			
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_MIX_ROUNDBALE_130") 
	then
	
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 3.749);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 3.749);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 3.749); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 3.749);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -4.75);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -4.75);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 2.453);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 2.453);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 2.453); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 2.453);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -6.053);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -6.053);
		elseif self.fillLevel < 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 1.148);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 1.148);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 1.148); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 1.148);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -7.346);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -7.346);
		elseif self.fillLevel < 9 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -0.155);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -0.155);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -0.155); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -0.155);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -8.651);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -8.651);
		elseif self.fillLevel < 11 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -1.46);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -1.46);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -1.46); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -1.46);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -9.956);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -9.956);
		elseif self.fillLevel >= 11 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -2.75);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -2.75);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -2.75); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -2.75);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -11.255);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -11.255);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.726, 0, 5.05);
		setTranslation(self.helpLineLeftEnd2, 4.08, 0, 5.05);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.726, 0, 5.05);
		setTranslation(self.helpLineRightEnd2, -4.08, 0, 5.05);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.182, 0, -3.46);
		setTranslation(self.helpLineBackStart2, -1.182, 0, -3.46);
		
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_STRAW_ROUNDBALE_140") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_HAY_ROUNDBALE_140") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_GRASS_ROUNDBALE_140")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_SILAGE_ROUNDBALE_140") 			
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_MIX_ROUNDBALE_140") 
	then
	
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 3.7);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 3.7);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 3.7); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 3.7);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -4.78);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -4.78);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 2.3);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 2.3);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 2.3); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 2.3);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -6.19);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -6.19);
		elseif self.fillLevel < 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 0.91);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 0.91);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 0.91); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 0.91);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -7.58);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -7.58);
		elseif self.fillLevel < 9 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -0.5);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -0.5);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -0.5); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -0.5);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -8.99);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -8.99);
		elseif self.fillLevel >= 9 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -1.9);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -1.9);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -1.9); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -1.9);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -10.38);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -10.38);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.726, 0, 5.1);
		setTranslation(self.helpLineLeftEnd2, 4.08, 0, 5.1);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.726, 0, 5.1);
		setTranslation(self.helpLineRightEnd2, -4.08, 0, 5.1);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.182, 0, -3.4);
		setTranslation(self.helpLineBackStart2, -1.182, 0, -3.4);
		
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_STRAW_ROUNDBALE_150") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_HAY_ROUNDBALE_150") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_GRASS_ROUNDBALE_150")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_SILAGE_ROUNDBALE_150") 			
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_MIX_ROUNDBALE_150") 
	then
	
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 3.62);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 3.62);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 3.62); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 3.62);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -4.89);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -4.89);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 2.11);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 2.11);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 2.11); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 2.11);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -6.4);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -6.4);
		elseif self.fillLevel < 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 0.606);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 0.606);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 0.606); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 0.606);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -7.89);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -7.89);
		elseif self.fillLevel < 9 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -0.89);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -0.89);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -0.89); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -0.89);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -9.39);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -9.39);
		elseif self.fillLevel >= 9 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -2.386);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -2.386);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -2.386); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -2.386);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -10.9);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -10.9);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.726, 0, 5.1);
		setTranslation(self.helpLineLeftEnd2, 4.08, 0, 5.1);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.726, 0, 5.1);
		setTranslation(self.helpLineRightEnd2, -4.08, 0, 5.1);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.182, 0, -3.4);
		setTranslation(self.helpLineBackStart2, -1.182, 0, -3.4);
	
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_TREESAPLINGPALLET") then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.693, 0, 2.97);
			setTranslation(self.helpLineLeftStart2, 4.114, 0, 2.97);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.693, 0, 2.97); 
			setTranslation(self.helpLineRightStart2, -4.114, 0, 2.97);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -5.527);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -5.527);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.693, 0, 1.247);
			setTranslation(self.helpLineLeftStart2, 4.114, 0, 1.247);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.693, 0, 1.247); 
			setTranslation(self.helpLineRightStart2, -4.114, 0, 1.247);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -7.255);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -7.255);
		elseif self.fillLevel < 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.693, 0, -0.5);
			setTranslation(self.helpLineLeftStart2, 4.114, 0, -0.5);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.693, 0, -0.5); 
			setTranslation(self.helpLineRightStart2, -4.114, 0, -0.5);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -9);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -9);
		elseif self.fillLevel >= 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.693, 0, -2.228);
			setTranslation(self.helpLineLeftStart2, 4.114, 0, -2.228);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.693, 0, -2.228); 
			setTranslation(self.helpLineRightStart2, -4.114, 0, -2.228);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -10.727);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -10.727);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.693, 0, 4.38);
		setTranslation(self.helpLineLeftEnd2, 4.114, 0, 4.38);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.693, 0, 4.38);
		setTranslation(self.helpLineRightEnd2, -4.114, 0, 4.38);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.182, 0, -4.1);
		setTranslation(self.helpLineBackStart2, -1.182, 0, -4.1); 
		
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("BIG_TREESAPLINGPALLET") then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.693, 0, 2.48);
			setTranslation(self.helpLineLeftStart2, 4.114, 0, 2.48);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.693, 0, 2.48); 
			setTranslation(self.helpLineRightStart2, -4.114, 0, 2.48);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -6);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -6);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.693, 0, 0.22);
			setTranslation(self.helpLineLeftStart2, 4.114, 0, 0.22);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.693, 0, 0.22); 
			setTranslation(self.helpLineRightStart2, -4.114, 0, 0.22);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -8.27);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -8.27);
		elseif self.fillLevel >= 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.693, 0, -2);
			setTranslation(self.helpLineLeftStart2, 4.114, 0, -2);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.693, 0, -2); 
			setTranslation(self.helpLineRightStart2, -4.114, 0, -2);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -10.53);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -10.53);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.693, 0, 4.62);
		setTranslation(self.helpLineLeftEnd2, 4.114, 0, 4.62);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.693, 0, 4.62);
		setTranslation(self.helpLineRightEnd2, -4.114, 0, 4.62);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.182, 0, -3.89);
		setTranslation(self.helpLineBackStart2, -1.182, 0, -3.89); 
	
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("TRANSPORTBOX") then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.75, 0, 2.92);
			setTranslation(self.helpLineLeftStart2, 4.055, 0, 2.92);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.75, 0, 2.92); 
			setTranslation(self.helpLineRightStart2, -4.055, 0, 2.92);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.155, 0, -5.56);
			setTranslation(self.helpLineBackEnd2, -1.155, 0, -5.56);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.75, 0, 1.095);
			setTranslation(self.helpLineLeftStart2, 4.055, 0, 1.095);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.75, 0, 1.095); 
			setTranslation(self.helpLineRightStart2, -4.055, 0, 1.095);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.155, 0, -7.4);
			setTranslation(self.helpLineBackEnd2, -1.155, 0, -7.4);
		elseif self.fillLevel < 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.75, 0, -0.73);
			setTranslation(self.helpLineLeftStart2, 4.055, 0, -0.73);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.75, 0, -0.73); 
			setTranslation(self.helpLineRightStart2, -4.055, 0, -0.73);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.155, 0, -9.23);
			setTranslation(self.helpLineBackEnd2, -1.155, 0, -9.23);
		elseif self.fillLevel >= 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.75, 0, -2.56);
			setTranslation(self.helpLineLeftStart2, 4.055, 0, -2.56);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.75, 0, -2.56); 
			setTranslation(self.helpLineRightStart2, -4.055, 0, -2.56);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.155, 0, -11.07);
			setTranslation(self.helpLineBackEnd2, -1.155, 0, -11.07);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.75, 0, 4.66);
		setTranslation(self.helpLineLeftEnd2, 4.055, 0, 4.66);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.75, 0, 4.66);
		setTranslation(self.helpLineRightEnd2, -4.055, 0, 4.66);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.155, 0, -3.83);
		setTranslation(self.helpLineBackStart2, -1.155, 0, -3.83); 
		
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("SILAGE_ADDITIVES_TANK") then
		
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 3 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.58, 0, 2.96);
			setTranslation(self.helpLineLeftStart2, 4.22, 0, 2.96);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.58, 0, 2.96); 
			setTranslation(self.helpLineRightStart2, -4.22, 0, 2.96);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.32, 0, -5.54);
			setTranslation(self.helpLineBackEnd2, -1.32, 0, -5.54);
		elseif self.fillLevel < 5 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.58, 0, 1.22);
			setTranslation(self.helpLineLeftStart2, 4.22, 0, 1.22);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.58, 0, 1.22); 
			setTranslation(self.helpLineRightStart2, -4.22, 0, 1.22);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.32, 0, -7.29);
			setTranslation(self.helpLineBackEnd2, -1.32, 0, -7.29);
		elseif self.fillLevel < 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.58, 0, -0.52);
			setTranslation(self.helpLineLeftStart2, 4.22, 0, -0.52);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.58, 0, -0.52); 
			setTranslation(self.helpLineRightStart2, -4.22, 0, -0.52);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.32, 0, -9.02);
			setTranslation(self.helpLineBackEnd2, -1.32, 0, -9.02);
		elseif self.fillLevel >= 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.58, 0, -2.27);
			setTranslation(self.helpLineLeftStart2, 4.22, 0, -2.27);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.58, 0, -2.27); 
			setTranslation(self.helpLineRightStart2, -4.22, 0, -2.27);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.32, 0, -10.76);
			setTranslation(self.helpLineBackEnd2, -1.32, 0, -10.76);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.58, 0, 4.61);
		setTranslation(self.helpLineLeftEnd2, 4.22, 0, 4.61);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.58, 0, 4.61);
		setTranslation(self.helpLineRightEnd2, -4.22, 0, 4.61);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.32, 0, -3.89);
		setTranslation(self.helpLineBackStart2, -1.32, 0, -3.89);
	
	elseif self.choosenProductType[self.productType][1] == g_i18n:getText("H_MILK") then
	
		--## set the length of the help line's to the current fill level
		if self.fillLevel < 4 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 3.74);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 3.74);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 3.74); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 3.74);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -4.77);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -4.77);
		elseif self.fillLevel < 7 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 2.66);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 2.66);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 2.66); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 2.66);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -5.84);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -5.84);
		elseif self.fillLevel < 10 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 1.606);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 1.606);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 1.606); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 1.606);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -6.89);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -6.89);
		elseif self.fillLevel < 13 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, 0.54);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, 0.54);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, 0.54); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, 0.54);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -7.95);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -7.95);
		elseif self.fillLevel < 16 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -0.53);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -0.53);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -0.53); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -0.53);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -9.03);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -9.03);
		elseif self.fillLevel < 19 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -1.59);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -1.59);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -1.59); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -1.59);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -10.09);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -10.09);
		elseif self.fillLevel >= 19 then
			--## left help line's
			setTranslation(self.helpLineLeftStart, 1.726, 0, -2.67);
			setTranslation(self.helpLineLeftStart2, 4.08, 0, -2.67);
			
			--## right help line's
			setTranslation(self.helpLineRightStart, -1.726, 0, -2.67); 
			setTranslation(self.helpLineRightStart2, -4.08, 0, -2.67);

			--## back help line's
			setTranslation(self.helpLineBackEnd, 1.182, 0, -11.17);
			setTranslation(self.helpLineBackEnd2, -1.182, 0, -11.17);
		end;
		
		--## left help line's
		setTranslation(self.helpLineLeftEnd, 1.726, 0, 4.78);
		setTranslation(self.helpLineLeftEnd2, 4.08, 0, 4.78);
		
		--## right help line's
		setTranslation(self.helpLineRightEnd, -1.726, 0, 4.78);
		setTranslation(self.helpLineRightEnd2, -4.08, 0, 4.78);
		
		--## back help line's
		setTranslation(self.helpLineBackStart, 1.182, 0, -3.72);
		setTranslation(self.helpLineBackStart2, -1.182, 0, -3.72);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("STRAW_SQUAREBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("HAY_SQUAREBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("MIX_SQUAREBALE") 
	then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.quaderballen.ballen1, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.quaderballen.ballen2, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.quaderballen.ballen3, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.quaderballen.ballen4, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.quaderballen.ballen5, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.quaderballen.ballen6, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.quaderballen.ballen7, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.quaderballen.ballen8, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.quaderballen.ballen9, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.quaderballen.ballen10, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.quaderballen.ballen11, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.quaderballen.ballen12, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.quaderballen.ballen13, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.quaderballen.ballen14, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.quaderballen.ballen15, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.quaderballen.ballen16, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen16, false);
		end;
		if self.fillLevel == 17 then
			setVisibility(self.spanngurt.quaderballen.ballen17, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen17, false);
		end;
		if self.fillLevel == 18 then
			setVisibility(self.spanngurt.quaderballen.ballen18, true);
		else
			setVisibility(self.spanngurt.quaderballen.ballen18, false);
		end;
	else
		setVisibility(self.spanngurt.quaderballen.ballen1, false);
		setVisibility(self.spanngurt.quaderballen.ballen2, false);
		setVisibility(self.spanngurt.quaderballen.ballen3, false);
		setVisibility(self.spanngurt.quaderballen.ballen4, false);
		setVisibility(self.spanngurt.quaderballen.ballen5, false);
		setVisibility(self.spanngurt.quaderballen.ballen6, false);
		setVisibility(self.spanngurt.quaderballen.ballen7, false);
		setVisibility(self.spanngurt.quaderballen.ballen8, false);
		setVisibility(self.spanngurt.quaderballen.ballen9, false);
		setVisibility(self.spanngurt.quaderballen.ballen10, false);
		setVisibility(self.spanngurt.quaderballen.ballen11, false);
		setVisibility(self.spanngurt.quaderballen.ballen12, false);
		setVisibility(self.spanngurt.quaderballen.ballen13, false);
		setVisibility(self.spanngurt.quaderballen.ballen14, false);
		setVisibility(self.spanngurt.quaderballen.ballen15, false);
		setVisibility(self.spanngurt.quaderballen.ballen16, false);
		setVisibility(self.spanngurt.quaderballen.ballen17, false);
		setVisibility(self.spanngurt.quaderballen.ballen18, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_STRAW_ROUNDBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_HAY_ROUNDBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_GRASS_ROUNDBALE")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_SILAGE_ROUNDBALE") 			
		or self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_MIX_ROUNDBALE") 
	then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.standardRundballen.ballen1, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.standardRundballen.ballen2, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.standardRundballen.ballen3, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.standardRundballen.ballen4, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.standardRundballen.ballen5, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.standardRundballen.ballen6, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.standardRundballen.ballen7, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.standardRundballen.ballen8, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.standardRundballen.ballen9, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.standardRundballen.ballen10, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.standardRundballen.ballen11, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.standardRundballen.ballen12, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.standardRundballen.ballen13, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.standardRundballen.ballen14, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.standardRundballen.ballen15, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.standardRundballen.ballen16, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen16, false);
		end;
		if self.fillLevel == 17 then
			setVisibility(self.spanngurt.standardRundballen.ballen17, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen17, false);
		end;
		if self.fillLevel == 18 then
			setVisibility(self.spanngurt.standardRundballen.ballen18, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen18, false);
		end;
		if self.fillLevel == 19 then
			setVisibility(self.spanngurt.standardRundballen.ballen19, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen19, false);
		end;
		if self.fillLevel == 20 then
			setVisibility(self.spanngurt.standardRundballen.ballen20, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen20, false);
		end;
		if self.fillLevel == 21 then
			setVisibility(self.spanngurt.standardRundballen.ballen21, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen21, false);
		end;
		if self.fillLevel == 22 then
			setVisibility(self.spanngurt.standardRundballen.ballen22, true);
		else
			setVisibility(self.spanngurt.standardRundballen.ballen22, false);
		end;
	else
		setVisibility(self.spanngurt.standardRundballen.ballen1, false);
		setVisibility(self.spanngurt.standardRundballen.ballen2, false);
		setVisibility(self.spanngurt.standardRundballen.ballen3, false);
		setVisibility(self.spanngurt.standardRundballen.ballen4, false);
		setVisibility(self.spanngurt.standardRundballen.ballen5, false);
		setVisibility(self.spanngurt.standardRundballen.ballen6, false);
		setVisibility(self.spanngurt.standardRundballen.ballen7, false);
		setVisibility(self.spanngurt.standardRundballen.ballen8, false);
		setVisibility(self.spanngurt.standardRundballen.ballen9, false);
		setVisibility(self.spanngurt.standardRundballen.ballen10, false);
		setVisibility(self.spanngurt.standardRundballen.ballen11, false);
		setVisibility(self.spanngurt.standardRundballen.ballen12, false);
		setVisibility(self.spanngurt.standardRundballen.ballen13, false);
		setVisibility(self.spanngurt.standardRundballen.ballen14, false);
		setVisibility(self.spanngurt.standardRundballen.ballen15, false);
		setVisibility(self.spanngurt.standardRundballen.ballen16, false);
		setVisibility(self.spanngurt.standardRundballen.ballen17, false);
		setVisibility(self.spanngurt.standardRundballen.ballen18, false);
		setVisibility(self.spanngurt.standardRundballen.ballen19, false);
		setVisibility(self.spanngurt.standardRundballen.ballen20, false);
		setVisibility(self.spanngurt.standardRundballen.ballen21, false);
		setVisibility(self.spanngurt.standardRundballen.ballen22, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_SILAGE_ROUNDBALE_130") 			
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_MIX_ROUNDBALE_130") 
	then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen1, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen2, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen3, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen4, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen5, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen6, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen7, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen8, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen9, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen10, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen11, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen12, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen13, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen14, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen15, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen16, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen16, false);
		end;
		if self.fillLevel == 17 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen17, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen17, false);
		end;
		if self.fillLevel == 18 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen18, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen18, false);
		end;
		if self.fillLevel == 19 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen19, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen19, false);
		end;
		if self.fillLevel == 20 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen20, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen20, false);
		end;
		if self.fillLevel == 21 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen21, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen21, false);
		end;
		if self.fillLevel == 22 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen22, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen22, false);
		end;
	else
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen1, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen2, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen3, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen4, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen5, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen6, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen7, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen8, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen9, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen10, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen11, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen12, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen13, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen14, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen15, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen16, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen17, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen18, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen19, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen20, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen21, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Gewickelt.ballen22, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_STRAW_ROUNDBALE_130") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_HAY_ROUNDBALE_130") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_GRASS_ROUNDBALE_130")
	then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen1, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen2, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen3, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen4, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen5, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen6, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen7, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen8, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen9, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen10, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen11, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen12, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen13, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen14, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen15, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen16, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen16, false);
		end;
		if self.fillLevel == 17 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen17, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen17, false);
		end;
		if self.fillLevel == 18 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen18, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen18, false);
		end;
		if self.fillLevel == 19 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen19, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen19, false);
		end;
		if self.fillLevel == 20 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen20, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen20, false);
		end;
		if self.fillLevel == 21 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen21, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen21, false);
		end;
		if self.fillLevel == 22 then
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen22, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen22, false);
		end;
	else
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen1, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen2, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen3, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen4, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen5, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen6, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen7, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen8, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen9, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen10, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen11, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen12, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen13, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen14, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen15, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen16, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen17, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen18, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen19, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen20, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen21, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen130Ungewickelt.ballen22, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_SILAGE_ROUNDBALE_140") 			
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_MIX_ROUNDBALE_140") 
	then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen1, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen2, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen3, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen4, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen5, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen6, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen7, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen8, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen9, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen10, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen11, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen12, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen13, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen14, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen15, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen16, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen16, false);
		end;
		if self.fillLevel == 17 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen17, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen17, false);
		end;
		if self.fillLevel == 18 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen18, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen18, false);
		end;
	else
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen1, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen2, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen3, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen4, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen5, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen6, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen7, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen8, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen9, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen10, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen11, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen12, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen13, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen14, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen15, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen16, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen17, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Gewickelt.ballen18, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_STRAW_ROUNDBALE_140") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_HAY_ROUNDBALE_140") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_GRASS_ROUNDBALE_140")
	then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen1, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen2, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen3, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen4, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen5, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen6, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen7, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen8, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen9, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen10, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen11, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen12, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen13, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen14, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen15, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen16, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen16, false);
		end;
		if self.fillLevel == 17 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen17, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen17, false);
		end;
		if self.fillLevel == 18 then
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen18, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen18, false);
		end;
	else
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen1, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen2, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen3, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen4, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen5, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen6, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen7, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen8, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen9, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen10, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen11, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen12, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen13, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen14, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen15, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen16, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen17, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen140Ungewickelt.ballen18, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_SILAGE_ROUNDBALE_150") 			
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_MIX_ROUNDBALE_150") 
	then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen1, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen2, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen3, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen4, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen5, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen6, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen7, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen8, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen9, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen10, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen11, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen12, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen13, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen14, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen15, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen16, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen16, false);
		end;
		if self.fillLevel == 17 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen17, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen17, false);
		end;
		if self.fillLevel == 18 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen18, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen18, false);
		end;
	else
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen1, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen2, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen3, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen4, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen5, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen6, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen7, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen8, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen9, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen10, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen11, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen12, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen13, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen14, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen15, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen16, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen17, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Gewickelt.ballen18, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_STRAW_ROUNDBALE_150") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_HAY_ROUNDBALE_150") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_GRASS_ROUNDBALE_150")
	then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen1, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen2, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen3, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen4, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen5, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen6, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen7, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen8, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen9, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen10, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen11, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen12, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen13, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen14, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen15, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen16, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen16, false);
		end;
		if self.fillLevel == 17 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen17, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen17, false);
		end;
		if self.fillLevel == 18 then
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen18, true);
		else
			setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen18, false);
		end;
	else
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen1, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen2, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen3, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen4, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen5, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen6, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen7, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen8, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen9, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen10, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen11, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen12, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen13, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen14, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen15, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen16, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen17, false);
		setVisibility(self.spanngurt.BM_ModdingRundballen150Ungewickelt.ballen18, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_TREESAPLINGPALLET") then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette1, true);
		else
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette2, true);
		else
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette3, true);
		else
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette4, true);
		else
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette5, true);
		else
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette6, true);
		else
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette7, true);
		else
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette8, true);
		else
			setVisibility(self.spanngurt.baumsetzlingpaletten.palette8, false);
		end;
	else
		setVisibility(self.spanngurt.baumsetzlingpaletten.palette1, false);
		setVisibility(self.spanngurt.baumsetzlingpaletten.palette2, false);
		setVisibility(self.spanngurt.baumsetzlingpaletten.palette3, false);
		setVisibility(self.spanngurt.baumsetzlingpaletten.palette4, false);
		setVisibility(self.spanngurt.baumsetzlingpaletten.palette5, false);
		setVisibility(self.spanngurt.baumsetzlingpaletten.palette6, false);
		setVisibility(self.spanngurt.baumsetzlingpaletten.palette7, false);
		setVisibility(self.spanngurt.baumsetzlingpaletten.palette8, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BIG_TREESAPLINGPALLET") then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette1, true);
		else
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette2, true);
		else
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette3, true);
		else
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette4, true);
		else
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette5, true);
		else
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette6, true);
		else
			setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette6, false);
		end;
	else
		setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette1, false);
		setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette2, false);
		setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette3, false);
		setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette4, false);
		setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette5, false);
		setVisibility(self.spanngurt.grosseBaumsetzlingpaletten.palette6, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BOARDPALLET") then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.holzpaletten.palette1, true);
		else
			setVisibility(self.spanngurt.holzpaletten.palette1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.holzpaletten.palette2, true);
		else
			setVisibility(self.spanngurt.holzpaletten.palette2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.holzpaletten.palette3, true);
		else
			setVisibility(self.spanngurt.holzpaletten.palette3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.holzpaletten.palette4, true);
		else
			setVisibility(self.spanngurt.holzpaletten.palette4, false);
		end;
	else
		setVisibility(self.spanngurt.holzpaletten.palette1, false);
		setVisibility(self.spanngurt.holzpaletten.palette2, false);
		setVisibility(self.spanngurt.holzpaletten.palette3, false);
		setVisibility(self.spanngurt.holzpaletten.palette4, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("WASHEDPOTATOPALLET") then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.kartoffelpaletten.palette1, true);
		else
			setVisibility(self.spanngurt.kartoffelpaletten.palette1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.kartoffelpaletten.palette2, true);
		else
			setVisibility(self.spanngurt.kartoffelpaletten.palette2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.kartoffelpaletten.palette3, true);
		else
			setVisibility(self.spanngurt.kartoffelpaletten.palette3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.kartoffelpaletten.palette4, true);
		else
			setVisibility(self.spanngurt.kartoffelpaletten.palette4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.kartoffelpaletten.palette5, true);
		else
			setVisibility(self.spanngurt.kartoffelpaletten.palette5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.kartoffelpaletten.palette6, true);
		else
			setVisibility(self.spanngurt.kartoffelpaletten.palette6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.kartoffelpaletten.palette7, true);
		else
			setVisibility(self.spanngurt.kartoffelpaletten.palette7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.kartoffelpaletten.palette8, true);
		else
			setVisibility(self.spanngurt.kartoffelpaletten.palette8, false);
		end;
	else
		setVisibility(self.spanngurt.kartoffelpaletten.palette1, false);
		setVisibility(self.spanngurt.kartoffelpaletten.palette2, false);
		setVisibility(self.spanngurt.kartoffelpaletten.palette3, false);
		setVisibility(self.spanngurt.kartoffelpaletten.palette4, false);
		setVisibility(self.spanngurt.kartoffelpaletten.palette5, false);
		setVisibility(self.spanngurt.kartoffelpaletten.palette6, false);
		setVisibility(self.spanngurt.kartoffelpaletten.palette7, false);
		setVisibility(self.spanngurt.kartoffelpaletten.palette8, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("TRANSPORTBOX") then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.transportboxen.box1, true);
		else
			setVisibility(self.spanngurt.transportboxen.box1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.transportboxen.box2, true);
		else
			setVisibility(self.spanngurt.transportboxen.box2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.transportboxen.box3, true);
		else
			setVisibility(self.spanngurt.transportboxen.box3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.transportboxen.box4, true);
		else
			setVisibility(self.spanngurt.transportboxen.box4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.transportboxen.box5, true);
		else
			setVisibility(self.spanngurt.transportboxen.box5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.transportboxen.box6, true);
		else
			setVisibility(self.spanngurt.transportboxen.box6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.transportboxen.box7, true);
		else
			setVisibility(self.spanngurt.transportboxen.box7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.transportboxen.box8, true);
		else
			setVisibility(self.spanngurt.transportboxen.box8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.transportboxen.box9, true);
		else
			setVisibility(self.spanngurt.transportboxen.box9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.transportboxen.box10, true);
		else
			setVisibility(self.spanngurt.transportboxen.box10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.transportboxen.box11, true);
		else
			setVisibility(self.spanngurt.transportboxen.box11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.transportboxen.box12, true);
		else
			setVisibility(self.spanngurt.transportboxen.box12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.transportboxen.box13, true);
		else
			setVisibility(self.spanngurt.transportboxen.box13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.transportboxen.box14, true);
		else
			setVisibility(self.spanngurt.transportboxen.box14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.transportboxen.box15, true);
		else
			setVisibility(self.spanngurt.transportboxen.box15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.transportboxen.box16, true);
		else
			setVisibility(self.spanngurt.transportboxen.box16, false);
		end;
	else
		setVisibility(self.spanngurt.transportboxen.box1, false);
		setVisibility(self.spanngurt.transportboxen.box2, false);
		setVisibility(self.spanngurt.transportboxen.box3, false);
		setVisibility(self.spanngurt.transportboxen.box4, false);
		setVisibility(self.spanngurt.transportboxen.box5, false);
		setVisibility(self.spanngurt.transportboxen.box6, false);
		setVisibility(self.spanngurt.transportboxen.box7, false);
		setVisibility(self.spanngurt.transportboxen.box8, false);
		setVisibility(self.spanngurt.transportboxen.box9, false);
		setVisibility(self.spanngurt.transportboxen.box10, false);
		setVisibility(self.spanngurt.transportboxen.box11, false);
		setVisibility(self.spanngurt.transportboxen.box12, false);
		setVisibility(self.spanngurt.transportboxen.box13, false);
		setVisibility(self.spanngurt.transportboxen.box14, false);
		setVisibility(self.spanngurt.transportboxen.box15, false);
		setVisibility(self.spanngurt.transportboxen.box16, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("SILAGE_ADDITIVES_TANK") then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.siliermittelTanks.tank1, true);
		else
			setVisibility(self.spanngurt.siliermittelTanks.tank1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.siliermittelTanks.tank2, true);
		else
			setVisibility(self.spanngurt.siliermittelTanks.tank2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.siliermittelTanks.tank3, true);
		else
			setVisibility(self.spanngurt.siliermittelTanks.tank3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.siliermittelTanks.tank4, true);
		else
			setVisibility(self.spanngurt.siliermittelTanks.tank4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.siliermittelTanks.tank5, true);
		else
			setVisibility(self.spanngurt.siliermittelTanks.tank5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.siliermittelTanks.tank6, true);
		else
			setVisibility(self.spanngurt.siliermittelTanks.tank6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.siliermittelTanks.tank7, true);
		else
			setVisibility(self.spanngurt.siliermittelTanks.tank7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.siliermittelTanks.tank8, true);
		else
			setVisibility(self.spanngurt.siliermittelTanks.tank8, false);
		end;
	else
		setVisibility(self.spanngurt.siliermittelTanks.tank1, false);
		setVisibility(self.spanngurt.siliermittelTanks.tank2, false);
		setVisibility(self.spanngurt.siliermittelTanks.tank3, false);
		setVisibility(self.spanngurt.siliermittelTanks.tank4, false);
		setVisibility(self.spanngurt.siliermittelTanks.tank5, false);
		setVisibility(self.spanngurt.siliermittelTanks.tank6, false);
		setVisibility(self.spanngurt.siliermittelTanks.tank7, false);
		setVisibility(self.spanngurt.siliermittelTanks.tank8, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("H_MILK") then
		if self.fillLevel == 1 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne1, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne2, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne3, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne4, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne5, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne6, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne7, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne8, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne8, false);
		end;
		if self.fillLevel == 9 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne9, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne9, false);
		end;
		if self.fillLevel == 10 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne10, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne10, false);
		end;
		if self.fillLevel == 11 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne11, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne11, false);
		end;
		if self.fillLevel == 12 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne12, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne12, false);
		end;
		if self.fillLevel == 13 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne13, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne13, false);
		end;
		if self.fillLevel == 14 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne14, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne14, false);
		end;
		if self.fillLevel == 15 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne15, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne15, false);
		end;
		if self.fillLevel == 16 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne16, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne16, false);
		end;
		if self.fillLevel == 17 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne17, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne17, false);
		end;
		if self.fillLevel == 18 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne18, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne18, false);
		end;
		if self.fillLevel == 19 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne19, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne19, false);
		end;
		if self.fillLevel == 20 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne20, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne20, false);
		end;
		if self.fillLevel == 21 then
			setVisibility(self.spanngurt.H_MilchKannen.kanne21, true);
		else
			setVisibility(self.spanngurt.H_MilchKannen.kanne21, false);
		end;
	else
		setVisibility(self.spanngurt.H_MilchKannen.kanne1, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne2, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne3, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne4, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne5, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne6, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne7, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne8, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne9, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne10, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne11, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne12, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne13, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne14, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne15, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne16, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne17, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne18, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne19, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne20, false);
		setVisibility(self.spanngurt.H_MilchKannen.kanne21, false);
	end;
	
	if self.fillLevel > 0 then
		setRotation(self.variableBodyParts.collisionFront, 120, 0, 0);
		setRotation(self.variableBodyParts.collisionBack, -120, 0, 0);
	end;
	
	setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex1, true);
	setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex2, true);
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BM_MODDING_PALLETS") then
		if self.fillLevel > 0 then
			setRotation(self.variableBodyParts.collisionFront, 0, 0, 0);
			setRotation(self.variableBodyParts.collisionBack, 0, 0, 0);
		end;
		
		if self.currentUnloadSide[self.unloadSide][1] == g_i18n:getText("UNLOAD_TRAILER") then
			if self.fillLevel > 0 then
				setVisibility(self.gitterBM_ModdingPaletten, true);
	
				setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex1, false);
				setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex2, false);
			else
				setVisibility(self.gitterBM_ModdingPaletten, false);
				
				setRotation(self.variableBodyParts.collisionFront, 120, 0, 0);
				setRotation(self.variableBodyParts.collisionBack, -120, 0, 0);
			end;
		else	
			setVisibility(self.gitterBM_ModdingPaletten, true);
	
			setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex1, false);
			setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex2, false);
		end;
	
		if self.fillLevel == 1 then
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette1, true);
		else
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette2, true);
		else
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette3, true);
		else
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette4, true);
		else
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette5, true);
		else
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette6, true);
		else
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette7, true);
		else
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette8, true);
		else
			setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette8, false);
		end;
	else
		setVisibility(self.gitterBM_ModdingPaletten, false);
		
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette1, false);
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette2, false);
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette3, false);
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette4, false);
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette5, false);
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette6, false);
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette7, false);
		setVisibility(self.antirutschmatte.BM_ModdingPaletten.palette8, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("WOOLPALLET") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BUYABLE_BLADES")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("EGGPALLET")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("GREENHOUSEPALLET")
	then
		if self.fillLevel == 1 then
			setVisibility(self.antirutschmatte.standardPaletten.palette1, true);
		else
			setVisibility(self.antirutschmatte.standardPaletten.palette1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.antirutschmatte.standardPaletten.palette2, true);
		else
			setVisibility(self.antirutschmatte.standardPaletten.palette2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.antirutschmatte.standardPaletten.palette3, true);
		else
			setVisibility(self.antirutschmatte.standardPaletten.palette3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.antirutschmatte.standardPaletten.palette4, true);
		else
			setVisibility(self.antirutschmatte.standardPaletten.palette4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.antirutschmatte.standardPaletten.palette5, true);
		else
			setVisibility(self.antirutschmatte.standardPaletten.palette5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.antirutschmatte.standardPaletten.palette6, true);
		else
			setVisibility(self.antirutschmatte.standardPaletten.palette6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.antirutschmatte.standardPaletten.palette7, true);
		else
			setVisibility(self.antirutschmatte.standardPaletten.palette7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.antirutschmatte.standardPaletten.palette8, true);
		else
			setVisibility(self.antirutschmatte.standardPaletten.palette8, false);
		end;
	else
		setVisibility(self.antirutschmatte.standardPaletten.palette1, false);
		setVisibility(self.antirutschmatte.standardPaletten.palette2, false);
		setVisibility(self.antirutschmatte.standardPaletten.palette3, false);
		setVisibility(self.antirutschmatte.standardPaletten.palette4, false);
		setVisibility(self.antirutschmatte.standardPaletten.palette5, false);
		setVisibility(self.antirutschmatte.standardPaletten.palette6, false);
		setVisibility(self.antirutschmatte.standardPaletten.palette7, false);
		setVisibility(self.antirutschmatte.standardPaletten.palette8, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("CONSUMPTION_GOODS") then
		if self.fillLevel == 1 then
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette1, true);
		else
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette1, false);
		end;
		if self.fillLevel == 2 then
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette2, true);
		else
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette2, false);
		end;
		if self.fillLevel == 3 then
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette3, true);
		else
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette3, false);
		end;
		if self.fillLevel == 4 then
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette4, true);
		else
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette4, false);
		end;
		if self.fillLevel == 5 then
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette5, true);
		else
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette5, false);
		end;
		if self.fillLevel == 6 then
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette6, true);
		else
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette6, false);
		end;
		if self.fillLevel == 7 then
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette7, true);
		else
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette7, false);
		end;
		if self.fillLevel == 8 then
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette8, true);
		else
			setVisibility(self.antirutschmatte.verbrauchsgueter.palette8, false);
		end;
	else
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette1, false);
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette2, false);
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette3, false);
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette4, false);
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette5, false);
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette6, false);
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette7, false);
		setVisibility(self.antirutschmatte.verbrauchsgueter.palette8, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("BUYABLE_BLADES") then
		if self.fillLevel > 0 then
			setRotation(self.variableBodyParts.collisionFront, 0, 0, 0);
			setRotation(self.variableBodyParts.collisionBack, 0, 0, 0);
		end;
		
		if self.currentUnloadSide[self.unloadSide][1] == g_i18n:getText("UNLOAD_TRAILER") then
			if self.fillLevel > 0 then
				setVisibility(self.gitterStandardPaletten, true);
	
				setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex1, false);
				setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex2, false);
			else
				setVisibility(self.gitterStandardPaletten, false);
				
				setRotation(self.variableBodyParts.collisionFront, 120, 0, 0);
				setRotation(self.variableBodyParts.collisionBack, -120, 0, 0);
			end;
		else	
			setVisibility(self.gitterStandardPaletten, true);
	
			setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex1, false);
			setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex2, false);
		end;
	else
		setVisibility(self.gitterStandardPaletten, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("WOOLPALLET") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("CONSUMPTION_GOODS")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("EGGPALLET")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("GREENHOUSEPALLET")
	then
		if self.fillLevel > 0 then
			setRotation(self.variableBodyParts.collisionFront, 0, 0, 0);
			setRotation(self.variableBodyParts.collisionBack, 0, 0, 0);
		end;
		
		if self.currentUnloadSide[self.unloadSide][1] == g_i18n:getText("UNLOAD_TRAILER") then
			if self.fillLevel > 0 then
				setVisibility(self.gitterWollPaletten, true);
	
				setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex1, false);
				setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex2, false);
			else
				setVisibility(self.gitterWollPaletten, false);
				
				setRotation(self.variableBodyParts.collisionFront, 120, 0, 0);
				setRotation(self.variableBodyParts.collisionBack, -120, 0, 0);
			end;
		else	
			setVisibility(self.gitterWollPaletten, true);
	
			setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex1, false);
			setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex2, false);
		end;
	else
		setVisibility(self.gitterWollPaletten, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("STRAW_SQUAREBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("HAY_SQUAREBALE") 
		or self.choosenProductType[self.productType][1] == g_i18n:getText("MIX_SQUAREBALE")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("STANDARD_TREESAPLINGPALLET")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BIG_TREESAPLINGPALLET")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("H_MILK")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("BOARDPALLET")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("WASHEDPOTATOPALLET")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("TRANSPORTBOX")
		or self.choosenProductType[self.productType][1] == g_i18n:getText("SILAGE_ADDITIVES_TANK")
	then
		if self.fillLevel > 0 then
			setRotation(self.variableBodyParts.collisionFront, 0, 0, 0);
			setRotation(self.variableBodyParts.collisionBack, 0, 0, 0);
		end;
		
		setVisibility(self.variableBodyParts.variableBodyPart2.visibleIndex1, true);
		setVisibility(self.variableBodyParts.variableBodyPart2.visibleIndex2, true);
		
		setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex1, false);
		setVisibility(self.variableBodyParts.variableBodyPart1.visibleIndex2, false);
	else
		setVisibility(self.variableBodyParts.variableBodyPart2.visibleIndex1, false);
		setVisibility(self.variableBodyParts.variableBodyPart2.visibleIndex2, false);
	end;
end;

function FlieglMain_Extension_DPW150:draw()
end;