--[[
	VariableCapacityBalerRegister.lua
	
	Autor: Ifko[nator]
	Datum: 15.09.2014
]]

SpecializationUtil.registerSpecialization("variableCapacityBaler", "VariableCapacityBaler", g_currentModDirectory.."Scripts/VariableCapacityBaler.lua")

VariableCapacityBalerRegister = {};

function VariableCapacityBalerRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("baler") then	
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.variableCapacityBaler", _name)) ~= nil then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("variableCapacityBaler"));
						end;
						Baler.HIDE_HUD = g_i18n:getText("HIDE_HUD_TEXT");
						Baler.SHOW_HUD = g_i18n:getText("SHOW_HUD_TEXT");
						Baler.NOT_ALLOW_ADD_CAPACITY = g_i18n:getText("NOT_ALLOW_ADD_CAPACITY_TEXT");
						Baler.ALLOW_ADD_CAPACITY = g_i18n:getText("ALLOW_ADD_CAPACITY_TEXT");
						Baler.SET_NEW_CAPACITY = g_i18n:getText("SET_NEW_CAPACITY_TEXT");
						Baler.STOP_SET_NEW_CAPACITY = g_i18n:getText("STOP_SET_NEW_CAPACITY_TEXT");
						Baler.VERSION = g_i18n:getText("VERSION_TEXT");
						Baler.FILL_LEVEL = g_i18n:getText("FILL_LEVEL_TEXT");
						Baler.CAPACITY = g_i18n:getText("CAPACITY_TEXT");
						Baler.CAPACITY_ADDED = g_i18n:getText("CAPACITY_ADDED_TEXT");
						Baler.ADD_CAPACITY_ACTIVE = g_i18n:getText("ADD_CAPACITY_ACTIVE_TEXT");
						Baler.ADD_CAPACITY_NOT_ACTIVE = g_i18n:getText("ADD_CAPACITY_NOT_ACTIVE_TEXT");
						Baler.ADD_CAPACITY_MIN = g_i18n:getText("ADD_CAPACITY_MIN_TEXT");
						Baler.ADD_CAPACITY_MAX = g_i18n:getText("ADD_CAPACITY_MAX_TEXT");
						Baler.CAPACITY_REMOVED = g_i18n:getText("CAPACITY_REMOVED_TEXT");
						Baler.REMOVE_CAPACITY_ACTIVE = g_i18n:getText("REMOVE_CAPACITY_ACTIVE_TEXT");
						Baler.REMOVE_CAPACITY_NOT_ACTIVE = g_i18n:getText("REMOVE_CAPACITY_NOT_ACTIVE_TEXT");
						Baler.REMOVE_CAPACITY_MIN = g_i18n:getText("REMOVE_CAPACITY_MIN_TEXT");
						Baler.REMOVE_CAPACITY_MAX = g_i18n:getText("REMOVE_CAPACITY_MAX_TEXT");
						Baler.NEW_CAPACITY = g_i18n:getText("NEW_CAPACITY_TEXT");
						Baler.UNKNOWN = g_i18n:getText("UNKNOWN_TEXT");
						Baler.MIN_UNKNOWN = g_i18n:getText("MIN_UNKNOWN_TEXT");
						Baler.MAX_UNKNOWN = g_i18n:getText("MAX_UNKNOWN_TEXT");
						Baler.CAPACITY_UNKNOWN = g_i18n:getText("CAPACITY_UNKNOWN_TEXT");
					end;
				end;
			end;	
		end;
	end;
end;

function VariableCapacityBalerRegister:deleteMap()
end;

function VariableCapacityBalerRegister:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityBalerRegister:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityBalerRegister:update(dt)
end;

function VariableCapacityBalerRegister:draw()
end;

addModEventListener(VariableCapacityBalerRegister);