--[[
	EN: 'VariableCapacityBaler' specialization for baler and forageWagon.
	
	DE: 'VariableCapacityBaler' Spezialisierung für Ballenpressen und Ladewagen.
	
	Autor: Ifko[nator]
	Datum: 10.09.2015
	Version: 4.0
	
	History: V 1.0 @ 26.06.2014 - intial release
			 V 2.0 @ 17.08.2014 - many changes... to many to list here.. ^^
			 V 3.5 @ 15.09.2014 - first try to get this in FS15
			 V 4.0 @ 10.09.2015 - optimize code a little bit and added support for more mods
	
	Alternativer XML Eintrag:
	
<!--Variable Kapazität Anfang-->
	<variableCapacity addMin="0.01" addMax="0.08" removeMin="0.005" removeMax="0.02" hudPosX="0.3" hudPosY="0.025"/> 
	<!-- Die hier eingetragen Zahlen werden mit der Zahl aus dem Abschnitt 'capacity' multipliziert.
	Hat man nun eine Kapazität von '2000' würden die Werte wie folgt aussehen:
	addMin = '20' addMax = '160' removeMin = '10' removeMax = '40'
	Den: 2000*0.01 = '20', 2000*0.08 = '160', 2000*0.005 = '10' und 2000*0.02 = '40'
	Mit den Werten bei 'hudPosX' und 'hudPosY' kann man die Postion des Huds verändern. Muss man aber nicht angeben.
Variable Kapazität Ende-->
]]

VariableCapacityBaler = {}

local variableCapacityBaler_directory = g_currentModDirectory;

function VariableCapacityBaler.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function VariableCapacityBaler:load(xmlFile)
	self.capacityStart = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0);
	
	self.addCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#addMin"), 0.005);
	self.addCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#addMax"), 0.01);
	
	self.removeCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#removeMin"), 0.0025);
	self.removeCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#removeMax"), 0.008);
	
	self.addCapacityMin = self.capacityStart * self.addCapacityMinXml;
	self.addCapacityMax = self.capacityStart * self.addCapacityMaxXml;
	
	self.removeCapacityMin = self.capacityStart * self.removeCapacityMinXml;
	self.removeCapacityMax = self.capacityStart * self.removeCapacityMaxXml;
	
	self.addCapacityTime = false;
	self.newAddCapacity = 0;
	self.newRemoveCapacity = 0;
	self.capacityTime = 0;
	self.setNewCapacityTime = 0;
	
	self.setNewCapacity = false;
	self.allowAddCapacity = true;
	self.showHud = false;
	
	self.VariableCapacityBalerHudPosX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#hudPosX"), 0.3);
	self.VariableCapacityBalerHudPosY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#hudPosY"), 0.025);
	self.VariableCapacityBalerHudWidth = 0.42;
	self.VariableCapacityBalerHudHeight = 0.23;
	
	self.VariableCapacityBalerOverlayFilename = 
		Utils.getFilename("GUI/VariableCapacity_Hud.png", 
		variableCapacityBaler_directory
	);
	self.VariableCapacityBalerOverlay = 
		Overlay:new("VariableCapacityBalerOverlay", 
		self.VariableCapacityBalerOverlayFilename, 
		self.VariableCapacityBalerHudPosX, 
		self.VariableCapacityBalerHudPosY, 
		self.VariableCapacityBalerHudWidth, 
		self.VariableCapacityBalerHudHeight
	);
end;

function VariableCapacityBaler:delete()
end;

function VariableCapacityBaler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityBaler:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityBaler:update(dt)
	if self:getIsActive() and self.isClient then
		if InputBinding.hasEvent(InputBinding.ADD_CAPACITY_BUTTON) then
			if self.allowAddCapacity then
				self.allowAddCapacity = false;
			else
				self.allowAddCapacity = true;
				if self.capacityTime < 2 then
					self.capacity = self.capacityStart - self.newRemoveCapacity;
				else 
					self.capacity = self.capacityStart + self.newAddCapacity;
				end;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.SHOW_HUD_BUTTON) then
			self.showHud = not self.showHud;
		end;
		if (self.fillLevel >= (self.capacity * 0.05) and self.fillLevel < (self.capacity * 0.95)) and self.allowAddCapacity and self.setNewCapacityTime <= 50 then
			if InputBinding.hasEvent(InputBinding.SET_NEW_CAPACITY_BUTTON) then
				self.setNewCapacity = not self.setNewCapacity;
			end;
		else
			self.setNewCapacity = false;
		end;
	end;
end;

function VariableCapacityBaler:updateTick(dt)
	if self.allowAddCapacity then
		if self.fillLevel < (self.capacity * 0.05) or self.setNewCapacity then
			self.addCapacityTime = true;
			self.newAddCapacity = math.random(self.addCapacityMin, self.addCapacityMax);
			self.newRemoveCapacity = math.random(self.removeCapacityMin, self.removeCapacityMax);
			if self.capacityTime < 2 then
				self.capacity = self.capacityStart + self.newAddCapacity;
			else
				self.capacity = self.capacityStart - self.newRemoveCapacity;
				self.capacityTime = 0;
			end;
		else
			self.addCapacityTime = false;
		end;
		if self.addCapacityTime then
			self.capacityTime = self.capacityTime + 1;
		end;
		if self.setNewCapacity then
			self.setNewCapacityTime = self.setNewCapacityTime + 1;
		else
			self.setNewCapacityTime = 0;
		end;
	else
		self.capacity = self.capacityStart;
		if self.fillLevel > self.capacityStart then
			self.fillLevel = self.capacityStart;
		end;
	end;
end;

function VariableCapacityBaler:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 
		'newCapacity="' .. tostring(self.capacity) .. 
		'" newAddCapacity="' .. tostring(self.newAddCapacity) .. 
		'" newRemoveCapacity="' .. tostring(self.newRemoveCapacity) .. 
		'" capacityTime="' .. tostring(self.capacityTime) .. 
		'" showHud="' .. tostring(self.showHud) .. 
		'" setNewCapacity="' .. tostring(self.setNewCapacity) .. 
		'" setNewCapacityTime="' .. tostring(self.setNewCapacityTime) .. 
	'"';
	
	return attributes;
end;

function VariableCapacityBaler:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local newCapacity = Utils.getNoNil(getXMLInt(xmlFile, key .. "#newCapacity"), self.capacity);
	local newFillLevel = Utils.getNoNil(getXMLInt(xmlFile, key .. "#fillLevel"), self.fillLevel);
	local newAddCapacity = Utils.getNoNil(getXMLInt(xmlFile, key .. "#newAddCapacity"), self.newAddCapacity);
	local newRemoveCapacity = Utils.getNoNil(getXMLInt(xmlFile, key .. "#newRemoveCapacity"), self.newRemoveCapacity);
	local capacityTime = Utils.getNoNil(getXMLInt(xmlFile, key .. "#capacityTime"), self.capacityTime);
	local showHud = Utils.getNoNil(getXMLBool(xmlFile, key .. "#showHud"), self.showHud);
	local setNewCapacity = Utils.getNoNil(getXMLBool(xmlFile, key .. "#setNewCapacity"), self.setNewCapacity);
	local setNewCapacityTime = Utils.getNoNil(getXMLInt(xmlFile, key .. "#setNewCapacityTime"), self.setNewCapacityTime);
	
	self.capacity = newCapacity;	
	self.fillLevel = newFillLevel;
	self.newAddCapacity = newAddCapacity;
	self.newRemoveCapacity = newRemoveCapacity;
	self.capacityTime = capacityTime;
	self.showHud = showHud;
	self.setNewCapacity = setNewCapacity;
	self.setNewCapacityTime = setNewCapacityTime;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function VariableCapacityBaler:draw()
	local FillLevel = string.format(math.floor(self.fillLevel));
	local FillLevelString = string.format("%d [l]", FillLevel);
	
	local Capacity = string.format(math.floor(self.capacity));
	local CapacityStart = string.format(math.floor(self.capacityStart));
	local CapacityStartString = string.format("%d [l]", CapacityStart);
	local CapacityString = string.format("%d [l]", Capacity);
	local CapacityStringUnknown = (Baler.UNKNOWN);
	
	local NewAddCapacity = string.format(math.floor(self.newAddCapacity));
	local NewAddCapacityString = string.format("%d [l]", NewAddCapacity);
	
	local AddCapacityMin = string.format(math.floor(self.addCapacityMin));
	local AddCapacityMinString = string.format("%d [l]", AddCapacityMin);
	local AddCapacityMax = string.format(math.floor(self.addCapacityMax));
	local AddCapacityMaxString = string.format("%d [l]", AddCapacityMax);
	
	local NewRemoveCapacity = string.format(math.floor(self.newRemoveCapacity));
	local NewRemoveCapacityString = string.format("%d [l]", NewRemoveCapacity);
	
	local RemoveCapacityMin = string.format(math.floor(self.removeCapacityMin));
	local RemoveCapacityMinString = string.format("%d [l]", RemoveCapacityMin);
	local RemoveCapacityMax = string.format(math.floor(self.removeCapacityMax));
	local RemoveCapacityMaxString = string.format("%d [l]", RemoveCapacityMax);
	
	if self.allowAddCapacity then
		g_currentMission:addHelpButtonText(Baler.NOT_ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
		if self.fillLevel >= (self.capacity * 0.05) and self.fillLevel < (self.capacity * 0.95) then
			if self.setNewCapacity then
				g_currentMission:addHelpButtonText(Baler.STOP_SET_NEW_CAPACITY, InputBinding.SET_NEW_CAPACITY_BUTTON);
			else
				g_currentMission:addHelpButtonText(Baler.SET_NEW_CAPACITY, InputBinding.SET_NEW_CAPACITY_BUTTON);
			end;
		end;
	else
		g_currentMission:addHelpButtonText(Baler.ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
	end;
	
	if self.showHud then
		self.VariableCapacityBalerOverlay:render();
		
		setTextBold(true);
		setTextAlignment(RenderText.ALIGN_CENTER);
		setTextColor(1, 1, 1, 1);
		
		renderText(self.VariableCapacityBalerHudPosX + 0.205, self.VariableCapacityBalerHudPosY + 0.19, 0.02, (Baler.VERSION));
		
		setTextAlignment(RenderText.ALIGN_LEFT);
		
		renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.15, 0.02, (Baler.FILL_LEVEL));
		renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.13, 0.02, (Baler.CAPACITY));
		
		if not self.setNewCapacity then
			if self.fillLevel > (self.capacity * 0.05) then
				if self.capacityTime < 2 then
					renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.11, 0.02, (Baler.CAPACITY_REMOVED));
					if self.newRemoveCapacity > 0 then
						if self.allowAddCapacity then
							renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.09, 0.02, (Baler.REMOVE_CAPACITY_ACTIVE));
						else
							renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.09, 0.02, (Baler.REMOVE_CAPACITY_NOT_ACTIVE));
						end;
					else
						renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.09, 0.02, (Baler.REMOVE_CAPACITY_NOT_ACTIVE));
					end;
					renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.07, 0.02, (Baler.REMOVE_CAPACITY_MIN));
					renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.05, 0.02, (Baler.REMOVE_CAPACITY_MAX));
				else
					renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.11, 0.02, (Baler.CAPACITY_ADDED));
					if self.newAddCapacity > 0 then
						if self.allowAddCapacity then
							renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.09, 0.02, (Baler.ADD_CAPACITY_ACTIVE));
						else
							renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.09, 0.02, (Baler.ADD_CAPACITY_NOT_ACTIVE));
						end;
					else
						renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.09, 0.02, (Baler.ADD_CAPACITY_NOT_ACTIVE));
					end;
					renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.07, 0.02, (Baler.ADD_CAPACITY_MIN));
					renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.05, 0.02, (Baler.ADD_CAPACITY_MAX));
				end;
			else
				renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.11, 0.02, (Baler.CAPACITY_UNKNOWN));
				renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.07, 0.02, (Baler.MIN_UNKNOWN));
				renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.05, 0.02, (Baler.MAX_UNKNOWN));
			end;
		else
			renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.11, 0.02, (Baler.CAPACITY_UNKNOWN));
			renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.07, 0.02, (Baler.MIN_UNKNOWN));
			renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.05, 0.02, (Baler.MAX_UNKNOWN));
		end;
		renderText(self.VariableCapacityBalerHudPosX + 0.015, self.VariableCapacityBalerHudPosY + 0.03, 0.02, (Baler.NEW_CAPACITY));
		
		setTextAlignment(RenderText.ALIGN_RIGHT);
		
		renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.15,0.02, (FillLevelString));
		renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.13, 0.02, (CapacityStartString));
		
		if not self.setNewCapacity then
			if self.fillLevel > (self.capacity * 0.05) then
				if self.capacityTime < 2 then
					renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.11, 0.02, (NewRemoveCapacityString));
					renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.07, 0.02, (RemoveCapacityMinString));
					renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.05, 0.02, (RemoveCapacityMaxString));
				else
					renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.11, 0.02, (NewAddCapacityString));
					renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.07, 0.02, (AddCapacityMinString));
					renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.05, 0.02, (AddCapacityMaxString));
				end;
				renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.03, 0.02, (CapacityString));
			else
				renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.11, 0.02, (Baler.UNKNOWN));
				renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.07, 0.02, (Baler.UNKNOWN));
				renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.05, 0.02, (Baler.UNKNOWN));
				renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.03, 0.02, (Baler.UNKNOWN));
			end;
		else
			renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.11, 0.02, (Baler.UNKNOWN));
			renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.07, 0.02, (Baler.UNKNOWN));
			renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.05, 0.02, (Baler.UNKNOWN));
			renderText(self.VariableCapacityBalerHudPosX + 0.4, self.VariableCapacityBalerHudPosY + 0.03, 0.02, (Baler.UNKNOWN));
		end;
		
		g_currentMission:addHelpButtonText(Baler.HIDE_HUD, InputBinding.SHOW_HUD_BUTTON);
	else
		if not self.setNewCapacity then
			if self.fillLevel > (self.capacity * 0.05) then
				if self.capacityTime < 2 then
					g_currentMission:addExtraPrintText(Baler.CAPACITY_REMOVED .. " " .. NewRemoveCapacityString);
					if self.newRemoveCapacity > 0 then
						if self.allowAddCapacity then
							g_currentMission:addExtraPrintText(Baler.REMOVE_CAPACITY_ACTIVE);
						else
							g_currentMission:addExtraPrintText(Baler.REMOVE_CAPACITY_NOT_ACTIVE);
						end;
					else
						g_currentMission:addExtraPrintText(Baler.REMOVE_CAPACITY_NOT_ACTIVE);
					end;
				else						
					g_currentMission:addExtraPrintText(Baler.CAPACITY_ADDED .. " " .. NewAddCapacityString);
					if self.newAddCapacity > 0 then
						if self.allowAddCapacity then
							g_currentMission:addExtraPrintText(Baler.ADD_CAPACITY_ACTIVE);
						else
							g_currentMission:addExtraPrintText(Baler.ADD_CAPACITY_NOT_ACTIVE);
						end;
					else
						g_currentMission:addExtraPrintText(Baler.ADD_CAPACITY_NOT_ACTIVE);
					end;
				end;
				g_currentMission:addExtraPrintText(Baler.NEW_CAPACITY .. " " .. CapacityString);
			else
				g_currentMission:addExtraPrintText(Baler.NEW_CAPACITY .. " " .. CapacityStringUnknown);
			end;
		else
			g_currentMission:addExtraPrintText(Baler.NEW_CAPACITY .. " " .. CapacityStringUnknown);
		end;

		g_currentMission:addHelpButtonText(Baler.SHOW_HUD, InputBinding.SHOW_HUD_BUTTON);
	end;
	
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false);
	setTextColor(1, 1, 1, 1);
end;