--[[
	VariableCapacityCombineRegister.lua
	
	Autor: Ifko[nator]
	Datum: 15.09.2014
]]

SpecializationUtil.registerSpecialization("variableCapacityCombine", "VariableCapacityCombine", g_currentModDirectory.."Scripts/VariableCapacityCombine.lua")

VariableCapacityCombineRegister = {};

function VariableCapacityCombineRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("combine") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.variableCapacityCombine", _name)) ~= nil then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("variableCapacityCombine"));
						end;
						Combine.HIDE_HUD = g_i18n:getText("HIDE_HUD_TEXT");
						Combine.SHOW_HUD = g_i18n:getText("SHOW_HUD_TEXT");
						Combine.NOT_ALLOW_ADD_CAPACITY = g_i18n:getText("NOT_ALLOW_ADD_CAPACITY_TEXT");
						Combine.ALLOW_ADD_CAPACITY = g_i18n:getText("ALLOW_ADD_CAPACITY_TEXT");
						Combine.SET_NEW_CAPACITY = g_i18n:getText("SET_NEW_CAPACITY_TEXT");
						Combine.STOP_SET_NEW_CAPACITY = g_i18n:getText("STOP_SET_NEW_CAPACITY_TEXT");
						Combine.VERSION = g_i18n:getText("VERSION_TEXT");
						Combine.GRAINTANK_FILL_LEVEL = g_i18n:getText("GRAINTANK_FILL_LEVEL_TEXT");
						Combine.GRAINTANK_CAPACITY = g_i18n:getText("GRAINTANK_CAPACITY_TEXT");
						Combine.GRAINTANK_CAPACITY_ADDED = g_i18n:getText("GRAINTANK_CAPACITY_ADDED_TEXT");
						Combine.ADD_GRAINTANK_CAPACITY_ACTIVE = g_i18n:getText("ADD_GRAINTANK_CAPACITY_ACTIVE_TEXT");
						Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE = g_i18n:getText("ADD_GRAINTANK_CAPACITY_NOT_ACTIVE_TEXT");
						Combine.ADD_GRAINTANK_CAPACITY_MIN = g_i18n:getText("ADD_GRAINTANK_CAPACITY_MIN_TEXT");
						Combine.ADD_GRAINTANK_CAPACITY_MAX = g_i18n:getText("ADD_GRAINTANK_CAPACITY_MAX_TEXT");
						Combine.GRAINTANK_CAPACITY_REMOVED = g_i18n:getText("GRAINTANK_CAPACITY_REMOVED_TEXT");
						Combine.REMOVE_GRAINTANK_CAPACITY_ACTIVE = g_i18n:getText("REMOVE_GRAINTANK_CAPACITY_ACTIVE_TEXT");
						Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE = g_i18n:getText("REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE_TEXT");
						Combine.REMOVE_GRAINTANK_CAPACITY_MIN = g_i18n:getText("REMOVE_GRAINTANK_CAPACITY_MIN_TEXT");
						Combine.REMOVE_GRAINTANK_CAPACITY_MAX = g_i18n:getText("REMOVE_GRAINTANK_CAPACITY_MAX_TEXT");
						Combine.NEW_GRAINTANK_CAPACITY = g_i18n:getText("NEW_GRAINTANK_CAPACITY_TEXT");
						Combine.UNKNOWN = g_i18n:getText("UNKNOWN_TEXT");
						Combine.GRAINTANK_MIN_UNKNOWN = g_i18n:getText("GRAINTANK_MIN_UNKNOWN_TEXT");
						Combine.GRAINTANK_MAX_UNKNOWN = g_i18n:getText("GRAINTANK_MAX_UNKNOWN_TEXT");
						Combine.GRAINTANK_CAPACITY_UNKNOWN = g_i18n:getText("GRAINTANK_CAPACITY_UNKNOWN_TEXT");
					end;
				end;
			end;	
		end;
	end;
end;

function VariableCapacityCombineRegister:deleteMap()
end;

function VariableCapacityCombineRegister:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityCombineRegister:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityCombineRegister:update(dt)
end;

function VariableCapacityCombineRegister:draw()
end;

addModEventListener(VariableCapacityCombineRegister);