--[[
	EN: 'VariableCapacityCombine' specialization for combine.
	
	DE: 'VariableCapacityCombine' Spezialisierung für Drescher.
	
	Autor: Ifko[nator]
	Datum: 10.09.2015
	Version: 4.0
	
	History: V 1.0 @ 26.06.2014 - intial release
			 V 2.0 @ 17.08.2014 - many changes... to many to list here.. ^^
			 V 3.5 @ 15.09.2014 - first try to get this in FS15
			 V 4.0 @ 10.09.2015 - optimize code a little bit and added support for more mods
	
	Alternativer XML Eintrag:
	
<!--Variable Kapazität Anfang-->
	<variableCapacity addMin="0.01" addMax="0.08" removeMin="0.005" removeMax="0.02" hudPosX="0.3" hudPosY="0.025"/> 
	<!-- Die hier eingetragen Zahlen werden mit der Zahl aus dem Abschnitt 'capacity' multipliziert.
	Hat man nun eine Kapazität von '2000' würden die Werte wie folgt aussehen:
	addMin = '20' addMax = '160' removeMin = '10' removeMax = '40'
	Den: 2000*0.01 = '20', 2000*0.08 = '160', 2000*0.005 = '10' und 2000*0.02 = '40'
	Mit den Werten bei 'hudPosX' und 'hudPosY' kann man die Postion des Huds verändern. Muss man aber nicht angeben.
Variable Kapazität Ende-->
]]

VariableCapacityCombine = {}

local variableCapacityCombine_directory = g_currentModDirectory;

function VariableCapacityCombine.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function VariableCapacityCombine:load(xmlFile)
	if self.capacity > 0 then
		self.capacityStart = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0);
		
		self.addCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#addMin"), 0.01);
		self.addCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#addMax"), 0.08);
		
		self.removeCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#removeMin"), 0.005);
		self.removeCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#removeMax"), 0.02);
		
		self.addCapacityMin = self.capacityStart * self.addCapacityMinXml;
		self.addCapacityMax = self.capacityStart * self.addCapacityMaxXml;
		
		self.removeCapacityMin = self.capacityStart * self.removeCapacityMinXml;
		self.removeCapacityMax = self.capacityStart * self.removeCapacityMaxXml;
		
		self.addCapacityTime = false;
		self.newAddCapacity = 0;
		self.newRemoveCapacity = 0;
		self.capacityTime = 0;
		self.setNewCapacityTime = 0;
		
		self.setNewCapacity = false;
		self.allowAddCapacity = true;
		self.showHud = false;
		
		self.VariableCapacityCombineHudPosX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variablecapacity#hudPosX"), 0.3);
		self.VariableCapacityCombineHudPosY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variablecapacity#hudPosY"), 0.025);
		self.VariableCapacityCombineHudWidth = 0.42;
		self.VariableCapacityCombineHudHeight = 0.23;
		
		self.VariableCapacityCombineOverlayFilename = 
			Utils.getFilename("GUI/VariableCapacity_Hud.png", 
			variableCapacityCombine_directory
		);
		self.VariableCapacityCombineOverlay = 
			Overlay:new("VariableCapacityCombineOverlay", 
			self.VariableCapacityCombineOverlayFilename, 
			self.VariableCapacityCombineHudPosX, 
			self.VariableCapacityCombineHudPosY, 
			self.VariableCapacityCombineHudWidth, 
			self.VariableCapacityCombineHudHeight
		);
	end;
end;

function VariableCapacityCombine:delete()
end;

function VariableCapacityCombine:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityCombine:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityCombine:update(dt)
	if self.capacity > 0 then
		if self:getIsActive() and self.isClient then
			if InputBinding.hasEvent(InputBinding.ADD_CAPACITY_BUTTON) then
				if self.allowAddCapacity then
					self.allowAddCapacity = false;
				else
					self.allowAddCapacity = true;
					if self.capacityTime < 2 then
						self.capacity = self.capacityStart + self.newAddCapacity;
					else
						self.capacity = self.capacityStart - self.newRemoveCapacity;
					end;
				end;
			end;
			if InputBinding.hasEvent(InputBinding.SHOW_HUD_BUTTON) then
				self.showHud = not self.showHud;
			end;
			if (self.fillLevel > 0 and self.fillLevel < (self.capacity * 0.95)) and self.allowAddCapacity and self.setNewCapacityTime <= 50 then
				if InputBinding.hasEvent(InputBinding.SET_NEW_CAPACITY_BUTTON) then
					self.setNewCapacity = not self.setNewCapacity;
				end;
			else
				self.setNewCapacity = false;
			end;
		end;
	end;
end;

function VariableCapacityCombine:updateTick(dt)
	if self.capacity > 0 then
		if self.allowAddCapacity then
			if self.fillLevel == 0 or self.setNewCapacity then
				self.addCapacityTime = true;
				self.newAddCapacity = math.random(self.addCapacityMin, self.addCapacityMax);
				self.newRemoveCapacity = math.random(self.removeCapacityMin, self.removeCapacityMax);
				if self.capacityTime < 2 then
					self.capacity = self.capacityStart - self.newRemoveCapacity;
				else
					self.capacity = self.capacityStart + self.newAddCapacity;
					self.capacityTime = 0;
				end;
			else
				self.addCapacityTime = false;
			end;
			if self.addCapacityTime then
				self.capacityTime = self.capacityTime + 1;
			end;
			if self.setNewCapacity then
				self.setNewCapacityTime = self.setNewCapacityTime + 1;
			else
				self.setNewCapacityTime = 0;
			end;
		else
			self.capacity = self.capacityStart;
			if self.fillLevel > self.capacityStart then
				self.fillLevel = self.capacityStart;
			end;
		end;
	end;
end;

function VariableCapacityCombine:getSaveAttributesAndNodes(nodeIdent)
	if self.capacity > 0 then
		local attributes = 
			'newCapacity="' .. tostring(self.capacity) .. 
			'" newAddCapacity="' .. tostring(self.newAddCapacity) .. 
			'" newRemoveCapacity="' .. tostring(self.newRemoveCapacity) .. 
			'" capacityTime="' .. tostring(self.capacityTime) .. 
			'" showHud="' .. tostring(self.showHud) .. 
			'" setNewCapacity="' .. tostring(self.setNewCapacity) .. 
			'" setNewCapacityTime="' .. tostring(self.setNewCapacityTime) .. 
		'"';
		
		return attributes;
	else
		return nil;
	end;
end;

function VariableCapacityCombine:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if self.capacity > 0 then
		local newCapacity = Utils.getNoNil(getXMLInt(xmlFile, key .. "#newCapacity"), self.capacity);
		local newFillLevel = Utils.getNoNil(getXMLInt(xmlFile, key .. "#fillLevel"), self.fillLevel);
		local newAddCapacity = Utils.getNoNil(getXMLInt(xmlFile, key .. "#newAddCapacity"), self.newAddCapacity);
		local newRemoveCapacity = Utils.getNoNil(getXMLInt(xmlFile, key .. "#newRemoveCapacity"), self.newRemoveCapacity);
		local capacityTime = Utils.getNoNil(getXMLInt(xmlFile, key .. "#capacityTime"), self.capacityTime);
		local showHud = Utils.getNoNil(getXMLBool(xmlFile, key .. "#showHud"), self.showHud);
		local setNewCapacity = Utils.getNoNil(getXMLBool(xmlFile, key .. "#setNewCapacity"), self.setNewCapacity);
		local setNewCapacityTime = Utils.getNoNil(getXMLInt(xmlFile, key .. "#setNewCapacityTime"), self.setNewCapacityTime);
		
		self.capacity = newCapacity;	
		self.fillLevel = newFillLevel;
		self.newAddCapacity = newAddCapacity;
		self.newRemoveCapacity = newRemoveCapacity;
		self.capacityTime = capacityTime;
		self.showHud = showHud;
		self.setNewCapacity = setNewCapacity;
		self.setNewCapacityTime = setNewCapacityTime;
		
		return BaseMission.VEHICLE_LOAD_OK;
	else
		return nil;
	end;
end;

function VariableCapacityCombine:draw()
	if self.capacity > 0 then
		local FillLevel = string.format(math.floor(self.fillLevel));
		local FillLevelString = string.format("%d [l]", FillLevel);
		
		local Capacity = string.format(math.floor(self.capacity));
		local CapacityStart = string.format(math.floor(self.capacityStart));
		local CapacityStartString = string.format("%d [l]", CapacityStart);
		local CapacityString = string.format("%d [l]", Capacity);
		local CapacityStringUnknown = (Combine.UNKNOWN);
		
		local NewAddCapacity = string.format(math.floor(self.newAddCapacity));
		local NewAddCapacityString = string.format("%d [l]", NewAddCapacity);
		
		local AddCapacityMin = string.format(math.floor(self.addCapacityMin));
		local AddCapacityMinString = string.format("%d [l]", AddCapacityMin);
		local AddCapacityMax = string.format(math.floor(self.addCapacityMax));
		local AddCapacityMaxString = string.format("%d [l]", AddCapacityMax);
		
		local NewRemoveCapacity = string.format(math.floor(self.newRemoveCapacity));
		local NewRemoveCapacityString = string.format("%d [l]", NewRemoveCapacity);
		
		local RemoveCapacityMin = string.format(math.floor(self.removeCapacityMin));
		local RemoveCapacityMinString = string.format("%d [l]", RemoveCapacityMin);
		local RemoveCapacityMax = string.format(math.floor(self.removeCapacityMax));
		local RemoveCapacityMaxString = string.format("%d [l]", RemoveCapacityMax);
		
		if self.allowAddCapacity then
			g_currentMission:addHelpButtonText(Combine.NOT_ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
			if self.fillLevel > 0 and self.fillLevel < (self.capacity * 0.95) then
				if self.setNewCapacity then
					g_currentMission:addHelpButtonText(Combine.STOP_SET_NEW_CAPACITY, InputBinding.SET_NEW_CAPACITY_BUTTON);
				else
					g_currentMission:addHelpButtonText(Combine.SET_NEW_CAPACITY, InputBinding.SET_NEW_CAPACITY_BUTTON);
				end;
			end;
		else
			g_currentMission:addHelpButtonText(Combine.ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
		end;
		
		if self.showHud then
			self.VariableCapacityCombineOverlay:render();
			
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_CENTER);
			setTextColor(1, 1, 1, 1);
			
			renderText(self.VariableCapacityCombineHudPosX + 0.205, self.VariableCapacityCombineHudPosY + 0.185, 0.022, (Combine.VERSION));
			
			setTextAlignment(RenderText.ALIGN_LEFT);
			
			renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.15, 0.02, (Combine.GRAINTANK_FILL_LEVEL));
			renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.13, 0.02, (Combine.GRAINTANK_CAPACITY));
			
			if not self.setNewCapacity then
				if self.fillLevel > 0 then
					if self.capacityTime < 2 then
						renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.11, 0.02, (Combine.GRAINTANK_CAPACITY_ADDED));
						if self.newAddCapacity > 0 then
							if self.allowAddCapacity then
								renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.09, 0.02, (Combine.ADD_GRAINTANK_CAPACITY_ACTIVE));
							else
								renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.09, 0.02, (Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE));
							end;
						else
							renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.09, 0.02, (Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE));
						end;
						renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.07, 0.02, (Combine.ADD_GRAINTANK_CAPACITY_MIN));
						renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.05, 0.02, (Combine.ADD_GRAINTANK_CAPACITY_MAX));
					else
						renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.11, 0.02, (Combine.GRAINTANK_CAPACITY_REMOVED));
						if self.newRemoveCapacity > 0 then
							if self.allowAddCapacity then
								renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.09, 0.02, (Combine.REMOVE_GRAINTANK_CAPACITY_ACTIVE));
							else
								renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.09, 0.02, (Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE));
							end;
						else
							renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.09, 0.02, (Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE));
						end;
						renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.07, 0.02, (Combine.REMOVE_GRAINTANK_CAPACITY_MIN));
						renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.05, 0.02, (Combine.REMOVE_GRAINTANK_CAPACITY_MAX));
					end;
				else
					renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.11, 0.02, (Combine.GRAINTANK_CAPACITY_UNKNOWN));
					renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.07, 0.02, (Combine.GRAINTANK_MIN_UNKNOWN));
					renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.05, 0.02, (Combine.GRAINTANK_MAX_UNKNOWN));
				end;
			else
				renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.11, 0.02, (Combine.GRAINTANK_CAPACITY_UNKNOWN));
				renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.07, 0.02, (Combine.GRAINTANK_MIN_UNKNOWN));
				renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.05, 0.02, (Combine.GRAINTANK_MAX_UNKNOWN));
			end;
			renderText(self.VariableCapacityCombineHudPosX + 0.015, self.VariableCapacityCombineHudPosY + 0.03,0.02, (Combine.NEW_GRAINTANK_CAPACITY));
			
			setTextAlignment(RenderText.ALIGN_RIGHT);
			
			renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.15, 0.02, (FillLevelString));
			renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.13, 0.02, (CapacityStartString));
			
			if not self.setNewCapacity then
				if self.fillLevel > 0 then
					if self.capacityTime < 2 then
						renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.11, 0.02, (NewAddCapacityString));
						renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.07, 0.02, (AddCapacityMinString));
						renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.05, 0.02, (AddCapacityMaxString));
					else
						renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.11, 0.02, (NewRemoveCapacityString));
						renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.07, 0.02, (RemoveCapacityMinString));
						renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.05, 0.02, (RemoveCapacityMaxString));
					end;
					renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.03, 0.02, (CapacityString));
				else
					renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.11, 0.02, (Combine.UNKNOWN));
					renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.07, 0.02, (Combine.UNKNOWN));
					renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.05, 0.02, (Combine.UNKNOWN));
					renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.03, 0.02, (Combine.UNKNOWN));
				end;
			else
				renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.11, 0.02, (Combine.UNKNOWN));
				renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.07, 0.02, (Combine.UNKNOWN));
				renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.05, 0.02, (Combine.UNKNOWN));
				renderText(self.VariableCapacityCombineHudPosX + 0.4, self.VariableCapacityCombineHudPosY + 0.03, 0.02, (Combine.UNKNOWN));
			end;
			
			g_currentMission:addHelpButtonText(Combine.HIDE_HUD, InputBinding.SHOW_HUD_BUTTON);
		else
			if not self.setNewCapacity then
				if self.fillLevel > 0 then
					if self.capacityTime < 2 then
						g_currentMission:addExtraPrintText(Combine.GRAINTANK_CAPACITY_ADDED .. " " .. NewAddCapacityString);
						if self.newAddCapacity > 0 then
							if self.allowAddCapacity then
								g_currentMission:addExtraPrintText(Combine.ADD_GRAINTANK_CAPACITY_ACTIVE);
							else
								g_currentMission:addExtraPrintText(Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE);
							end;
						else
							g_currentMission:addExtraPrintText(Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE);
						end;
					else
						g_currentMission:addExtraPrintText(Combine.GRAINTANK_CAPACITY_REMOVED .. " " .. NewRemoveCapacityString);
						if self.newRemoveCapacity > 0 then
							if self.allowAddCapacity then
								g_currentMission:addExtraPrintText(Combine.REMOVE_GRAINTANK_CAPACITY_ACTIVE);
							else
								g_currentMission:addExtraPrintText(Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE);
							end;
						else
							g_currentMission:addExtraPrintText(Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE);
						end;
					end;
					g_currentMission:addExtraPrintText(Combine.NEW_GRAINTANK_CAPACITY .. " " .. CapacityString);
				else
					g_currentMission:addExtraPrintText(Combine.NEW_GRAINTANK_CAPACITY .. " " .. CapacityStringUnknown);
				end;
			else
				g_currentMission:addExtraPrintText(Combine.NEW_GRAINTANK_CAPACITY .. " " .. CapacityStringUnknown);
			end;
		
			g_currentMission:addHelpButtonText(Combine.SHOW_HUD, InputBinding.SHOW_HUD_BUTTON);
		end;
		
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(false);
		setTextColor(1, 1, 1, 1);
	end;
end;