--[[
Spezialisierung die die aktuell eingestellte Baumstammlänge beim Harverster speichert.

Author:	Ifko[nator]
Datum:	25.08.2015

Version:	v1.6
History:	v1.0 @ 02.08.2015 - initial implementation
			v1.5 @ 03.08.2015 - added render function, to render the current cutting length on the screen.
			v1.6 @ 25.08.2015 - added a function to allow set down the current cutting length.
]]

WoodHarvesterSaveCuttingLength = {};

function WoodHarvesterSaveCuttingLength.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(WoodHarvester, specializations);
end;

function WoodHarvesterSaveCuttingLength:load(xmlFile)
end;

function WoodHarvesterSaveCuttingLength:delete()
end;

function WoodHarvesterSaveCuttingLength:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WoodHarvesterSaveCuttingLength:keyEvent(unicode, sym, modifier, isDown)
end;

function WoodHarvesterSaveCuttingLength:update(dt)
	if self:getIsActiveForInput() and self:getIsTurnedOn() and not self.isAttachedSplitShapeMoving then
		if InputBinding.hasEvent(InputBinding.SET_CURRENT_CUTTING_LENGTH_DOWN) then
			if self.currentCutLength > self.cutLengthMin and self.currentCutLength < self.cutLengthMax+0.0001 then
				self.currentCutLength = self.currentCutLength - self.cutLengthStep;
			else
				self.currentCutLength = self.cutLengthMin;
			end;
		end;
	end;
end;


function WoodHarvesterSaveCuttingLength:draw()
	if self:getIsTurnedOn() then
		if self:getIsActive() then
			local currentLengthString = string.format(WoodHarvester.CURRENT_CUT_LENGTH, self.currentCutLength);
			
			renderText(g_currentMission.fillLevelIconOverlay.x + 4.4*g_currentMission.fillLevelTextOffsetX, g_currentMission.speedHud.y, g_currentMission.fillLevelTextSizeSmall, currentLengthString);
		end;
		
		if self:getIsActiveForInput() and not self.isAttachedSplitShapeMoving  then
			if self.currentCutLength > self.cutLengthMin and self.currentCutLength < self.cutLengthMax+0.0001 then
				g_currentMission:addHelpButtonText(WoodHarvester.SET_CURRENT_CUTTING_LENGTH_DOWN, InputBinding.SET_CURRENT_CUTTING_LENGTH_DOWN);
			end;
		end;
	end;
end;

function WoodHarvesterSaveCuttingLength:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local currentCutLength = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#currentCutLength"), self.cutLengthMin);
		
		self.currentCutLength = currentCutLength;
	end;

	return BaseMission.VEHICLE_LOAD_OK;
end;

function WoodHarvesterSaveCuttingLength:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'currentCutLength="'.. tostring(self.currentCutLength) .. '"';

	return attributes, nil;
end;