--[[
	GPS_Extension_Register.lua
	
	Autor: Ifko[nator]
	Datum: 20.08.2015
]]

if g_modNameToDirectory["ZZZ_GPS"] then
	SpecializationUtil.registerSpecialization("GPS_Extension", "GPS_Extension", g_currentModDirectory .. "GPS_Extension.lua")
	
	GPS_Extension_Register = {};
	
	function GPS_Extension_Register:loadMap(name)
		if self.firstRun == nil then
			self.firstRun = false;
			for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
				if v ~= nil then
					local allowInsertion = true;
					for i = 1, table.maxn(v.specializations) do
						local vs = v.specializations[i];
						-- Standard lua's
						if vs ~= nil and vs == SpecializationUtil.getSpecialization("drivable") then
							local v_name_string = v.name 
							local point_location = string.find(v_name_string, ".", nil, true)
							if point_location ~= nil then
								local _name = string.sub(v_name_string, 1, point_location-1);
								-- Mod lua's (nicht im dataS Ordner!)
								if rawget(SpecializationUtil.specializations, string.format("%s.GPS_Extension", _name)) ~= nil then
									allowInsertion = false;
								end;
							end;
							if allowInsertion then
								table.insert(v.specializations, SpecializationUtil.getSpecialization("GPS_Extension"));
							end;
						end;
					end;
				end;	
			end;
		end;
	end;
	
	function GPS_Extension_Register:deleteMap()end;
	function GPS_Extension_Register:keyEvent(unicode, sym, modifier, isDown)end;
	function GPS_Extension_Register:mouseEvent(posX, posY, isDown, isUp, button)end;
	function GPS_Extension_Register:update(dt)end;
	function GPS_Extension_Register:draw()end;
	
	addModEventListener(GPS_Extension_Register);
else
	print("[INFO from the GPS_Extension_Register.lua]: Missing the GPS Mod in your mod directory: '" .. g_modsDirectory .. "'! GPS_Extension_Register.lua and GPS_Extension.lua are stopped now!");
end;