--[[
GPS Mod Erweiterung

Spezialisierung die den GPS Mod langsam wenden lässt. Auch ist es nun möglich mit dem GPS Mod Runndballen zu pressen, ohne das man einreifen muss.

Author:	Ifko[nator]
Datum:	20.08.2015

Version:	v1.0
History:	v1.0 - initial implementation

Special thanks to upsidedown for helping me out to find the middel line of the current work width..
]]

GPS_Extension = {};

function GPS_Extension.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function GPS_Extension:load(xmlFile)
	self.hasSetSpeed = {false, false, false};
	self.hasBaleUnloaded = false;
	
	self.startMotorBrake = self.motor.brakeForce;
end;

function GPS_Extension:setSlowTurn()
	if self.GPSdistance2FieldBorder ~= nil then
		return self.lhBeta*self.GPSWidth >= 0.6 or self.lhBeta*self.GPSWidth <= -0.6 or self.GPSdistance2FieldBorder <= self.GPSautoStopDistance + 20;
	else
		return self.lhBeta*self.GPSWidth >= 0.6 or self.lhBeta*self.GPSWidth <= -0.6;
	end;
end;

function GPS_Extension:update(dt)
	if self:getIsActive() then
		if self.GPSisActiveSteering then
			if self.hasSetSpeed[2] then
				self.hasSetSpeed[2] = false;
			end;
			
			if GPS_Extension.setSlowTurn(self) then
				self:setCruiseControlMaxSpeed(10);
				
				if self.hasSetSpeed[1] then
					self.hasSetSpeed[1] = false;
				end;
			else
				if not self.hasSetSpeed[1] then
					self:setCruiseControlMaxSpeed(self.cruiseControl.maxSpeed);
					self.hasSetSpeed[1] = true;
				end;
			end;
		else
			if not self.hasSetSpeed[2] then
				self:setCruiseControlMaxSpeed(self.cruiseControl.maxSpeed);
				self.hasSetSpeed[2] = true;
			end;
		end;
		
		for _, implement in pairs(self.attachedImplements) do
			if implement ~= nil and implement.object ~= nil then
				local roundBaler = implement.object;
				local controlledTractor = roundBaler.attacherVehicle;
				
				if SpecializationUtil.hasSpecialization(Baler, roundBaler.specializations) and roundBaler.firstBaleMarker == nil and controlledTractor.GPSisActiveSteering then
					--## we have an round baler attached :)
					if roundBaler.fillLevel > roundBaler.capacity*0.5 and roundBaler.fillLevel < roundBaler.capacity*0.8 then
						if self.hasSetSpeed[3] then
							self.hasSetSpeed[3] = false;
						end;
						
						controlledTractor:setCruiseControlMaxSpeed(15);
					elseif roundBaler.fillLevel > roundBaler.capacity*0.8 and roundBaler.fillLevel < roundBaler.capacity*0.95 then
						if self.hasSetSpeed[3] then
							self.hasSetSpeed[3] = false;
						end;
						
						controlledTractor:setCruiseControlMaxSpeed(10);
					elseif roundBaler.fillLevel > roundBaler.capacity*0.95 and roundBaler.fillLevel < roundBaler.capacity then
						if self.hasSetSpeed[3] then
							self.hasSetSpeed[3] = false;
						end;
						
						controlledTractor:setCruiseControlMaxSpeed(5);
					elseif roundBaler.fillLevel == roundBaler.capacity then
						if self.hasSetSpeed[3] then
							self.hasSetSpeed[3] = false;
						end;
						
						if not self.hasBaleUnloaded then
							self.hasBaleUnloaded = true;
						end;
						
						controlledTractor.setCruiseControlState(self, 0);
						
						if #(roundBaler.bales) > 0 and roundBaler:isUnloadingAllowed() then
							roundBaler:setIsUnloadingBale(true);
						end;
					elseif roundBaler.balerUnloadingState ~= Baler.UNLOADING_CLOSED then
						if roundBaler.balerUnloadingState == Baler.UNLOADING_OPEN then
							roundBaler:setIsUnloadingBale(false);
						end
					elseif roundBaler.balerUnloadingState == Baler.UNLOADING_CLOSED then
						if self.hasBaleUnloaded then
							controlledTractor.setCruiseControlState(self, 1);
							self.hasBaleUnloaded = false;
						end;
						
						if not self.hasSetSpeed[3] then
							controlledTractor:setCruiseControlMaxSpeed(self.cruiseControl.maxSpeed);
							self.hasSetSpeed[3] = true;
						end;
					else
						if not self.hasSetSpeed[3] then
							controlledTractor:setCruiseControlMaxSpeed(self.cruiseControl.maxSpeed);
							self.hasSetSpeed[3] = true;
						end;
					end;
				else
					if not self.hasSetSpeed[3] then
						controlledTractor:setCruiseControlMaxSpeed(self.cruiseControl.maxSpeed);
						self.hasSetSpeed[3] = true;
					end;
				end;
			end;
		end;
	end;
end;

function GPS_Extension:draw()end;
function GPS_Extension:delete()end;
function GPS_Extension:mouseEvent(posX, posY, isDown, isUp, button)end;
function GPS_Extension:keyEvent(unicode, sym, modifier, isDown)end;