--
-- FrontPTO
-- Specialization for PTO attach to tractor when a implement is attached with PTO
--
-- @author  	Stefan Maurus
-- @version 	v1.0
-- @date  		14.06.2014
--
-- Based on attachablePTO Script from JoXXer (http://www.bjr-modding.com/)
--


FrontPTO = {};

function FrontPTO.prerequisitesPresent(specializations)
    return true;
end;

function FrontPTO:load(xmlFile)
	self.toggleFrontPTOAttach = SpecializationUtil.callSpecializationsFunction("toggleFrontPTOAttach");
	
	self.frontPTO = {};
	
    self.frontPTO.visIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontPTO#visIndex"));
	setVisibility(self.frontPTO.visIndex,false);
	
    self.frontPTO.tractorFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontPTO#tractorFixPoint"));
	self.frontPTO.tractorFixPointTrans = {getTranslation(self.frontPTO.tractorFixPoint)};
	self.frontPTO.tractorFixPointRot = {getRotation(self.frontPTO.tractorFixPoint)};
	
    self.frontPTO.shaft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontPTO#shaftIndex"));
    self.frontPTO.shaftRot = {getRotation(self.frontPTO.shaft)};
	
    self.frontPTO.referenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontPTO#referenceNode"));
    self.frontPTO.movingPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontPTO#movingPart"));
	self.frontPTO.movingPartTrans = {getTranslation(self.frontPTO.movingPart)};
	
    self.frontPTO.distanceModifier = getXMLFloat(xmlFile, "vehicle.frontPTO#distanceModifier");
	
	self.frontPTO.tractorPTONode = nil;
	self.frontPTO.jointDescIndex = nil;
	self.frontPTO.attached = false;
end;

function FrontPTO:delete()
end;

function FrontPTO:readStream(streamId, connection)
end;

function FrontPTO:writeStream(streamId, connection)
end;

function FrontPTO:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FrontPTO:keyEvent(unicode, sym, modifier, isDown)
end;

function FrontPTO:update(dt)
	if self.frontPTO.tractorPTONode then
		if self.frontPTO.attached then
			local ptoAttX, ptoAttY, ptoAttZ = getWorldTranslation(self.frontPTO.tractorPTONode);
			setTranslation(self.frontPTO.tractorFixPoint, 0, 0, 0);
			local localXTrans, localYTrans, localZTrans = worldToLocal(self.frontPTO.tractorFixPoint, ptoAttX, ptoAttY, ptoAttZ);
			setTranslation(self.frontPTO.tractorFixPoint, localXTrans, localYTrans, localZTrans+self.frontPTO.distanceModifier);
			
			setDirection(self.frontPTO.shaft, localXTrans, localYTrans, localZTrans, 0, 1, 0);
			local _,_,dist = worldToLocal(self.frontPTO.referenceNode, ptoAttX, ptoAttY, ptoAttZ);
			local movPartX, movePartY, movPartZ = unpack(self.frontPTO.movingPartTrans);
			setTranslation(self.frontPTO.movingPart, movPartX, movePartY, movPartZ+dist+self.frontPTO.distanceModifier);
		end;
	end;
end;

function FrontPTO:updateTick(dt)
	for _, implement in pairs(self.attachedImplements) do
        if implement.object ~= nil then
            if implement.object.ptoInput ~= nil then
				self:toggleFrontPTOAttach(true);
			else
				self:toggleFrontPTOAttach(false);
			end;
		else
			self:toggleFrontPTOAttach(false);
		end;
	end;	
end;

function FrontPTO:draw()
end;

function FrontPTO:onAttach(attacherVehicle, jointDescIndex)
	local attachedJoint = attacherVehicle.attacherJoints[jointDescIndex];
	if attachedJoint.ptoOutput ~= nil then
		if attachedJoint.ptoOutput.node ~= nil then
			self.frontPTO.tractorPTONode = attachedJoint.ptoOutput.node;
			self.frontPTO.jointDescIndex = jointDescIndex;
		end;
	end;
end;

function FrontPTO:detachImplement(implement, implementIndex)
	self:toggleFrontPTOAttach(false);
end;

function FrontPTO:onDetach()
	self:toggleFrontPTOAttach(false);
	self.frontPTO.tractorPTONode = nil;
	self.frontPTO.jointDescIndex = nil;
end;

function FrontPTO:onSetLowered(moveDown)
end;

function FrontPTO:toggleFrontPTOAttach(attached)
	self.frontPTO.attached = attached;
	if self.frontPTO.tractorPTONode then
		if self.frontPTO.attached then
			setRotation(self.frontPTO.tractorFixPoint, 0, 0, 0);
			setVisibility(self.frontPTO.visIndex, true);			
		else
			setVisibility(self.frontPTO.visIndex, false);
			setTranslation(self.frontPTO.tractorFixPoint, unpack(self.frontPTO.tractorFixPointTrans));
			setRotation(self.frontPTO.tractorFixPoint, unpack(self.frontPTO.tractorFixPointRot));
			setTranslation(self.frontPTO.movingPart, unpack(self.frontPTO.movingPartTrans));
			setRotation(self.frontPTO.shaft, unpack(self.frontPTO.shaftRot));
		end;
	end;
end;