--[[
Spezialisierung die den Cam Zoom aller Fahrzeuge erweitert. In der modDesc der 'zzz_CameraZoomExtension.zip' konfigurierbar. 

<vehicleCam transMax="NEUER_WERT_DEN_DU_WILLST" />

Author:	Ifko[nator]
Datum:	17.07.2015

Version:	v1.0
History:	v1.0 - initial implementation -- GLOBAL VERSION!
]]

CameraZoomExtension = {};

local CameraZoomExtension_Directory = g_currentModDirectory;

function CameraZoomExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function CameraZoomExtension:load(xmlFile)
	local modDesc = loadXMLFile("modDesc", CameraZoomExtension_Directory .. "modDesc.xml");
	
	self.camZoomMax = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.vehicleCam#transMax"), 40);
	
	self.camZoomMax = math.floor(self.camZoomMax);
	
	--[[--## First try .. Only Camera 1 was supportet... Bad if Camera 1 is NOT the Outdoor cam ..
	
	if self.cameras[self.camIndex].transMax ~= nil then
		if self.cameras[self.camIndex].transMax > 0 then
			--print("Found 'transMax'! Value = '" .. self.cameras[self.camIndex].transMax .."' in cam: '" .. self.camIndex .. "'.");
			
			if self.cameras[self.camIndex].transMax < self.camZoomMax then
				self.cameras[self.camIndex].transMax = self.camZoomMax;
				--print("Set 'transMax' for cam '" .. self.camIndex .. "' to: '" .. self.cameras[self.camIndex].transMax .. "'.");
			end;
		end;
	end;]]
	
	--## The Following Code checks ALL Cams in the xml File and changed it, if 'transMax' is smaller as the new Value and bigger than 0 ..
	
	local camCount = getXMLFloat(xmlFile, "vehicle.cameras#count");
	
	if camCount ~= nil then
		for cam = 1, camCount do
			if self.cameras[cam].transMax ~= nil then
				if self.cameras[cam].transMax > 0  then
					--print("Found 'transMax'! Value = '" .. self.cameras[cam].transMax .."' in cam: '" .. cam .. "'.");
			
					if self.cameras[cam].transMax < self.camZoomMax then
						self.cameras[cam].transMax = self.camZoomMax;
						--print("Set 'transMax' for cam '" .. cam .. "' to: '" .. self.cameras[cam].transMax .. "'.");
					end;
				end;
			end;
		end;
	else
		print("[WARNING from the CameraZoomExtension.lua]: Missing the TAG 'vehicle.cameras#count' in the XML File: '" .. self.configFileName .. "'!");
		print("[WARNING from the CameraZoomExtension.lua]: This should not happen, but this Script is stopped for this Vehicle!");
	end;
	
	delete(modDesc);
end;

function CameraZoomExtension:delete()
end;

function CameraZoomExtension:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CameraZoomExtension:keyEvent(unicode, sym, modifier, isDown)
end;

function CameraZoomExtension:update(dt)
end;


function CameraZoomExtension:draw()
end;