--[[
	Author: 	Ifko[nator]
	Date:		24.04.2015
	Version:	1.5
	
	History: 	V 1.0 @ 24.04.2015 - intial implementation
				V 1.5 @ 25.04.2015 - Double Path fix for mod's and DLC's. 
]]

local newBeaconLightDirectory = g_currentModDirectory
local newBeaconLightFilename = Utils.getFilename("beaconlight/beaconlight.i3d", newBeaconLightDirectory)

local fixLoadSharedI3DFile = Utils.loadSharedI3DFile
function Utils.loadSharedI3DFile(filename, baseDir, ...)
	local pos = string.find(filename, ":/", 1)
	if pos ~= nil then	
		baseDir = ""
	end
	
	pos = string.find(filename, ":/", 3)
	
	if pos ~= nil then		
		filename = string.sub(filename, pos - 1)
	end
	
	pos = string.find(filename, "mods//newBeaconlightsForAllVehicles/beaconlight/")
	if pos ~= nil then
		if not fileExists(Utils.getNoNil(baseDir, "") .. filename) then
			baseDir = ""
			filename = newBeaconLightDirectory .. string.sub(filename, pos + 42)
		end
	end
	
	local fixedFilename = fixLoadSharedI3DFile(filename, baseDir, ...)

	return fixedFilename
end

local oldloadSharedI3DFile = Utils.loadSharedI3DFile
Utils.loadSharedI3DFile = function (filename, baseDir, ...)
	local originalBeaconLights = {
		"$data/vehicles/shared/beaconLight01.i3d",
		"$data/vehicles/shared/beaconLight02.i3d",
		"$data/vehicles/shared/beaconLight03.i3d",
		"$data/vehicles/shared/beaconLight04.i3d", 
		"$data/vehicles/shared/beaconLight05.i3d", 
		"$data/vehicles/shared/beaconLight06.i3d"
	}
	
	for _, originalBeaconLight in pairs(originalBeaconLights) do
		if filename == originalBeaconLight then
			filename = newBeaconLightFilename
		end
	end
	local beaconLightFilename = oldloadSharedI3DFile(filename, baseDir, ...)

	
	return beaconLightFilename
end

return