--[[
	Author: 	Ifko[nator]
	Date:		24.04.2015
	Version:	1.0 - intial implementation
]]

local newBeaconLightDirectory = g_currentModDirectory
local newBeaconLightFilename = Utils.getFilename("beaconlight/beaconlight.i3d", newBeaconLightDirectory)

local oldloadSharedI3DFile = Utils.loadSharedI3DFile;
Utils.loadSharedI3DFile = function (filename, baseDir, ...)
	local originalBeaconLights = {
		"$data/vehicles/shared/beaconLight01.i3d",
		"$data/vehicles/shared/beaconLight02.i3d",
		"$data/vehicles/shared/beaconLight03.i3d",
		"$data/vehicles/shared/beaconLight04.i3d", 
		"$data/vehicles/shared/beaconLight05.i3d", 
		"$data/vehicles/shared/beaconLight06.i3d"
	}
	
	for _, originalBeaconLight in pairs(originalBeaconLights) do
		if filename == originalBeaconLight then
			filename = newBeaconLightFilename
		end
	end
	local beaconLightFilename = oldloadSharedI3DFile(filename, baseDir, ...)
	
	return beaconLightFilename
end;

return