-- GMK Mod
-- Author:	Ifko[nator]
-- Datum:	08.02.2015
-- Manure and Liquidmanure Mod by TMT
-- Fertilizer Mod added by Ifko[nator]

GMK_Mod = {};

function GMK_Mod:SprayerLoad(xmlFile)
	if self.FeldBegrenzung == nil then
		if Fillable.FILLTYPE_KALK then                                                                                                                 
			if hasXMLProperty(xmlFile, "vehicle.typeDesc") then
				local typeDesc = getXMLString(xmlFile, "vehicle.typeDesc");                                                                            
				if typeDesc == nil then
					typeDesc = getXMLString(xmlFile, "vehicle.typeDesc.en");
				end
				if typeDesc ~= nil and string.find(typeDesc, "FertilizerSpreader") then
					self.fillTypes[Fillable.FILLTYPE_KALK] = true;                                                                                     
				end;
			end;
		end;
	end;
end;                                                                                                                                               
Sprayer.load = Utils.appendedFunction(Sprayer.load, GMK_Mod.SprayerLoad);

FruitUtil.registerFruitType("manureSolid", false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitType("manureLiquid", false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitType("fertilizerSolid", false, false, true, 1, 100, 2, 1, 1, nil);

FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_MANURESOLID, "manureSolid_windrow", g_i18n:getText("manure"), 0, 3, false, nil);
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_MANURELIQUID, "manureLiquid_windrow", g_i18n:getText("liquidManure"), 0, 3, false, nil);
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_FERTILIZERSOLID, "fertilizerSolid_windrow", g_i18n:getText("fertilizer"), 0, 3, false, nil);

local orgi_sprayerUpdateTick = Sprayer.updateTick
Sprayer.updateTick = function(self, dt)
	orgi_sprayerUpdateTick(self, dt)
	if self.isTurnedOn and self.fillLevel > 0 then                                                                                                 
		local windrowId = nil;                                                                                                                     

		if self.currentFillType == Fillable.FILLTYPE_MANURE then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId;
			end;
		elseif self.currentFillType == Fillable.FILLTYPE_LIQUIDMANURE then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId;
			end;
		elseif self.currentFillType == Fillable.FILLTYPE_FERTILIZER then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId;
			end;
		end;
		
		if windrowId ~= nil then
			for _, workArea in pairs(self.workAreas) do
				if self:getIsAreaActive(workArea) then
					local x, y, z = getWorldTranslation(workArea.start);
					local x1, y1, z1 = getWorldTranslation(workArea.width);
					local x2, y2, z2 = getWorldTranslation(workArea.height);
					if self.FeldBegrenzung ~= nil then
						Utils.updateManureWindrowArea(windrowId, x, z, x1, z1, x2, z2, not self.FeldBegrenzung);
					else
						Utils.updateManureWindrowArea(windrowId, x, z, x1, z1, x2, z2, false);
					end;
				end;
			end;
		end;
	end;
end;

Utils.updateManureWindrowArea = function(windrowId, x, z, x1, z1, x2, z2, force)
	local IDs,detailId = {}, g_currentMission.terrainDetailId;
	local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2);

	if force then
		setDensityParallelogram(windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, g_currentMission.numWindrowChannels, g_currentMission.maxWindrowValue);
	else
		table.insert(IDs,g_currentMission.cultivatorChannel);
		table.insert(IDs,g_currentMission.sowingChannel);
		table.insert(IDs,g_currentMission.ploughChannel);
		table.insert(IDs,g_currentMission.terrainDetailTypeFirstChannel);
		
		for i = 1, #(IDs) do
			setDensityMaskedParallelogram(windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, IDs[i], g_currentMission.terrainDetailTypeNumChannels, 1);
		end;
	end;
end;                                                                                                                                                                                     

Utils.DestroyManureWindrowArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)                                                                
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;                                                                                                                                                          
end;                                                                                                                                                                                     

local orgi_UpdateDestroyCommonArea = Utils.updateDestroyCommonArea;                                                                                                                      
Utils.updateDestroyCommonArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField)
	orgi_UpdateDestroyCommonArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField);
	
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
end;                                                                                                                                                                                     

local orgi_cutFruitArea = Utils.cutFruitArea;                                                                                                                                            
Utils.cutFruitArea =  function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth)
	local pixelsSum, numPixels, spraySum = orgi_cutFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth);
	if destroySpray then
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
	end;
	return pixelsSum, numPixels, spraySum;
end;                                                                                                                                                                                     

local orgi_updateSowingArea = Utils.updateSowingArea;
Utils.updateSowingArea = function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting)
	local numPixels, numDetailPixels = orgi_updateSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting);

	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	return numPixels, numDetailPixels;
end;                                                                                                                                                                                     