-- Regestrierung von neuen Frchten im LS 15
-- Vorlage: ffentliche Script Doku http://www.ls-mods.de/scriptDocumentation.php by GIANTS Software GmbH

-- Author:	Ifko[nator]
-- Datum:	20.12.2014


-- Gehckselter Weizen/Gersten
FruitUtil.registerFruitType("choppedStraw", g_i18n:getText("choppedStraw"), false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitTypePreparing(FruitUtil.FRUITTYPE_CHOPPEDSTRAW,"choppedStraw_haulm", 8, 8, 9);

-- Gehckselter Mais
FruitUtil.registerFruitType("choppedMaize", g_i18n:getText("choppedMaize"), false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitTypePreparing(FruitUtil.FRUITTYPE_CHOPPEDMAIZE,"choppedMaize_haulm", 8, 8, 9);

--[[ NOT READY NOW
FruitUtil.registerFruitType("choppedMaize_Front", g_i18n:getText("choppedMaize"), false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitTypePreparing(FruitUtil.FRUITTYPE_CHOPPEDMAIZE_FRONT,"choppedMaizeFront_haulm", 8, 8, 9);
FruitUtil.registerFruitType("choppedMaize_Back", g_i18n:getText("choppedMaize"), false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitTypePreparing(FruitUtil.FRUITTYPE_CHOPPEDMAIZE_BACK,"choppedMaizeBack_haulm", 8, 8, 9);
]]

-- Gehckselter Raps
FruitUtil.registerFruitType("choppedRape", g_i18n:getText("choppedRape"), false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitTypePreparing(FruitUtil.FRUITTYPE_CHOPPEDRAPE,"choppedRape_haulm", 8, 8, 9);

-- Manure, Liquidmanure Mod by TMT
-- Fertilizer and Kalk Mod added by Ifko[nator]

Fruchtregestrierung = {};
Fruchtregestrierung.dir = g_currentModDirectory;
Fruchtregestrierung.fillType = {};
 
local HudDir = "Maps/huds/";

table.insert(Fruchtregestrierung.fillType, {name = "kalk", price = 0.1, Eco = true, hud = HudDir .. "kalkhud"});

local org_FSBaseMission_loadMap = FSBaseMission.loadMap
FSBaseMission.loadMap = function(a, b, c, d, e)
	if a.baseDirectory == Fruchtregestrierung.dir then
		Fruchtregestrierung.MapName = a.missionInfo.map.title;
		local fill = {};
		for i = 1, table.getn(Fruchtregestrierung.fillType) do
			local fillType = Fruchtregestrierung.fillType[i];
			local HudFile = Fruchtregestrierung.dir .. fillType.hud .. ".dds";
			local I18N = fillType.I18N;
			if I18N == nil then
				if g_i18n:hasText(fillType.name) then
					I18N = g_i18n:getText(fillType.name);
				else
					I18N = fillType.name;
				end;
			end;
			local FillType = Fillable.registerFillType(fillType.name, I18N, fillType.price, fillType.Eco, HudFile);
			if Fillable.fillTypeIndexToDesc[FillType] and Fillable.fillTypeIndexToDesc[FillType].nameI18N then
				FSBaseMission.addFillTypeOverlay(a, FillType, HudFile)
				table.insert(fill, Fillable.fillTypeIndexToDesc[FillType].nameI18N);
			else
				table.insert(fill, fillType.name .. " not nameI18N");
			end;
		end;
	end;
	ra, rb, rc, rd, re = org_FSBaseMission_loadMap(a, b, c, d, e);
	return ra, rb, rc, rd, re;
end;

function Fruchtregestrierung:SprayerLoad(xmlFile)
	if self.FeldBegrenzung == nil then
		if Fillable.FILLTYPE_KALK then
			if hasXMLProperty(xmlFile, "vehicle.typeDesc") then
				local typeDesc = getXMLString(xmlFile, "vehicle.typeDesc");
				if typeDesc == nil then
					typeDesc = getXMLString(xmlFile, "vehicle.typeDesc.en");
				end
				if typeDesc ~= nil and string.find(typeDesc, "FertilizerSpreader") then
					self.fillTypes[Fillable.FILLTYPE_KALK] = true;
				end;
			end;
		end;
	end;
	self.areaLimitation = true;
end;
Sprayer.load = Utils.appendedFunction(Sprayer.load, Fruchtregestrierung.SprayerLoad); 

function Fruchtregestrierung:SprayerUpdate(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.areaLimitation) then
			self.areaLimitation = not self.areaLimitation;
			self:raiseDirtyFlags(self.sprayerDirtyFlag);
		end;
	end;
end;
Sprayer.update = Utils.appendedFunction(Sprayer.update, Fruchtregestrierung.SprayerUpdate);

function Fruchtregestrierung:SprayerDraw()
	if self.FeldBegrenzung == nil then
		if self.areaLimitation then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), g_i18n:getText("areaLimitation")), InputBinding.areaLimitation);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), g_i18n:getText("areaLimitation")), InputBinding.areaLimitation);
		end;
	end;
end;
Sprayer.draw = Utils.appendedFunction(Sprayer.draw, Fruchtregestrierung.SprayerDraw);

function Fruchtregestrierung:SprayerReadStream(streamId, connection)
	self.areaLimitation = streamReadBool(streamId);
end
Sprayer.readStream = Utils.appendedFunction(Sprayer.readStream, Fruchtregestrierung.SprayerReadStream);

function Fruchtregestrierung:SprayerWriteStream(streamId, connection)
	streamWriteBool(streamId, self.areaLimitation);
end
Sprayer.writeStream = Utils.appendedFunction(Sprayer.writeStream, Fruchtregestrierung.SprayerWriteStream);

function Fruchtregestrierung:SprayerReadUpdateStream(streamId, timestamp, connection)
	self.areaLimitation = streamReadBool(streamId);
end
Sprayer.readUpdateStream = Utils.appendedFunction(Sprayer.readUpdateStream, Fruchtregestrierung.SprayerReadUpdateStream);

function Fruchtregestrierung:SprayerWriteUpdateStream(streamId, connection, dirtyMask)
	streamWriteBool(streamId, self.areaLimitation);
end
Sprayer.writeUpdateStream = Utils.appendedFunction(Sprayer.writeUpdateStream, Fruchtregestrierung.SprayerWriteUpdateStream);

FruitUtil.registerFruitType("manureSolid", false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitType("manureLiquid", false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitType("fertilizerSolid", false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitType("kalkSolid", false, false, true, 1, 100, 2, 1, 1, nil);

FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_MANURESOLID, "manureSolid_windrow", g_i18n:getText("manure"), 0, 3, false, nil);
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_MANURELIQUID, "manureLiquid_windrow", g_i18n:getText("liquidManure"), 0, 3, false, nil);
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_FERTILIZERSOLID, "fertilizerSolid_windrow", g_i18n:getText("fertilizer"), 0, 3, false, nil);
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_KALKSOLID, "kalkSolid_windrow", g_i18n:getText("kalkSolid"), 0, 3, false, nil);

Sprayer.registerSprayType("kalk", g_i18n:getText("kalkSolid"), 0.3, 10, true, nil);

local orgi_sprayerUpdateTick = Sprayer.updateTick
Sprayer.updateTick = function(self, dt)
	orgi_sprayerUpdateTick(self, dt)
	if self.isTurnedOn and self.fillLevel > 0 then
		local windrowId = nil;
		
		if self.currentFillType == Fillable.FILLTYPE_MANURE then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId;
			end;
		elseif self.currentFillType == Fillable.FILLTYPE_LIQUIDMANURE then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId;
			end;
		elseif self.currentFillType == Fillable.FILLTYPE_KALK then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID].windrowId;
			end;
		elseif self.currentFillType == Fillable.FILLTYPE_FERTILIZER then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId;
			end;
		end;

		if windrowId ~= nil then
			for _, workArea in pairs(self.workAreas) do
				if self:getIsAreaActive(workArea) then
					local x, y, z = getWorldTranslation(workArea.start);
					local x1, y1, z1 = getWorldTranslation(workArea.width);
					local x2, y2, z2 = getWorldTranslation(workArea.height);
					Utils.updateManureWindrowArea(windrowId, x, z, x1, z1, x2, z2, not self.areaLimitation);
				end;
			end;
		end;
	end;
end;

Utils.updateManureWindrowArea = function(windrowId, x, z, x1, z1, x2, z2, force)
	local IDs,detailId = {}, g_currentMission.terrainDetailId;
	local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2);

	if force then
		setDensityParallelogram(windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, g_currentMission.numWindrowChannels, g_currentMission.maxWindrowValue);
	else
		table.insert(IDs, g_currentMission.cultivatorChannel);
		table.insert(IDs, g_currentMission.sowingChannel);
		table.insert(IDs, g_currentMission.ploughChannel);
		table.insert(IDs, g_currentMission.terrainDetailTypeFirstChannel);
		
		for i = 1, table.getn(IDs) do
			setDensityMaskedParallelogram(windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, IDs[i], g_currentMission.terrainDetailTypeNumChannels, 1);
		end;
	end;
end;

Utils.DestroyManureWindrowArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
end;

local orgi_UpdateDestroyCommonArea = Utils.updateDestroyCommonArea;
Utils.updateDestroyCommonArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField)
	orgi_UpdateDestroyCommonArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField);

	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
end;

local orgi_cutFruitArea = Utils.cutFruitArea;
Utils.cutFruitArea =  function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth)
	local pixelsSum, numPixels, spraySum = orgi_cutFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth);
	if destroySpray then
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
	end;
	return pixelsSum, numPixels, spraySum;
end;

local orgi_updateSowingArea = Utils.updateSowingArea;
Utils.updateSowingArea = function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting)
	local numPixels, numDetailPixels = orgi_updateSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting);

	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_KALKSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	return numPixels, numDetailPixels;
end;