--[[
	BaleToSilage

	Autor: 	Ifko[nator]
	Date: 	19.12.2014
]]

BaleToSilage = {}
BaleToSilage.dir = g_currentModDirectory

local BaleToSilage_mt = Class(BaleToSilage, Object);

local Ifkonator_FSBaseMission_loadMap = FSBaseMission.loadMap
FSBaseMission.loadMap = function(a, b, c, d, e)
	if a.baseDirectory == BaleToSilage.dir then
		print("[INFO der BaleToSilage.lua]: Silageballen koennen nun auf der '"..a.missionInfo.map.title.."' im Futterlager eingelagert werden. [Beim Silagehaufen]");	
	end;
	ra,rb,rc,rd,re = Ifkonator_FSBaseMission_loadMap(a, b, c, d, e)
	return ra,rb,rc,rd,re 
end;

function baleToSilageOnCreate(id)
	local trigger = BaleToSilage:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
end;

g_onCreateUtil.addOnCreateFunction("baleToSilageOnCreate", baleToSilageOnCreate);

function BaleToSilage:new(isServer, isClient)
	local self = Object:new(isServer, isClient, BaleToSilage_mt);
	self.className = "BaleToSilage";
	return self;
end;

function BaleToSilage:delete()
	removeTrigger(self.triggerId);
end;

function BaleToSilage:load(id)
	self.triggerId = id;
	addTrigger(self.triggerId, "triggerCallback", self);
end;

function BaleToSilage:update(dt)
end;

function BaleToSilage:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_server ~= nil then
		local object = g_currentMission:getNodeObject(otherId);
		if object ~= nil and object:isa(Bale) and object.fillType == Fillable.FILLTYPE_SILAGE then
			if not (object.isAttached ~= nil and object.isAttached) then
				object:delete();
				g_currentMission:setSiloAmount(Fillable.FILLTYPE_SILAGE, g_currentMission:getSiloAmount(Fillable.FILLTYPE_SILAGE) + object.fillLevel);
			end;
		end;
	end;
end;