--[[
	BaleToManure 

	Autor: 	Ifko[nator]
	Date: 	19.12.2014
]]

BaleToManure = {}
BaleToManure.dir = g_currentModDirectory

local BaleToManure_mt = Class(BaleToManure, Object);

local Ifkonator_FSBaseMission_loadMap = FSBaseMission.loadMap
FSBaseMission.loadMap = function(a, b, c, d, e)
	if a.baseDirectory == BaleToManure.dir then
		print("[INFO der BaleToManure.lua]: Strohballen koennen nun auf der '"..a.missionInfo.map.title.."' im Mistzwischenlager eingelagert werden.");	
	end;
	ra,rb,rc,rd,re = Ifkonator_FSBaseMission_loadMap(a, b, c, d, e)
	return ra,rb,rc,rd,re 
end;

function baleToManureOnCreate(id)
	local trigger = BaleToManure:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
end;

g_onCreateUtil.addOnCreateFunction("baleToManureOnCreate", baleToManureOnCreate);

function BaleToManure:new(isServer, isClient)
	local self = Object:new(isServer, isClient, BaleToManure_mt);
	self.className = "BaleToManure";
	return self;
end;

function BaleToManure:delete()
	removeTrigger(self.triggerId);
end;

function BaleToManure:load(id)
	self.triggerId = id;
	addTrigger(self.triggerId, "triggerCallback", self);
end;

function BaleToManure:update(dt)
end;

function BaleToManure:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_server ~= nil then
		local object = g_currentMission:getNodeObject(otherId);
		if object ~= nil and object:isa(Bale) and object.fillType == Fillable.FILLTYPE_BARLEY_WINDROW or object.fillType == Fillable.FILLTYPE_WHEAT_WINDROW then
			if not (object.isAttached ~= nil and object.isAttached) then
				object:delete();
				g_currentMission:setSiloAmount(Fillable.FILLTYPE_MANURE, g_currentMission:getSiloAmount(Fillable.FILLTYPE_MANURE) + object.fillLevel);
			end;
		end;
	end;
end;