--[[
	AutomaticUnloadForBaleWrappersRegister.lua
	
	Autor: Ifko[nator]
	Datum: 21.02.2015
]]

SpecializationUtil.registerSpecialization("AutomaticUnloadForBaleWrappers", "AutomaticUnloadForBaleWrappers", g_currentModDirectory.."AutomaticUnloadForBaleWrappers.lua")

AutomaticUnloadForBaleWrappersRegister = {};

function AutomaticUnloadForBaleWrappersRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("baleWrapper") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.AutomaticUnloadForBaleWrappers", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.automaticUnloadForBaleWrappers", _name)) ~= nil
							then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("AutomaticUnloadForBaleWrappers"));
						end;
						BaleWrapper.STOP_AUTOMATIC_UNLOAD = g_i18n:getText("STOP_AUTOMATIC_UNLOAD");
						BaleWrapper.START_AUTOMATIC_UNLOAD = g_i18n:getText("START_AUTOMATIC_UNLOAD");
					end;
				end;
			end;	
		end;
	end;
end;

function AutomaticUnloadForBaleWrappersRegister:deleteMap()end;
function AutomaticUnloadForBaleWrappersRegister:keyEvent(unicode, sym, modifier, isDown)end;
function AutomaticUnloadForBaleWrappersRegister:mouseEvent(posX, posY, isDown, isUp, button)end;
function AutomaticUnloadForBaleWrappersRegister:update(dt)end;
function AutomaticUnloadForBaleWrappersRegister:draw()end;

addModEventListener(AutomaticUnloadForBaleWrappersRegister);