--[[ add Fill Types

	Author: 	Ifko[nator]
	Datum: 		31.12.2014
	Version: 	1.5

	History: 	V 1.0 @ 20.12.2014 - intial release
				V 1.5 @ 31.12.2014 - added: manure, straw and grass

	Dieses Script fügt allen Anhängern und Schaufeln, die Häckselgut (chaff) laden können Mischfutter (forage), Silage (silage) und Hackschnitzel (woodChips) hinzu. Sollte schon einer der drei Fruchtarten verbaut sein, wird er selbstverständlich nicht mehr neu hinzugefügt.
	Auch die Particlesysteme werden angepasst. Sollte der Anhänger oder die Schaufel ein Particlesystem für Silage eingetragen haben, wird dieses auch für das Mischfutter verwendet. Sollte das nicht der Fall sein, wird für beide das Häckselgut Particlesystem verwendet. Sofern dies verfügbar ist, versteht sich.. :D Sollte der Anhänger oder die Schaufel noch kein Particlesystem für Hackschnitzel haben, so wird das Häckselgut Particlesystem verwendet.

	Neu ab V 1.5:
	- Alle Anhänger/Schaufeln, die Häckselgut laden können, können nun auch Gras laden, (grass_windrow, dryGrass_windrow). Es wird das ParticleSystem vom Häckselgut verwendet, wenn kein ParticleSystem für Gras eingetragen ist, sofern das ParticleSystem vom Häckselgut vorhanden ist.
	- Alle Anhänger/Schaufeln, die Hackschnitzel laden können, können nun auch Stroh laden, (wheat_windrow, barley_windrow). Es wird das ParticleSystem von den Hackschnitzel verwendet, wenn kein ParticleSystem für Stroh eingetragen ist, sofern das ParticleSystem vom Hackschnitzel vorhanden ist.
	- Alle Anhänger/Schaufeln, die Silage laden können, ausnahme Ladewagen/Häckseltransportwagen, können nun auch Mist laden. Es wird das ParticleSystem von der Silage verwendet, wenn kein ParticleSystem für Mist eingetragen ist, sofern das ParticleSystem von Silage vorhanden ist.
	
	Fixes ab v 1.5:
	- Die Probleme beim Speichern oder Beenden, die einige bei der V1 hatten, sollten nun Geschichte sein. Sollte das nicht der Fall sein, bin ich echt ratlos.

]]

print("### addFillTypes Script by Ifko[nator] in der Version 1.5 erfolgreich geladen!");

local oldFillableLoad = Fillable.load;
Fillable.load = function(self, xmlFile)
	oldFillableLoad(self, xmlFile);

	if self.fillTypes[Fillable.FILLTYPE_CHAFF] then
		if self.fillTypes[Fillable.FILLTYPE_FORAGE] == nil then
			self.fillTypes[Fillable.FILLTYPE_FORAGE] = true;
		end;

		if self.fillTypes[Fillable.FILLTYPE_SILAGE] == nil then
			self.fillTypes[Fillable.FILLTYPE_SILAGE] = true;
		end;

		if self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] == nil then
			self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] = true;
		end;

		if self.fillTypes[Fillable.FILLTYPE_DRYGRASS_WINDROW] == nil then
			self.fillTypes[Fillable.FILLTYPE_DRYGRASS_WINDROW] = true;
		end;

		if self.fillTypes[Fillable.FILLTYPE_GRASS_WINDROW] == nil then
			self.fillTypes[Fillable.FILLTYPE_GRASS_WINDROW] = true;
		end;
	end;

	if self.fillTypes[Fillable.FILLTYPE_SILAGE] then
		if self.fillTypes[Fillable.FILLTYPE_MANURE] == nil and self.fillTypes[Fillable.FILLTYPE_WHEAT] ~= nil then
			self.fillTypes[Fillable.FILLTYPE_MANURE] = true
		end;
	end;

	if self.fillTypes[Fillable.FILLTYPE_WOODCHIPS] then
		if self.fillTypes[Fillable.FILLTYPE_WHEAT_WINDROW] == nil then
			self.fillTypes[Fillable.FILLTYPE_WHEAT_WINDROW] = true;
		end;

		if self.fillTypes[Fillable.FILLTYPE_BARLEY_WINDROW] == nil then
			self.fillTypes[Fillable.FILLTYPE_BARLEY_WINDROW] = true;
		end;
	end;
end; 

local oldTrailerLoad = Trailer.load;
Trailer.load = function(self, xmlFile)
	oldTrailerLoad(self, xmlFile);

	if self.tipAnimations ~= nil then
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local forage = Fillable.fillTypeNameToInt["forage"];
		local silage = Fillable.fillTypeNameToInt["silage"];
		local woodChips = Fillable.fillTypeNameToInt["woodChips"];
		local manure = Fillable.fillTypeNameToInt["manure"];
		local dryGrass_windrow = Fillable.fillTypeNameToInt["dryGrass_windrow"];
		local grass_windrow = Fillable.fillTypeNameToInt["grass_windrow"];
		local wheat_windrow = Fillable.fillTypeNameToInt["wheat_windrow"];
		local barley_windrow = Fillable.fillTypeNameToInt["barley_windrow"];

		for a = 1, #(self.tipAnimations) do
			if self.tipAnimations[a].dischargeParticleSystems[chaff] ~= nil then
				if self.tipAnimations[a].dischargeParticleSystems[silage] == nil then 
					self.tipAnimations[a].dischargeParticleSystems[silage] = self.tipAnimations[a].dischargeParticleSystems[chaff];
					if self.tipAnimations[a].dischargeParticleSystems[forage] == nil then 
						self.tipAnimations[a].dischargeParticleSystems[forage] = self.tipAnimations[a].dischargeParticleSystems[chaff];
					end;
				else
					if self.tipAnimations[a].dischargeParticleSystems[forage] == nil then 
						self.tipAnimations[a].dischargeParticleSystems[forage] = self.tipAnimations[a].dischargeParticleSystems[silage];
					end;
					if self.tipAnimations[a].dischargeParticleSystems[manure] == nil then 
						self.tipAnimations[a].dischargeParticleSystems[manure] = self.tipAnimations[a].dischargeParticleSystems[silage];
					end;
				end;

				if self.tipAnimations[a].dischargeParticleSystems[woodChips] == nil then 
					self.tipAnimations[a].dischargeParticleSystems[woodChips] = self.tipAnimations[a].dischargeParticleSystems[chaff];
				end;

				if self.tipAnimations[a].dischargeParticleSystems[dryGrass_windrow] == nil then 
					self.tipAnimations[a].dischargeParticleSystems[dryGrass_windrow] = self.tipAnimations[a].dischargeParticleSystems[chaff];
				end;

				if self.tipAnimations[a].dischargeParticleSystems[grass_windrow] == nil then 
					self.tipAnimations[a].dischargeParticleSystems[grass_windrow] = self.tipAnimations[a].dischargeParticleSystems[chaff];
				end;
			end;

			if self.tipAnimations[a].dischargeParticleSystems[woodChips] ~= nil then
				if self.tipAnimations[a].dischargeParticleSystems[wheat_windrow] == nil then 
					self.tipAnimations[a].dischargeParticleSystems[wheat_windrow] = self.tipAnimations[a].dischargeParticleSystems[woodChips];
				end;

				if self.tipAnimations[a].dischargeParticleSystems[barley_windrow] == nil then 
					self.tipAnimations[a].dischargeParticleSystems[barley_windrow] = self.tipAnimations[a].dischargeParticleSystems[woodChips];
				end;
			end;
		end;
	end;
end;

local oldTrailerDelete = Trailer.delete;
Trailer.delete = function(self)
	if self.tipAnimations ~= nil then
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local forage = Fillable.fillTypeNameToInt["forage"];
		local silage = Fillable.fillTypeNameToInt["silage"];
		local woodChips = Fillable.fillTypeNameToInt["woodChips"];
		local manure = Fillable.fillTypeNameToInt["manure"];
		local dryGrass_windrow = Fillable.fillTypeNameToInt["dryGrass_windrow"];
		local grass_windrow = Fillable.fillTypeNameToInt["grass_windrow"];
		local wheat_windrow = Fillable.fillTypeNameToInt["wheat_windrow"];
		local barley_windrow = Fillable.fillTypeNameToInt["barley_windrow"];

		for a = 1, #(self.tipAnimations) do
			if self.tipAnimations[a].dischargeParticleSystems[forage] == self.tipAnimations[a].dischargeParticleSystems[(silage or chaff)] then
				self.tipAnimations[a].dischargeParticleSystems[forage] = nil;
			end;

			if self.tipAnimations[a].dischargeParticleSystems[woodChips] == self.tipAnimations[a].dischargeParticleSystems[chaff] then
				self.tipAnimations[a].dischargeParticleSystems[woodChips] = nil;
			end;

			if self.tipAnimations[a].dischargeParticleSystems[silage] == self.tipAnimations[a].dischargeParticleSystems[chaff] then
				self.tipAnimations[a].dischargeParticleSystems[silage] = nil;
			end;

			if self.tipAnimations[a].dischargeParticleSystems[manure] == self.tipAnimations[a].dischargeParticleSystems[silage] then
				self.tipAnimations[a].dischargeParticleSystems[manure] = nil;
			end;

			if self.tipAnimations[a].dischargeParticleSystems[dryGrass_windrow] == self.tipAnimations[a].dischargeParticleSystems[chaff] then
				self.tipAnimations[a].dischargeParticleSystems[dryGrass_windrow] = nil;
			end;

			if self.tipAnimations[a].dischargeParticleSystems[grass_windrow] == self.tipAnimations[a].dischargeParticleSystems[chaff] then
				self.tipAnimations[a].dischargeParticleSystems[grass_windrow] = nil;
			end;

			if self.tipAnimations[a].dischargeParticleSystems[wheat_windrow] == self.tipAnimations[a].dischargeParticleSystems[woodChips] then
				self.tipAnimations[a].dischargeParticleSystems[wheat_windrow] = nil;
			end;

			if self.tipAnimations[a].dischargeParticleSystems[barley_windrow] == self.tipAnimations[a].dischargeParticleSystems[woodChips] then
				self.tipAnimations[a].dischargeParticleSystems[barley_windrow] = nil;
			end;
		end;
		oldTrailerDelete(self);
	end;
end;
	
local oldShovelLoad = Shovel.load;
Shovel.load = function(self, xmlFile)
	oldShovelLoad(self, xmlFile);

	if self.emptyParticleSystems ~= nil then
		local forage = Fillable.fillTypeNameToInt["forage"];
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local manure = Fillable.fillTypeNameToInt["manure"];
		local woodChips = Fillable.fillTypeNameToInt["woodChips"];
		local dryGrass_windrow = Fillable.fillTypeNameToInt["dryGrass_windrow"];
		local grass_windrow = Fillable.fillTypeNameToInt["grass_windrow"];
		local wheat_windrow = Fillable.fillTypeNameToInt["wheat_windrow"];
		local barley_windrow = Fillable.fillTypeNameToInt["barley_windrow"];

		if self.emptyParticleSystems[chaff] ~= nil then
			if self.emptyParticleSystems[manure] ~= nil then
				if self.emptyParticleSystems[forage] == nil then
					self.emptyParticleSystems[forage] = self.emptyParticleSystems[manure];
				end;
			else
				if self.emptyParticleSystems[forage] == nil then
					self.emptyParticleSystems[forage] = self.emptyParticleSystems[chaff];
				end;
			end;

			if self.emptyParticleSystems[woodChips] == nil then
				self.emptyParticleSystems[woodChips] = self.emptyParticleSystems[chaff];
			end;

			if self.emptyParticleSystems[dryGrass_windrow] == nil then
				self.emptyParticleSystems[dryGrass_windrow] = self.emptyParticleSystems[chaff];
			end;

			if self.emptyParticleSystems[grass_windrow] == nil then
				self.emptyParticleSystems[grass_windrow] = self.emptyParticleSystems[chaff];
			end;
		end;

		if self.emptyParticleSystems[woodChips] ~= nil then
			if self.emptyParticleSystems[wheat_windrow] == nil then
				self.emptyParticleSystems[wheat_windrow] = self.emptyParticleSystems[woodChips];
			end;

			if self.emptyParticleSystems[barley_windrow] == nil then
				self.emptyParticleSystems[barley_windrow] = self.emptyParticleSystems[woodChips];
			end;
		end;
	end;
end;

local oldShovelDelete = Shovel.delete;
Shovel.delete = function(self)
	if self.emptyParticleSystems ~= nil then
		local forage = Fillable.fillTypeNameToInt["forage"];
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local manure = Fillable.fillTypeNameToInt["manure"];
		local woodChips = Fillable.fillTypeNameToInt["woodChips"];
		local dryGrass_windrow = Fillable.fillTypeNameToInt["dryGrass_windrow"];
		local grass_windrow = Fillable.fillTypeNameToInt["grass_windrow"];
		local wheat_windrow = Fillable.fillTypeNameToInt["wheat_windrow"];
		local barley_windrow = Fillable.fillTypeNameToInt["barley_windrow"];

		if self.emptyParticleSystems[forage] == self.emptyParticleSystems[manure] then
			self.emptyParticleSystems[forage] = nil;
		elseif self.emptyParticleSystems[forage] == self.emptyParticleSystems[chaff] then
			self.emptyParticleSystems[forage] = nil;
		end;

		if self.emptyParticleSystems[woodChips] == self.emptyParticleSystems[chaff] then
			self.emptyParticleSystems[woodChips] = nil;
		end;

		if self.emptyParticleSystems[dryGrass_windrow] == self.emptyParticleSystems[chaff] then
			self.emptyParticleSystems[dryGrass_windrow] = nil;
		end;

		if self.emptyParticleSystems[grass_windrow] == self.emptyParticleSystems[chaff] then
			self.emptyParticleSystems[grass_windrow] = nil;
		end;

		if self.emptyParticleSystems[wheat_windrow] == self.emptyParticleSystems[woodChips] then
			self.emptyParticleSystems[wheat_windrow] = nil;
		end;

		if self.emptyParticleSystems[barley_windrow] == self.emptyParticleSystems[woodChips] then
			self.emptyParticleSystems[barley_windrow] = nil;
		end;
		oldShovelDelete(self);
	end;
end;