--[[
	ThreshingCounterRegister.lua
	
	Autor: Ifko[nator]
	Datum: 25.11.2014
]]

SpecializationUtil.registerSpecialization("ThreshingCounter", "ThreshingCounter", g_currentModDirectory.."ThreshingCounter/ThreshingCounter.lua")

ThreshingCounterRegister = {};

function ThreshingCounterRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("combine") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.ThreshingCounter", _name)) ~= nil then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("ThreshingCounter"));
						end;
						Combine.SHOW_NOT_TRANSPARENT_HUD_TEXT = g_i18n:getText("SHOW_NOT_TRANSPARENT_HUD_TEXT");
						Combine.SHOW_TRANSPARENT_HUD_TEXT = g_i18n:getText("SHOW_TRANSPARENT_HUD_TEXT");
					end;
				end;
			end;	
		end;
	end;
end;

function ThreshingCounterRegister:deleteMap()end;
function ThreshingCounterRegister:keyEvent(unicode, sym, modifier, isDown)end;
function ThreshingCounterRegister:mouseEvent(posX, posY, isDown, isUp, button)end;
function ThreshingCounterRegister:update(dt)end;
function ThreshingCounterRegister:draw()end;

addModEventListener(ThreshingCounterRegister);