--[[
	RopeCounterRegister.lua
	
	Autor: Ifko[nator]
	Datum: 27.11.2014
]]

SpecializationUtil.registerSpecialization("RopeCounter", "RopeCounter", g_currentModDirectory.."RopeCounter/RopeCounter.lua")

RopeCounterRegister = {};

function RopeCounterRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("baler") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.RopeCounter", _name)) ~= nil then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("RopeCounter"));
						end;
						Baler.ROPE_EMPTY_TEXT = g_i18n:getText("ROPE_EMPTY_TEXT");
						Baler.ROPE_EMPTY_BUTTON = g_i18n:getText("ROPE_EMPTY_BUTTON");
					end;
				end;
			end;	
		end;
	end;
end;

function RopeCounterRegister:deleteMap()end;
function RopeCounterRegister:keyEvent(unicode, sym, modifier, isDown)end;
function RopeCounterRegister:mouseEvent(posX, posY, isDown, isUp, button)end;
function RopeCounterRegister:update(dt)end;
function RopeCounterRegister:draw()end;

addModEventListener(RopeCounterRegister);