--[[
	BaleCounterRegister.lua
	
	Autor: Ifko[nator]
	Datum: 25.11.2014
]]

SpecializationUtil.registerSpecialization("BaleCounter", "BaleCounter", g_currentModDirectory.."BaleCounter/BaleCounter.lua")

BaleCounterRegister = {};

function BaleCounterRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("baler") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.BaleCounter", _name)) ~= nil then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("BaleCounter"));
						end;
						Baler.SHOW_NOT_TRANSPARENT_HUD_TEXT = g_i18n:getText("SHOW_NOT_TRANSPARENT_HUD_TEXT");
						Baler.SHOW_TRANSPARENT_HUD_TEXT = g_i18n:getText("SHOW_TRANSPARENT_HUD_TEXT");
					end;
				end;
			end;	
		end;
	end;
end;

function BaleCounterRegister:deleteMap()end;
function BaleCounterRegister:keyEvent(unicode, sym, modifier, isDown)end;
function BaleCounterRegister:mouseEvent(posX, posY, isDown, isUp, button)end;
function BaleCounterRegister:update(dt)end;
function BaleCounterRegister:draw()end;

addModEventListener(BaleCounterRegister);