--[[
RopeCounter
Spezi damit das Ballengarn einer Presse auch aufgebraucht wird.

Author:	Ifko[nator]
Datum:	19.12.2014

Version:	v1.5
History:	v1.0 - initial implementation -- GLOBAL VERSION!
			v1.5 - support for the 'FollowMe Mod'. Means, automatic purchase of the ropes, if the 'FollowMe Mod' is active. :)
]]

RopeCounter = {};

local RopeCounterDirectory = g_currentModDirectory;

function RopeCounter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function RopeCounter:load(xmlFile)
	self.createBale = Utils.appendedFunction(self.createBale, RopeCounter.createBale);
	
	self.ropeEmpty = false;
	
	-- ## XML TAG
	self.ropeCountStartLocal = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ropesModdingWelt#baleCount"), 40);
	self.ropeRoll = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ropesModdingWelt#ropeRoll"));
	self.ropePriceLocal = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ropesModdingWelt#pricePerBale"), 10);
	
	-- ## modDesc TAG
	local modDesc = loadXMLFile("modDesc", RopeCounterDirectory .. "modDesc.xml");
		
	self.ropeCountStartGlobal = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.ropesModdingWelt#baleCount"), 40);
	self.ropePriceGlobal = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.ropesModdingWelt#pricePerBale"), 10);
	
	-- ## look if XML TAG is available else took modDesc TAG
	local ropeCountStartLocal = string.format("vehicle.ropesModdingWelt#baleCount");
	
	if hasXMLProperty(xmlFile, ropeCountStartLocal) then
		self.ropeCountStart = self.ropeCountStartLocal;
	else
		self.ropeCountStart = self.ropeCountStartGlobal;
	end;
	
	self.ropeCount = self.ropeCountStart;
	
	local ropePriceLocal = string.format("vehicle.ropesModdingWelt#pricePerBale");
	
	if hasXMLProperty(xmlFile, ropePriceLocal) then
		self.ropePrice = self.ropePriceLocal;
	else
		self.ropePrice = self.ropePriceGlobal;
	end;
	
	self.ropePrice = self.ropePrice * self.ropeCountStart;
	
	-- ## hud
	self.ropeCounterHudPosX = 0.7997;
    self.ropeCounterHudPosYStart = 0.2023; 
	self.ropeCounterHudPosY = self.ropeCounterHudPosYStart;
	self.ropeCounterHudPosYOffset = 0.0085;
    
	self.ropeCounterOverlay = Overlay:new("ropeCounterOverlay", Utils.getFilename("RopeCounter/RopeCounter_hud.dds", RopeCounterDirectory), self.ropeCounterHudPosX, self.ropeCounterHudPosYStart, 0.2371, 0.039525);
	self.ropeCounterOverlayTransparent = Overlay:new("ropeCounterOverlayTransparent", Utils.getFilename("RopeCounter/RopeCounter_Transparent_hud.dds", RopeCounterDirectory), self.ropeCounterHudPosX, self.ropeCounterHudPosYStart, 0.2371, 0.039525);
	
	self.ropeCounterOverlayCombine = Overlay:new("ropeCounterOverlayCombine", Utils.getFilename("RopeCounter/RopeCounter_hud.dds", RopeCounterDirectory), self.ropeCounterHudPosX, self.ropeCounterHudPosYStart + 0.0344, 0.2371, 0.039525);
	self.ropeCounterOverlayCombineTransparent = Overlay:new("ropeCounterOverlayCombineTransparent", Utils.getFilename("RopeCounter/RopeCounter_Transparent_hud.dds", RopeCounterDirectory), self.ropeCounterHudPosX, self.ropeCounterHudPosYStart + 0.0344, 0.2371, 0.039525);
end;

function RopeCounter:delete()
end;

function RopeCounter:readStream(streamId, connection)
	local count = streamReadInt32(streamId);	
	self.ropeCount = count;
end;

function RopeCounter:writeStream(streamId, connection)	
	streamWriteInt32(streamId, self.ropeCount);
end;

function RopeCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RopeCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function RopeCounter:update(dt)
	if self:getIsActive() then
		if self.ropeCount ~= nil then
			if self.ropeCount < 0 then 
				-- ## safe is safe .. 
				self.ropeCount = 0;
			end;
			if self.ropeCount == 0 then
				self:setIsTurnedOn(false);
				self.ropeEmpty = true;
				if self.ropeRoll ~= nil then
					setVisibility(self.ropeRoll, false);
				end;
				if self.attacherVehicle ~= nil then
					if self.attacherVehicle.modFM ~= nil then 
						-- FollowMe Mod is in the Moddirectory.
						if self.attacherVehicle.modFM.FollowState == 1 then
							-- ## automatic purchase of the ropes, because the 'FollowMe Mod' is active.
							self:setIsTurnedOn(true);
							self.ropeEmpty = false;
							if self.ropeRoll ~= nil then
								setVisibility(self.ropeRoll, true);
							end;
							if self.isServer then
								g_currentMission:addSharedMoney(- self.ropePrice);
							end;
							self.ropeCount = self.ropeCountStart;
						else 
							-- ## manual purchase of the ropes, because the 'FollowMe Mod' is not active.
							if InputBinding.hasEvent(InputBinding.ROPE_EMPTY_BUTTON) then
								self:setIsTurnedOn(true);
								self.ropeEmpty = false;
								if self.ropeRoll ~= nil then
									setVisibility(self.ropeRoll, true);
								end;
								if self.isServer then
									g_currentMission:addSharedMoney(- self.ropePrice);
								end;
								self.ropeCount = self.ropeCountStart;
							end;
						end;
					else 
						-- ## manual purchase of the Ropes, because 'FollowMe Mod' is not the Moddirectory.
						if InputBinding.hasEvent(InputBinding.ROPE_EMPTY_BUTTON) then
							self:setIsTurnedOn(true);
							self.ropeEmpty = false;
							if self.ropeRoll ~= nil then
								setVisibility(self.ropeRoll, true);
							end;
							if self.isServer then
								g_currentMission:addSharedMoney(- self.ropePrice);
							end;
							self.ropeCount = self.ropeCountStart;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function RopeCounter:draw()
	if self.ropeEmpty then
		local warnigText = string.format(Baler.ROPE_EMPTY_TEXT, self.ropePrice, self.ropeCountStart);
		g_currentMission:addWarning("");
		
		setTextAlignment(RenderText.ALIGN_CENTER);
		setTextBold(true);
		setTextColor(0, 0, 0, 1);
		renderText(0.53, 0.58, 0.023, warnigText);
		
		g_currentMission:addHelpButtonText(Baler.ROPE_EMPTY_BUTTON, InputBinding.ROPE_EMPTY_BUTTON);
	end;
	
	setTextAlignment(RenderText.ALIGN_RIGHT);	
	setTextBold(true);	
	
	if self.attacherVehicle.threshingCounterHudPosY ~= nil then
		-- ## baler attached on a combie wich have a threshing counter, so we must move the rope counter hud and the 'renderText' function.
		if self.showTransparentHuds ~= nil then
			if self.showTransparentHuds then
				self.ropeCounterOverlayCombineTransparent:render();
			else
				self.ropeCounterOverlayCombine:render();
			end;
		else
			self.ropeCounterOverlayCombineTransparent:render();
		end;
		self.ropeCounterHudPosY = 0.2367;
	else
		if self.showTransparentHuds ~= nil then
			if self.showTransparentHuds then
				self.ropeCounterOverlayTransparent:render();
			else
				self.ropeCounterOverlay:render();
			end;
		else
			self.ropeCounterOverlayTransparent:render();
		end;
		self.ropeCounterHudPosY = self.ropeCounterHudPosYStart;
	end;
	
	setTextColor(0, 0, 0, 1);
	renderText(self.ropeCounterHudPosX + 0.195, self.ropeCounterHudPosY + self.ropeCounterHudPosYOffset - 0.0025, 0.024, tostring(self.ropeCount));
	
	if self.ropeCount > 5 then
		setTextColor(1, 1, 1, 1);
	else
		setTextColor(0.95, 0, 0, 1);
	end;
	renderText(self.ropeCounterHudPosX + 0.195, self.ropeCounterHudPosY + self.ropeCounterHudPosYOffset, 		  0.024, tostring(self.ropeCount));
	
	setTextColor(1, 1, 1, 1);
	setTextBold(false);	
	setTextAlignment(RenderText.ALIGN_LEFT);
end

function RopeCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local ropeCount = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#ropeCount"), self.ropeCount);
	
		self.ropeCount = ropeCount;
	end; 
    
	return BaseMission.VEHICLE_LOAD_OK;
end;

function RopeCounter:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'ropeCount="'.. tostring(self.ropeCount) .. '"';
	
	return attributes, nil;
end;


function RopeCounter:createBale(baleIndex)
	if self.ropeCount ~= nil then
		if self.isTurnedOn then 
			-- ## only set the rope count down, when the baler is started and not at the Savegame loading, (Here also bales will be created ..).
			self.ropeCount = self.ropeCount - 1;
		end;
	end;
end;