--[[ 
BaleCounter
Spezi für einen Ballenzähler.

Author:	Ifko[nator]
Datum:	28.11.2014

Version:	v1.0
History:	v1.0 - initial implementation -- GLOBAL VERSION!
]]

BaleCounter = {};

local BaleCounterDirectory = g_currentModDirectory;

function BaleCounter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function BaleCounter:load(xmlFile)
	self.dropBale = Utils.appendedFunction(self.dropBale, BaleCounter.dropBale);

	self.totalBaleCount = 0;
	self.sessionBaleCount = 0;
	
	self.baleCounterHudPosX = 0.7997;
	self.baleCounterHudPosYStart = 0.1679;
	self.baleCounterHudPosY = self.baleCounterHudPosYStart;
	self.baleCounterHudPosYOffset = 0.0085;
	
	self.baleCounterOverlay = Overlay:new("baleCounterOverlay", Utils.getFilename("BaleCounter/BaleCounter_hud.dds", BaleCounterDirectory), self.baleCounterHudPosX, self.baleCounterHudPosYStart, 0.2371, 0.039525);
	self.baleCounterOverlayTransparent = Overlay:new("baleCounterOverlayTransparent", Utils.getFilename("BaleCounter/BaleCounter_Transparent_hud.dds", BaleCounterDirectory), self.baleCounterHudPosX, self.baleCounterHudPosYStart, 0.2371, 0.039525);
	
	self.baleCounterOverlayCombine = Overlay:new("baleCounterOverlayCombine", Utils.getFilename("BaleCounter/BaleCounter_hud.dds", BaleCounterDirectory), self.baleCounterHudPosX, self.baleCounterHudPosYStart + 0.0344, 0.2371, 0.039525);
	self.baleCounterOverlayCombineTransparent = Overlay:new("baleCounterOverlayCombineTransparent", Utils.getFilename("BaleCounter/BaleCounter_Transparent_hud.dds", BaleCounterDirectory), self.baleCounterHudPosX, self.baleCounterHudPosYStart + 0.0344, 0.2371, 0.039525);
	
	self.showTransparentHuds = true;
end;

function BaleCounter:delete()
end;

function BaleCounter:readStream(streamId, connection)
	local session = streamReadInt32(streamId);
	local total = streamReadInt32(streamId);	
	self.sessionBaleCount = session;
	self.totalBaleCount = total;
end;

function BaleCounter:writeStream(streamId, connection)	
	streamWriteInt32(streamId, self.totalBaleCount);
	streamWriteInt32(streamId, self.sessionBaleCount);
end;

function BaleCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BaleCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function BaleCounter:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.SHOW_TRANSPARENT_HUD_BUTTON) then
			self.showTransparentHuds = not self.showTransparentHuds;
		end;
	end;
end;

function BaleCounter:draw()
	setTextAlignment(RenderText.ALIGN_RIGHT);	
	setTextBold(true);	
	
	if self.attacherVehicle.threshingCounterHudPosY ~= nil then
		-- Baler attached on a combie wich have a threshing counter, so we must move the bale counter hud and the 'renderText' function
		if self.showTransparentHuds then
			self.baleCounterOverlayCombineTransparent:render();
			if self:getIsActiveForInput() then
				g_currentMission:addHelpButtonText(Baler.SHOW_NOT_TRANSPARENT_HUD_TEXT, InputBinding.SHOW_TRANSPARENT_HUD_BUTTON);
			end;
		else
			self.baleCounterOverlayCombine:render();
			if self:getIsActiveForInput() then
				g_currentMission:addHelpButtonText(Baler.SHOW_TRANSPARENT_HUD_TEXT, InputBinding.SHOW_TRANSPARENT_HUD_BUTTON);
			end;
		end;
		self.baleCounterHudPosY = 0.2023;
	else
		if self.showTransparentHuds then
			self.baleCounterOverlayTransparent:render();
			if self:getIsActiveForInput() then
				g_currentMission:addHelpButtonText(Baler.SHOW_NOT_TRANSPARENT_HUD_TEXT, InputBinding.SHOW_TRANSPARENT_HUD_BUTTON);
			end;
		else
			self.baleCounterOverlay:render();
			if self:getIsActiveForInput() then
				g_currentMission:addHelpButtonText(Baler.SHOW_TRANSPARENT_HUD_TEXT, InputBinding.SHOW_TRANSPARENT_HUD_BUTTON);
			end;
		end;
		self.baleCounterHudPosY = self.baleCounterHudPosYStart;
	end;
	
	setTextColor(0, 0, 0, 1);
	renderText(self.baleCounterHudPosX + 0.11,	self.baleCounterHudPosY + self.baleCounterHudPosYOffset - 0.0025, 0.024, tostring(self.totalBaleCount));
	renderText(self.baleCounterHudPosX + 0.195, self.baleCounterHudPosY + self.baleCounterHudPosYOffset - 0.0025, 0.024, tostring(self.sessionBaleCount));
	
	setTextColor(1, 1, 1, 1);	
	renderText(self.baleCounterHudPosX + 0.11,  self.baleCounterHudPosY + self.baleCounterHudPosYOffset, 		  0.024, tostring(self.totalBaleCount));
	renderText(self.baleCounterHudPosX + 0.195, self.baleCounterHudPosY + self.baleCounterHudPosYOffset, 		  0.024, tostring(self.sessionBaleCount));
   
	setTextBold(false);	
	setTextAlignment(RenderText.ALIGN_LEFT);
end

function BaleCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local totalBaleCount = Utils.getNoNil(getXMLInt(xmlFile, key .. "#totalBales"), self.totalBaleCount);
		local showTransparentHuds = Utils.getNoNil(getXMLBool(xmlFile, key .. "#showTransparentHuds"), self.showTransparentHuds);
		
		self.totalBaleCount = totalBaleCount;
		self.showTransparentHuds = showTransparentHuds;
	end; 
    
	return BaseMission.VEHICLE_LOAD_OK;
end;

function BaleCounter:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 
		'totalBales="' .. tostring(self.totalBaleCount) .. 
		'" showTransparentHuds="' .. tostring(self.showTransparentHuds) .. 
	'"';
	
	return attributes, nil;
end;

function BaleCounter:dropBale(baleIndex)
	if self.totalBaleCount ~= nil then
		self.totalBaleCount = self.totalBaleCount + 1;
		self.sessionBaleCount = self.sessionBaleCount + 1;
	end;
end;