--[[
PickUp Particlesystem fr Pressen oder Ladewagen.
Anpassungen:	Ifko[nator]
Erstellt am:	25.06.2013

Edit: 18.08.2013
Gendert wurde: StaticParticleSystem fr die NewHollandPickupParticleSystems direkt eigebunden damit keine extra lua mehr notwendig ist.
Gendert von: Ifko[nator]

Fix: Nun wird kein PS mehr erzeugt wenn man einen Ladewagen entleert und dieser angeschaltet ist. Dazu wurde die Arbeitsweise des Scriptes komplett neu aufgebaut.
Gefixt von Ifko[nator] am:	06.04.2014

Edit2: 03.05.2014 
Gendert wurde: Das 'extraParticleSystem' wird, wenn es in der XML eingetragen ist, nun nur noch bei der Strohaufnahme erzeugt.
Gendert von: Ifko[nator]
-----------------------------------------------------------------------
Konvert in den LS 15 am 06.12.2014 by Ifko[nator]
-----------------------------------------------------------------------

Dieses Script ist Freiverwendbar! Sollt es ja auch nutzen.. ^^

XML Code:

<newHollandPickupParticleSystemsModdingWelt>
	<Straw file="Pfad zur .i3d des PS hier eingeben" node="Index zur Transformgroup, an der das PS erzeugt wird, hier angeben" />    			<!-- Stroh PS -->
	<Grass file="Pfad zur .i3d des PS hier eingeben" node="Index zur Transformgroup, an der das PS erzeugt wird, hier angeben" />    			<!-- Gras PS -->
	<dryGrass file="Pfad zur .i3d des PS hier eingeben" node="Index zur Transformgroup, an der das PS erzeugt wird, hier angeben" /> 			<!-- Heu PS dieses PS funktioniert nur bei Pressen, da ein Ladewagen automatisch aus Heu, Gras macht. [Ausgehend von den Standardsachen versteht sich.. Gut mglich das es einen Ladewagen als Mod gibt, der das Heu nicht in Gras umwandelt..]-->
	<extraParticleSystem file="Pfad zur .i3d des PS hier eingeben" node="Index zur Transformgroup, an der das PS erzeugt wird, hier angeben" /> <!-- Extra PS (nur beim Stroh Pressen)-->
</newHollandPickupParticleSystemsModdingWelt>

Knnte dann so aussehen:

<newHollandPickupParticleSystemsModdingWelt>
	<Straw file="particleSystems/StrawPickup.i3d" node="0>14|2" />       	   <!-- Stroh PS -->
	<Grass file="particleSystems/GrassPickup.i3d" node="0>14|2" />       	   <!-- Gras PS -->
	<dryGrass file="particleSystems/DryGrassPickup.i3d" node="0>14|2" />  	   <!-- Heu PS dieses PS funktioniert nur bei Pressen, da ein Ladewagen automatisch aus Heu, Gras macht.  [Ausgehend von den Standardsachen versteht sich.. Gut mglich das es einen Ladewagen als Mod gibt, der das Heu nicht in Gras umwandelt..]-->
	<extraParticleSystem file="PSystem/extraParticlesystem.i3d" node="0>23" /> <!-- Extra PS (nur beim Stroh Pressen)-->
</newHollandPickupParticleSystemsModdingWelt>

Hinwei:

Es mssen nicht alle 4 ParticleSysteme in der XML des Gertes angegeben werden! Wenn man ein ParticleSystem nicht braucht, braucht man es auch nicht in die XML einzutragen. Es kommt zu keinen Fehler, wenn ein ParticleSystem nicht eingetragen ist.

modDesc:

INFO:
Ein VehicleType sollte in der modDesc schon vorhanden sein, sonst wirds etwas schwerer..

<specializations>
	<specialization name="NewHollandPickupParticleSystems" className="NewHollandPickupParticleSystems" filename="Scripts/NewHollandPickupParticleSystems.lua"/>	
</specializations>

Sollte das Tag '<specializations>' schon vorhanden sein, dann tragt dort bitte nur das

<specialization name="NewHollandPickupParticleSystems" className="NewHollandPickupParticleSystems" filename="Scripts/NewHollandPickupParticleSystems.lua"/>

ein. Den Pfad bei 'filename' zur NewHollandPickupParticleSystems.lua gegebenenfalls anpassen!

<vehicleTypes>
  <type name="NAME des VehicleTypes (Ist von Mod zu Mod unterschiedlich)" className="Vehicle" filename="$dataS/scripts/vehicles/Vehicle.lua">
	<specialization name="NewHollandPickupParticleSystems" />
  </type>
</vehicleTypes>

ACHTUNG!:
Beim VehicleType mssen auch noch andere specializations stehen! Diese knnen von Mod zu Mod unterschiedlich sein. Daher ist es einfacher, wenn ihr einen Mod habt, der einen VehicleType schon fertig eingetragen hat.

Fr fragen bin ich via PN: 
auf www.modding-welt.com als "Ifko[nator]" zu erreichen.
]]

NewHollandPickupParticleSystems = {};

function NewHollandPickupParticleSystems.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function NewHollandPickupParticleSystems:load(xmlFile)
	-- Strohparticle
	self.wheatParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.newHollandPickupParticleSystemsModdingWelt.Straw(%d)", i);
		local node = getXMLString(xmlFile, key .. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key .. "#file");
			local wheatParticleSystem = {};
			wheatParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, wheatParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.wheatParticleSystems, wheatParticleSystem);
		end;
		i = i + 1;
	end;
	
	-- Graspasrticle
	self.grassParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.newHollandPickupParticleSystemsModdingWelt.Grass(%d)", i);
		local node = getXMLString(xmlFile, key .. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key .. "#file");
			local grassParticleSystem = {};
			grassParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, grassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.grassParticleSystems, grassParticleSystem);
		end;
		i = i + 1;
	end;
	
	-- Heuparticle
	self.dryGrassParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.newHollandPickupParticleSystemsModdingWelt.dryGrass(%d)", i);
		local node = getXMLString(xmlFile, key .. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key .. "#file");
			local dryGrassParticleSystem = {};
			dryGrassParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, dryGrassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.dryGrassParticleSystems, dryGrassParticleSystem);
		end;
		i = i + 1;
	end;
	
	-- extra Staub (z.B. beim Pressen)
	self.extraParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.newHollandPickupParticleSystemsModdingWelt.extraParticleSystem(%d)", i);
		local node = getXMLString(xmlFile, key .. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key .. "#file");
			local extraParticleSystem = {};
			extraParticleSystem.particleSystem = {};
			Utils.loadParticleSystem(xmlFile, extraParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.extraParticleSystems, extraParticleSystem);
		end;
		i = i + 1;
	end;
	
	self.previousLevel = self.fillLevel;
	self.pickUpAktiv = false;
	self.grassPickUpPs = false;
	self.dryGrassPickUpPs = false;
	self.strawPickUpPs = false;
end;

function NewHollandPickupParticleSystems:delete()
	for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
		Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(grassParticleSystem.particleSystem, false);
	end;
	for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
		Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
	end;
	for _, extraParticleSystem in pairs(self.extraParticleSystems) do
		Utils.deleteParticleSystem(extraParticleSystem.particleSystem);
	end;
end;

function NewHollandPickupParticleSystems:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NewHollandPickupParticleSystems:keyEvent(unicode, sym, modifier, isDown)
end;

function NewHollandPickupParticleSystems:updateTick(dt)
	if self:getIsActive() then
		if self.lastSpeedReal > 5/3600 then
			if self.previousLevel ~= self.fillLevel then
				if self.previousLevel < self.fillLevel then
					if self.isTurnedOn then
						self.pickUpAktiv = true;
					else
						self.pickUpAktiv = false;
					end;
				else
					self.pickUpAktiv = false;
				end;
				self.previousLevel = self.fillLevel;
			else
				self.pickUpAktiv = false;
			end;
		else
			self.pickUpAktiv = false;
		end;
	else
		self.pickUpAktiv = false;
	end;
end;

function NewHollandPickupParticleSystems:update(dt)
	if self.pickUpAktiv then
		if (self.currentFillType == Fillable.FILLTYPE_WHEAT_WINDROW or self.currentFillType == Fillable.FILLTYPE_BARLEY_WINDROW) then
			self.strawPickUpPs = true;
		else
			self.strawPickUpPs = false;
		end;
		if (self.currentFillType == Fillable.FILLTYPE_GRASS_WINDROW) then
			self.grassPickUpPs = true;
		else
			self.grassPickUpPs = false;
		end;
		if (self.currentFillType == Fillable.FILLTYPE_DRYGRASS_WINDROW) then
			self.dryGrassPickUpPs = true;
		else
			self.dryGrassPickUpPs = false;
		end;
	else
		self.strawPickUpPs = false;
		self.grassPickUpPs = false;
		self.dryGrassPickUpPs = false;
	end;
	
	for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
		Utils.setEmittingState(wheatParticleSystem.particleSystem, self.strawPickUpPs); -- Wenn self.strawPickUpPs 'true' ist, dann wird dieses ParticleSystem erzeugt.
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(grassParticleSystem.particleSystem, self.grassPickUpPs); -- Wenn self.grassPickUpPs 'true' ist, dann wird dieses ParticleSystem erzeugt.
	end;
	for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
		Utils.setEmittingState(dryGrassParticleSystem.particleSystem, self.dryGrassPickUpPs); -- Wenn self.dryGrassPickUpPs 'true' ist, dann wird dieses ParticleSystem erzeugt.
	end;
	if SpecializationUtil.hasSpecialization(Baler, self.specializations) then
		for _, extraParticleSystem in pairs(self.extraParticleSystems) do
			Utils.setEmittingState(extraParticleSystem.particleSystem, self.strawPickUpPs);  -- Wenn self.strawPickUpPs 'true' ist und es sich um eine Presse handelt, dann wird dieses ParticleSystem erzeugt.
		end;
	end;
end;
	
function  NewHollandPickupParticleSystems:draw()
end;

-------------------------------------------------------------------------------------------------------------------------------------
-- StaticParticleSystem fr die NewHollandPickupParticleSystems

StaticParticleSystem = {};

function StaticParticleSystem.loadParticleSystem(xmlFile, particleSystemTable, baseString, component, currentEmittingState, defaultParticleSystem, directory)
	local defaultLinkNode = component;
	if type(component) == "table" then
		defaultLinkNode = component[1].node;
	end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(component, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);
	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = defaultParticleSystem;
	end
	if psFile == nil then
		return;
	end
	psFile = Utils.getFilename(psFile, directory);
	local rootNode = loadI3DFile(psFile);
	if rootNode == 0 then
		print("[ERROR der NewHollandPickupParticleSystems.lua]: Das ParticleSystem '" .. psFile .. "' konnte nicht geladen werden. Dieses ParticleSystem ist daher inakiv.");
		return;
	end
	link(linkNode, rootNode);
	for i=0, getNumOfChildren(rootNode)-1 do
		local child = getChildAt(rootNode, i);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 then
				if getClassName(geometry) == "ParticleSystem" then
					table.insert(particleSystemTable, {geometry = geometry, shape = child});
					if currentEmittingState ~= nil then
						setEmittingState(geometry, currentEmittingState);
					end;
				end;
			end;
		end;
	end;
	return rootNode;
end;