--	Ce Mod est un petit outil qui affiche en haut à droite le prix le plus élevé des produits.
--	Lorsqu'il y a des produit en forte demande, les prix correspondant clignote.
--	La combinaison des touches Alt et F2 permet d'activer ou désactiver l'affichage.

-- V1.33
--	Gestion de l'affichage pour les résolution écran inférieures à 1920x1080

-- V1.32
--	Ajout du traitement particulier du produit "cochon" de certaines Map

-- V1.31
--	Correction de l'erreur d'affichage des libellés du nom des produits et des lieux

-- V1.30
--	Ajout du nom de l'endroit ou le prix est le meilleur

-- V1.20
--	Ajout des copeaux de bois et de l'ensilage

-- V1.10
--	Ajout de la combinaison des touches Alt et F2 pour activer ou désactiver l'affichage

-- V1.00
--	Première version



-- This Mod is a small tool that displays at the top right the higher product prices.
-- When there is a product in high demand, the corresponding prize flashes.
-- The combination of Alt and F2 keys to enable or disable the display.

-- V1.33
--	Managing the display for the lower screen resolution to 1920x1080

-- V1.32
--	Adding the special treatment of the product "pig" of some Map

-- V1.31
--	Fixed display error labels with the names of products and places

-- V1.30
--	Adding the name of the place where the price is the best

-- V1.20
--	Adding wood chips and silage

-- V1.10
--	Adding the combination of Alt and F2 keys to toggle the display.

-- V1.00
--	First Version

-- This is my Mod, I realized myself.
	
MinMax = {};
MinMax.idTimerPrix = 0;
MinMax.intervaleTimerPrix = 2000;
MinMax.idTimerClignotant = 0;
MinMax.intervaleTimerClignotant = 800;
MinMax.produitEnGrosseDemande = nil;
MinMax.grosseDemandeVisible = nil;
MinMax.prixProduits = nil;
MinMax.actif = true;
MinMax.lieux = nil;
MinMax.etatsBunkerSilo = {};


function MinMax:loadMap(name)
	MinMax.idTimerPrix = addTimer(MinMax.intervaleTimerPrix, "MinMax.timerPrix");
	MinMax.idTimerClignotant = addTimer(MinMax.intervaleTimerClignotant, "MinMax.timerClignotant");
	
	MinMax.etatsBunkerSilo[0] = "Fill";
	MinMax.etatsBunkerSilo[1] = "Close";
	MinMax.etatsBunkerSilo[2] = "Drain";
end;

function MinMax:deleteMap()
	removeTimer(MinMax.idTimerPrix)
	removeTimer(MinMax.idTimerClignotant)
end;

function MinMax:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MinMax:keyEvent(unicode, sym, modifier, isDown)

	if ( isDown) then
		if sym == 283 then
			if bitAND(modifier,4095) == 256 then
				if (MinMax.actif) then
					MinMax.actif = false;
				else
					MinMax.actif = true;
				end;
			end;
		end;
	end;
end;

function MinMax:update(dt)
end;

function MinMax:draw()
	
	if ( MinMax.actif) then
		setTextBold(true)
		
		local produitsClasses = {};
		local interligne = 0.015
		local y = 0.865
		local xNomType = 0.790 
		local xPrix = 0.880
		local xLieu = 0.885
		local taillePolice = 0.018

		if ( g_screenWidth < 1920) then
			xNomType = 0.785 
			xPrix = 0.875
			xLieu = 0.880
			taillePolice = 0.014
		end;

		for nomType, p in pairs(MinMax.prixProduits) do
			table.insert(produitsClasses, nomType)
		end;
		table.sort( produitsClasses)
		for p, nomType in pairs(produitsClasses) do
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText( xNomType, y, taillePolice,  nomType);
			
			setTextAlignment(RenderText.ALIGN_RIGHT);			
			local prix = string.format("%4s", MinMax.prixProduits[nomType]);
			if( MinMax.produitEnGrosseDemande[nomType] ) then
				if (MinMax.grosseDemandeVisible) then
					renderText(xPrix, y, taillePolice,  prix)
				end;
			else
				renderText(xPrix, y, taillePolice,  prix)
			end;
			
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText( xLieu, y, taillePolice,  MinMax.lieux[nomType] );
			y = y - interligne
		end;

		setTextBold(false)
		
	end;
end;


function timerPrix()

	prix()
	
	setTimerTime(MinMax.idTimerPrix, MinMax.intervaleTimerPrix);
	return true;
end;


function prix()

	if ( MinMax.actif) then
		
		local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1);
		
		MinMax.produitEnGrosseDemande = {};
		MinMax.prixProduits = {};
		MinMax.lieux = {};
		
		for k,tipTrig in pairs(g_currentMission.tipTriggers) do
		
			local nomTrigger = g_i18n:getText(tipTrig.stationName)
			if ( string.sub( nomTrigger, 1, 7) ==  "Missing" and string.sub( nomTrigger, string.len( nomTrigger) - 3, string.len( nomTrigger)) == ".xml") then
				nomTrigger = tipTrig.stationName
			end;

			local fillTypes = getUserAttribute(tipTrig.triggerId, "fillTypes");
			if fillTypes == nil then
				fillTypes = getUserAttribute(tipTrig.triggerId, "fruitTypes");
			end
		
			if ( tipTrig.stationName ~= "BunkerSilo" and tipTrig.stationName ~= "Station") then

				local types = Utils.splitString(" ", fillTypes);
				for indexeType, nom in pairs(types) do
											
					local desc = Fillable.fillTypeNameToDesc[nom]
					if (desc ~=nil) then
						local nomType = desc.nameI18N
						local greatDemandMultiplier = 1;
						local greatDemand = g_currentMission.economyManager:getCurrentGreatDemand(tipTrig.stationName, desc.index);
					   
						if greatDemand ~= nil then
							greatDemandMultiplier = greatDemand.demandMultiplier;
							if (MinMax.produitEnGrosseDemande[nomType] == nil) then
								MinMax.produitEnGrosseDemande[nomType] = true
							else
								MinMax.produitEnGrosseDemande[nomType] = false
							end;
							
						end;
						
						local prix = difficultyMultiplier * tipTrig.priceMultipliers[desc.index] * Fillable.fillTypeIndexToDesc[desc.index].pricePerLiter * greatDemandMultiplier
						
						if ( nom ~= "pig") then
							prix = math.ceil( prix * 1000)
						end;
						
						if ( MinMax.prixProduits[nomType] == nil) then
							MinMax.prixProduits[nomType] = prix
							MinMax.lieux[nomType] = nomTrigger
						else
							if ( prix > MinMax.prixProduits[nomType]) then
								MinMax.prixProduits[nomType] = prix
								MinMax.lieux[nomType] = nomTrigger
							end;
						end;
					end;
				end;
			else
				if ( tipTrig.stationName == "BunkerSilo") then
					if( tipTrig.bunkerSilo.state ~= nil) then
						local c = "---------------4--------------------> nomTrigger="..nomTrigger.." tipTrig.bunkerSilo.fillLevel="..tipTrig.bunkerSilo.fillLevel.." tipTrig.bunkerSilo.state "..MinMax.etatsBunkerSilo[tipTrig.bunkerSilo.state] 
					
						--print(c)
					end;
				end
			end;
		end;
	end;
end;	

function timerClignotant()

	if ( MinMax.actif) then
		if ( MinMax.produitEnGrosseDemande ~= "") then
			if (MinMax.grosseDemandeVisible) then
				MinMax.grosseDemandeVisible = false
			else
				MinMax.grosseDemandeVisible = true
			end;
		else
			MinMax.grosseDemandeVisible = false
		end;
	end;
		
	setTimerTime(MinMax.idTimerClignotant, MinMax.intervaleTimerClignotant);
	return true;
end;


addModEventListener(MinMax);

local modItem = ModsUtil.findModItemByModName(g_currentModName);

print(string.format("Script loaded: MinMax.lua (v%.2f)", modItem.version));


