
MinMax = {};
MinMax.version = 1.0;   
MinMax.idTimerPrix = 0;
MinMax.intervaleTimerPrix = 60000;
MinMax.idTimerClignotant = 0;
MinMax.intervaleTimerClignotant = 800;
MinMax.cerealeGrosseDemande = nil;
MinMax.grosseDemandeVisible = false;
MinMax.cereales = nil;


function MinMax:loadMap(name)
	MinMax.idTimerPrix = addTimer(MinMax.intervaleTimerPrix, "MinMax.timerPrix");
	MinMax.idTimerClignotant = addTimer(MinMax.intervaleTimerClignotant, "MinMax.timerClignotant");
end;

function MinMax:deleteMap()

end;

function MinMax:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MinMax:keyEvent(unicode, sym, modifier, isDown)
end;

function MinMax:update(dt)

	if (MinMax.cereales == nil) then 
		prix()
	end;

end;

function MinMax:draw()

	setTextBold(true)
	setTextAlignment(RenderText.ALIGN_RIGHT);
	
	local y = 0.865
	for i = 1,6 do
	
		local texte = g_i18n:getText(FruitUtil.fruitIndexToDesc[i].name)
		
		if( i == MinMax.cerealeGrosseDemande) then
			if (MinMax.grosseDemandeVisible) then
				texte = texte .. " " .. string.format("%4s", MinMax.cereales[i])
			end;
		else
			texte = texte .. " " .. string.format("%4s", MinMax.cereales[i])
		end;
		
		renderText(0.99, y, 0.018,  texte );
		y = y - 0.015
	end;
	
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false)
	
end;

function timerPrix()
	
	prix()
	
	setTimerTime(MinMax.idTimerPrix, MinMax.intervaleTimerPrix);
	return true;
end;


function prix()
	local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1); -- 1  2  4
	
	MinMax.cerealeGrosseDemande = ""
	MinMax.cereales = {0,0,0,0,0,0};
	
	for k,tipTrig in pairs(g_currentMission.tipTriggers) do
		if (tipTrig.appearsOnPDA) then
			if ( table.getn(tipTrig.acceptedFillTypes) > 0) then
				for a,acceptedTypes in pairs(tipTrig.acceptedFillTypes) do
					if ( a <= 6) then	
						--local ancienPrix = Utils.getNoNil(FruitUtil.fruitIndexToDesc[a].yesterdaysPrice, 0)
						--print( Fillable.fillTypeIndexToDesc[a].yesterdaysPrice);
						
						local greatDemandMultiplier = 1;
						local greatDemand = g_currentMission.economyManager:getCurrentGreatDemand(tipTrig.stationName, a);
		               
						if greatDemand ~= nil then
		                   greatDemandMultiplier = greatDemand.demandMultiplier;
						   MinMax.cerealeGrosseDemande = a
						end;
						
						local prix = math.ceil( difficultyMultiplier * tipTrig.priceMultipliers[a] * Fillable.fillTypeIndexToDesc[a].pricePerLiter * greatDemandMultiplier * 1000)
						if ( prix > MinMax.cereales[a]) then
							MinMax.cereales[a] = prix
						end;
					end
				end;
			end;
		end;
	end;
end;	

function timerClignotant()

	if ( MinMax.cerealeGrosseDemande ~= "") then
		if (MinMax.grosseDemandeVisible) then
			MinMax.grosseDemandeVisible = false
		else
			MinMax.grosseDemandeVisible = true
		end;
	else
		MinMax.grosseDemandeVisible = false
	end;

	setTimerTime(MinMax.idTimerClignotant, MinMax.intervaleTimerClignotant);
	return true;
end;


addModEventListener(MinMax);

print(string.format("Script loaded: MinMax.lua (v%.2f)", MinMax.version));

