-- V1.10
--	Ajout de la combinaison des touches Alt et F2 pour activer ou désactiver l'affichage
--
--	Adding the combination of Alt and F2 keys to toggle the display.

-- V1.00
--	Création
	
MinMax = {};
MinMax.version = 1.0;   
MinMax.idTimerPrix = 0;
MinMax.intervaleTimerPrix = 60000;
MinMax.idTimerClignotant = 0;
MinMax.intervaleTimerClignotant = 800;
MinMax.fruitGrosseDemande = nil;
MinMax.grosseDemandeVisible = false;
MinMax.prixFruits = nil;
MinMax.actif = true;

function MinMax:loadMap(name)
	MinMax.idTimerPrix = addTimer(MinMax.intervaleTimerPrix, "MinMax.timerPrix");
	MinMax.idTimerClignotant = addTimer(MinMax.intervaleTimerClignotant, "MinMax.timerClignotant");
end;

function MinMax:deleteMap()
end;

function MinMax:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MinMax:keyEvent(unicode, sym, modifier, isDown)

	if ( isDown) then
		if sym == 283 then
			if bitAND(modifier,4095) == 256 then
				if (MinMax.actif) then
					MinMax.actif = false;
				else
					MinMax.actif = true;
				end;
			end;
		end;
	end;
end;

function MinMax:update(dt)

	if (MinMax.prixFruits == nil) then 
		prix()
	end;

end;

function MinMax:draw()

	if ( MinMax.actif) then
		setTextBold(true)
		setTextAlignment(RenderText.ALIGN_RIGHT);
		
		local y = 0.865
		for i = 1, table.getn(MinMax.prixFruits) do
		
			local texte = g_i18n:getText(FruitUtil.fruitIndexToDesc[i].name)
			
			if( i == MinMax.fruitGrosseDemande) then
				if (MinMax.grosseDemandeVisible) then
					texte = texte .. " " .. string.format("%4s", MinMax.prixFruits[i])
				end;
			else
				texte = texte .. " " .. string.format("%4s", MinMax.prixFruits[i])
			end;
			
			renderText(0.99, y, 0.018,  texte );
			y = y - 0.015
		end;
		
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(false)
		
	end;
end;

function timerPrix()
	prix()
	
	setTimerTime(MinMax.idTimerPrix, MinMax.intervaleTimerPrix);
	return true;
end;


function prix()

	if ( MinMax.actif) then
		
		local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1); -- 1  2  4
		
		MinMax.fruitGrosseDemande = ""
		MinMax.prixFruits = {0,0,0,0,0,0};
		
		for k,tipTrig in pairs(g_currentMission.tipTriggers) do
		
			if ( tipTrig.stationName ~= "BunkerSilo" and tipTrig.stationName ~= "Station") then
			print(tipTrig.stationName .. " " .. table.getn(tipTrig.acceptedFillTypes))
				if ( table.getn(tipTrig.acceptedFillTypes) > 0) then
					for a,acceptedTypes in pairs(tipTrig.acceptedFillTypes) do
						--if ( a <= getn(tipTrig.acceptedFillTypes)) then	
							--local ancienPrix = Utils.getNoNil(FruitUtil.fruitIndexToDesc[a].yesterdaysPrice, 0)
							--print( Fillable.fillTypeIndexToDesc[a].yesterdaysPrice);
							local greatDemandMultiplier = 1;
							local greatDemand = g_currentMission.economyManager:getCurrentGreatDemand(tipTrig.stationName, a);
						   
							if greatDemand ~= nil then
							   greatDemandMultiplier = greatDemand.demandMultiplier;
							   MinMax.fruitGrosseDemande = a
							end;
							
							local prix = math.ceil( difficultyMultiplier * tipTrig.priceMultipliers[a] * Fillable.fillTypeIndexToDesc[a].pricePerLiter * greatDemandMultiplier * 1000)
							if ( prix > MinMax.prixFruits[a]) then
								MinMax.prixFruits[a] = prix
							end;
						--end
					end;
				end;
			end;
		end;
	end;
end;	

function timerClignotant()
	if ( MinMax.actif) then
		if ( MinMax.fruitGrosseDemande ~= "") then
			if (MinMax.grosseDemandeVisible) then
				MinMax.grosseDemandeVisible = false
			else
				MinMax.grosseDemandeVisible = true
			end;
		else
			MinMax.grosseDemandeVisible = false
		end;
	end;
		
	setTimerTime(MinMax.idTimerClignotant, MinMax.intervaleTimerClignotant);
	return true;
end;


addModEventListener(MinMax);

print(string.format("Script loaded: MinMax.lua (v%.2f)", MinMax.version));

