--
-- mogliBasics
-- This is the specialization for mogliBasics
--




mogliBase = {}

mogliBase.version       = 1.0

function mogliBase.newSubclass()
	local subclass = {}
	setmetatable( subclass, { __index = function (table, key) return mogliBase[key] end } )
	subclass.baseDirectory = g_currentModDirectory
	subclass.modsDirectory = g_modsDirectory.."/"
	return subclass
end

function mogliBase.globalsReset( createIfMissing )
end

function mogliBase.globalsLoad( file , rootTag, globals )	

	local xmlFile = loadXMLFile( "mogliBasics", file, rootTag )
	for name,value in pairs(globals) do
		local tp = getXMLString(xmlFile, rootTag.."." .. name .. "#type")
		if     tp == nil then
--			print(file..": "..name.." = nil")
		elseif tp == "bool" then
			local bool = getXMLBool( xmlFile, rootTag.."." .. name .. "#value" )
			if bool ~= nil then
				--if bool then globals[name] = 1 else globals[name] = 0 end
				globals[name] = bool
			end
--			print(file..": "..name.." = "..tostring(globals[name]))
		elseif tp == "float" then
			local float = getXMLFloat( xmlFile, rootTag.."." .. name .. "#value" )
			if float ~= nil then globals[name] = float end
--			print(file..": "..name.." = "..tostring(globals[name]))
		elseif tp == "int" then
			local int = getXMLInt( xmlFile, rootTag.."." .. name .. "#value" )
			if int ~= nil then globals[name] = int end
--			print(file..": "..name.." = "..tostring(globals[name]))
		else
			print(file..": "..name..": invalid XML type : "..tp)
		end
	end
end

function mogliBase.getText(id)
	if id == nil then
		return "nil";
	end;
	
	if g_i18n:hasText( id ) then
	  return g_i18n:getText( id )
	end
	
	return id
end;

function mogliBase.normalizeAngle( angle )
	local normalizedAngle = angle
	if angle > math.pi then
		normalizedAngle = angle - math.pi - math.pi
	elseif angle <= -math.pi then
		normalizedAngle = angle + math.pi + math.pi
	end
	return normalizedAngle
end

function mogliBase.prerequisitesPresent(specializations)
  return true
end

function mogliBase:load(xmlFile)
-- should always be overwritten
	mogliBase.registerState( self, "mogliBasicsDummy", false, mogliBase.debugEvent )
end

function mogliBase:delete()
end

function mogliBase:mouseEvent(posX, posY, isDown, isUp, button)
end

function mogliBase:keyEvent(unicode, sym, modifier, isDown)
end

function mogliBase:update(dt)
end

function mogliBase:updateTick(dt)	
end

function mogliBase:readStream(streamId, connection)
end

function mogliBase:writeStream(streamId, connection)
end

function mogliBase:draw()	
end  
       
function mogliBase:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ""
	return attributes
end;

function mogliBase:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	return BaseMission.VEHICLE_LOAD_OK;
end

function mogliBase:initStateHandling( )
	if self.mbVersion == nil or self.mbVersion < mobliBase_version then
		self.mbVersion = mobliBase_version
		if self.mbSetState ~= mogliBase.mbSetState then
			self.mbSetState = mogliBase.mbSetState
		end
		if self.mbStateHandler == nil then
			self.mbStateHandler = {}
		end
	end
end

function mogliBase:registerState( level1, default, handler )
	mogliBase.initStateHandling( self )
	self[level1] = default
	if handler ~= nil then
		self.mbStateHandler[level1] = handler
	end		
end

function mogliBase:mbSetState(level1, value, noEventSend, stringFormat)
	mogliBase.initStateHandling( self )
	
	if self[level1] == nil or self[level1] ~= value then
	
		local valueEvent, valueNew 
		
		if stringFormat then
			valueEvent = value
		elseif value== true or value=="true" then
			valueEvent = "true"
		elseif value==false or value=="false" then
			valueEvent = "false"
		elseif value==nil then
			valueEvent = "nil"
		elseif type(value)=="string" then
			valueEvent = '"'..value..'"'		
		else
			valueEvent = tostring(value)
		end
		
		if not ( stringFormat ) then
			valueNew = value
		elseif valueEvent== "true" then
			valueNew = true
		elseif valueEvent=="false" then
			valueNew = false
		elseif valueEvent=="nil" then
			valueNew = nil
		elseif  string.len(valueEvent)>=2 
				and string.sub(valueEvent,1,1)=='"'
				and string.sub(valueEvent,-1,-1)=='"' then
			valueNew = string.sub(valueEvent,2,-2)
		else
			valueNew = tonumber( valueEvent )
		end
			
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then 
				g_server:broadcastEvent(mogliBaseEvent:new(self, level1, valueEvent), nil, nil, object) 
			else
				g_client:getServerConnection():sendEvent(mogliBaseEvent:new(self, level1, valueEvent)) 
			end 
		end 						
	
		if self.mbStateHandler[level1] ~= nil then
			local noEventSend2 = true 
			if self.isServer then
				noEventSend2 = noEventSend 
			end 
			
			local state, message = pcall( self.mbStateHandler[level1], self, self[level1], valueNew, noEventSend2 )
			if not state then
				print("Error: "..tostring(message)) 
				mogliBase.debugEvent( self, self[level1], valueNew, noEventSend ) 
				self[level1] = valueNew 	
			end
		else
			self[level1]= valueNew 	
		end 	
	end 	
end 

function mogliBase:debugEvent( old, new, noEventSend )
	local i = 2 
	local info 
	print("------------------------------------------------------------------------") 
	while i <= 10 do
		info = debug.getinfo(i) 
		if info == nil then break end
		print(string.format("%i: %s (%i): %s", i, info.short_src, Utils.getNoNil(info.currentline,0), Utils.getNoNil(info.name,"<???>"))) 
		i = i + 1 
	end
	if info ~= nil and info.name ~= nil and info.currentline ~= nil then
		print("...") 
	end
	print("------------------------------------------------------------------------") 
	print(tostring(old).." "..tostring(new).." "..tostring(noEventSend)) 
end 


mogliBaseEvent = {} 
mogliBaseEvent_mt = Class(mogliBaseEvent, Event) 

InitEventClass(mogliBaseEvent, "mogliBaseEvent") 

 
function mogliBaseEvent:emptyNew()
	local self = Event:new(mogliBaseEvent_mt) 
	self.className="mogliBaseEvent" 
	return self 
end 

function mogliBaseEvent:new(object, level1, value)
	local self = mogliBaseEvent:emptyNew() 
  self.object = object 
  self.level1 = level1 
  self.value = value 
	return self 
end 

function mogliBaseEvent:readStream(streamId, connection)
	--both clients and server can receive this event
  local id = streamReadInt32(streamId) 
  self.object = networkGetObject(id) 
  self.level1 = streamReadString(streamId) 
  self.value = streamReadString(streamId) 
  self:run(connection) 
end 

function mogliBaseEvent:writeStream(streamId, connection)
	--both clients and server can send this event
  streamWriteInt32(streamId, networkGetObjectId(self.object)) 
  streamWriteString(streamId, self.level1 ) 
  streamWriteString(streamId, self.value ) 
end 

function mogliBaseEvent:run(connection)
	----both clients and server can "run" this event (after reading it)	
	mogliBase.mbSetState(self.object, self.level1, self.value, true, true) 
  if not connection:getIsServer() then  
    g_server:broadcastEvent(mogliBaseEvent:new(self.object, self.level1, self.value), nil, connection, self.object) 
  end 
end 