--
-- AutoCombine
-- Extended AICombine 
--
-- @author  Mogli aka biedens
-- @date  22.10.2013
--
--  code source: AICombine.lua by Giants Software    
 
AutoCombine = {};
local AcDirectory = g_currentModDirectory;

------------------------------------------------------------------------
-- INCLUDES
------------------------------------------------------------------------
source(Utils.getFilename("Mogli.lua", AcDirectory));

------------------------------------------------------------------------
-- prerequisitesPresent
------------------------------------------------------------------------
function AutoCombine.prerequisitesPresent(specializations)
  return SpecializationUtil.hasSpecialization(Hirable, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

------------------------------------------------------------------------
-- load
------------------------------------------------------------------------
function AutoCombine:load(xmlFile)

	self.acOnBackCollisionTrigger    = AutoCombine.acOnBackCollisionTrigger;
	self.acOnCombineCollisionTrigger = AutoCombine.acOnCombineCollisionTrigger;

	-- for courseplay  
	self.acNumCollidingVehicles = 0;
	self.acIsCPStopped          = false;
	self.acTurnStage            = 0;
	
	self.acNodeIsLinked = false;
	self.acButtons = {};

	self.acParameters = {}
	self.acParameters.upNDown 							= false;
	self.acParameters.otherCombine = false;
	self.acParameters.waitMode           = false;
	self.acParameters.leftAreaActive = true;
  self.acParameters.rightAreaActive = false;
  self.acParameters.enabled = false;
  self.acParameters.noReverse = false;
  self.acParameters.CPSupport = false;
	self.acParameters.turnOffset = 0;
	self.acParameters.widthOffset = 0;
	self.acParameters.speed = 10;

	self.acDeltaTimeoutWait   = math.max(Utils.getNoNil( self.waitForTurnTimeout, 1500 ), 1000 ); 
	self.acDeltaTimeoutRun    = math.max(Utils.getNoNil( self.driveBackTimeout  , 1000 ),  300 );
	self.acDeltaTimeoutStop   = 4 * math.max(Utils.getNoNil( self.turnStage1Timeout , 20000), 10000);
	self.acDeltaTimeoutStart  = math.max(Utils.getNoNil( self.turnTimeoutLong   , 6000 ), 4000 );
	self.acDeltaTimeoutNoTurn = math.max(Utils.getNoNil( self.turnStage4Timeout , 2000 ), 1000 );
	self.acSteeringSpeed      = Utils.getNoNil( self.aiSteeringSpeed, 0.001 );
	self.acRecalculateDt      = 0;
	self.acTurn2Outside       = false;
	self.acDirectionBeforeTurn = {};
	self.acCollidingVehicles   = {};
	self.acCollidingCombines   = {};
	self.acTurnStageSent       = 0;

	self.acI3D = getChild(Utils.loadSharedI3DFile("AutoCombine.i3d", AcDirectory),"AutoCombine");
	
	self.acBackTrafficCollisionTrigger   = getChild(self.acI3D,"backCollisionTrigger");
	self.acOtherCombineCollisionTriggerL = getChild(self.acI3D,"otherCombColliTriggerL");
	self.acOtherCombineCollisionTriggerR = getChild(self.acI3D,"otherCombColliTriggerR");
	self.acBorderDetected = nil;	
	self.acFruitsDetected = nil;
	
  self.acAutoRotateBackSpeedBackup = self.autoRotateBackSpeed;	

	self.acRefNode = self.aiTreshingDirectionNode;

	if      self.articulatedAxis ~= nil 
			and self.articulatedAxis.componentJoint ~= nil
      and self.articulatedAxis.componentJoint.jointNode ~= nil 
			and self.articulatedAxis.rotMax then	
		self.acRefNode = self.components[self.articulatedAxis.componentJoint.componentIndices[2]].node;
	end;

end;

function AutoCombine:initMogliHud()
	if self.acMogliInitDone then
		return
	end
	self.acMogliInitDone = true

	Mogli.init( self, AcDirectory, "AutoCombineHud", "AutoCombineHud.dds",  "AC_COMBINE_TEXTHELPPANELON", "AC_COMBINE_TEXTHELPPANELOFF", InputBinding.AC_COMBINE_HELPPANEL, 0.395, 0.0108, 5, 3, AutoCombine.sendParameters, 0.03, 0.04 )
	Mogli.setTitle( self, "AC_COMBINE_VERSION" )
	
	Mogli.addButton(self, "off.dds",            "on.dds",           AutoCombine.onStart,       AutoCombine.evalStart,     1,1, "HireEmployee", "DismissEmployee", nil, AutoCombine.getStartImage );
	
	Mogli.addButton(self, "no_wait.dds",        "wait.dds",         AutoCombine.setWait,       AutoCombine.evalWait,      2,1, "AC_COMBINE_WAITMODE_OFF", "AC_COMBINE_WAITMODE_ON" );	
	Mogli.addButton(self, "inactive_left.dds",  "active_left.dds",  AutoCombine.setAreaLeft,   AutoCombine.evalAreaLeft,  3,1, "AC_COMBINE_TXT_ACTIVESIDERIGHT", "AC_COMBINE_TXT_ACTIVESIDELEFT" );
	Mogli.addButton(self, "inactive_right.dds", "active_right.dds", AutoCombine.setAreaRight,  AutoCombine.evalAreaRight, 4,1, "AC_COMBINE_TXT_ACTIVESIDELEFT", "AC_COMBINE_TXT_ACTIVESIDERIGHT" );
	Mogli.addButton(self, "next.dds",           "no_next.dds",      AutoCombine.nextTurnStage, AutoCombine.evalTurnStage, 5,1, "AC_COMBINE_TXT_NEXTTURNSTAGE", nil );
	                            
	Mogli.addButton(self, "ai_combine.dds",     "auto_combine.dds", AutoCombine.onEnable,      AutoCombine.evalEnable,    1,2, "AC_COMBINE_TXT_STOP", "AC_COMBINE_TXT_START" );
	Mogli.addButton(self, "no_distance.dds",    "distance.dds",     AutoCombine.setOtherCombine,AutoCombine.evalOtherCombine, 2,2, "AC_COMBINE_COLLISIONTRIGGERMODE_OFF", "AC_COMBINE_COLLISIONTRIGGERMODE_ON" );	
	Mogli.addButton(self, "no_uturn2.dds",      "uturn.dds",        AutoCombine.setUTurn,     AutoCombine.evalUTurn,      3,2, "AC_COMBINE_UTURN_OFF", "AC_COMBINE_UTURN_ON") ;
	Mogli.addButton(self, "reverse.dds",        "no_reverse.dds",   AutoCombine.setNoReverse, AutoCombine.evalNoReverse,  4,2, "AC_COMBINE_REVERSE_ON", "AC_COMBINE_REVERSE_OFF");
--Mogli.addButton(self, "no_cp.dds",          "cp.dds",           AutoCombine.setCPSupport, AutoCombine.evalCPSupport,  5,2, "AC_COMBINE_TXT_CP_OFF", "AC_COMBINE_TXT_CP_ON" );

	Mogli.addButton(self, "bigger.dds",         nil,                AutoCombine.setWidthUp,   nil, 1,3, "AC_COMBINE_WIDTH_OFFSET", nil, AutoCombine.getWidth);
	Mogli.addButton(self, "smaller.dds",        nil,                AutoCombine.setWidthDown, nil, 2,3, "AC_COMBINE_WIDTH_OFFSET", nil, AutoCombine.getWidth);
	Mogli.addButton(self, "forward.dds",        nil,                AutoCombine.setForward,   nil, 3,3, "AC_COMBINE_TURN_OFFSET", nil, AutoCombine.getTurnOffset);
	Mogli.addButton(self, "backward.dds",       nil,                AutoCombine.setBackward,  nil, 4,3, "AC_COMBINE_TURN_OFFSET", nil, AutoCombine.getTurnOffset);
	Mogli.addButton(self, "auto_steer_off.dds", "auto_steer_on.dds",AutoCombine.onAutoSteer,  AutoCombine.evalAutoSteer, 5,3, "AC_AUTO_STEER_ON", "AC_AUTO_STEER_OFF", nil, AutoCombine.getAutoSteerImage );
	
end

------------------------------------------------------------------------
-- draw
------------------------------------------------------------------------
function AutoCombine:draw()

	if self.acMogliInitDone then
		Mogli.draw(self,self.acLCtrlPressed);
	elseif self.acLCtrlPressed == nil or not self.acLCtrlPressed then
		g_currentMission:addHelpButtonText(Mogli.getText("AC_COMBINE_TEXTHELPPANELON"), InputBinding.AC_COMBINE_HELPPANEL);
	end

	if self.acLCtrlPressed then
		if      not self.isAIThreshing 
				and self.allowsThreshing or self:canStartAIThreshing() then
			if self.acTurnStage >= 97 then
				g_currentMission:addHelpButtonText(Mogli.getText("AC_AUTO_STEER_OFF"),InputBinding.AC_AUTO_STEER);
			else
				g_currentMission:addHelpButtonText(Mogli.getText("AC_AUTO_STEER_ON"), InputBinding.AC_AUTO_STEER);
			end
		end
		if self.acParameters.enabled then
			g_currentMission:addHelpButtonText(Mogli.getText("AC_COMBINE_TXT_START"), InputBinding.AC_COMBINE_ENABLE)
		else
			g_currentMission:addHelpButtonText(Mogli.getText("AC_COMBINE_TXT_STOP"), InputBinding.AC_COMBINE_ENABLE)
		end
	else
		if self.acParameters.enabled or self.acTurnStage >= 97 then
			if self.acParameters.rightAreaActive then
				g_currentMission:addHelpButtonText(Mogli.getText("AC_COMBINE_TXT_ACTIVESIDERIGHT"), InputBinding.AC_COMBINE_SWAP_SIDE)
			else
				g_currentMission:addHelpButtonText(Mogli.getText("AC_COMBINE_TXT_ACTIVESIDELEFT"), InputBinding.AC_COMBINE_SWAP_SIDE)
			end
		end
	end
end;

------------------------------------------------------------------------
-- onLeave
------------------------------------------------------------------------
function AutoCombine:onLeave()
	if self.acMogliInitDone then
		Mogli.onLeave(self);
	end
end;

------------------------------------------------------------------------
-- onEnter
------------------------------------------------------------------------
function AutoCombine:onEnter()
	if self.acMogliInitDone then
		Mogli.onEnter(self);
	end
end;

------------------------------------------------------------------------
-- mouseEvent
------------------------------------------------------------------------
function AutoCombine:mouseEvent(posX, posY, isDown, isUp, button)
	if self.isEntered and self.isClient and self.acMogliInitDone then
		Mogli.mouseEvent(self, posX, posY, isDown, isUp, button);	
	end
end

------------------------------------------------------------------------
-- delete
------------------------------------------------------------------------
function AutoCombine:delete()
	if self.acMogliInitDone then
		Mogli.delete(self)
	end
end;

------------------------------------------------------------------------
-- mouse event callbacks
------------------------------------------------------------------------
function AutoCombine.showGui(self,on)
	if on then
		if self.acMogliInitDone == nil or not self.acMogliInitDone then
			AutoCombine.initMogliHud(self)
		end
		Mogli.showGui(self,true)
	elseif self.acMogliInitDone then
		Mogli.showGui(self,false)
	end
end;

function AutoCombine:evalUTurn()
	return not self.acParameters.upNDown;
end;

function AutoCombine:setUTurn(enabled)
	self.acParameters.upNDown = enabled;
end;

function AutoCombine:evalWait()
	return not self.acParameters.waitMode;
end;

function AutoCombine:setWait(enabled)
	self.acParameters.waitMode = enabled;
end;

function AutoCombine:evalAreaLeft()
	return not self.acParameters.leftAreaActive;
end;

function AutoCombine:setAreaLeft(enabled)
	if not enabled then return; end;
	self.acParameters.leftAreaActive  = enabled;
	self.acParameters.rightAreaActive = not enabled;
end;

function AutoCombine:evalAreaRight()
	return not self.acParameters.rightAreaActive;
end;

function AutoCombine:setAreaRight(enabled)
	if not enabled then return; end;
	self.acParameters.rightAreaActive = enabled;
	self.acParameters.leftAreaActive  = not enabled;
end;

function AutoCombine:evalStart()
	return not self.isAIThreshing or not self:canStartAIThreshing();
end;

function AutoCombine:onStart(enabled)
  if self.isAIThreshing and not enabled then
    self:stopAIThreshing()
  elseif self:canStartAIThreshing() and enabled then
    self:startAIThreshing()
  end
end;

function AutoCombine:getStartImage()
	if self.isAIThreshing then
		return "on.dds"
	elseif self:canStartAIThreshing() then
		return "off.dds"
	end
	return "empty.dds"
end

function AutoCombine:evalEnable()
	return not self.acParameters.enabled;
end;

function AutoCombine:onEnable(enabled)
	if not self.isAIThreshing then
		self.acParameters.enabled = enabled;
	end;
end;

function AutoCombine:evalOtherCombine()
	return not self.acParameters.otherCombine;
end;

function AutoCombine:setOtherCombine(enabled)
	self.acParameters.otherCombine = enabled;
end;

function AutoCombine:evalNoReverse()
	return not self.acParameters.noReverse;
end;

function AutoCombine:setNoReverse(enabled)
	self.acParameters.noReverse = enabled;
end;

function AutoCombine:setWidthUp()
	self.acParameters.widthOffset = self.acParameters.widthOffset + 0.125;
	self.acDimensions = nil;
end;

function AutoCombine:setWidthDown()
	self.acParameters.widthOffset = self.acParameters.widthOffset - 0.125;
	self.acDimensions = nil;
end;

function AutoCombine:getWidth(old)
	new = string.format(old..": %0.2fm",self.acParameters.widthOffset+self.acParameters.widthOffset);
	return new
end

function AutoCombine:setForward()
	self.acParameters.turnOffset = self.acParameters.turnOffset + 0.25;
	self.acDimensions = nil;
end;                                               

function AutoCombine:setBackward()               
	self.acParameters.turnOffset = self.acParameters.turnOffset - 0.25;
	self.acDimensions = nil;
end;

function AutoCombine:getTurnOffset(old)
	new = string.format(old..": %0.2fm",self.acParameters.turnOffset);
	return new
end

function AutoCombine:evalTurnStage()
	if self.acParameters.enabled then
		if     self.acTurnStage == 2 
				or self.acTurnStage == 12
				or self.acTurnStage == 15
				or self.acTurnStage == 17
				or self.acTurnStage == 18 then
			return true
		end
--	else
--		if self.turnStage > 0 and self.turnStage < 4 then
--			return true;
--		end
	end
	
	return false
end

function AutoCombine:nextTurnStage()
	AutoCombine.setNextTurnStage(self);
end

function AutoCombine:evalCPSupport()
	return not self.acParameters.CPSupport;
end

function AutoCombine:setCPSupport(enabled)
	self.acParameters.CPSupport = enabled;
end

function AutoCombine:getAutoSteerImage()
	if self.acTurnStage >= 97 then
		return "auto_steer_on.dds"
	elseif not self.isAIThreshing and self:canStartAIThreshing() then
		return "auto_steer_off.dds"
	end
	return "empty.dds"
end

function AutoCombine:evalAutoSteer()
	return self.isAIThreshing or self.acTurnStage < 97 or not ( self:canStartAIThreshing() )
end

function AutoCombine:onAutoSteer(enabled)
	if self.isAIThreshing then
		if self.acTurnStage >= 97 then
			self.acTurnStage   = 0
		end
	elseif self.canStartAIThreshing ~= nil and enabled then
		if self:canStartAIThreshing() then
			self:startThreshing()
		end
		self.setAIImplementsMoveDown(self,true);
		self.acTurnStage   = 98
		self.acRotatedTime = 0
	else
		if self.acTurnStage >= 97 then
			self:stopThreshing()
		end
		self.acTurnStage   = 0
    self.stopMotorOnLeave = true
    self.deactivateOnLeave = true
	end
end

------------------------------------------------------------------------
-- courseplay
------------------------------------------------------------------------
function AutoCombine.cpInvertSide(string)
	if     string == "left"  then
		return "right";
	elseif string == "right" then
		return "left";
	end
	return nil;
end
		
local oldCourseplaySide_to_drive = nil;
function AutoCombine.cpSideToDrive(self, _self, combine, distance,switchSide)

	if oldCourseplaySide_to_drive == nil then return "none" end
	
	if     combine.acParameters == nil 
			or combine.acParameters.enabled == nil 
			or not combine.acParameters.enabled 
			or combine.acParameters.CPSupport == nil
			or not combine.acParameters.CPSupport
			or not combine.isAIThreshing then
		return oldCourseplaySide_to_drive(self, _self, combine, distance,switchSide)
	end
	
	if combine.cp.forcedSide ~= nil then
		return oldCourseplaySide_to_drive(self, _self, combine, distance,switchSide)
	end

	local tractor = combine
	if courseplay.isAttachedCombine(self, combine) then
		tractor = combine.attacherVehicle
	end
	
	if tractor.drive then
		return oldCourseplaySide_to_drive(self, _self, combine, distance,switchSide)
	end

	if combine.acParameters.leftAreaActive then
		fruitSide = "right"
	else
		fruitSide = "left"
	end

	if switchSide then
		if     combine.acTurnStage >=  1 and combine.acTurnStage <= 10 then
			--_self.sideToDrive = fruitSide
			_self.sideToDrive = AutoCombine.cpInvertSide( fruitSide );
		elseif combine.acTurnStage >= 11 and combine.acTurnStage <= 19 then
			fruitSide         = AutoCombine.cpInvertSide( fruitSide )
			_self.sideToDrive = fruitSide;
		else
			_self.sideToDrive = AutoCombine.cpInvertSide( fruitSide );
		end
	else
		_self.sideToDrive = AutoCombine.cpInvertSide( fruitSide );
	end
	
	courseplay.debug(self,string.format("AutoCombine.lua(%i): %s: turn stage %i, switch side is %s, fruit side is %s, side to drive is %s", debug.getinfo(1).currentline, tostring(combine.name), combine.acTurnStage, tostring(switchSide), fruitSide, _self.sideToDrive),2);
	
	return fruitSide;
end

------------------------------------------------------------------------
-- keyEvent
------------------------------------------------------------------------
function AutoCombine:keyEvent(unicode, sym, modifier, isDown)
	
--if isDown and sym == Input.KEY_s then
--	self.speed2Level = 0;
--	AutoCombine.setInt32Value( self, "speed2Level", 0 )
--end;	
	if isDown and sym == Input.KEY_lctrl then
		self.acLCtrlPressed = true
	else
		self.acLCtrlPressed = false
	end
end;

------------------------------------------------------------------------
-- update
------------------------------------------------------------------------
function AutoCombine:update(dt)

	if self.isEntered and self.isClient and self:getIsActive() then
		if     InputBinding.hasEvent(InputBinding.AC_COMBINE_ENABLE) then
			AutoCombine.onEnable( self, not self.acParameters.enabled )
		elseif InputBinding.hasEvent(InputBinding.AC_AUTO_STEER) then
			if self.acTurnStage < 97 then
				AutoCombine.onAutoSteer(self, true)
			else
				AutoCombine.onAutoSteer(self, false)
			end
		elseif InputBinding.hasEvent(InputBinding.AC_COMBINE_SWAP_SIDE) then
			self.acParameters.leftAreaActive  = not self.acParameters.leftAreaActive;
			self.acParameters.rightAreaActive = not self.acParameters.rightAreaActive;
			AutoCombine.sendParameters(self);
		elseif InputBinding.hasEvent(InputBinding.AC_COMBINE_HELPPANEL) then
			AutoCombine.showGui( self, not self.mogliGuiActive );
		end
	end;
	
	if math.abs(self.axisSide) > 0.1 and self.acTurnStage >= 97 then
		self.acTurnStage = 97
	elseif self.acTurnStage == 97 then
		self.acTurnStage = 98
	end
	
	if self.acTurnStage >= 97 then
    self.stopMotorOnLeave = false
    self.deactivateOnLeave = false
	end
	
	if self.mogliGuiActive or self.acParameters.enabled then
		if not self.acNodeIsLinked then
			AutoCombine.calculateDimensions(self);	
			self.acNodeIsLinked = true;
			link(self.acRefNode,self.acI3D);
		end;
	end;

	if      self.mogliGuiActive
			and not self.isAIThreshing
			and self:getIsActiveForInput(false) 
			and self.acParameters.enabled then
			
		AutoCombine.calculateDimensions(self);	
		if self.acDimensions ~= nil then				
			local a,n,l,d = 0,0,4,0;
			for _,wheel in pairs(self.wheels) do
				if wheel.rotSpeed < -1E-03 then
					a = a - wheel.steeringAngle;
					n = n + 1;
				end;
			end
			
			if n > 1 then a = a / n end;		
			if not self.acParameters.leftAreaActive then a = -a; end;
			if     a < -self.acDimensions.maxSteeringAngle then a = -self.acDimensions.maxSteeringAngle
			elseif a >  self.acDimensions.maxLookingAngle  then a =  self.acDimensions.maxLookingAngle end;
			
			d = AutoCombine.calculateWidth(self,l,a);
			if not self.acParameters.leftAreaActive then d = -d; end;
			
			local x0,y0,z0,x1,y1,z1;
			x1,y1,z1 = localDirectionToWorld( self.acRefNode, d,0,l) ;
			
			--x0,y0,z0 = getWorldTranslation(lm);
			x0,y0,z0 = localToWorld( self.acRefNode, self.acDimensions.xLeft,0.25,self.acDimensions.zLeft );
				
			drawDebugArrow(x0,y0,z0,x1,0,z1,x1,0,z1,1,0,0);
			drawDebugArrow(x0,y0+1,z0,x1,0,z1,x1,0,z1,1,0,0);
			drawDebugArrow(x0,y0+1,z0,0,-1,0,0,-1,0,1,0,0);

			--x0,y0,z0 = getWorldTranslation(rm);
			x0,y0,z0 = localToWorld( self.acRefNode, self.acDimensions.xRight,0.25,self.acDimensions.zRight );
				
			drawDebugArrow(x0,y0,z0,x1,0,z1,x1,0,z1,1,0,0);
			drawDebugArrow(x0,y0+1,z0,x1,0,z1,x1,0,z1,1,0,0);
			drawDebugArrow(x0,y0+1,z0,0,-1,0,0,-1,0,1,0,0);
		end;
	end;

	if      self.acParameters          ~= nil
			and oldCourseplaySide_to_drive == nil
			and courseplay                 ~= nil 
			and courseplay.side_to_drive   ~= nil
			and ( courseplay.versionFlt    == nil 
			   or courseplay.versionFlt    <= 3.41 ) then
		oldCourseplaySide_to_drive = courseplay.side_to_drive;
		courseplay.side_to_drive   = AutoCombine.cpSideToDrive;
		print("AutoCombine was added to CoursePlay v"..tostring(courseplay.version));
	end

end;

------------------------------------------------------------------------
-- AICombine:updateTick
------------------------------------------------------------------------
local oldAICombineUpdateTick = AICombine.updateTick;
AICombine.updateTick = function(self,dt)

	self.mogliInfoText = ""
	
  if      self.isServer
			and self.isAIThreshing 
			and self.acParameters ~= nil
			and self.acParameters.waitMode 
			and self.capacity > 0
			and self.fillLevel > 0.1 * self.capacity 
			and not self.waitingForDischarge 
			and next(self.overloadingTrailersInRange) ~= nil 
			then		
    self.driveBackAfterDischarge = true
    self.waitingForDischarge     = true
    self.waitForDischargeTime    = g_currentMission.time + self.waitForDischargeTimeout
	end;
	
	if self.driveBackAfterDischarge then
	  self.driveBackTime = g_currentMission.time + self.driveBackTimeout
	end
	
  oldAICombineUpdateTick(self,dt);

	if self.acParameters == nil or self.acParameters.enabled == nil or not self.acParameters.enabled then
		return
	end
	
	if self.isAIThreshing then
		self.realForceAiDriven = true
	end
	
	if      not self.isAIThreshing 
			and self.lastValidInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN
			and self.acTurnStage >= 98 then
		AutoCombine.autoSteer(self,dt)
	end
	
	if self.acDimensions == nil then
		self.acRecalculateDt = 0
	else
		self.acRecalculateDt = self.acRecalculateDt + dt
		if self.acTurnStage == 0 and self.acRecalculateDt > 60000 then
			self.acRecalculateDt = 0
			self.acDimensions    = nil;
		end
	end
		
	if self.isServer then
		if self.acParameters.otherCombine then	
			AutoCombine.addOtherCombineCollisionTrigger(self);
		else
			AutoCombine.removeOtherCombineCollisionTrigger(self);
		end
	end		
	
	if self.acTurnStageSent ~= self.acTurnStage then
		AutoCombine.setInt32Value( self, "turnStage", self.acTurnStage )
	end

	if      self.mogliGuiActive
			and self:getIsActive()  
			and ( self.mogliInfoText == nil or self.mogliInfoText == "" ) then
		local workWidth = 0;
		if self.acDimensions == nil or self.acDimensions.distance == nil then
			local lm, rm = AutoCombine.getMarker(self);
			if lm ~= nil then
				workWidth,_,_ = AutoCombine.getRelativeTranslation( self.aiTreshingDirectionNode, lm );
			end;
			if rm ~= nil then
				x,_,_ = AutoCombine.getRelativeTranslation( self.aiTreshingDirectionNode, rm );
				workWidth = workWidth - x;
			end
			workWidth = workWidth - AutoCombine.getAreaOverlap(self,workWidth);	
			workWidth = workWidth + self.acParameters.widthOffset + self.acParameters.widthOffset;
		else
			workWidth = self.acDimensions.distance + self.acDimensions.distance;
		end
		self.mogliInfoText = string.format(Mogli.getText("AC_COMBINE_TXT_WORKWIDTH").." %0.2fm",workWidth)
		if self.acParameters.enabled and self.isAIThreshing and self.acTurnStage ~= 0 then
			self.mogliInfoText = self.mogliInfoText .. string.format(" (%i)",self.acTurnStage)
		end
	end

	if not ( ( self.isAIThreshing and self.acParameters.enabled )
				or self.acTurnStage>= 98 ) then
		AutoCombine.setStatus( self, 0 )
	end
end

------------------------------------------------------------------------
-- attachImplement
------------------------------------------------------------------------
function AutoCombine:attachImplement(implement)
	self.acDimensions = nil;
end;

------------------------------------------------------------------------
-- detachImplement
------------------------------------------------------------------------
function AutoCombine:detachImplement(implementIndex)
	self.acDimensions = nil;
end;

------------------------------------------------------------------------
-- AICombine:canStartAIThreshing
------------------------------------------------------------------------
local oldAICombineCanStartAIThreshing = AICombine.canStartAIThreshing;
function AICombine:canStartAIThreshing()

	if self.acParameters == nil or not ( self.acParameters.enabled ) then
		return oldAICombineCanStartAIThreshing(self);
	elseif not ( self.numAttachedTrailers > 0 
					 and self.acParameters.upNDown
					 and self.acParameters.noReverse ) then
		return oldAICombineCanStartAIThreshing(self);
	elseif g_currentMission.disableCombineAI 
			or Hirable.numHirablesHired >= g_currentMission.maxNumHirables then
    return false
  end
  return true
end

------------------------------------------------------------------------
-- AICombine:getIsAIThreshingAllowed
------------------------------------------------------------------------
local oldAICombineGetIsAIThreshingAllowed = AICombine.getIsAIThreshingAllowed;
AICombine.getIsAIThreshingAllowed = function(self)

	if self.acParameters == nil or not ( self.acParameters.enabled ) then
		return oldAICombineGetIsAIThreshingAllowed(self);
	elseif not ( self.numAttachedTrailers > 0 
					 and self.acParameters.upNDown
					 and self.acParameters.noReverse ) then
		return oldAICombineGetIsAIThreshingAllowed(self);
	elseif g_currentMission.disableCombineAI 
			or Hirable.numHirablesHired >= g_currentMission.maxNumHirables then
    return false
  end
  return true
end


------------------------------------------------------------------------
-- AICombine:startAIThreshing
------------------------------------------------------------------------
--local oldAICombineStartAIThreshing = AICombine.startAIThreshing;
--AICombine.startAIThreshing = function(self, noEventSend)
	
function AutoCombine:startAIThreshing(noEventSend)
	-- just to be safe...
	if self.acParameters ~= nil and self.acParameters.enabled then
		self.realForceAiDriven = true
		self.acDimensions  = nil;
		self.acTurnStage   = 22;
		self.turnTimer     = self.acDeltaTimeoutWait;
		self.aiRescueTimer = self.acDeltaTimeoutStop;
		self.waitForTurnTime = 0;
		
	--if self.speed2Level == nil or self.speed2Level < 1 or self.speed2Level > 4 then
	--	self.speed2Level = 2
	--	for cutter, implement in pairs(self.attachedCutters) do
	--		if Cutter.getUseLowSpeedLimit(cutter) then
	--			self.speed2Level = 1
	--		end
	--	end
	--end
		
		AutoCombine.sendParameters(self);

		AutoCombine.addBackTrafficCollisionTrigger(self);
		
		for _, implement in pairs(self.attachedImplements) do
			if     implement.object.attacherJoint.jointType  == Vehicle.JOINTTYPE_TRAILERLOW
					or implement.object.attacherJoint.jointType  == Vehicle.JOINTTYPE_TRAILER then
				self.acParameters.noReverse = true
			end
		end

		AutoCombine.sendParameters(self);
	end

--	return oldAICombineStartAIThreshing(self, noEventSend);
end;

------------------------------------------------------------------------
-- AICombine:stopAIThreshing
------------------------------------------------------------------------
--local oldAICombineStopAIThreshing = AICombine.stopAIThreshing;
--AICombine.stopAIThreshing = function(self, noEventSend)

function AutoCombine:stopAIThreshing(noEventSend)
	if self.acParameters ~= nil and self.acParameters.enabled then
		self.realForceAiDriven = false
		AutoCombine.removeBackTrafficCollisionTrigger(self);
	end
--	return oldAICombineStopAIThreshing(self, noEventSend);
end;

function AutoCombine:getFruitArea(x1,z1,x2,z2,d,fruitType,hasFruitPreparer)
	local lx1,lz1,lx2,lz2,lx3,lz3 = AutoCombine.getParallelogram( self, x1, z1, x2, z2, d );
	return Utils.getFruitArea(fruitType, lx1,lz1,lx2,lz2,lx3,lz3, hasFruitPreparer);
end

function AutoCombine:isField(x1,z1,x2,z2)
	local lx1,lz1,lx2,lz2,lx3,lz3 = AutoCombine.getParallelogram( self, x1, z1, x2, z2, 0 );

	for i=0,3 do
		if Utils.getDensity(g_currentMission.terrainDetailId, i, lx1,lz1,lx2,lz2,lx3,lz3) ~= 0 then
			return true;
		end;
	end;

	return false;
	
end

------------------------------------------------------------------------
-- setStatus
------------------------------------------------------------------------
function AutoCombine:setStatus( newStatus )
	
	if self.mogliStatus == nil or self.mogliStatus ~= newStatus then
		AutoCombine.setInt32Value( self, "status", Utils.getNoNil( newStatus, 0 ) )
	end
	
end

------------------------------------------------------------------------
-- AICombine:updateAIMovement
------------------------------------------------------------------------
local oldAICombineUpdateAIMovement = AICombine.updateAIMovement;
AICombine.updateAIMovement = function(self, dt)

	if self.acParameters == nil or self.acParameters.enabled == nil or not self.acParameters.enabled then
		return oldAICombineUpdateAIMovement(self,dt);
	end;

  if not self:getIsAIThreshingAllowed() then
    self:stopAIThreshing()
    return
  end
  if not self.isControlled then
    if g_currentMission.environment.needsLights then
      self:setLightsVisibility(true)
    else
      self:setLightsVisibility(false)
    end
  end
  local allowedToDrive = true
  if self.capacity == 0 then
    if not self.pipeStateIsUnloading[self.currentPipeState] then
			AutoCombine.setStatus( self, 0 )
      allowedToDrive = false
    elseif  self.lastValidFillType   ~= FruitUtil.FRUITTYPE_UNKNOWN
				and ( ( self.lastArea        ~= nil and self.lastArea        > 0 )		
				   or ( self.lastCuttersArea ~= nil and self.lastCuttersArea > 0 ) ) then	
			self.waitingForTrailerToUnload = true
		end
  elseif self.fillLevel >= 0.99*self.capacity then
		AutoCombine.setStatus( self, 0 )
    allowedToDrive = false
  end
  if self.waitingForTrailerToUnload then
    do
      local trailer = self:findTrailerToUnload(self.lastValidFillType)
      if trailer ~= nil then
        self.waitingForTrailerToUnload = false
      end
    end
  end
  if self.fillLevel >= 0.99*self.capacity and self.capacity > 0 or self.waitingForTrailerToUnload or self.waitingForDischarge or self.acIsCPStopped then
		self.acIsCPStopped = false;
		AutoCombine.setStatus( self, 0 )
    allowedToDrive     = false;
  end
  for _, v in pairs(self.numCollidingVehicles) do
    if v > 0 then
			self.mogliInfoText = Mogli.getText("AC_COMBINE_COLLISION_OTHER");
			AutoCombine.setStatus( self, 3 )
      allowedToDrive = false
      break
    end
  end
	if self.acParameters.otherCombine then
		for _, v in pairs(self.acCollidingCombines) do
			if v > 0 then
				self.mogliInfoText = Mogli.getText("AC_COMBINE_COLLISION_OTHER");
				AutoCombine.setStatus( self, 3 )
				allowedToDrive = false
				break
			end
		end
	end
	
	if self.acParameters.CPSupport then
	elseif self.acTurnStage == 2 or self.acTurnStage == 18 then
		for _, v in pairs(self.acCollidingVehicles) do
			if v > 0 then
				self.mogliInfoText = Mogli.getText("AC_COMBINE_COLLISION_BACK");
				AutoCombine.setStatus( self, 3 )
				allowedToDrive = false
				break
			end
		end
	end
	
	local moveForwards = true;
	local noBreaking   = false
	
  local speedLevel = self.acParameters.speed
	if speedLevel == 0 then
		AutoCombine.setStatus( self, 0 )	
	end
	
  if not self:getIsThreshingAllowed(true) then
    AutoCombine.setStatus( self, 0 )
		allowedToDrive = false
    self:stopThreshing(false)
    self.waitingForWeather = true
  elseif self.waitingForWeather then
    if self.acTurnStage == 0 or self.acTurnStage >= 20 then
      self.driveBackTime = g_currentMission.time + self.driveBackTimeout
    end
    self:startThreshing()
    self.waitingForWeather = false
  end
	
  if not allowedToDrive or speedLevel == 0 then
		AIVehicleUtil.driveInDirection(self, dt, 30, 0, 0, 28, false, moveForwards, nil, nil)
    return
  end

  if self.driveBackTime ~= nil and self.driveBackTime > g_currentMission.time then
    local x, y, z = getWorldTranslation(self.aiTreshingDirectionNode)
    local lx, lz = AIVehicleUtil.getDriveDirection(self.aiTreshingDirectionNode, self.aiThreshingTargetX, y, self.aiThreshingTargetZ)
		AIVehicleUtil.driveInDirection(self, dt, 30, 0, 0, 28, true, false, nil, nil, speedLevel, 1)
    return
  end

  local hasFruitPreparer = false
  local fruitType = self.lastValidInputFruitType

--==============================================================				
-- find fruit type if cutter supports only one
	if self.acTurnStage == 22 and fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
		local found = nil;
		for cutter, implement in pairs(self.attachedCutters) do
			for i,f in pairs(cutter.fruitTypes) do
				if f and i>0 then
					if fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
						found = true;
						fruitType = i;
					elseif fruitType ~= i then
						found = false;
						break;
					end
				end
			end
		end
		
		if found == nil or not found then
			fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
		end
	end

-- find fruit type looking ahead
	if self.acTurnStage == 22 and fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
		AutoCombine.calculateDimensions(self);
		d = - self.acDimensions.distance - self.acDimensions.distance;
		if not self.acParameters.leftAreaActive then d = -d; end;

		for cutter, implement in pairs(self.attachedCutters) do
			for i,f in pairs(cutter.fruitTypes) do
				if f and i>0 then
					if AutoCombine.getFruitArea( self, 0, -1, d, 10, 0, i, false ) > 0 then
						fruitType = i;
						break;
					end
				end
			end
			if fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then break end
		end
	end
	
  if self.fruitPreparerFruitType ~= nil and self.fruitPreparerFruitType == fruitType then
    hasFruitPreparer = true
  end

	local angle = 0;
	self.acBorderDetected = false;
	self.turnTimer = self.turnTimer - dt;
	
	if self.acTurnStage ~= 0 then
		if self.aiRescueTimer < 0 then
			self:stopAIThreshing();
			return;
		end;
		self.aiRescueTimer = self.aiRescueTimer - dt;
	else
		self.aiRescueTimer = self.acDeltaTimeoutStop;
	end
	
--==============================================================				
-- calculate...		
	if fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
		self.setAIImplementsMoveDown(self,true);
		AutoCombine.setStatus( self, 2 )
	else
		AutoCombine.calculateDimensions(self);
	
		local offsetOutside = 0;
		if     self.acParameters.rightAreaActive then
			offsetOutside = -1;
		elseif self.acParameters.leftAreaActive then
			offsetOutside = 1;
		end;
			
		self.mogliInfoText = "";				
		
		local d, lookAhead = 0,10;							
		local border;	
		local aaDiffX, aaDiffZ = 0,0;
		
--==============================================================				
		self.acFruitsDetected = false;
		
		if     self.acTurnStage == 17 then -- and self.acParameters.noReverse then
			d = - self.acDimensions.distance - self.acDimensions.distance;
			if not self.acParameters.leftAreaActive then d = -d; end;
			self.acFruitsDetected = AutoCombine.getFruitArea( self, 0, -2, d, 2, 0, fruitType, hasFruitPreparer ) > 0;
		elseif self.acTurnStage == 2 then --or self.acTurnStage == 18 then
			local w = math.max( 2, math.min( 1.4 * self.acDimensions.distance, 0.7 * (self.acDimensions.cutterDistance + self.acDimensions.wheelBase) ) );
			if self.acTurn2Outside then		
				d = - self.acDimensions.distance;
			else
				d = - 2 * self.acDimensions.distance
			end
			if not self.acParameters.leftAreaActive then d = -d; end;
			self.acFruitsDetected = AutoCombine.getFruitArea( self, 0, -w, d, w, 0, fruitType, hasFruitPreparer ) > 0;
		elseif self.acTurnStage == 11 or self.acTurnStage == 15 then
			d = self.acDimensions.distance + self.acDimensions.distance;
			self.acFruitsDetected = AutoCombine.getFruitArea( self, -self.acDimensions.distance, 0, d, 1, 0, fruitType, hasFruitPreparer ) > 0;		
		elseif self.acTurnStage == 0 or self.acTurnStage >= 20 then
			d = self.acDimensions.distance + self.acDimensions.distance;
			d = - math.max( 0.9 * d, d - 1 );
			if not self.acParameters.leftAreaActive then d = -d; end;
			self.acFruitsDetected = AutoCombine.getFruitArea( self, 0, -2, d, 3, 0, fruitType, hasFruitPreparer ) > 0;		
		end;		

--==============================================================				
		if self.acTurnStage == 0 or self.acTurnStage >= 20 then
-- look 3 to 10 meters ahead				
			local found = self.acFruitsDetected;
			if self.acTurnStage == 0 then found = true end;
			
			local lmin = math.min( 5, 2    + math.max( 1, 0.6 * self.acDimensions.distance ) );
			local lmax = math.min(10, lmin + math.max( 2, math.floor( 0.6 * self.acDimensions.distance + 0.5 ) ) );

--			if found then
--				d = - self.acDimensions.distance - self.acDimensions.distance;
--				if not self.acParameters.leftAreaActive then d = -d; end;
--				while not AutoCombine.isField( self, 0, lmax, d, 1 ) do
--					lmax = lmax - 1;
--					if lmax < lmin then 
--						lmin = lmin - 1;
--						if lmin < 0.5 then
--							break
--						end
--					end
--				end
--			end
						
			lookAhead = lmin;
			while lookAhead < lmax do --10 do
				d = AutoCombine.calculateWidth(self,lookAhead-1,self.acDimensions.maxLookingAngle);
				local w = math.max(1, AutoCombine.calculateWidth(self,lookAhead-1,-self.acDimensions.maxSteeringAngle) + d );
				if not self.acParameters.leftAreaActive then 
					d = -d;
				else
					w = -w;
				end;
				if     not AutoCombine.isField( self, d, lookAhead, w, 1, 0 ) then
					break;
				elseif not found and AutoCombine.getFruitArea( self, d, lookAhead-1, w, 1, 0, fruitType, hasFruitPreparer ) > 0 then
					found = true;
				elseif found and ( lookAhead >= lmax or AutoCombine.getFruitArea( self, d, lookAhead-1, w, 1, 0, fruitType, hasFruitPreparer ) <= 0 ) then
					break;
				end;
				lookAhead = lookAhead + 1;
				if lookAhead > 10 then
					lookAhead = 10;
					break;
				end;
			end;
	

			if lookAhead < 0.5 then
				self.acFruitsDetected = false;		
				self.acBorderDetected = false;
				border                = 0;
			else
				angle        = 0;	
				border       = AutoCombine.getFruitArea( self, 0, 0, offsetOutside, lookAhead, 0, fruitType, hasFruitPreparer );
				local factor = 0.05;			
				if border <= 0 then
					factor = -factor;					
				elseif self.acDimensions.maxLookingAngle < self.acDimensions.maxSteeringAngle then
					factor = factor * self.acDimensions.maxLookingAngle / self.acDimensions.maxSteeringAngle
				end 
				
				for i=1,20 do
					local a = factor*i*self.acDimensions.maxSteeringAngle; 							
					d = AutoCombine.calculateWidth(self,lookAhead,a);
					if not self.acParameters.leftAreaActive then d = -d; end;
					if self.acDimensions.aaAngleFactor > 0 then
						aaDiffX = math.sin( self.acDimensions.aaAngleFactor * a ) * self.acDimensions.aaDistance;
						aaDiffZ = ( math.cos( self.acDimensions.aaAngleFactor * a ) - 1 ) * self.acDimensions.aaDistance;
						if not self.acParameters.leftAreaActive then aaDiffX = -aaDiffX; end;
					end

					b = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
					
					if     border > 0 then
						if b <= 0 then
							self.acBorderDetected = true;
							angle = a;
							break
						end
					else
						if b > 0 then
							self.acBorderDetected = true;
							break
						end
					end
					angle = a;
				end
			end
			
			if not self.acBorderDetected then
				if      self.acTurnStage              >= 20
						and self.acTurnStage              <= 21
						and self.acDirectionBeforeTurn.tx ~= nil
						and self.acDirectionBeforeTurn.tz ~= nil then
					angle = nil;			
				elseif border > 0 then
					angle = self.acDimensions.maxSteeringAngle;
					self.acTurn2Outside = true;
				else
					angle = -self.acDimensions.maxSteeringAngle;
					self.acTurn2Outside = false;
					if      self.acTurnStage == 0 
							and self.turnTimer  <= self.acDeltaTimeoutRun then
						local l = AutoCombine.getTraceLength(self);
						local a = math.deg(AutoCombine.getTurnAngle(self));
						if not self.acParameters.leftAreaActive then a = -a; end;
--						if      ( self.acParameters.upNDown or self.acDimensions.aaAngleFactor > 1E-6 )
--								and l >= self.acDimensions.distance + self.acDimensions.distance 
--								and a < -9 then
--							angle = 0;
--						elseif  l >= 1
--								and a < -30 then
--							angle = 0;
--						end
						if      l >= 1
								and a < -15 then
							angle = 0;
						end
					elseif  self.acTurnStage >= 21 
							and not self.acFruitsDetected then
						angle = 0;
					end
				end
			end
			
--==============================================================				
-- backwards
		elseif self.acTurnStage == 2 or self.acTurnStage == 18 then
			self.acBorderDetected = false

			local a, b2, at1, at2
			local offsetInside               = -offsetOutside			
			local fMin, fMax, fStep          = 0,1,0.1
			
			for l=18,3,-3 do
			if self.acTurn2Outside then
				angle = self.acDimensions.maxSteeringAngle
			else
				angle = -self.acDimensions.maxSteeringAngle
			end
			
			--for l=3,18,3 do
				local doBreak = false
				for f=fMin,fMax,fStep do
					a = f*self.acDimensions.maxLookingAngle; 	
					if not self.acTurn2Outside then a = -a end

					d = AutoCombine.calculateWidth(self,l,-a);
					if not self.acParameters.leftAreaActive then d = -d; end;

					border, at1 = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, l, d, fruitType, hasFruitPreparer );
					b2    , at2 = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetInside , l, d, fruitType, hasFruitPreparer );				
									
					if border < 1 and b2 > 0 then
						--print(tostring(l).." "..tostring(d).." "..tostring(offsetOutside).." "..tostring(math.deg(a)).." "..tostring(f))
						angle   = a
						--doBreak = true
						self.acBorderDetected = true;
						break;
					elseif self.acTurnStage == 2 then
						if     self.acTurn2Outside and border < 1 then
							angle = math.min( angle, a )
						elseif not self.acTurn2Outside and b2 > 0 then
							angle = math.max( angle, a )
						end
					end
				end
				if doBreak then
					break
				end			
			end
			
--==============================================================		
-- U turn		
		elseif self.acTurnStage == 17 then
			angle = self.acDimensions.maxLookingAngle;
			d = AutoCombine.calculateWidth(self,lookAhead,angle);
			if not self.acParameters.leftAreaActive then d = -d; end;
		
			border = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, -offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
			
			if border > 0 then
				border = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
				if border < 1 then
					self.acBorderDetected = true;						
				end
			end
--==============================================================		
-- 90° with dolly backwards
		elseif self.acTurnStage == 5 then
			if AutoCombine.getTurnDistance(self) > 20 then
				self.acBorderDetected = true
			elseif self.acTurn2Outside then		
				angle = self.acDimensions.maxLookingAngle;
				d = AutoCombine.calculateWidth(self,lookAhead,angle);
				if not self.acParameters.leftAreaActive then d = -d; end;
				border = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
				if border < 1 then
					self.acBorderDetected = true
				end
			else				
				local dist = self.acDimensions.radius + self.acDimensions.distance - self.acDimensions.cutterDistance

				self.acParameters.leftAreaActive = not self.acParameters.leftAreaActive
				border = AutoCombine.getFruitArea( self, aaDiffX, dist + aaDiffZ, - offsetOutside * ( self.acDimensions.distance + self.acDimensions.distance ), 1, 0, fruitType, hasFruitPreparer );
				self.acParameters.leftAreaActive = not self.acParameters.leftAreaActive
				
				if border > 0 then
					self.acBorderDetected = true					
				end
			end
			
--==============================================================		
-- 90° with dolly forwards
		elseif self.acTurnStage == 7 then
			if self.acTurn2Outside then				
				angle = self.acDimensions.maxLookingAngle;
			else
				angle = -self.acDimensions.maxLookingAngle;
			end;
			
			d = AutoCombine.calculateWidth(self,lookAhead,angle);
			if not self.acParameters.leftAreaActive then d = -d; end;
		
			if self.acTurn2Outside then
				border = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
				if border < 1 then
					self.acBorderDetected = true
				end
			else
				border = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, -offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
			
				if border > 0 then
					border = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
					if border < 1 then
						self.acBorderDetected = true;						
					end
				end
			end
		end;
		
--==============================================================		
--==============================================================		

		if angle == nil then
			local m = self.acDimensions.maxSteeringAngle;
			
			if self.acTrunStage == 21 then
				angle = 0;
			elseif self.acTurn2Outside then
				angle = m;
			else
				angle = -m;
			end
		
			if self.acDirectionBeforeTurn.tx ~= nil and self.acDirectionBeforeTurn.tz ~= nil then
				local x,z,dx,dz,wx,wz;
				if self.acParameters.leftAreaActive then
					x,_,z = localToWorld(self.acRefNode, self.acDimensions.xLeft, 0, self.acDimensions.zLeft );
				else
					x,_,z = localToWorld(self.acRefNode, self.acDimensions.xRight, 0, self.acDimensions.zRight);
				end			dx = self.acDirectionBeforeTurn.tx - x;
				dz = self.acDirectionBeforeTurn.tz - z;		
				wx,_,wz = worldDirectionToLocal(self.acRefNode,dx,0,dz);
				
			--print(tostring(wx)(wx).." "..tostring(wz))
				--if wz < 0 then wz = -wz end

				if wz > 0.1 then
					
					if not self.acParameters.leftAreaActive then wx = -wx; end;
					
					dmax = AutoCombine.calculateWidth(self,wz, self.acDimensions.maxLookingAngle);
					dmin = AutoCombine.calculateWidth(self,wz,-self.acDimensions.maxSteeringAngle);
						
					if wx > dmax then
						angle = m;
					elseif wx < dmin then
						angle = -m;
					else
						angle = AutoCombine.calculateSteeringAngle(self,wx,wz);
					end
					if self.acTurnStage < 20 and math.abs(wx) < 0.2 and wz > 4 then
						self.acBorderDetected = true;									
					end
				--print(tostring(wx)(math.deg(angle)))
				end
			end
		end

--==============================================================		
--==============================================================		
		local turnAngle = math.deg(AutoCombine.getTurnAngle(self));
		if self.acParameters.leftAreaActive then
			turnAngle = -turnAngle;
		end;
		--self.mogliInfoText = string.format("turn angle = %3i",turnAngle);

--==============================================================		
-- move far enough			
		if     self.acTurnStage == 1 then

			if AutoCombine.getTurnDistance(self) > 5 then
				angle = 0;
			elseif self.acParameters.CPSupport and turnAngle > 5 then
				angle = self.acDimensions.maxSteeringAngle;
			elseif turnAngle < -5 then
				angle = turnAngle
			else
				angle = 0;
			end

			--if self.acTurn2Outside or ( angle == 0 and AutoCombine.getTurnDistance(self) > self.acDimensions.insideDistance ) then

			local insideDistance = 5
			local factor         = 1
			if not self.acTurn2Outside and angle == 0 then			
				factor         = math.max( 0, math.cos( math.min( math.rad(turnAngle) + AutoCombine.getCorrectedMaxSteeringAngle(self), 0.5 * math.pi ) ) - 1 + math.sin( math.max( math.pi - math.rad(turnAngle) - AutoCombine.getCorrectedMaxSteeringAngle(self), 0 ) ) )
				insideDistance = math.max(0, self.acDimensions.cutterDistance - 1 - self.acDimensions.distance + ( self.acDimensions.radius * factor ) );				
			end 
			
			if self.acTurn2Outside or ( angle == 0 and AutoCombine.getTurnDistance(self) > insideDistance ) then
        --print(tostring(self.acDimensions.cutterDistance).." - 1 - "..tostring(self.acDimensions.distance).." + ( "..tostring(self.acDimensions.radius).." * "..tostring(factor)..")")
				--print(tostring(turnAngle).."; "..tostring(AutoCombine.getTurnDistance(self)).." > "..tostring(insideDistance))				
				self.setAIImplementsMoveDown(self,false);
				self.acTurnStage   = 4;
				self.turnTimer     = self.acDeltaTimeoutWait;
				allowedToDrive     = false;				
				self.waitForTurnTime = g_currentMission.time + self.turnTimer;
			end

--==============================================================				
-- wait before going back				
		elseif self.acTurnStage == 4 then
			allowedToDrive = false;				
			moveForwards   = false;					

			if self.acParameters.noReverse then
				angle = 0
			elseif self.acTurn2Outside then				
				angle = self.acDimensions.maxSteeringAngle;
			else
				angle = -self.acDimensions.maxSteeringAngle;
			end;
			
			--if self.turnTimer < 0 then
			if self.waitForTurnTime < g_currentMission.time then
				if self.acParameters.noReverse then
					self.acTurnStage = 5
				else
					self.acTurnStage = 2;
				end
				self.turnTimer     = self.acDeltaTimeoutStart;
			end;

--==============================================================				
-- going back
		elseif self.acTurnStage == 2 then

			moveForwards = false;					
		
			--if     ( ( turnAngle > 30 or self.acTurn2Outside ) 
			--		 and self.acBorderDetected 
			--		 and not self.acFruitsDetected ) 
			--		or ( self.turnTimer < 0 and math.abs( turnAngle ) > 90 ) 
			--		or AutoCombine.getTurnDistance(self) > 20 then
			if     AutoCombine.getTurnDistance(self) > 18
					or ( not self.acFruitsDetected
					 and ( self.acBorderDetected or ( self.turnTimer < 0 and math.abs( turnAngle ) > 90 ) ) ) 
					or ( self.acTurnStage == 2 and self.acTurn2Outside and self.acBorderDetected ) then
			--print(tostring(wx)(turnAngle).." "..tostring(self.acBorderDetected).." "..tostring(self.acFruitsDetected).." "..tostring(self.turnTimer).." "..tostring(AutoCombine.getTurnDistance(self)))
				self.acTurnStage   = 3;
				self.turnTimer     = self.acDeltaTimeoutWait;
				self.lastTurnAngle = angle;
				self.setAIImplementsMoveDown(self,true);
			end;

--==============================================================				
-- wait after going back					
		elseif self.acTurnStage == 3 then
			allowedToDrive = false;						
			
			angle = self.lastTurnAngle;
			
			if self.turnTimer < 0 then
				self.acTurnStage   = 20;					
				self.turnTimer     = self.acDeltaTimeoutStart;
			end;
			
--==============================================================				
-- going back
		elseif self.acTurnStage == 5 then

			moveForwards = false;				
			angle        = 0
			
			for _, implement in pairs(self.attachedImplements) do
				if implement.object.steeringAxleNode ~= nil and implement.object.steeringAxleNode > 0 then
					local toolAngle = AutoCombine.getRelativeYRotation( self.acRefNode, implement.object.steeringAxleNode )
					if self.acParameters.leftAreaActive then
						toolAngle = -toolAngle
					end
					angle = math.min( math.max( toolAngle, -self.acDimensions.maxSteeringAngle ), self.acDimensions.maxSteeringAngle );
				end
			end
			
			if self.acBorderDetected then
				self.acTurnStage   = 6;					
				self.turnTimer     = self.acDeltaTimeoutStart;
				self.setAIImplementsMoveDown(self,true);
			end;
			
--==============================================================				
-- wait before going forward				
		elseif self.acTurnStage == 6 then
			allowedToDrive = false;				

			if self.acTurn2Outside then				
				angle = self.acDimensions.maxSteeringAngle;
			else
				angle = -self.acDimensions.maxSteeringAngle;
			end;
						
			--if self.turnTimer < 0 then
			if self.waitForTurnTime < g_currentMission.time then
				self.acTurnStage = 7
				self.turnTimer   = self.acDeltaTimeoutWait;
			end;

--==============================================================				
-- going forward
		elseif self.acTurnStage == 7 then
		
			if self.acFruitsDetected or self.acBorderDetected then
				self.acTurnStage   = 20;					
				self.turnTimer     = self.acDeltaTimeoutStart;
			elseif self.acTurn2Outside then				
				angle = self.acDimensions.maxSteeringAngle;
			else
				angle = -self.acDimensions.maxSteeringAngle;
			end;

--==============================================================				
-- wait before U-turn					
		elseif self.acTurnStage == 11 then
			allowedToDrive = false;		
			noBreaking     = true
			angle = 0;

			--if self.turnTimer < 0 then
			if self.waitForTurnTime < g_currentMission.time then
				self.setAIImplementsMoveDown(self,false);

				if self.acTurn2Outside then
					self.acTurnStage = 12;
					self.turnTimer   = self.acDeltaTimeoutStop;
				else
					local dist = self.acDimensions.uTurnDistance2;
					if self.acParameters.noReverse then
						dist = self.acDimensions.uTurnDistance;
					end;

					if not self.acFruitsDetected and AutoCombine.getTurnDistance(self) > dist then
						self.acTurnStage = 17;
						self.lastTurnAngle = math.deg(AutoCombine.getTurnAngle(self));					
					else
						self.acTurnStage = 15;
						self.turnTimer   = self.acDeltaTimeoutWait;
					end
				end
			end
			
--==============================================================				
-- move to the right position before U-turn					
		elseif  self.acTurnStage == 12 then

			local ref = 0;
			if self.acParameters.noReverse then
				ref = math.deg(self.acDimensions.uTurnAngle);
			end;
			
			if self.acTurn2Outside then
				angle = -self.acDimensions.maxSteeringAngle;
										
				if turnAngle >= ref then
					self.acTurn2Outside = false;
					self.acTurnStage = 13;
					self.turnTimer   = self.acDeltaTimeoutRun;
				end
			else
				angle = self.acDimensions.maxSteeringAngle;
								
				if turnAngle <= 0 then
					local dist = self.acDimensions.uTurnDistance2;
					if self.acParameters.noReverse then
						dist = self.acDimensions.uTurnDistance;
					end;

					if AutoCombine.getTurnDistance(self) > dist then
						--self.setAIImplementsMoveDown(self,true);
						self.acTurnStage = 17;
						self.lastTurnAngle = math.deg(AutoCombine.getTurnAngle(self));					
					else
						self.acTurnStage = 14;
						self.turnTimer   = self.acDeltaTimeoutRun;
					end;
				end;
			end;

--==============================================================				
-- wait during U-turn
		elseif self.acTurnStage == 13 then
			allowedToDrive = false;						
			noBreaking     = true
			
			angle = self.acDimensions.maxSteeringAngle;
			
			if self.turnTimer < 0 then
				self.acTurnStage = 12;					
			end;

--==============================================================				
-- wait during U-turn before going forward
		elseif self.acTurnStage == 14 then
			allowedToDrive = false;						
			noBreaking     = true
			
			angle = 0;
			
			if self.turnTimer < 0 then
				self.acTurnStage = 15;					
			end;
			
--==============================================================				
-- go to the right distance before the U-turn
		elseif self.acTurnStage == 15 then

			angle = 0;
			
			local dist = self.acDimensions.uTurnDistance2;
			if self.acParameters.noReverse then
				dist = self.acDimensions.uTurnDistance;
			end;
				
			if not self.acFruitsDetected and AutoCombine.getTurnDistance(self) > dist then
				self.acTurnStage = 16;					
				self.turnTimer   = self.acDeltaTimeoutRun;
			end;

--==============================================================				
-- wait during U-turn after going forward
		elseif self.acTurnStage == 16 then

			allowedToDrive = false;						
			noBreaking     = true
												
			angle = self.acDimensions.maxSteeringAngle;
			if self.turnTimer < 0 then
				--self.setAIImplementsMoveDown(self,true);
				self.acTurnStage   = 17;					
				self.lastTurnAngle = math.deg(AutoCombine.getTurnAngle(self));					
			end;
			
--==============================================================				
-- The U-turn					
		elseif self.acTurnStage == 17 then

			local ref = -105;
			if self.acDimensions.aaAngleFactor > 1E-6 then ref = -120 end;
			
			if not self.acParameters.noReverse and turnAngle <= ref then
				self.acTurn2Outside   = true;
				self.acTurnStage      = 18;
				self.turnTimer        = self.acDeltaTimeoutStop;
			elseif turnAngle <= -175 then 
				self.setAIImplementsMoveDown(self,true);
				self.acTurnStage      = 19;				
				self.lastTurnAngle    = 0;
				self.turnTimer        = self.acDeltaTimeoutRun;
			elseif self.acFruitsDetected then
				if self.acBorderDetected then
					self.setAIImplementsMoveDown(self,true);
					self.acTurnStage    = 19;				
					self.lastTurnAngle  = self.acDimensions.maxLookingAngle;
					self.turnTimer      = self.acDeltaTimeoutRun;
				elseif not self.acParameters.noReverse and turnAngle <= -75 then
					self.acTurn2Outside = true;
					self.acTurnStage    = 18;
					self.turnTimer      = self.acDeltaTimeoutStop;
				end;
			end;
			
			angle = self.acDimensions.maxSteeringAngle;

--==============================================================				
-- going back
		elseif self.acTurnStage == 18 then

			moveForwards = false;					
			
			if      self.acBorderDetected 
					and not self.acFruitsDetected then
				self.setAIImplementsMoveDown(self,true);
				self.acTurnStage    = 19;
				self.turnTimer      = self.acDeltaTimeoutRun;
				self.lastTurnAngle  = angle;
			elseif math.abs(turnAngle) > 175 then
				self.setAIImplementsMoveDown(self,true);
				self.acTurnStage    = 19;
				self.turnTimer      = self.acDeltaTimeoutRun;
				self.lastTurnAngle  = 0;
			end;

--==============================================================				
-- wait after U-turn
		elseif self.acTurnStage == 19 then
			allowedToDrive = false;						
			
			angle = self.lastTurnAngle;
			
			if self.turnTimer < 0 then
				self.acTurnStage = 21;					
				self.turnTimer   = self.acDeltaTimeoutStart;
			end;
			
--==============================================================				
-- searching...
		elseif self.acTurnStage >= 20 and self.acTurnStage <= 22 then
			moveForwards     = true;

		--if self.acFruitsDetected and self.acBorderDetected then
			if self.acFruitsDetected then
				AutoCombine.saveDirection( self, false );
				self.acTurnStage    = 0;
				self.acTurn2Outside = false;
				self.turnTimer      = self.acDeltaTimeoutNoTurn;
				self.aiRescueTimer  = self.acDeltaTimeoutStop;
			end;
			
--==============================================================				
-- threshing...					
		elseif self.acTurnStage == 0 then
			moveForwards     = true;
			
			--if not self.acBorderDetected then 
			--	print(tostring(math.deg(angle)).." "..tostring(self.acBorderDetected).." "..tostring(self.acFruitsDetected).." "..tostring(self.acTurn2Outside))
			--end
			
			if self.acBorderDetected then --and self.acFruitsDetected then
				AutoCombine.saveDirection( self, true );
				self.turnTimer   	  = math.max(self.turnTimer,self.acDeltaTimeoutRun);
				self.aiRescueTimer  = self.acDeltaTimeoutStop;
			elseif  self.acFruitsDetected 
					and not self.acTurn2Outside then
				AutoCombine.saveDirection( self, true );
			elseif self.turnTimer < 0 then
			
--==============================================================				
--      Stop ???
				if not self.acTurn2Outside and not self.acFruitsDetected then 
					local dist    = math.floor( 2.5 * math.max( 10, self.acDimensions.distance ) )
					local wx,_,wz = getWorldTranslation( self.acRefNode )
					local stop    = true
					local lx,lz
					for i=0,dist do
						for j=0,dist do
							for k=1,4 do
								if     k==1 then 
									lx = wx + i
									lz = wz + j
								elseif k==2 then
									lx = wx - i
									lz = wz + j
								elseif k==3 then
									lx = wx + i
									lz = wz - j
								else
									lx = wx - i
									lz = wz - j
								end
								if Utils.getFruitArea(fruitType, lx-0.5,lz-0.5,lx+1,lz,lx,lz+1, hasFruitPreparer) > 0 then
									stop = false
									break
								end						
							end
							if not stop then break end
						end
						if not stop then break end
					end
							
					if stop then
						self:stopAIThreshing();
						return
					end
				end			
--==============================================================				
			
				if     self.acTurn2Outside 
						or not self.acParameters.upNDown
						or AutoCombine.getTraceLength(self) < self.acDimensions.distance + self.acDimensions.distance then		
					self.acTurnStage = 1;
					self.turnTimer = self.acDeltaTimeoutWait;
				else
					--invert turn angle because we will swap left/right in about 10 lines
					turnAngle = -turnAngle;
					if self.acParameters.noReverse then
						self.acTurn2Outside = turnAngle < self.acDimensions.uTurnAngle;
					elseif self.acParameters.CPSupport then
						self.acTurn2Outside = math.deg(turnAngle) < -3;					
					else
						self.acTurn2Outside = AutoCombine.getTurnDistance(self) <= self.acDimensions.uTurnDistance2;
					end;
					self.acTurnStage = 11;
					self.turnTimer = self.acDeltaTimeoutWait;
					self.waitForTurnTime = g_currentMission.time + self.turnTimer;
					self.acParameters.leftAreaActive  = not self.acParameters.leftAreaActive;
					self.acParameters.rightAreaActive = not self.acParameters.rightAreaActive;
					AutoCombine.sendParameters(self);
				end
			end
			
--==============================================================				
-- error!!!
		else
			allowedToDrive = false;						
			self.mogliInfoText = string.format(Mogli.getText("AC_COMBINE_ERROR")..": %i",self.acTurnStage);
			print(self.mogliInfoText);
			self:stopAIThreshing();
			return;
		end

		if self.acTurnStage == 22 and self.acBorderDetected then
			AutoCombine.setStatus( self, 2 )
		elseif self.acTurnStage == 22 then
			AutoCombine.setStatus( self, 0 )
		elseif self.acTurnStage == 0 or self.acTurnStage >= 20 then
			if self.acBorderDetected then
				AutoCombine.setStatus( self, 1 )
			else
				AutoCombine.setStatus( self, 2 )
			end
		else
			AutoCombine.setStatus( self, 0 )
		end		
	end		
--==============================================================				


--==============================================================				
--==============================================================				
	if math.abs( self.axisSide ) > 0.3 then --if AutoTractor.acDevFeatures and math.abs( self.axisSide ) > 0.3 then 
		AutoCombine.setStatus( self, 0 )
		self.acBorderDetected = false
		border   = 0
		angle    = self.axisSide * self.acDimensions.maxSteeringAngle
		if self.acParameters.leftAreaActive then
			angle = -angle;		
		end
		if not moveForwards then
			angle = -angle;		
		end
		self.turnTimer = self.turnTimer + dt;
		if self.acTurnStage <= 0 then
			self.aiRescueTimer = self.aiRescueTimer + dt;
		end			
	end			
	--
	--if math.abs( self.axisForward ) > 0.3 then
	--	AutoCombine.setStatus( self, 0 )
	--	self.acBorderDetected = false
	--	border   = 0
	--	if self.axisForward > 0 then
	--		moveForwards = true
	--	else
	--		moveForwards = false
	--	end
	--	allowedToDrive = true
	--end
--==============================================================				
--==============================================================				


	local acceleration = 0;					
	local slowAngleLimit = 20;
	if self.isMotorStarted and speedLevel ~= 0 and self.fuelFillLevel > 0 then
		acceleration = 1.0;
	end
	
	if not allowedToDrive and moveForwards and noBreaking and self.lastAcceleration ~= nil and self.lastAcceleration > 0 then
		allowedToDrive = true
		acceleration   = math.min( 0.5 * self.lastAcceleration, self.motor.accelerations[4] )
		--print(tostring(moveForwards).." "..tostring(noBreaking).." "..string.format("old acc. %0.3f new acc. %0.3f, speed level %i",self.lastAcceleration, acceleration, speedLevel) )
		speedLevel     = 0
	end;

	if self.haeckseldolly and self.acTurnStage ~= 0 then
		for _, implement in pairs(self.attachedImplements) do
			if implement.object.bunkerrechts ~= nil then
				implement.object.bunkerrechts = not self.acParameters.leftAreaActive
			end
		end
	end
	
	local maxAngle = 25;
  local maxlx = 0.7071067;
	if self.acDimensions ~= nil and self.acDimensions.maxSteeringAngle ~= nil then
		maxAngle = math.deg( self.acDimensions.maxSteeringAngle );
	end;
	
	local lx, lz = 0, 1;
		
	if angle == nil then
		angle = 0
	elseif not self.acParameters.leftAreaActive then
		angle = -angle;
	end

	self.turnStage = 0
	self.turnAP    = nil
	if self.acTurnStage ==  4 then
		self.turnStage = 1
		--self.turnAP    = true
	elseif self.acTurnStage ==  3 then
		self.turnStage = 5
		--self.turnAP    = true
	elseif self.acTurnStage >=  2 and self.acTurnStage <  11 then
		if self.acParameters.noReverse then
			self.turnStage = 3
		else
			self.turnStage = 2
		end
		--self.turnAP    = true
	elseif self.acTurnStage >= 12 and self.acTurnStage <  15 then
		self.turnStage = 1
	elseif self.acTurnStage >= 15 and self.acTurnStage <  17 then
		if self.acParameters.noReverse then
			self.turnStage = 3
		else
			self.turnStage = 2
		end
	elseif self.acTurnStage >= 17 and self.acTurnStage <  18 then
		self.turnStage = 4
	elseif self.acTurnStage >= 18 and self.acTurnStage <= 19 then
		self.turnStage = 5		
	else
		self.turnStage = 0
	end
	
	if acceleration > 0 and speedLevel > 7 then
		if self.acTurnStage ~= 0 or not self.acBorderDetected then
			speedLevel = 7
		end
	end
	
	lx, lz = math.sin(angle), math.cos(angle);
	
	if      self.acTurnStage == 0 
			and self.acBorderDetected 
			and self.acFruitsDetected then
		self.aiSteeringSpeed = 0.75 * self.acSteeringSpeed;	
	elseif self.acTurnStage == 0 
			or self.acTurnStage >= 20 then
		self.aiSteeringSpeed = self.acSteeringSpeed;	
	else
		self.aiSteeringSpeed = 1.5 * self.acSteeringSpeed;	
	end
		
	--if self.acTurnStage == 2 then
	--	print(tostring(acceleration).." "..
	--				tostring(allowedToDrive).." "..
	--				tostring(moveForwards).." "..
	--				tostring(speedLevel).." "..
	--				tostring(self.motor.realSpeedLevelsAI[speedLevel]).." "..
	--				tostring(self.realGroundSpeed))
	--end
		
	AIVehicleUtil.driveInDirection(self, dt, maxAngle, acceleration, math.max(0.25,0.75*acceleration), slowAngleLimit, allowedToDrive, moveForwards, lx, lz, speedLevel, 0.6)
	
	self.aiSteeringSpeed = self.acSteeringSpeed;	
	
  local colDirX = lx
  local colDirZ = lz
  if maxlx < colDirX then
    colDirX = maxlx
    colDirZ = 0.7071067
  elseif colDirX < -maxlx then
    colDirX = -maxlx
    colDirZ = 0.7071067
  end
  --for triggerId, _ in pairs(self.numCollidingVehicles) do
	  --AIVehicleUtil.setCollisionDirection(self.aiTreshingDirectionNode, triggerId, colDirX, colDirZ)
  --end

end 

------------------------------------------------------------------------
-- autoSteer
------------------------------------------------------------------------
function AutoCombine:autoSteer(dt)

	AutoCombine.calculateDimensions(self);

	local offsetOutside = 0;
	if     self.acParameters.rightAreaActive then
		offsetOutside = -1;
	elseif self.acParameters.leftAreaActive then
		offsetOutside = 1;
	end;
		
  local fruitType = self.lastValidInputFruitType
  if fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
		return
	elseif self.fruitPreparerFruitType ~= nil and self.fruitPreparerFruitType == fruitType then
    hasFruitPreparer = true
  end
	local d, lookAhead = 0,4;							
	local aaDiffX, aaDiffZ = 0,0;
  local hasFruitPreparer = false
	local border = AutoCombine.getFruitArea( self, 0, 0, offsetOutside, lookAhead, 0, fruitType, hasFruitPreparer );
	local angle = 0;	
	local detected = false;
	local factor = 0.05;			
	if border <= 0 then
		factor = -factor;					
	elseif self.acDimensions.maxLookingAngle < self.acDimensions.maxSteeringAngle then
		factor = factor * self.acDimensions.maxLookingAngle / self.acDimensions.maxSteeringAngle
	end 
	
	for i=1,20 do
		local a = factor*i*self.acDimensions.maxSteeringAngle; 							
		d = AutoCombine.calculateWidth(self,lookAhead,a);
		if not self.acParameters.leftAreaActive then d = -d; end;
		if self.acDimensions.aaAngleFactor > 0 then
			aaDiffX = math.sin( self.acDimensions.aaAngleFactor * a ) * self.acDimensions.aaDistance;
			aaDiffZ = ( math.cos( self.acDimensions.aaAngleFactor * a ) - 1 ) * self.acDimensions.aaDistance;
			if not self.acParameters.leftAreaActive then aaDiffX = -aaDiffX; end;
		end

		b = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
		
		if     border > 0 then
			if b <= 0 then
				detected = true;
				angle = a;
				break
			end
		else
			if b > 0 then
				detected = true;
				break
			end
		end
		angle = a;
	end
	
	if detected then
		if self.acTurnStage ~= 99 then
			self.acTurnStage = 99
			AutoCombine.saveDirection( self, false )
		end
		AutoCombine.saveDirection( self, true );
		self.turnTimer = self.acDeltaTimeoutRun
	else
		self.turnTimer = self.turnTimer - dt;
	
		if border > 0 then
			angle = self.acDimensions.maxSteeringAngle;
		else
			angle = -self.acDimensions.maxSteeringAngle;

			local l = AutoCombine.getTraceLength(self);
			local a = math.deg(AutoCombine.getTurnAngle(self));
			if not self.acParameters.leftAreaActive then a = -a; end;
			if      l >= 1
					and a < -15 then
				angle = 0;
			end
		end

		if self.acTurnStage == 99 and self.turnTimer < 0 then
			if border > 0 then
				--self.setAIImplementsMoveDown(self,false);
				self:setCruiseControlState( Drivable.CRUISECONTROL_STATE_OFF )
			else
				d = self.acDimensions.distance + self.acDimensions.distance;
				d = - math.max( 0.9 * d, d - 1 );
				if not self.acParameters.leftAreaActive then d = -d; end;
				if AutoCombine.getFruitArea( self, 0, -2, d, 3, 0, fruitType, hasFruitPreparer ) <= 0 then
					--self.setAIImplementsMoveDown(self,false);
					self:setCruiseControlState( Drivable.CRUISECONTROL_STATE_OFF )
				end
			end
		end
	end
	
	if not self.acParameters.leftAreaActive then angle = -angle end
	if self.movingDirection < -1E-2 then angle = -angle end
	local targetRotTime = 0
	
	if self.acRotatedTime == nil then
		self.rotatedTime = 0
	else
		self.rotatedTime = self.acRotatedTime
	end
	
	if self.isEntered then
		if     angle == 0 then
			targetRotTime = 0
		elseif angle  > 0 then
			targetRotTime = self.maxRotTime * math.min( angle / self.acDimensions.maxSteeringAngle, 1)
		else
			targetRotTime = self.minRotTime * math.min(-angle / self.acDimensions.maxSteeringAngle, 1)
		end
		if targetRotTime > self.rotatedTime then
			self.rotatedTime = math.min(self.rotatedTime + dt * self.aiSteeringSpeed, targetRotTime)
		else
			self.rotatedTime = math.max(self.rotatedTime - dt * self.aiSteeringSpeed, targetRotTime)
		end
--	elseif self.motor.speedlevel > 0 then
--		lx, lz = math.sin(angle), math.cos(angle);
--		AIVehicleUtil.driveInDirection(self, dt, self.acDimensions.maxSteeringAngle, 1, 0.75, 25, true, true, lx, lz, self.motor.speedlevel, 0.6)
	end
	
	self.acRotatedTime = self.rotatedTime
end

------------------------------------------------------------------------
-- 
------------------------------------------------------------------------
function AutoCombine:addBackTrafficCollisionTrigger()
	if self.acBackTrafficCollisionTrigger ~= nil then
		AutoCombine.addCollisionTrigger(self,self,self.acBackTrafficCollisionTrigger,"acOnBackCollisionTrigger");
	end;
end;

------------------------------------------------------------------------
-- 
------------------------------------------------------------------------
function AutoCombine:removeBackTrafficCollisionTrigger()
	if self.acBackTrafficCollisionTrigger ~= nil then		
		AutoCombine.removeCollisionTrigger(self,self,self.acBackTrafficCollisionTrigger,"acOnBackCollisionTrigger");
	end;
end;

------------------------------------------------------------------------
-- 
------------------------------------------------------------------------
function AutoCombine:addOtherCombineCollisionTrigger()
	local on,off;
	if self.acParameters.otherCombine then	
		if self.acParameters.leftAreaActive then
			on  = self.acOtherCombineCollisionTriggerL;
			off = self.acOtherCombineCollisionTriggerR;
		else
			on  = self.acOtherCombineCollisionTriggerR;
			off = self.acOtherCombineCollisionTriggerL;
		end
		
		if on ~= nil then
			if self.acCollidingCombines[on] == nil then
				AutoCombine.addCollisionTrigger(self,self,on,"acOnCombineCollisionTrigger");
			end
		end
		if off ~= nil then
			if self.acCollidingCombines[off] ~= nil then
				AutoCombine.removeCollisionTrigger(self,self,off,"acOnCombineCollisionTrigger");
			end
		end
	end
end

------------------------------------------------------------------------
-- 
------------------------------------------------------------------------
function AutoCombine:removeOtherCombineCollisionTrigger()
	local off;
	off = self.acOtherCombineCollisionTriggerL;
	if off ~= nil then
		if self.acCollidingCombines[off] ~= nil then
			AutoCombine.removeCollisionTrigger(self,self,off,"acOnCombineCollisionTrigger");
		end
	end
	off = self.acOtherCombineCollisionTriggerR;
	if off ~= nil then
		if self.acCollidingCombines[off] ~= nil then
			AutoCombine.removeCollisionTrigger(self,self,off,"acOnCombineCollisionTrigger");
		end
	end
end;
		
------------------------------------------------------------------------
-- acOnBackCollisionTrigger
------------------------------------------------------------------------
function AutoCombine:acOnBackCollisionTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  if onEnter or onLeave then
    if g_currentMission.players[otherId] ~= nil then
      if onEnter then
        self.acCollidingVehicles[triggerId] = self.acCollidingVehicles[triggerId] + 1
      elseif onLeave then
        self.acCollidingVehicles[triggerId] = math.max(self.acCollidingVehicles[triggerId] - 1, 0)
      end
    elseif self.trafficCollisionIgnoreList[otherId] == nil then
      local vehicle = g_currentMission.nodeToVehicle[otherId]
      if vehicle ~= nil then
        if onEnter then
          self.acCollidingVehicles[triggerId] = self.acCollidingVehicles[triggerId] + 1
        elseif onLeave then
          self.acCollidingVehicles[triggerId] = math.max(self.acCollidingVehicles[triggerId] - 1, 0)
        end
      end
    end
  end
end

		
------------------------------------------------------------------------
-- acOnCombineCollisionTrigger
------------------------------------------------------------------------
function AutoCombine:acOnCombineCollisionTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  if onEnter or onLeave then
    if g_currentMission.players[otherId] == nil and self.trafficCollisionIgnoreList[otherId] == nil then
      local vehicle = g_currentMission.nodeToVehicle[otherId]
      if vehicle ~= nil and SpecializationUtil.hasSpecialization(Combine, vehicle.specializations) then
        if onEnter then
          self.acCollidingCombines[triggerId] = self.acCollidingCombines[triggerId] + 1
        elseif onLeave then
          self.acCollidingCombines[triggerId] = math.max(self.acCollidingCombines[triggerId] - 1, 0)
        end
      end
    end
  end
end

		
------------------------------------------------------------------------
-- addCollisionTrigger
------------------------------------------------------------------------
function AutoCombine:addCollisionTrigger(object,transformId,cb)
  if self.isServer then
    if transformId ~= nil then
			if     cb ~= nil and cb == "acOnBackCollisionTrigger" then
				addTrigger(transformId, cb, self)
				self.acCollidingVehicles[transformId] = 0
			elseif cb ~= nil and cb == "acOnCombineCollisionTrigger" then
				addTrigger(transformId, cb, self)
				self.acCollidingCombines[transformId] = 0
			else
				addTrigger(transformId, "onTrafficCollisionTrigger", self)
				self.numCollidingVehicles[transformId] = 0
			end
    end
    if object ~= self then
      for _, v in pairs(object.components) do
        self.trafficCollisionIgnoreList[v.node] = true
      end
    end
  end
end

------------------------------------------------------------------------
-- removeCollisionTrigger
------------------------------------------------------------------------
function AutoCombine:removeCollisionTrigger(object,transformId,cb)
  if self.isServer then
    if transformId ~= nil then
      removeTrigger(transformId)
			if     cb ~= nil and cb == "acOnBackCollisionTrigger" then
				self.acCollidingVehicles[transformId] = nil
			elseif cb ~= nil and cb == "acOnCombineCollisionTrigger" then
				self.acCollidingCombines[transformId] = nil
			else
				self.numCollidingVehicles[transformId] = nil
			end
    end
    if object ~= self then
      for _, v in pairs(object.components) do
        self.trafficCollisionIgnoreList[v.node] = nil
      end
    end
  end
end

------------------------------------------------------------------------
-- getSaveAttributesAndNodes
------------------------------------------------------------------------
function AutoCombine:getSaveAttributesAndNodes(nodeIdent)
	local attributes;
	if     self.acParameters.enabled
			or self.acParameters.upNDown
			or self.acParameters.waitode 
			or self.acParameters.rightAreaActive
			or self.acParameters.otherCombine then
		attributes = 'acVersion="2.3"';
		attributes = attributes..' acEnabled="'     ..Mogli.bool2int(self.acParameters.enabled).. '"';
		attributes = attributes..' acUTurn="'       ..Mogli.bool2int(self.acParameters.upNDown).. '"';
		attributes = attributes..' acWaitMode="'    ..Mogli.bool2int(self.acParameters.waitMode).. '"';
		attributes = attributes..' acAreaRight="'   ..Mogli.bool2int(self.acParameters.rightAreaActive).. '"';
		attributes = attributes..' acOtherCombine="'..Mogli.bool2int(self.acParameters.otherCombine).. '"';
		attributes = attributes..' acNoReverse="'   ..Mogli.bool2int(self.acParameters.noReverse).. '"';
		attributes = attributes..' acCPSupport="'   ..Mogli.bool2int(self.acParameters.CPSupport).. '"';
		attributes = attributes..' acTurnOffset="'  ..self.acParameters.turnOffset..'"';		
		attributes = attributes..' acWidthOffset="' ..self.acParameters.widthOffset..'"';		
		attributes = attributes..' acSpeed="'       ..self.acParameters.speed..'"';		
	end;
	
	--print(attributes);
	
	return attributes
end;

------------------------------------------------------------------------
-- acGetXmlBool
------------------------------------------------------------------------
local function acGetXmlBool(xmlFile, key, default)
	local l = getXMLInt(xmlFile, key);
	if l~= nil then
		return (l == 1);
	end;
	return default;
end;

local function acGetXmlFloat(xmlFile, key, default)
	local f = getXMLFloat(xmlFile, key);
	if f ~= nil then
		return f;
	end;
	return default;
end;
------------------------------------------------------------------------
-- loadFromAttributesAndNodes
------------------------------------------------------------------------
function AutoCombine:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local version = getXMLString(xmlFile, key.."#acVersion");
	
	self.acParameters.enabled         = acGetXmlBool(xmlFile, key.."#acEnabled",     self.acParameters.enabled);
	self.acParameters.upNDown	        = acGetXmlBool(xmlFile, key.."#acUTurn",       self.acParameters.upNDown);
	self.acParameters.waitMode        = acGetXmlBool(xmlFile, key.."#acWaitMode",    self.acParameters.waitMode);
	self.acParameters.rightAreaActive = acGetXmlBool(xmlFile, key.."#acAreaRight",   self.acParameters.rightAreaActive);
	self.acParameters.otherCombine    = acGetXmlBool(xmlFile, key.."#acOtherCombine",self.acParameters.otherCombine);
	self.acParameters.noReverse       = acGetXmlBool(xmlFile, key.."#acNoReverse",   self.acParameters.noReverse);
	self.acParameters.CPSupport       = acGetXmlBool(xmlFile, key.."#acCPSupport",   self.acParameters.CPSupport);
	self.acParameters.turnOffset      = acGetXmlFloat(xmlFile, key.."#acTurnOffset", self.acParameters.turnOffset ); 
	self.acParameters.widthOffset     = acGetXmlFloat(xmlFile, key.."#acWidthOffset",self.acParameters.widthOffset); 
	self.acParameters.speed           = acGetXmlFloat(xmlFile, key.."#acSpeed",      self.acParameters.speed); 

	self.acParameters.leftAreaActive  = not self.acParameters.rightAreaActive;
	self.acDimensions                 = nil;
	
	return BaseMission.VEHICLE_LOAD_OK;
end

------------------------------------------------------------------------
-- getMarker
------------------------------------------------------------------------
function AutoCombine:getMarker()

  local lm = self.aiLeftMarker;
  local rm = self.aiRightMarker;
	
  for cutter, implement in pairs(self.attachedCutters) do
    if cutter.aiLeftMarker ~= nil and lm == nil then
      lm = cutter.aiLeftMarker
    end
    if cutter.aiRightMarker ~= nil and rm == nil then
      rm = cutter.aiRightMarker
    end
  end;
	
	return lm, rm;
end;

------------------------------------------------------------------------
-- getAreaOverlap
------------------------------------------------------------------------
function AutoCombine:getAreaOverlap(threshWidth)
  local areaOverlap = 0;
	local scale = Utils.getNoNil( self.aiTurnThreshWidthScale, 0.1 );
	local diff  = Utils.getNoNil( self.aiTurnThreshWidthMaxDifference, 0.6 );

	areaOverlap = 0.5 * math.min(threshWidth * (1 - scale), diff);

	return areaOverlap;
end

------------------------------------------------------------------------
-- getCorrectedMaxSteeringAngle
------------------------------------------------------------------------
function AutoCombine:getCorrectedMaxSteeringAngle()

	local steeringAngle = self.acDimensions.maxSteeringAngle;
	if      self.articulatedAxis ~= nil 
			and self.articulatedAxis.componentJoint ~= nil
      and self.articulatedAxis.componentJoint.jointNode ~= nil 
			and self.articulatedAxis.rotMax then
		-- Ropa
		steeringAngle = steeringAngle + 0.15 * self.articulatedAxis.rotMax;
	end

	return steeringAngle
end

------------------------------------------------------------------------
-- calculateDimensions
------------------------------------------------------------------------
function AutoCombine:calculateDimensions()
	if self.acDimensions ~= nil then
		if lm == nil then
			return;
		end;
		
		local _,y,_ = AutoCombine.getRelativeTranslation( self.acRefNode, lm );		
		y = y + 1E-6;
		if y >= self.acDimensions.yMin then
			return;
		end
	end;
	
	self.acRecalculateDt = 0
	self.acDimensions = {};

	local lm, rm = AutoCombine.getMarker(self);
	local n = 0;
	self.acDimensions.distance = 0;
	self.acDimensions.cutterDistance = 0;

	if lm ~= nil then
		self.acDimensions.xLeft,self.acDimensions.yMin,self.acDimensions.zLeft = AutoCombine.getRelativeTranslation( self.acRefNode, lm );		
		self.acDimensions.distance = self.acDimensions.distance + self.acDimensions.xLeft;
		self.acDimensions.cutterDistance = self.acDimensions.cutterDistance + self.acDimensions.zLeft;
		n = n + 1;
	else
		self.acDimensions.xLeft,self.acDimensions.yMin,self.acDimensions.zLeft = 0,99,0;		
	end
	if rm ~= nil then
		self.acDimensions.xRight,_,self.acDimensions.zRight = AutoCombine.getRelativeTranslation( self.acRefNode, rm );		
		self.acDimensions.distance = self.acDimensions.distance - self.acDimensions.xRight;
		self.acDimensions.cutterDistance = self.acDimensions.cutterDistance + self.acDimensions.zRight;
		n = n + 1;
	else
		self.acDimensions.xRight,self.acDimensions.zRight = 0,0;
	end
	
	if n > 1 then
		self.acDimensions.distance = self.acDimensions.distance / n;
		self.acDimensions.cutterDistance = self.acDimensions.cutterDistance / n;
	elseif n < 1 then
		self.acDimensions.distance = 1.75;
		self.acDimensions.cutterDistance = 3.3;
	end;
	self.acDimensions.cutterDistance = self.acDimensions.cutterDistance + 0.3;
	
	local threshWidth           = self.acDimensions.distance + self.acDimensions.distance;
  local areaOverlap           = AutoCombine.getAreaOverlap(self,threshWidth);	
	self.acDimensions.distance  = self.acDimensions.distance - areaOverlap;
	self.acDimensions.xLeft     = self.acDimensions.xLeft    - areaOverlap;
	self.acDimensions.xRight    = self.acDimensions.xRight   + areaOverlap;
	self.acDimensions.distance0 = self.acDimensions.distance;
	self.acDimensions.xLeft0    = self.acDimensions.xLeft;
	self.acDimensions.xRight0   = self.acDimensions.xRight;
		
	local m_ws, c_ws, z_ws, m_wn, c_wn, z_wn, m_wp, c_wp, z_wp = 0,0,0,0,0,0,0,0,0;
	self.acDimensions.maxSteeringAngle = math.rad(1);
	for _,wheel in pairs(self.wheels) do
		local x,y,z = AutoCombine.getRelativeTranslation(self.acRefNode,wheel.driveNode);
		if     wheel.rotSpeed < -1E-03 then
			if c_ws < 1 then z_ws = z else z_ws = math.min(z_ws,z) end;
			c_ws = 1;
			local m = math.min(math.abs(wheel.rotMin),math.abs(wheel.rotMax));
			if m > 0 then
				self.acDimensions.maxSteeringAngle = math.max( self.acDimensions.maxSteeringAngle, m );			
			end;
		elseif wheel.rotSpeed < 1E-03 then
			if c_wn < 1 then z_wn = z else z_wn = math.max(z_wn,z) end;
			c_wn = 1;
		else
			if c_wp < 1 then z_wp = z else z_wp = math.max(z_wp,z) end;
			c_wp = 1;
		end;
	end;

	if c_ws > 1 then z_ws = m_ws / c_ws; self.acDimensions.maxSteeringAngle = self.acDimensions.maxSteeringAngle / c_ws end;
	if c_wn > 1 then z_wn = m_wn / c_wn end;
	if c_wp > 1 then z_wp = m_wp / c_wp end;
	
	-- defaults
	self.acDimensions.zOffset         = 0;
	self.acDimensions.wheelBase       = 4;
	self.acDimensions.radius          = 10;
	self.acDimensions.aaDistance      = 0;
	self.acDimensions.aaAngle         = 0;
	self.acDimensions.aaAngleFactor   = 0;
	self.acDimensions.maxLookingAngle = 25;
	
	if      self.articulatedAxis ~= nil 
			and self.articulatedAxis.componentJoint ~= nil
      and self.articulatedAxis.componentJoint.jointNode ~= nil 
			and self.articulatedAxis.rotMax then
		-- Ropa
		local x,y,z = AutoCombine.getRelativeTranslation( self.acRefNode, self.articulatedAxis.componentJoint.jointNode );
		self.acDimensions.aaDistance    = self.acDimensions.cutterDistance - z;
    self.acDimensions.aaAngle       = self.articulatedAxis.rotMax;
		self.acDimensions.aaAngleFactor = self.acDimensions.aaAngle / self.acDimensions.maxSteeringAngle;
		self.acDimensions.zOffset       = z;
		
	elseif ( c_ws > 0 and c_wn > 0 )
			or ( c_ws > 0 and c_wp > 0 )
			or ( c_wn > 0 and c_wp > 0 ) then		
		if     c_wn < 1 then
			z_wn = 0.5 * ( z_ws + z_wp );
		elseif c_ws < 1 then
			z_ws = z_wp;
		end;
		
		self.acDimensions.zOffset       = z_wn;
	end;

	self.acDimensions.wheelBase       = self.acDimensions.zOffset - z_ws;
	self.acDimensions.cutterDistance  = self.acDimensions.cutterDistance - self.acDimensions.zOffset;
	self.acDimensions.radius          = self.acDimensions.wheelBase / math.tan( AutoCombine.getCorrectedMaxSteeringAngle(self) );

	AutoCombine.calculateDistances(self)
end

------------------------------------------------------------------------
-- calculateDistances
------------------------------------------------------------------------
function AutoCombine:calculateDistances()

	self.acDimensions.distance        = self.acDimensions.distance0 + self.acParameters.widthOffset;
	self.acDimensions.xLeft           = self.acDimensions.xLeft0    + self.acParameters.widthOffset;
	self.acDimensions.xRight          = self.acDimensions.xRight0   - self.acParameters.widthOffset;
	
	local optimDist                   = 0.5+self.acDimensions.distance;
	if self.acDimensions.radius > optimDist then
		self.acDimensions.uTurnAngle    = math.acos( optimDist / self.acDimensions.radius );
	else
		self.acDimensions.uTurnAngle    = 0;
	end;

	self.acDimensions.maxLookingAngle = math.min( AutoCombine.calculateSteeringAngle( self, 2, 1 ) ,self.acDimensions.maxSteeringAngle);
	local factor = math.max( 0, math.cos( math.min( math.rad(15) + AutoCombine.getCorrectedMaxSteeringAngle(self), 0.5 * math.pi ) ) - 1 + math.sin( math.max( math.pi - math.rad(15) - AutoCombine.getCorrectedMaxSteeringAngle(self), 0 ) ) )
	self.acDimensions.insideDistance  = math.max(0, self.acDimensions.cutterDistance - 1 - self.acDimensions.distance + ( self.acDimensions.radius * factor ) );
	
	if self.acDimensions.aaAngle > 1E-6 then
		self.acDimensions.maxLookingAngle = math.min( self.acDimensions.maxLookingAngle, self.acDimensions.aaAngle );
		self.acDimensions.uTurnDistance   = 1.2 * self.acDimensions.cutterDistance + self.acDimensions.distance;
		self.acDimensions.uTurnDistance2  = self.acDimensions.cutterDistance + 0.7 * math.sin( self.articulatedAxis.rotMax ) * self.acDimensions.aaDistance;
	else
		self.acDimensions.uTurnDistance   = self.acDimensions.cutterDistance + math.max(2, 1 + self.acDimensions.distance - self.acDimensions.radius);
		self.acDimensions.uTurnDistance2  = math.max(1, self.acDimensions.cutterDistance + 1 + self.acDimensions.distance - self.acDimensions.radius );
	end
	
	self.acDimensions.insideDistance  = math.max( 0, self.acDimensions.insideDistance + self.acParameters.turnOffset );
  self.acDimensions.uTurnDistance   = math.max( 1, self.acDimensions.uTurnDistance  + self.acParameters.turnOffset );
  self.acDimensions.uTurnDistance2  = math.max( 1, self.acDimensions.uTurnDistance2 + self.acParameters.turnOffset );
	
--print(string.format("a1=%i a2=%i cd=%f di=%f rd=%f wb=%f id=%f ud=%f ud2=%f",math.deg(self.acDimensions.maxSteeringAngle),math.deg(self.acDimensions.maxLookingAngle),self.acDimensions.cutterDistance,self.acDimensions.xLeft,self.acDimensions.radius,self.acDimensions.wheelBase,self.acDimensions.insideDistance,self.acDimensions.uTurnDistance,self.acDimensions.uTurnDistance2 	));
end

------------------------------------------------------------------------
-- getRelativeTranslation
------------------------------------------------------------------------
function AutoCombine.getRelativeTranslation(root,node)
	local x,y,z;
	if getParent(node)==root then
		x,y,z = getTranslation(node);
	else
		x,y,z = worldToLocal(root,getWorldTranslation(node));
	end;
	return x,y,z;
end

------------------------------------------------------------------------
-- calculateSteeringAngle
------------------------------------------------------------------------
function AutoCombine.calculateSteeringAngle(self,x,z)
	local angle = math.atan( self.acDimensions.wheelBase * x / ( self.acDimensions.cutterDistance * z + self.acDimensions.distance * x ) );
	return angle;
end;

------------------------------------------------------------------------
-- calculateWidth
------------------------------------------------------------------------
function AutoCombine:calculateWidth(z,angle)
	if math.abs(z)<1E-6 then
		return 0;
	end;
	
	local tanAngle = math.tan( angle );
	local dist = self.acDimensions.cutterDistance * z * tanAngle / ( self.acDimensions.wheelBase - tanAngle * self.acDimensions.distance );

	if self.acDimensions.aaAngleFactor > 0 then
		dist = dist + math.sin( self.acDimensions.aaAngleFactor * angle ) * z;
  end
	
	return dist;
end;

------------------------------------------------------------------------
-- getParallelogram
------------------------------------------------------------------------
function AutoCombine:getParallelogram( xOffset, zOffset, width, height, diff )
	local x, z, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ;

	if self.acParameters.leftAreaActive then
		x = self.acDimensions.xLeft;
		z = self.acDimensions.zLeft;
	else
		x = self.acDimensions.xRight;
		z = self.acDimensions.zRight;
	end
	
	startWorldX,_,startWorldZ   = localToWorld( self.acRefNode, x + xOffset,         0, z + zOffset );
	widthWorldX,_,widthWorldZ   = localToWorld( self.acRefNode, x + xOffset + width, 0, z + zOffset );
	heightWorldX,_,heightWorldZ = localToWorld( self.acRefNode, x +           diff,  0, z + zOffset + height );	
	
	return startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ;
end

------------------------------------------------------------------------
-- saveDirection
------------------------------------------------------------------------
function AutoCombine:saveDirection( cumulate )

	if cumulate then
		local vector = {};	
		vector.dx,_,vector.dz = localDirectionToWorld( self.acRefNode, 0,0,1 );
		vector.px,_,vector.pz = getWorldTranslation( self.acRefNode );
		
		if self.acDirectionBeforeTurn.traceIndex == nil then
			self.acDirectionBeforeTurn.trace = {};
			self.acDirectionBeforeTurn.traceIndex = 0;
		end;
		
		local count = table.getn(self.acDirectionBeforeTurn.trace);
		if count > 100 and self.acDirectionBeforeTurn.traceIndex == count then
			local x = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].px - self.acDirectionBeforeTurn.trace[1].px;
			local z = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].pz - self.acDirectionBeforeTurn.trace[1].pz;		
		
			if x*x + z*z > 36 then 
				self.acDirectionBeforeTurn.traceIndex = 0
			end
		end;
		self.acDirectionBeforeTurn.traceIndex = self.acDirectionBeforeTurn.traceIndex + 1;
		
		self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex] = vector;
		self.acDirectionBeforeTurn.a = nil;
		self.acDirectionBeforeTurn.x = vector.px;
		self.acDirectionBeforeTurn.z = vector.pz;
		
		if self.lastValidInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			local hasFruitPreparer = false
			if self.fruitPreparerFruitType ~= nil and self.fruitPreparerFruitType == self.lastValidInputFruitType then
				hasFruitPreparer = true
			end
				
			local lx,lz;
			if self.acParameters.leftAreaActive then
				lx = self.acDimensions.xRight;
				lz = self.acDimensions.zRight;
			else
				lx = self.acDimensions.xLeft;
				lz = self.acDimensions.zLeft;
			end
	
			local x,_,z = localToWorld( self.acRefNode, lx, 0, lz );
			
			if Utils.getFruitArea(self.lastValidInputFruitType, x-1,z-1,x+1,z-1,x-1,z+1, hasFruitPreparer) > 0 then	
				self.acDirectionBeforeTurn.tx = x;
				self.acDirectionBeforeTurn.tz = z;
			end
		end
	else
		self.acDirectionBeforeTurn.trace = {};
		self.acDirectionBeforeTurn.traceIndex = 0;
		self.acDirectionBeforeTurn.sx, _, self.acDirectionBeforeTurn.sz = getWorldTranslation( self.acRefNode );
	end
end

------------------------------------------------------------------------
-- getFirstTraceIndex
------------------------------------------------------------------------
function AutoCombine:getFirstTraceIndex()
	if     self.acDirectionBeforeTurn.trace      == nil 
			or self.acDirectionBeforeTurn.traceIndex == nil 
			or self.acDirectionBeforeTurn.traceIndex < 1 then
		return nil;
	end;
	local l = table.getn(self.acDirectionBeforeTurn.trace);
	if l < 1 then
		return nil;
	end;
	local i = self.acDirectionBeforeTurn.traceIndex + 1;
	if i > l then i = 1 end
	return i;
end

------------------------------------------------------------------------
-- getTurnDistance
------------------------------------------------------------------------
function AutoCombine:getTurnDistance()
	if     self.acRefNode               == nil
			or self.acDirectionBeforeTurn   == nil
			or self.acDirectionBeforeTurn.x == nil
			or self.acDirectionBeforeTurn.z == nil then
		return 0
	end;
	local x,_,z = getWorldTranslation( self.acRefNode );
	x = x - self.acDirectionBeforeTurn.x;
	z = z - self.acDirectionBeforeTurn.z;
	return math.sqrt( x*x + z*z )
end

------------------------------------------------------------------------
-- getTraceLength
------------------------------------------------------------------------
function AutoCombine.getTraceLength( self )
	if self.acDirectionBeforeTurn.trace == nil then
		return 0;
	end;
	
	if table.getn(self.acDirectionBeforeTurn.trace) < 2 then
		return 0;
	end;
	
	local i = AutoCombine.getFirstTraceIndex( self );
	if i == nil then
		return 0;
	end
	
	local x = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].px - self.acDirectionBeforeTurn.sx;
	local z = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].pz - self.acDirectionBeforeTurn.sz;
	
	return math.sqrt( x*x + z*z );
end;

------------------------------------------------------------------------
-- getTurnAngle
------------------------------------------------------------------------
function AutoCombine.getTurnAngle( self )			
	if self.acDirectionBeforeTurn.a == nil then
		local i = AutoCombine.getFirstTraceIndex( self );
		if i == nil then
			return 0
		end
		if i == self.acDirectionBeforeTurn.traceIndex then
			return 0
		end
		local l = AutoCombine.getTraceLength( self );
		if l < 1E-3 then
			return 0
		end

		local vx = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].px - self.acDirectionBeforeTurn.trace[i].px;
		local vz = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].pz - self.acDirectionBeforeTurn.trace[i].pz;		
		self.acDirectionBeforeTurn.a = Utils.getYRotationFromDirection(vx/l,vz/l);
	end;

	local x,y,z = localDirectionToWorld( self.acRefNode, 0,0,1 );
	
	local angle = Utils.getYRotationFromDirection(x,z) - self.acDirectionBeforeTurn.a;
	while angle < math.pi do 
		angle = angle+math.pi+math.pi; 
	end;
	while angle > math.pi do
		angle = angle-math.pi-math.pi; 
  end;
	
	return angle;
end;	

------------------------------------------------------------------------
-- getRelativeYRotation
------------------------------------------------------------------------
function AutoCombine.getRelativeYRotation(root,node)
	local x, y, z = worldDirectionToLocal(node, localDirectionToWorld(root, 0, 0, 1))
	local dot = z
	dot = dot / Utils.vector2Length(x, z)
	local angle = math.acos(dot)
	if x < 0 then
		angle = -angle
	end
	return angle
end

------------------------------------------------------------------------
-- Manually switch to next turn stage
------------------------------------------------------------------------
function AutoCombine:setNextTurnStage(noEventSend)

	if self.acParameters.enabled then
		if     self.acTurnStage == 2  then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			self.acTurnStage   = 3;
			self.setAIImplementsMoveDown(self,true);
		elseif self.acTurnStage == 12 then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			if self.acTurn2Outside then
				self.acTurn2Outside = false;
				self.acTurnStage   = 13;
			else
				self.acTurnStage   = 14;
			end
		elseif self.acTurnStage == 15 then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			self.acTurnStage   = 17;
		elseif self.acTurnStage == 17 then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			if self.acParameters.noReverse then
				self.acTurnStage   = 19;
				self.setAIImplementsMoveDown(self,true);
			else
				self.acTurn2Outside = true;
				self.turnTimer     = self.acDeltaTimeoutStop;
				self.acTurnStage   = 18;
			end
		elseif self.acTurnStage == 18 then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			self.acTurnStage   = 19;
			self.setAIImplementsMoveDown(self,true);
		end
	else
		if self.turnStage > 0 and self.turnStage < 4 then
			self.turnStage = self.turnStage + 1;
		end
	end

  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(AutoCombineNextTSEvent:new(self), nil, nil, self)
    else
      g_client:getServerConnection():sendEvent(AutoCombineNextTSEvent:new(self))
    end
  end
end;

------------------------------------------------------------------------
-- Event stuff
------------------------------------------------------------------------
function AutoCombine:getParameters()
	if self.acParameters == nil then
		self.acParameters = {}
		self.acParameters.upNDown = false;
		self.acParameters.otherCombine = false;
		self.acParameters.waitMode = false;
		self.acParameters.leftAreaActive = true;
		self.acParameters.rightAreaActive = false;
		self.acParameters.enabled = false;
		self.acParameters.noReverse = false;
		self.acParameters.CPSupport = false;
		self.acParameters.turnOffset = 0;
		self.acParameters.widthOffset = 0;
		self.acParameters.speed = 10;
	end;

	return self.acParameters;
end;

local function acReadStream(streamId)
	local parameters = {};
	
	parameters.enabled         = streamReadBool(streamId);
	parameters.upNDown	       = streamReadBool(streamId);
	parameters.waitMode        = streamReadBool(streamId);
	parameters.rightAreaActive = streamReadBool(streamId);
	parameters.otherCombine    = streamReadBool(streamId);
	parameters.noReverse       = streamReadBool(streamId);
	parameters.CPSupport       = streamReadBool(streamId);
	parameters.turnOffset      = streamReadFloat32(streamId);
	parameters.widthOffset     = streamReadFloat32(streamId);
	parameters.speed           = streamReadFloat32(streamId);

	return parameters;
end

local function acWriteStream(streamId, parameters)
	streamWriteBool(streamId, Utils.getNoNil( parameters.enabled        ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.upNDown	      ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.waitMode       ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.rightAreaActive,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.otherCombine   ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.noReverse      ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.CPSupport      ,false ));
	streamWriteFloat32(streamId, Utils.getNoNil( parameters.turnOffset  ,0 ));
	streamWriteFloat32(streamId, Utils.getNoNil( parameters.widthOffset ,0 ));
	streamWriteFloat32(streamId, Utils.getNoNil( parameters.speed       ,10 ));
end

function AutoCombine:setParameters(parameters)
	local turnOffset = 0;
	if self.acParameters ~= nil and self.acParameters.turnOffset ~= nil then
		turnOffset = self.acParameters.turnOffset
	end
	local widthOffset = 0;
	if self.acParameters ~= nil and self.acParameters.widthOffset ~= nil then
		widthOffset = self.acParameters.widthOffset
	end
	
	self.acParameters = {}
	self.acParameters.enabled         = Utils.getNoNil(parameters.enabled        ,false);
	self.acParameters.upNDown         = Utils.getNoNil(parameters.upNDown        ,false);
	self.acParameters.waitMode        = Utils.getNoNil(parameters.waitMode       ,false);
	self.acParameters.rightAreaActive = Utils.getNoNil(parameters.rightAreaActive,false);
	self.acParameters.otherCombine    = Utils.getNoNil(parameters.otherCombine   ,false);
	self.acParameters.noReverse       = Utils.getNoNil(parameters.noReverse      ,false);
	self.acParameters.CPSupport       = Utils.getNoNil(parameters.CPSupport      ,false);
	self.acParameters.turnOffset      = Utils.getNoNil(parameters.turnOffset     ,0);
	self.acParameters.widthOffset     = Utils.getNoNil(parameters.widthOffset    ,0);
	self.acParameters.speed           = Utils.getNoNil(parameters.speed          ,10);
	self.acParameters.leftAreaActive  = not self.acParameters.rightAreaActive;
		
	if self.acDimensions ~= nil then
		if     math.abs( self.acParameters.turnOffset  - turnOffset  ) > 1E-6
				or math.abs( self.acParameters.widthOffset - widthOffset ) > 1E-6 then
			AutoCombine.calculateDistances( self )
		end
	end
end

function AutoCombine:readStream(streamId, connection)
  AutoCombine.setParameters( self, acReadStream(streamId) );
end

function AutoCombine:writeStream(streamId, connection)
  acWriteStream(streamId,AutoCombine.getParameters(self));
end

function AutoCombine:sendParameters(noEventSend)
	if self.acDimensions ~= nil then
		AutoCombine.calculateDistances( self )
	end

  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(AutoCombineParametersEvent:new(self, AutoCombine.getParameters(self)), nil, nil, self)
    else
      g_client:getServerConnection():sendEvent(AutoCombineParametersEvent:new(self, AutoCombine.getParameters(self)))
    end
  end
end;

AutoCombineParametersEvent = {}
AutoCombineParametersEvent_mt = Class(AutoCombineParametersEvent, Event)
InitEventClass(AutoCombineParametersEvent, "AutoCombineParametersEvent")
function AutoCombineParametersEvent:emptyNew()
  local self = Event:new(AutoCombineParametersEvent_mt)
  return self
end
function AutoCombineParametersEvent:new(object, parameters)
  local self = AutoCombineParametersEvent:emptyNew()
  self.object     = object;
  self.parameters = parameters;
  return self
end
function AutoCombineParametersEvent:readStream(streamId, connection)
  local id = streamReadInt32(streamId)
  self.object = networkGetObject(id)
	self.parameters = acReadStream(streamId);
  self:run(connection)
end
function AutoCombineParametersEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.object))
	acWriteStream(streamId, self.parameters);
end
function AutoCombineParametersEvent:run(connection)
  AutoCombine.setParameters(self.object,self.parameters);
  if not connection:getIsServer() then
    g_server:broadcastEvent(AutoCombineParametersEvent:new(self.object, self.parameters), nil, connection, self.object)
  end
end


AutoCombineNextTSEvent = {}
AutoCombineNextTSEvent_mt = Class(AutoCombineNextTSEvent, Event)
InitEventClass(AutoCombineNextTSEvent, "AutoCombineNextTSEvent")
function AutoCombineNextTSEvent:emptyNew()
  local self = Event:new(AutoCombineNextTSEvent_mt)
  return self
end
function AutoCombineNextTSEvent:new(object)
  local self = AutoCombineNextTSEvent:emptyNew()
  self.object     = object;
  return self
end
function AutoCombineNextTSEvent:readStream(streamId, connection)
  local id = streamReadInt32(streamId)
  self.object = networkGetObject(id)
  self:run(connection)
end
function AutoCombineNextTSEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.object))
end
function AutoCombineNextTSEvent:run(connection)
  AutoCombine.setNextTurnStage(self.object,true);
  if not connection:getIsServer() then
    g_server:broadcastEvent(AutoCombineNextTSEvent:new(self.object), nil, connection, self.object)
  end
end

AutoCombineTurnStageEvent = {}
AutoCombineTurnStageEvent_mt = Class(AutoCombineTurnStageEvent, Event)
InitEventClass(AutoCombineTurnStageEvent, "AutoCombineTurnStageEvent")
function AutoCombineTurnStageEvent:emptyNew()
  local self = Event:new(AutoCombineTurnStageEvent_mt)
  return self
end
function AutoCombineTurnStageEvent:new(object,turnStage)
  local self = AutoCombineTurnStageEvent:emptyNew()
  self.object     = object;
	self.turnStage  = turnStage;
  return self
end
function AutoCombineTurnStageEvent:readStream(streamId, connection)
  local id = streamReadInt32(streamId)
  self.object    = networkGetObject(id)
	self.turnStage = streamReadInt32(streamId)
  self:run(connection)
end
function AutoCombineTurnStageEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.object))
  streamWriteInt32(streamId, self.turnStage)
end
function AutoCombineTurnStageEvent:run(connection)
  self.object.acTurnStage     = self.turnStage;
  self.object.acTurnStageSent = self.turnStage;
  if not connection:getIsServer() then
    g_server:broadcastEvent(AutoCombineTurnStageEvent:new(self.object,self.turnStage), nil, connection, self.object)
  end
end

------------------------------------------------------------------------
-- AutoCombineInt32Event
------------------------------------------------------------------------
function AutoCombine:setInt32Value( name, value, noEventSend )
	
	if noEventSend == nil or not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(AutoCombineInt32Event:new(self,name,value), nil, nil, self)
		else
			g_client:getServerConnection():sendEvent(AutoCombineInt32Event:new(self,name,value))
		end
	end
	
	if     name == "status" then
		if self.acMogliInitDone then
			Mogli.setStatus( self, value )		
		end
	elseif name == "turnStage" then
		self.acTurnStage     = value
		self.acTurnStageSent = value
	else
		self[name] = value
	end
end


AutoCombineInt32Event = {}
AutoCombineInt32Event_mt = Class(AutoCombineInt32Event, Event)
InitEventClass(AutoCombineInt32Event, "AutoCombineInt32Event")
function AutoCombineInt32Event:emptyNew()
  local self = Event:new(AutoCombineInt32Event_mt)
  return self
end
function AutoCombineInt32Event:new(object,name,value)
  local self = AutoCombineInt32Event:emptyNew()
  self.object = object
	self.name   = name
	self.value  = value
  return self
end
function AutoCombineInt32Event:readStream(streamId, connection)
  local id = streamReadInt32(streamId)
  self.object = networkGetObject(id)
	self.name   = streamReadString(streamId)
	self.value 	= streamReadInt32(streamId)
  self:run(connection)
end
function AutoCombineInt32Event:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.object))
  streamWriteString(streamId,self.name)
  streamWriteInt32(streamId, self.value)
end
function AutoCombineInt32Event:run(connection)
  AutoCombine.setInt32Value( self.object, self.name, self.value, true )
  if not connection:getIsServer() then
    g_server:broadcastEvent(AutoCombineInt32Event:new(self.object,self.name,self.value), nil, connection, self.object)
  end
end

