--
-- MPOwner
--
-- @author  ANDR55
-- Version 0.1
-- @date 31.05.2014

MPOwner = {};

source(g_currentModDirectory.."MPOwnerEvent.lua");
source(g_currentModDirectory.."MPOwnerRefreshEvent.lua");

local esl_directory = g_currentModDirectory;

function MPOwner.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;


function MPOwner:load(xmlFile)
	self.MPOwner = {};
	self.MPOwner.owner = "";
end;

function MPOwner:delete()
end;

function MPOwner:readStream(streamId, connection)
	
end;

function MPOwner:readUpdateStream(streamId, timestamp, connection)

end

function MPOwner:writeStream(streamId, connection)
	
end;

function MPOwner:writeUpdateStream(streamId, connection, dirtyMask)

end

function MPOwner:mouseEvent(posX, posY, isDown, isUp, button)

end;

function MPOwner:keyEvent(unicode, sym, modifier, isDown)

end;

function MPOwner:updateTick(dt)

end;


function MPOwner:update(dt)
	
	if self.MPOwner == nil then
		self.MPOwner = {}
	end
	
	if not self.MPOwner.initialize then
		--Broadcast auslsen
		g_client:getServerConnection():sendEvent(MPOwnerRefreshEvent:new(self));
		self.MPOwner.initialize = true;
	end;
	
    if self.isActive then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.MPOWNER_CHANGE) then
				
				local user = ""
				
				if self.MPOwner.owner ~= self.controllerName then
					user = self.controllerName
				end;

				g_client:getServerConnection():sendEvent(MPOwnerEvent:new(self, user));
			end;
		end;
	end;
	
	
	if self == g_currentMission.controlledVehicle then
		if self.isActive then
			if self.MPOwner.owner == "" then
				g_currentMission:addHelpButtonText("Besitzer:".." ".."keiner", InputBinding.MPOWNER_CHANGE);
				--g_currentMission:addHelpButtonText(g_i18n:getText("MPOWNER_CHANGE")..": "..g_i18n:getText("MPOWNER_CHANGE_NOBODY"), InputBinding.MPOWNER_CHANGE);
			else
				g_currentMission:addHelpButtonText("Besitzer:".." "..Utils.getNoNil(self.MPOwner.owner, "keiner"), InputBinding.MPOWNER_CHANGE);
				--g_currentMission:addHelpButtonText(g_i18n:getText("MPOWNER_CHANGE")..": "..Utils.getNoNil(self.MPOwner.owner, g_i18n:getText("MPOWNER_CHANGE_NOBODY")), InputBinding.MPOWNER_CHANGE);
			end;
		end;
	end;
	
end;

function MPOwner:draw()


end;

function MPOwner:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	local valueStr = getXMLString(xmlFile, key.."#owner");
	if valueStr ~= nil then
		self.MPOwner.owner = valueStr;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function MPOwner:getSaveAttributesAndNodes(nodeIdent)

	local attributes = 'owner="'..Utils.getNoNil(self.MPOwner.owner)..'"';
    return attributes, nil;
end;

