loadMapObject = {};
g_BaseDir = g_currentModDirectory;

function loadMapObject:loadMap(name)
	local xmlFile = loadXMLFile("optionsFile", Utils.getFilename("loadMapObject.xml", g_BaseDir));
	local i=0;
	while true do
		local mapname = getXMLString(xmlFile,string.format("options.map(%d)#path",i));
		if mapname == nil or mapname == "" then break; end;
		if string.find(name,mapname,1) then
			g_currentMission.isLoadingMap = true;
			local f = 0;
			while true do
				local rootNode = g_currentMission.maps[1];
				local objstr = string.format("options.map(%d).remove(%d)",i,f);
				if not hasXMLProperty(xmlFile,objstr) then break; end;
				local remIndex = getXMLString(xmlFile,objstr.."#index");
				if remIndex ~= nil and remIndex ~= "" then
					local remObj = Utils.indexToObject(rootNode,remIndex);
					delete(remObj);
				else
					local remName = getXMLString(xmlFile,objstr.."#name");
					if remName ~= nil and remName ~= "" then
						local child = getChild(rootNode,remName);
						if child ~= nil and child ~= 0 then
							delete(child);
						end;
					end;
				end;
				f=f+1;
			end;
			f=0;
			while true do
				local objstr = string.format("options.map(%d).insert(%d)",i,f);
				local filename = getXMLString(xmlFile,objstr.."#file");
				if filename == nil or filename == "" then break; end;
				local mapObject = g_currentMission:loadMap(Utils.getFilename(filename, g_BaseDir));
				local transStr = getXMLString(xmlFile,objstr.."#translation");
				if transStr ~= nil and transStr ~= "" then
					local x,y,z = Utils.getVectorFromString(transStr);
					setTranslation(mapObject,Utils.getNoNil(x,0),Utils.getNoNil(y,0),Utils.getNoNil(z,0));
				end;
				local rotStr = getXMLString(xmlFile,objstr.."#rotation");
				if rotStr ~= nil and rotStr ~= "" then
					local x,y,z = Utils.getVectorFromString(rotStr);
					setRotation(mapObject,math.rad(Utils.getNoNil(x,0)),math.rad(Utils.getNoNil(y,0)),math.rad(Utils.getNoNil(z,0)));
				end;
				f=f+1;
			end;
			g_currentMission.isLoadingMap = false;
			break;
		else
			i=i+1;
		end;
	end;
end;

function loadMapObject:deleteMap()
end;

function loadMapObject:mouseEvent(posX, posY, isDown, isUp, button)
end;

function loadMapObject:keyEvent(unicode, sym, modifier, isDown)
end;

function loadMapObject:update(dt)
end;

function loadMapObject:draw(dt)
end;

addModEventListener(loadMapObject);