-- by "Marhu" 
-- v 1.0
-- Date: 30.03.2013
-- to send MilkTruck TriggerEvent for MilkTrailer

MilchTriggerCallbackEvent = {};
MilchTriggerCallbackEvent_mt = Class(MilchTriggerCallbackEvent, Event);

InitEventClass(MilchTriggerCallbackEvent, "MilchTriggerCallbackEvent");

function MilchTriggerCallbackEvent:emptyNew()
    local self = Event:new(MilchTriggerCallbackEvent_mt);
    return self;
end;
    
function MilchTriggerCallbackEvent:new(object, id, fill, add)
	local self = MilchTriggerCallbackEvent:emptyNew();
	self.object = object;
	self.id = id;
	self.fill = fill;
	self.add = add;
	return self;
end;

function MilchTriggerCallbackEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.id = streamReadInt32(streamId);
	self.fill = streamReadBool(streamId);
	self.add = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function MilchTriggerCallbackEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.id);
	streamWriteBool(streamId, self.fill);
	streamWriteBool(streamId, self.add);
end;

function MilchTriggerCallbackEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		local trigger = {id = self.id}
		if self.fill then
			trigger.fillMilk = true;
		else
			trigger.buyMilk = true;
		end;
		if self.add then
			self.object:addMilchTrailerFillTrigger(trigger, false, true);
		else
			self.object:removeMilchTrailerFillTrigger(trigger, false, true);
		end;
	end;
end;

function MilchTriggerCallbackEvent.sendEvent(vehicle, id, fill, add, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MilchTriggerCallbackEvent:new(vehicle, id, fill, add), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MilchTriggerCallbackEvent:new(vehicle, id, fill, add));
		end;
	end;
end;