-- by "Marhu" 
-- v 1.0
-- Date: 10.05.2013
--"Register Animal Fill Types"

RegAnimal = {};
RegAnimal.dir = g_currentModDirectory

local org_FSBaseMission_loadMap = FSBaseMission.loadMap
FSBaseMission.loadMap = function(a, b, c, d, e)
	if a.baseDirectory == RegAnimal.dir then
		local xmlFile = loadXMLFile("TempXML", RegAnimal.dir.."modDesc.xml");
		local Key = "modDesc.RegAnimal";
		local i=0;
		while true do
			local AnimalKey = Key..string.format(".Animal(%d)", i);
			if not hasXMLProperty(xmlFile, AnimalKey) then
				break;
			end;
			local name = getXMLString(xmlFile, AnimalKey.."#name");
			local price = getXMLFloat(xmlFile, AnimalKey.."#price");
			local Eco = getXMLBool(xmlFile, AnimalKey.."#Eco");
			local hud = getXMLString(xmlFile, AnimalKey.."#hud");
			local HudFile = RegAnimal.dir..hud;
			local FillType = Fillable.registerFillType(name, g_i18n:getText(name), price, Eco, HudFile)
			if Fillable.fillTypeIndexToDesc[FillType].nameI18N then
				FSBaseMission.addFillTypeOverlay(a,FillType,HudFile)
				print("  Register fill type: ",Fillable.fillTypeIndexToDesc[FillType].nameI18N);
			end
			i=i+1;
		end;
		delete(xmlFile);
	end
	ra,rb,rc,rd,re = org_FSBaseMission_loadMap(a, b, c, d, e)
	return ra,rb,rc,rd,re 
end

