
fastSwitcherClass = {};

-- Position & color properties (TODO: make these user-configurable)
fastSwitcherClass.posX = 0.2;
fastSwitcherClass.posY = 0.7;
fastSwitcherClass.fontSize = 0.02;
fastSwitcherClass.lineDist = fastSwitcherClass.fontSize + 0.003;
fastSwitcherClass.fontForecolor = {1.0, 1.0, 1.0, 1.0}; -- white
fastSwitcherClass.fontBackcolor = {0.0, 0.0, 0.0, 1.0}; -- black

-- Register as event listener
addModEventListener(fastSwitcherClass);


function fastSwitcherClass:loadSteerable(xmlFile)
  -- Try to find the name of the vehicle.
  if self.name == nil then self.name = getXMLString(xmlFile, "vehicle.name.".. g_languageShort); end
  if self.name == nil then self.name = getXMLString(xmlFile, "vehicle.name"); end
  if self.name == nil then self.name = getXMLString(xmlFile, "vehicle#type"); end
  if self.name == nil then
      self.name = "Steerable" -- Oh well, lets just call it this then!
  end
end
Steerable.load  = Utils.appendedFunction(Steerable.load, fastSwitcherClass.loadSteerable);

function  fastSwitcherClass:loadAttachable(xmlFile)
  -- Try to find the name of the attachable
  if self.name == nil then self.name = getXMLString(xmlFile, "vehicle.name.".. g_languageShort); end
  if self.name == nil then self.name = getXMLString(xmlFile, "vehicle.name"); end
  if self.name == nil then self.name = getXMLString(xmlFile, "vehicle#type"); end
  if self.name == nil then
      self.name = "Attachable" -- Oh well, lets just call it this then!
  end
end
Attachable.load = Utils.appendedFunction(Attachable.load, fastSwitcherClass.loadAttachable);


function fastSwitcherClass:loadMap(name)
end;

function fastSwitcherClass:deleteMap()
end;

function fastSwitcherClass:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fastSwitcherClass:keyEvent(unicode, sym, modifier, isDown)
  if isDown then
    local key
    if sym <= 57 and sym >= 48 then             -- Keys '0' to '9'
--print("FastSwitcher.keyEvent(). sym="..sym..", modifier="..modifier)
      if bitAND(modifier,4095) == 64 then       -- Left CTRL
-- 111111111111 = 4095
-- 000001000000 = 64
        key = tonumber(string.char(sym))
        if key == 0 then key = 10; end
      elseif bitAND(modifier,4095) == 128 then  -- Right CTRL
-- 111111111111 = 4095
-- 000010000000 = 128
        key = tonumber(string.char(sym))
        if key == 0 then key = 10; end
        key = key + 10
      elseif bitAND(modifier,4095) == 65 then  -- Left CTRL + Left Shift
-- 111111111111 = 4095
-- 000001000001 = 65
        key = tonumber(string.char(sym))
        if key == 0 then key = 10; end
        key = key + 20
      elseif bitAND(modifier,4095) == 130 then  -- Right CTRL + Right Shift
-- 111111111111 = 4095
-- 000010000010 = 130
        key = tonumber(string.char(sym))
        if key == 0 then key = 10; end
        key = key + 30
      end
    end

    if key ~= nil then
      local vehicles = table.getn(g_currentMission.steerables)
      if vehicles > 0 and key <= vehicles then
        Input.keyPressedState = {}  -- Try to make sure, that the next vehicle dont get anything activated.

        if not g_currentMission.steerables[key].isEntered then
--        g_currentMission:toggleVehicle( <index_offset> )  -- Somehow I think this could be used, to make it work in multiplayer. But I have no way of testing it.

--[[
          if not g_currentMission.controlPlayer then
            g_currentMission:onLeaveVehicle()
          end
          g_currentMission:onEnterVehicle(g_currentMission.steerables[key])
]]

            -- Inspired by 'Switcher V2' by edmund.
            if g_currentMission.steerables[key].isControlled == false then
                g_client:getServerConnection():sendEvent(VehicleEnterRequestEvent:new(g_currentMission.steerables[key], g_settingsNickname));
            end;



--        if g_currentMission.controlPlayer then
--          --print("FastSwitcher.keyEvent(). g_currentMission.controlPlayer")
--          Input.keyPressedState = {}
--          g_currentMission:onEnterVehicle(g_currentMission.steerables[key])
--        else
--          local current
--          for i=1,table.getn(g_currentMission.steerables) do
--            if g_currentMission.currentVehicle == g_currentMission.steerables[i] then
--              current = i
--              break
--            end
--          end
--          --print("FastSwitcher.keyEvent(). currentVehicle="..Utils.getNoNil(g_currentMission.currentVehicle, "nil")..",key="..key)
--          if current ~= nil and key ~= current then
--            local vehicle = key - current
--            --print("FastSwitcher.keyEvent(). vehicle="..vehicle)
--            Input.keyPressedState = {}
--            g_currentMission:toggleVehicle(vehicle)
--          else
--            Input.keyPressedState = {}
--            g_currentMission:onLeaveVehicle()
--            g_currentMission:onEnterVehicle(g_currentMission.steerables[key])
--          end
--        end
        end
      end
    end
  end
end

function renderTextWithShade(x,y, textSize, text)
    --setTextColor(0.0, 0.0, 0.0, 1.0);   -- black
    setTextColor(unpack(fastSwitcherClass.fontBackcolor));
    renderText(x, y - (textSize/10), textSize, text);
    --setTextColor(1.0, 1.0, 1.0, 1.0);   -- white
    setTextColor(unpack(fastSwitcherClass.fontForecolor));
    renderText(x, y, textSize, text);
end;

function fastSwitcherClass:update(dt)
end;

---- http://lua-users.org/wiki/StringTrim
--function fastSwitcherClass.trim(s)
--  return s:match'^%s*(.*%S)' or ''
--end

function fastSwitcherClass:draw()

-- Debug code.
--  for i=1,350 do
--    if Input.keyPressedState[i] then
--        print("Input.keyPressedState[".. i .."]")
--    end
--  end
-- Debug end.

  local form
  if Input.keyPressedState[306] then        -- left CTRL
    form = 1
    if Input.keyPressedState[304] then      -- left SHIFT
      form = 21
    end
  elseif Input.keyPressedState[305] then    -- right CTRL
    form = 11
    if Input.keyPressedState[303] then      -- right SHIFT
      form = 31
    end
  end

  if form ~= nil then
    local posX     = fastSwitcherClass.posX;
    local posY     = fastSwitcherClass.posY;
    local fontSize = fastSwitcherClass.fontSize;
    local lineDist = fastSwitcherClass.lineDist;
    
    setTextAlignment(RenderText.ALIGN_LEFT);
    setTextBold(true);

    renderTextWithShade(posX, posY-(-1.5)*lineDist, fontSize+0.005, "== ".. g_i18n:getText("vehicles") .." "..form.." - "..(form+9).." ==== FastSwitcher ==");
    
    for line=0,9 do
      local veh = g_currentMission.steerables[line+form];
      if veh ~= nil then
        -- Prefix with vehicle number
        local txt = string.format("%2d: ", line+form) .. veh.name;

        if (veh.attachedImplements[1] ~= nil and veh.attachedImplements[1].object ~= nil) then
          txt = txt .. " - ".. g_i18n:getText("with") .." '".. Utils.getNoNil(veh.attachedImplements[1].object.name, "(implement1)") .."'";
          --
          if (veh.attachedImplements[2] ~= nil and veh.attachedImplements[2].object ~= nil) then
            txt = txt ..                              " & '".. Utils.getNoNil(veh.attachedImplements[2].object.name, "(implement2)") .."'";
          end;
        end;

        renderTextWithShade(posX, posY-(line*lineDist), fontSize, txt);

        -- If controlled by player or AI
        if veh.isControlled or veh.isHired then 
          if veh.isControlled then
            txt = Utils.getNoNil(veh.controllerName, "(player)");
          elseif veh.isHired then
            txt = g_i18n:getText("hired"); 
          end;
          setTextAlignment(RenderText.ALIGN_RIGHT);
          renderTextWithShade(posX-0.01, posY-(line*lineDist), fontSize, txt);
          setTextAlignment(RenderText.ALIGN_LEFT);
        end;
      end;
    end;
  end;
end;

print("Script loaded: FastSwitcher.lua (v1.3)");
