-- LS15Money(original: SrsMoney)
-- by hummel (modhoster)

LS15Money = {};

function LS15Money:loadMap(name)
  self.money_amount = 0;
end;

function LS15Money:keyEvent(unicode, sym, modifier, isDown)
  if bitAND(modifier, Input.MOD_ALT) > 0 and bitAND(modifier, Input.MOD_CTRL) > 0 then
    if InputBinding.isPressed(InputBinding.HONK) then
      self.money_amount = 1000000;
    end
    
    if InputBinding.isPressed(InputBinding.TOGGLE_BEACON_LIGHTS) then
      self.money_amount = -1000000;
    end

    if self.money_amount ~= 0 and g_server == nil then
      g_client:getServerConnection():sendEvent(LS13MoneyEvent:new(self));
    end;
  end;		
end;

function LS15Money:update(dt)
  if self.money_amount ~= 0 and g_server ~= nil then 
    g_currentMission:addSharedMoney(self.money_amount);
    self.money_amount = 0;
  end;
end;

function LS15Money:draw()
end;

function LS15Money:deleteMap()
end;

function LS15Money:mouseEvent(posX, posY, isDown, isUp, button)
end;

addModEventListener(LS15Money);

LS13MoneyEvent = {};
LS13MoneyEvent_mt = Class(LS15MoneyEvent, Event);

InitEventClass(LS15MoneyEvent, "LS15MoneyEvent");

function LS15MoneyEvent:readStream(streamId, connection)
  self.object = LS15Money;
  self.object.money_amount = streamReadInt32(streamId);
end;

function LS15MoneyEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, self.object.money_amount);
end;

function LS15MoneyEvent:new(object)
  local self = LS15MoneyEvent:emptyNew()
  self.object = object;
  return self;
end;

function LS15MoneyEvent:emptyNew()
  local self = Event:new(LS15MoneyEvent_mt);
  self.className="LS15MoneyEvent";
  return self;
end;
