SetDuelRWheelsEvent = {};
SetDuelRWheelsEvent_mt = Class(SetDuelRWheelsEvent, Event);

InitEventClass(SetDuelRWheelsEvent, "SetDuelRWheelsEvent");

function SetDuelRWheelsEvent:emptyNew()
      local self = Event:new(SetDuelRWheelsEvent_mt);
      self.className="SetDuelRWheelsEvent";
      return self;
end;

function SetDuelRWheelsEvent:new(object, active)
      local self = SetDuelRWheelsEvent:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;

function SetDuelRWheelsEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
 end;

function SetDuelRWheelsEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;

function SetDuelRWheelsEvent:run(connection)
      self.object:setDuelWheelsVisibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDuelRWheelsEvent:new(self.object, self.active), nil, connection, self.object);
      end;
end;