SetDuelFWheelsEvent = {};
SetDuelFWheelsEvent_mt = Class(SetDuelFWheelsEvent, Event);

InitEventClass(SetDuelFWheelsEvent, "SetDuelFWheelsEvent");

function SetDuelFWheelsEvent:emptyNew()
      local self = Event:new(SetDuelFWheelsEvent_mt);
      self.className="SetDuelFWheelsEvent";
      return self;
end;

function SetDuelFWheelsEvent:new(object, active)
      local self = SetDuelFWheelsEvent:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;

function SetDuelFWheelsEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
 end;

function SetDuelFWheelsEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;

function SetDuelFWheelsEvent:run(connection)
      self.object:setDuelFWheelsVisibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDuelFWheelsEvent:new(self.object, self.active), nil, connection, self.object);
      end;
end;