-- Lulu88520
-- Script pour la benne leboulch k150
-- Ls-Modteam-France
-- @date  09/06/2014
-- http://www.ls-modteam-france.com

k150 = {};

function k150.prerequisitesPresent(specializations)
	  return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function k150:load(xmlFile)
    self.setIsCaissonDown = SpecializationUtil.callSpecializationsFunction("setIsCaissonDown");
    self.toggleSupport = SpecializationUtil.callSpecializationsFunction("toggleSupport");  
    self.manualSupportAnimation = getXMLString(xmlFile, "vehicle.manualSupport#animationName");
    self.supportRangeIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manualSupport#rangeIndex"));
    self.isInRangeSupport = false;
    self.isSupportDown = true;
 	
	self.animPortes = false;   
	
	self.playerinrange = false;	
		
	self.portesNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.portesNode#index"));	
	self.smokeParticleSystems = {};
    local entry = {};
      entry.ps = {};
      Utils.loadParticleSystem(xmlFile, entry.ps, "vehicle.smokeParticleSystem", self.components, false, nil, self.baseDirectory);
      if table.getn(entry.ps) > 0 then
          entry.isActive = false;
          table.insert(self.smokeParticleSystems, entry);
      end
      local i=0;
      while true do
          local baseName = string.format("vehicle.smokeParticleSystems.smokeParticleSystem(%d)", i);
          if not hasXMLProperty(xmlFile, baseName) then
              break;
          end;
          local entry = {};
          entry.ps = {};
          Utils.loadParticleSystem(xmlFile, entry.ps, baseName, self.components, false, nil, self.baseDirectory);
          if table.getn(entry.ps) > 0 then
              entry.isActive = false;
             entry.cuttingArea = i+1;
              table.insert(self.smokeParticleSystems, entry);
          end
          i = i+1;
      end; 
	  
	  
	  --lever manuel	 
	  
	self.caisson = {};
	self.caisson.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.caisson#index"));
	
	self.minrotation = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.caisson#minRot"), 0));
	
	self.caisson.minRot = {self.minrotation,0,0};
	
	self.maxrotation = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.caisson#maxRot"), 0));
	self.caisson.maxRot = {self.maxrotation,0,0};
	self.caisson.rotTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.caisson#rotTime"), 3) * 1000;
	self.caisson.liftTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.caisson#liftTime"), 3) * 1000;
	self.caisson.currentRotLimit = {0};
	self.isExpanded = false;
	self.caisson.isDown = false;

        self.barre = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.barre#index"));
        setVisibility(self.barre, true);

        self.barreElevation = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.barreElevation#index"));
        setVisibility(self.barreElevation, false);
	
	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;	
	
	
		
	
end;

function k150:delete()
for _, entry in ipairs(self.smokeParticleSystems) do
          Utils.deleteParticleSystem(entry.ps);
          entry.isActive = false;
end;
end;

function k150:readStream(streamId, connection)
   self.animPortes = streamReadBool(streamId);	
   local isSupportDown = streamReadBool(streamId);
   self:toggleSupport(isSupportDown, true); 
   local isCaissonDown = streamReadBool(streamId);
   self:setIsCaissonDown(isCaissonDown, true);
end;

function k150:writeStream(streamId, connection)
streamWriteBool(streamId, self.animPortes);
streamWriteBool(streamId, self.isSupportDown);
streamWriteBool(streamId, self.caisson.isDown);	      
end;

function k150:mouseEvent(posX, posY, isDown, isUp, button)
end;

function k150:keyEvent(unicode, sym, modifier, isDown) 
        if self:getIsActiveForInput(false) then		
		if sym == self.keys.caissonUP then 
			self.caisson.isDownMax = isDown	
		end;

		if sym == self.keys.caissonDOWN then
			self.caisson.isDownMin = isDown		
		end;		
	end; 
end;

function k150:update(dt)

         if self:getIsActive() then		
		if self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			-- Show warning about the support being down
			if self.isSupportDown then
				g_currentMission:addWarning(string.format(g_i18n:getText("BJR_SUPPORT_WARNING")), 0.018, 0.033);
			end;
		end;
	end;
         if self.supportRangeIndex then
		-- Manage key events for inrange support --
		if self.isInRangeSupport then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				if self.isSupportDown then
					self:toggleSupport(false);
				else
					self:toggleSupport(true);
				end;
			end;
			-- Display key when in range --
			if self.isSupportDown then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_RAISE_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_LOWER_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			end;
		end;
	end;
	

	if self.sendanimPortes ~= self.animPortes then
    self.sendanimPortes = self.animPortes;
    animPortesEvent:sendEvent(self, self.animPortes);
end;


	if self.playerinrange then
		if InputBinding.hasEvent(InputBinding.PORTES) and self.fillLevel <= 0 then
			self.animPortes = not self.animPortes			
		end;

		if self.animPortes then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Fermer_portes"), self.typeDesc), InputBinding.PORTES);
		else if self.fillLevel <= 0 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Ouvrir_portes"), self.typeDesc), InputBinding.PORTES);
			end;
		end;
		
		if self.fillLevel > 0 then
		 g_currentMission:addExtraPrintText(g_i18n:getText("WARNING_BENNE_PLEINE"));
		 end;
	end;

	

	
end;

function k150:updateTick(dt)
for _, tool in pairs(self.movingTools) do
   tool.isDirty = true;
end;
        if self.supportRangeIndex then
		if g_currentMission.player ~= nil then
			-- Getting the distance between the player and the support
			local nearestDistance = 1.5; --max distance allowed
			local px, py, pz = getWorldTranslation(self.supportRangeIndex);
			local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				self.isInRangeSupport = true;
			else
				self.isInRangeSupport = false;
			end;
		end;
	else
		self.isInRangeSupport = false;
	end;
	
	 for _, part in pairs(self.movingParts) do
					part.isDirty = true;
		end;    

if self.isClient then               
  if self.animPortes then               
			   self:setAnimationTime(1, self.animationParts[1].animDuration)
          else       			
				self:setAnimationTime(1, self.animationParts[1].startPosition);       
	end;
end;    
  


  	if self.attacherVehicle and g_currentMission.player ~= nil then
		local nearestDistance = 2.0;
		local px, py, pz = getWorldTranslation(self.portesNode);
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.playerinrange = true;
		else
			self.playerinrange = false;
		end;
	end;	
	
	if self.isClient then
               for _,ps in pairs(self.smokeParticleSystems) do                  
                  if self.currentFillType == Fillable.FILLTYPE_MANURE and self.fillLevel > 3000 and self.movingDirection == 0 then                       
                      Utils.setEmittingState(ps.ps, true);
                  else
                      Utils.setEmittingState(ps.ps, false);
                  end
               end
 end;

--lever manuel	
if self:getIsActive() then	
 local doRotate = self.caisson.isDownMax or self.caisson.isDownMin
	if doRotate then
               local x, y, z = getRotation(self.caisson.node);	
               local rot = {x,y,z};
               local newRot = Utils.getMovedLimitedValues(rot, self.caisson.maxRot, self.caisson.minRot, 3, self.caisson.rotTime, dt, not self.caisson.isDownMax);		
               setRotation(self.caisson.node, unpack(newRot));              
        end;
end;
local rx, ry, rz = getRotation(self.caisson.node);            
              if rx < -0.00001 then
                setVisibility(self.barre, false);
                setVisibility(self.barreElevation, true);
              end; 
 	      if rx == 0 then
	        setVisibility(self.barre, true);
                setVisibility(self.barreElevation, false); 
              end;
	
end;

function k150:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local isSupportDown = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isSupportDown"), false);
	self:toggleSupport(isSupportDown);	
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function k150:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'isSupportDown="' .. tostring(self.isSupportDown) .. '"';
    return attributes, nil;
end;
  
function k150:onDetach()
end;

function k150:draw() 
if g_currentMission.showHelpText and self.isClient then
      g_currentMission:addExtraPrintText(g_i18n:getText("AIDE"));  
end;

if self.attacherVehicle ~= nil then
			g_currentMission:addExtraPrintText(g_i18n:getText("caisson"))			
	end;
end;

function k150:setIsCaissonDown(isCaissonDown, noEventSend)
	SetCaissonDownEvent.sendEvent(self, isCaissonDown, noEventSend);
	self.caisson.isDownMax = isCaissonDown;
        self.caisson.isDownMin = isCaissonDown;
end;

function k150:toggleSupport(isSupportDown, noEventSend)
	ToggleSupportEvent.sendEvent(self, isSupportDown, noEventSend);	
	
	if not isSupportDown then
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, -1, nil, true);
		end;
	else
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, 1, nil, true);
		end;
	end;
	
	self.isSupportDown = isSupportDown;
end;



animPortesEvent = {};
animPortesEvent_mt = Class(animPortesEvent, Event);

InitEventClass(animPortesEvent, "animPortesEvent");

function animPortesEvent:emptyNew()
  local self = Event:new(animPortesEvent_mt);
  self.className="animPortesEvent";
  return self;
end;

function animPortesEvent:new(object, animPortes)
  local self = animPortesEvent:emptyNew();
  self.object = object;
  self.animPortes = animPortes;
  return self;
end;

function animPortesEvent:readStream(streamId, connection)
  self.object = networkGetObject(streamReadInt32(streamId));
  self.animPortes = streamReadBool(streamId);
  self:run(connection);
end;

function animPortesEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.object));
  streamWriteBool(streamId, self.animPortes);
end;

function animPortesEvent:run(connection)
  self.object.animPortes = self.animPortes;  
  if not connection:getIsServer() then
    g_server:broadcastEvent(animPortesEvent:new(self.object, self.animPortes), nil, connection, self.object);
  end;
end;

function animPortesEvent:sendEvent(object, animPortes, noEventSend)
  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(animPortesEvent:new(object, animPortes), nil, nil, object);
    else
      g_client:getServerConnection():sendEvent(animPortesEvent:new(object, animPortes));
    end;
  end;
end;

-- Support event

ToggleSupportEvent = {};
ToggleSupportEvent_mt = Class(ToggleSupportEvent, Event);

InitEventClass(ToggleSupportEvent, "ToggleSupportEvent");

function ToggleSupportEvent:emptyNew()
    local self = Event:new(ToggleSupportEvent_mt);
    return self;
end;

function ToggleSupportEvent:new(vehicle, isSupportDown)
    local self = ToggleSupportEvent:emptyNew()
    self.vehicle = vehicle;
	self.isSupportDown = isSupportDown;
    return self;
end;

function ToggleSupportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.vehicle = networkGetObject(id);
	self.isSupportDown = streamReadBool(streamId);
    self:run(connection);
end;

function ToggleSupportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.isSupportDown);
end;

function ToggleSupportEvent:run(connection)
	self.vehicle:toggleSupport(self.isSupportDown, true);
end;

function ToggleSupportEvent.sendEvent(vehicle, isSupportDown, noEventSend)
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ToggleSupportEvent:new(vehicle, isSupportDown), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ToggleSupportEvent:new(vehicle, isSupportDown));
		end;
	end;
end;


--lever manuel multi

SetCaissonDownEvent = {};
SetCaissonDownEvent_mt = Class(SetCaissonDownEvent, Event);

InitEventClass(SetCaissonDownEvent, "SetCaissonDownEvent");

function SetCaissonDownEvent:emptyNew()
	local self = Event:new(SetCaissonDownEvent_mt);
	self.className="SetCaissonDownEvent";
	return self;
end;

function SetCaissonDownEvent:new(object, isCaissonDown)
	local self = SetCaissonDownEvent:emptyNew()
	self.object = object;
	self.isCaissonDown = isCaissonDown
	return self;
end;

function SetCaissonDownEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isCaissonDown = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function SetCaissonDownEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isCaissonDown);
end;

function SetCaissonDownEvent:run(connection)
	self.object:setIsCaissonDown(self.isCaissonDown, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetCaissonDownEvent:new(self.object, self.isCaissonDown), nil, connection, self.object);
	end;
end;

function SetCaissonDownEvent.sendEvent(vehicle, isCaissonDown, noEventSend)
	if isCaissonDown ~= vehicle.caisson.isDownMax or isCaissonDown ~= vehicle.caisson.isDownMin then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetCaissonDownEvent:new(vehicle, isCaissonDown), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetCaissonDownEvent:new(vehicle, isCaissonDown));
			end;
		end;
	end;
end;