-- Author: Brain 
-- 06.02.2011

Plough9 = {};

function Plough9.prerequisitesPresent(specializations)
   return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Plough9:load(xmlFile)
	local supportNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.support#index"));
    if supportNode ~= nil then
        self.support = {};
        self.support.node = supportNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.support#minTrans"));
        self.support.minTrans = {};
        self.support.minTrans[1] = Utils.getNoNil(x, 0);
        self.support.minTrans[2] = Utils.getNoNil(y, 0);
        self.support.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.support#maxTrans"));
        self.support.maxTrans = {};
        self.support.maxTrans[1] = Utils.getNoNil(x, 0);
        self.support.maxTrans[2] = Utils.getNoNil(y, 0);
        self.support.maxTrans[3] = Utils.getNoNil(z, 0);
	    self.support.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.support#transTime"), 2)*1000;   
    end;
	
	local supportMeshNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.supportMesh#index"));
    if supportMeshNode ~= nil then
        self.supportMesh = {};
        self.supportMesh.node = supportMeshNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.supportMesh#minRot"));
        self.supportMesh.minRot = {};
        self.supportMesh.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.supportMesh.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.supportMesh.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.supportMesh#maxRot"));
        self.supportMesh.maxRot = {};
        self.supportMesh.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.supportMesh.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.supportMesh.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.supportMesh.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.supportMesh#rotTime"), 2)*1000;
        self.supportMesh.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.supportMesh#touchRotLimit"), 10));
    end;
end;

function Plough9:delete()
end;

function Plough9:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Plough9:keyEvent(unicode, sym, modifier, isDown)
end;

function Plough9:update(dt)
	if self.support ~= nil then
		local x, y, z = getTranslation(self.support.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.support.maxTrans, self.support.minTrans, 3, self.support.transTime, dt, not self.supportMax);
		setTranslation(self.support.node, unpack(newTrans));
	end;
	
	if self.supportMesh ~= nil then
    	local x, y, z = getRotation(self.supportMesh.node);
    	local rot = {x,y,z};
    	local newRot = Utils.getMovedLimitedValues(rot, self.supportMesh.maxRot, self.supportMesh.minRot, 3, self.supportMesh.rotTime, dt, not self.supportMeshMax);
    	setRotation(self.supportMesh.node, unpack(newRot));
    end;
	
	local joint = self.componentJoints[1];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
end;

function Plough9:draw()
end;

function Plough9:onAttach()
	self.supportMax = true;
	self.supportMeshMax = true;
end;

function Plough9:onDetach()
	self.supportMax = false;
	self.supportMeshMax = false;
end;