--
-- palletBags
-- Class for pallet bags
--
-- @author  PeterJ - euroDZN
-- @date  09/09/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

palletBags = {};

function palletBags.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function palletBags:load(xmlFile)
	
	self.palletBags = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.palletBags.palletBag(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local bag = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local alwaysVisible = Utils.getNoNil(getXMLBool(xmlFile, key.."#alwaysVisible"), false);
		if bag ~= nil then
			table.insert(self.palletBags, {node=bag, alwaysVisible=alwaysVisible});
		end;
		i = i + 1;
		if not self.palletBags[i].alwaysVisible then
			setVisibility(self.palletBags[i].node, false);
		--else
			--setScale(self.palletBags[i].node, 1,0.05,1);
		end;
	end;
	self.numberOfBags = table.getn(self.palletBags);
	self.bagCapacity = self.capacity/self.numberOfBags;
end;

function palletBags:delete()
end;

function palletBags:mouseEvent(posX, posY, isDown, isUp, button)
end;

function palletBags:keyEvent(unicode, sym, modifier, isDown)
end;

function palletBags:update(dt)

	if self.palletBags ~= nil then
		if self.fillLevel >= 0 and not self.buyFilled then
			for i = 1, table.getn(self.palletBags) do
				local bagFull = i * self.bagCapacity;
				local bagEmpty = (i * self.bagCapacity) - self.bagCapacity;
				if self.fillLevel >= bagEmpty then
					if self.fillLevel > 0 then
						setVisibility(self.palletBags[i].node, true);
					else
						setVisibility(self.palletBags[i].node, false);
					end;
					if self.fillLevel >= bagEmpty and self.fillLevel <= bagFull then
						setScale(self.palletBags[i].node, 1,(self.fillLevel-bagEmpty)/self.bagCapacity,1);
					end;
				else
					if not self.palletBags[i].alwaysVisible then
						setVisibility(self.palletBags[i].node, false);
					else
						if self.fillLevel < bagEmpty * 5 then
							setScale(self.palletBags[i].node, 1,0.05,1);
						end;
					end;
				end;
			end;
		end;
	end;

end;

function palletBags:draw()
end;
