-- NI Modding
--
-- author  	Henly20 
-- date  	03-11-2013.
-- ni_modding@hotmail.com
-- http://nimodding.wordpress.com

TE20 = {};

function TE20.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function TE20:load(xmlFile)

	self.drivingShaft = {};
	self.drivingShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivingShaft#index"));
    
	self.toplink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.topLink#index"));
	self.drawbar = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drawbar#index"));
	self.highhitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.highHitch#index"));
	self.drawbarLow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drawbarLow#index"));	
 	setVisibility((self.toplink), false);
 	setVisibility((self.drawbar), true);
 	setVisibility((self.highhitch), false);
 	setVisibility((self.drawbarLow), true);	
	
    self.fanNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fan#index"));
    self.fanNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fan#index1"));
	
	local rotationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
		if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
    end;
	local rotationPartNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart8#index"));
    if rotationPartNode8 ~= nil then
        self.rotationPart8 = {};
        self.rotationPart8.node = rotationPartNode8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#minRot"));
        self.rotationPart8.minRot = {};
        self.rotationPart8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#maxRot"));
        self.rotationPart8.maxRot = {};
        self.rotationPart8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#rotTime"), 2)*1000;
        self.rotationPart8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#touchRotLimit"), 10));
    end;	
end;

function TE20:delete()
end;

function TE20:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TE20:keyEvent(unicode, sym, modifier, isDown)
end;

function TE20:update(dt)

	if self.isMotorStarted then
		if self.fanNode ~= nil then
			rotate(self.fanNode, 0, 0, self.motor.lastMotorRpm*4);
		end;
		if self.fanNode1 ~= nil then
			rotate(self.fanNode1, 0, 0, self.motor.lastMotorRpm*4);
		end;
    end;
	
	if self.drivingShaft ~= nil then
		local x,y,z = getRotation(self.wheels[1].driveNode);
		setRotation(self.drivingShaft.node, 0 ,0, x*-2);	
	end;
	if self:getIsActive() then	
		if self.rotationPart4 ~= nil then
			local x, y, z = getRotation(self.rotationPart4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4Active);
			setRotation(self.rotationPart4.node, unpack(newRot));
		end;
		if self.rotationPart8 ~= nil then
			local x, y, z = getRotation(self.rotationPart8.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart8.maxRot, self.rotationPart8.minRot, 3, self.rotationPart8.rotTime, dt, not self.rotationMax8Active);
			setRotation(self.rotationPart8.node, unpack(newRot));
		end;
		if self.brakeLightsVisibility then
			self.rotationMax4Active = true;
			self.rotationMax8Active = true;
		else
			self.rotationMax4Active = false;
			self.rotationMax8Active = false;
		end;	
	end;
end;

function TE20:draw()
end;

function TE20:attachImplement(implement)	
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
			setVisibility((self.toplink), true);
			setVisibility((self.drawbar), false);
			setVisibility((self.highhitch), false);	
			setVisibility((self.drawbarLow), false);			
		end;
	end;

	if jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 2 then
			setVisibility((self.toplink), false);
			setVisibility((self.drawbar), true);
			setVisibility((self.highhitch), true);
			setVisibility((self.drawbarLow), true);			
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 3 then	
			setVisibility((self.toplink), false);
			setVisibility((self.drawbar), false);
			setVisibility((self.highhitch), false);
			setVisibility((self.drawbarLow), true);				
		end;
	end;
	self.updateJoint = true;	
end;

function TE20:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == 1 or jointIndex == 3 then
		setVisibility((self.toplink), false);
		setVisibility((self.drawbar), true);
		setVisibility((self.highhitch), false);
		setVisibility((self.drawbarLow), true);			
	end;
	if jointIndex == 2 then
		setVisibility((self.toplink), false);
		setVisibility((self.drawbar), true);
		setVisibility((self.highhitch), false);
		setVisibility((self.drawbarLow), true);			
	end
end;

function TE20:validateAttacherJoint(implement, jointDesc, dt)
	return true;
end;