  --
  -- fergSprayer
  -- Class for all sprayers
  --
  -- @author  Stefan Geiger
  -- @date  24/02/08
  --
  -- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
  
source("dataS/scripts/vehicles/specializations/SetTurnedOnEvent.lua");
source("dataS/scripts/vehicles/specializations/SprayerAreaEvent.lua");
source("dataS/scripts/vehicles/specializations/SprayerSetIsFillingEvent.lua");
fergSprayer = {};
  
  
fergSprayer.SPRAYTYPE_UNKNOWN = 0;
fergSprayer.NUM_SPRAYTYPES = 0;
  
fergSprayer.sprayTypes = {};
fergSprayer.sprayTypeIndexToDesc = {};
  
fergSprayer.sprayTypeToFillType = {};
fergSprayer.fillTypeToSprayType = {};
  
function fergSprayer.registerSprayType(name, nameI18N, pricePerLiter, litersPerSqmPerSecond, partOfEconomy, hudOverlayFilename)
      local key = "SPRAYTYPE_"..string.upper(name);
      if fergSprayer[key] == nil then
          fergSprayer.NUM_SPRAYTYPES = fergSprayer.NUM_SPRAYTYPES+1;
          fergSprayer[key] = fergSprayer.NUM_SPRAYTYPES;
  
          local desc = {name = name, index = fergSprayer.NUM_SPRAYTYPES};
          desc.litersPerSqmPerSecond = litersPerSqmPerSecond;
  
  
          fergSprayer.sprayTypes[name] = desc;
          fergSprayer.sprayTypeIndexToDesc[fergSprayer.NUM_SPRAYTYPES] = desc;
  
          local fillType = Fillable.registerFillType(name, nameI18N, pricePerLiter, partOfEconomy, hudOverlayFilename)
          fergSprayer.sprayTypeToFillType[fergSprayer.NUM_SPRAYTYPES] = fillType;
          fergSprayer.fillTypeToSprayType[fillType] = fergSprayer.NUM_SPRAYTYPES;
      end;
end;
  
function fergSprayer.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;
  
function fergSprayer:load(xmlFile)
  
      assert(self.setIsTurnedOn == nil, "fergSprayer needs to be the first specialization which implements setIsTurnedOn");
      self.setIsTurnedOn = fergSprayer.setIsTurnedOn;
      self.getIsTurnedOnAllowed = fergSprayer.getIsTurnedOnAllowed;
  
      assert(self.setIsSprayerFilling == nil, "fergSprayer needs to be the first specialization which implements setIsSprayerFilling");
      self.setIsSprayerFilling = fergSprayer.setIsSprayerFilling;
      self.addSprayerFillTrigger = fergSprayer.addSprayerFillTrigger;
      self.removeSprayerFillTrigger = fergSprayer.removeSprayerFillTrigger;
  
      self.fillLitersPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillLitersPerSecond"), 500);
      self.isSprayerFilling = false;
  
      self.isSprayerTank = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.sprayer#isTank"), false);
      self.allowsSpraying = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.sprayer#allowsSpraying"), true);
  
      self.sprayLitersPerSecond = {};
      local i=0;
      while true do
          local key = string.format("vehicle.sprayUsages.sprayUsage(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local fillType = getXMLString(xmlFile, key.. "#fillType");
          local litersPerSecond = getXMLFloat(xmlFile, key.. "#litersPerSecond");
          if fillType ~= nil and litersPerSecond ~= nil then
              local fillTypeInt = Fillable.fillTypeNameToInt[fillType];
              if fillTypeInt ~= nil then
                  self.sprayLitersPerSecond[fillTypeInt] = litersPerSecond;
                  if self.defaultSprayLitersPerSecond == nil then
                      self.defaultSprayLitersPerSecond = litersPerSecond;
                  end;
              else
                  print("Warning: Invalid spray usage fill type '"..fillType.."' in '" .. self.configFileName.. "'");
              end;
          end;
          i = i+1;
      end;
      if self.defaultSprayLitersPerSecond == nil then
          if self.allowsSpraying then
              print("Warning: No spray usage specified for '" .. self.configFileName.. "'. This sprayer will not use any spray.");
          end
          self.defaultSprayLitersPerSecond = 0;
      end;
  
      self.lastSprayValveUpdateFoldTime = nil;
      self.sprayValves = {};
  
      if self.isClient then
          local psFile = getXMLString(xmlFile, "vehicle.sprayParticleSystem#file");
          if psFile ~= nil then
              local i=0;
              while true do
                  local baseName = string.format("vehicle.sprayValves.sprayValve(%d)", i);
                  local node = getXMLString(xmlFile, baseName.. "#index");
                  if node == nil then
                      break;
                  end;
                  node = Utils.indexToObject(self.components, node);
                  if node ~= nil then
                      local sprayValve = {};
                      sprayValve.particleSystems = {};
                      Utils.loadParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.sprayParticleSystem", node, false, nil, self.baseDirectory);
  
                      sprayValve.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#foldMinLimit"), 0);
                      sprayValve.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#foldMaxLimit"), 1);
  
                      table.insert(self.sprayValves, sprayValve);
                  end;
                  i = i+1;
              end;
          end;
  
          local spraySound = getXMLString(xmlFile, "vehicle.spraySound#file");
          if spraySound ~= nil and spraySound ~= "" then
              spraySound = Utils.getFilename(spraySound, self.baseDirectory);
              self.spraySound = createSample("spraySound");
              self.spraySoundEnabled = false;
              loadSample(self.spraySound, spraySound, false);
              self.spraySoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.spraySound#pitchOffset"), 1);
              self.spraySoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.spraySound#volume"), 1);
              setSamplePitch(self.spraySound, self.spraySoundPitchOffset);
          end;
      end;
  
  
  	self.turnedOnRotationNodes = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.turnedOnRotationNodes.turnedOnRotationNode(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key.."#rotSpeed"), 1)*0.001);
          if node ~= nil then
              table.insert(self.turnedOnRotationNodes, {node=node, rotSpeed=rotSpeed});
          end;
          i = i + 1;
      end;
  
      self.sprayerFillTriggers = {};
      self.sprayerFillActivatable = SprayerFillActivatable:new(self);
  
      self.showFieldNotOwnedWarning = false;
  
      self.isTurnedOn = false;
      self.speedViolationMaxTime = 1000;
      self.speedViolationTimer = self.speedViolationMaxTime;
  
      self.sprayerDirtyFlag = self:getNextDirtyFlag();
	  
  	self.setTransRot = SpecializationUtil.callSpecializationsFunction("setTransRot");
	self.TransRotAnimation = getXMLString(xmlFile, "vehicle.TransRot#animationName");
	self.TransRot = false;
    self.rotatingPartsAnimTime = 0;
  
    self.rotatingParts = {};
    local i=0;
    while true do
          local baseName = string.format("vehicle.rotatingParts.rotatingPart(%d)", i);
          if not hasXMLProperty(xmlFile, baseName) then
              break;
          end;
          local entry = {};
          entry.node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. "#node"));
          entry.speed = Utils.getNoNil(getXMLFloat(xmlFile, baseName.. "#speed"), 0.005);
          if entry.node ~= nil then
              table.insert(self.rotatingParts, entry);
          end;
          i = i+1;
    end;
    self.chainUVScrollParts = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.chainUVScrollParts.chainUVScrollPart(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.chainUVScrollParts, {node=node, speed=speed});
        end;
        i = i +1;
    end;
end;
  
function fergSprayer:delete()
  
      g_currentMission:removeActivatableObject(self.sprayerFillActivatable);
  
      for k,sprayValve in pairs(self.sprayValves) do
          Utils.deleteParticleSystem(sprayValve.particleSystems);
      end;
  
      if self.spraySound ~= nil then
          delete(self.spraySound);
          self.spraySoundEnabled = false;
      end;
end;
  
function fergSprayer:readStream(streamId, connection)
      local turnedOn = streamReadBool(streamId);
      local isSprayerFilling = streamReadBool(streamId);
      self:setIsTurnedOn(turnedOn, true);
      self:setIsSprayerFilling(isSprayerFilling, true);
    self:setTransRot(streamReadBool(streamId), true);
end;
  
function fergSprayer:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isTurnedOn);
      streamWriteBool(streamId, self.isSprayerFilling);
    streamWriteBool(streamId, self.TransRot);
end;
  
function fergSprayer:readUpdateStream(streamId, timestamp, connection)
      if connection:getIsServer() then
          self.showFieldNotOwnedWarning = streamReadBool(streamId);
      end;
end;
  
function fergSprayer:writeUpdateStream(streamId, connection, dirtyMask)
      if not connection:getIsServer() then
          streamWriteBool(streamId, self.showFieldNotOwnedWarning);
      end;
end;
  
function fergSprayer:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function fergSprayer:keyEvent(unicode, sym, modifier, isDown)
end;
  
function fergSprayer:update(dt)
  
      if self.isClient then
          if self.allowsSpraying and self:getIsActiveForInput() then
              -- if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
                  -- self:setIsTurnedOn(not self.isTurnedOn);
              -- end;
          end;
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setTransRot(not self.isTransRotOn);
			end;
		end;
      end;
  
end;
  
function fergSprayer:updateTick(dt)
  	if self:getIsActive() then
		if self.isTransRotOn and self.movingDirection > 0 and self:getIsTurnedOnAllowed(true) then
			self:setIsTurnedOn(true);
		else
			self:setIsTurnedOn(false);
		end;	
		if self.isTurnedOn and self.movingDirection > 0 and self.isTransRotOn then
			  -- update rotatingParts
			  self.rotatingPartsAnimTime = self.rotatingPartsAnimTime + dt;
			  for _, rotatingPart in ipairs(self.rotatingParts) do
				  setRotation(rotatingPart.node, rotatingPart.speed*self.rotatingPartsAnimTime, 0, 0);
			  end;
		end;
	end;
      if self:getIsActive() then
          local showFieldNotOwnedWarning = false;
          if self.isTurnedOn then
              if not self:getIsTurnedOnAllowed(true) then
                  self:setIsTurnedOn(false);
              end;
          end
          if self.isTurnedOn and self.allowsSpraying then
  
              if self.isClient then
                  -- update valve particle systems
                  local foldAnimTime = self.foldAnimTime;
                  if foldAnimTime ~= nil and foldAnimTime ~= self.lastSprayValveUpdateFoldTime then
                      self.lastSprayValveUpdateFoldTime = foldAnimTime;
                      for _,sprayValve in pairs(self.sprayValves) do
                          Utils.setEmittingState(sprayValve.particleSystems, foldAnimTime <= sprayValve.foldMaxLimit and foldAnimTime >= sprayValve.foldMinLimit);
                      end
                  end
              end
  
              self.lastSprayingArea = 0;
  
              if self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31 then
                  self.speedViolationTimer = self.speedViolationTimer - dt;
              else
                  self.speedViolationTimer = self.speedViolationMaxTime;
              end;
  
              if self.isServer then
                  if self.speedViolationTimer > 0 then
                      local litersPerSecond = self.sprayLitersPerSecond[self.currentFillType];
                      if litersPerSecond == nil then
                          litersPerSecond = self.defaultSprayLitersPerSecond;
                      end
                      local usage = litersPerSecond * dt*0.001;
  
                      local hasSpray = false;
  
                      if self.capacity == 0 or self:getIsHired() then
                          hasSpray = true;
                          local fillType = self.currentFillType;
                          if fillType == Fillable.FILLTYPE_UNKNOWN then
                              fillType = self:getFirstEnabledFillType();
                          end
                          local fillTypeDesc = Fillable.fillTypeIndexToDesc[fillType];
                          if fillTypeDesc ~= nil then
                              local delta = usage*fillTypeDesc.pricePerLiter
                              g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + delta;
                              g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + delta;
  
                              g_currentMission:addSharedMoney(-delta, "other");
  
                              -- TODO update spray stats
                              --[[g_currentMission.missionStats.sprayUsageTotal = g_currentMission.missionStats.sprayUsageTotal + usage;
                              g_currentMission.missionStats.sprayUsageSession = g_currentMission.missionStats.sprayUsageSession + usage;]]
                          end;
                      else
                          if self.fillLevel > 0 then
                              hasSpray = true;
                              self:setFillLevel(self.fillLevel - usage, self.currentFillType);
                          else
                              -- try to find another attached sprayer
                              local fillType = self.currentFillType;
                              if fillType == Fillable.FILLTYPE_UNKNOWN then
                                  fillType = self:getFirstEnabledFillType();
                              end
                              local sprayerTank = fergSprayer.findAttachedSprayerTank(self:getRootAttacherVehicle(), fillType);
                              if sprayerTank ~= nil then
                                  hasSpray = true;
                                  sprayerTank:setFillLevel(sprayerTank:getFillLevel(fillType) - usage, fillType);
                              end
                          end;
                      end;
  
                      if hasSpray then
                          local cuttingAreasSend = {};
                          for _,cuttingArea in pairs(self.cuttingAreas) do
                              if self:getIsAreaActive(cuttingArea) then
                                  local x,_,z = getWorldTranslation(cuttingArea.start);
                                  if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
                                      local x1,_,z1 = getWorldTranslation(cuttingArea.width);
                                      local x2,_,z2 = getWorldTranslation(cuttingArea.height);
  
                                      local sqm = math.abs((z1-z)*(x2-x) - (x1-x)*(z2-z)); -- this is the cross product with y=0
  
                                      --Utils.updateSprayArea(x, z, x1, z1, x2, z2);
  
                                      self.lastSprayingArea = self.lastSprayingArea + sqm;
  
                                      table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                                  else
                                      showFieldNotOwnedWarning = true;
                                  end
                              end;
                          end;
                          if (table.getn(cuttingAreasSend) > 0) then
                              SprayerAreaEvent.runLocally(cuttingAreasSend);
                              g_server:broadcastEvent(SprayerAreaEvent:new(cuttingAreasSend));
                          end;
                      end;
                  end;
              end;
  
              if self.isClient then
                  if not self.spraySoundEnabled and self.spraySound ~= nil and self:getIsActiveForSound() then
                      playSample(self.spraySound, 0, self.spraySoundVolume, 0);
                      self.spraySoundEnabled = true;
                  end;
              end;
  
              for _, node in pairs(self.turnedOnRotationNodes) do
                  rotate(node.node, 0, -dt*node.rotSpeed, 0);
              end
          else
              self.speedViolationTimer = self.speedViolationMaxTime;
          end;
  
          if self.isServer then
              if showFieldNotOwnedWarning ~= self.showFieldNotOwnedWarning then
                  self.showFieldNotOwnedWarning = showFieldNotOwnedWarning;
                  self:raiseDirtyFlags(self.sprayerDirtyFlag);
              end
          end
      end;
  
      if self.isServer and self.isSprayerFilling then
          local delta = 0;
          if self.sprayerFillTrigger ~= nil then
              delta = self.fillLitersPerSecond*dt*0.001;
              delta = self.sprayerFillTrigger:fillSprayer(self, delta);
          end
  
          if delta <= 0 then
              self:setIsSprayerFilling(false);
          end;
      end
end;
  
function fergSprayer:draw()
  
      if self.isClient then
          if self:getIsActiveForInput(true) then
              if not self:getIsTurnedOnAllowed(true) and self.fillLevel <= 0 then
                  g_currentMission:addExtraPrintText(g_i18n:getText("FirstFillTheTool"));
              end;
        if not self.isTransRotOn then
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Engage"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
        else
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Disengage"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
        end;

          end
  
          if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
              g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2"), 0.07+0.022, 0.019+0.029);
          elseif self.showFieldNotOwnedWarning then
              g_currentMission:addWarning(g_i18n:getText("You_dont_own_this_field"));
          end;
      end;
end;
  
function fergSprayer:onDetach()
      if self.deactivateOnDetach then
          fergSprayer.onDeactivate(self);
      else
          fergSprayer.onDeactivateSounds(self);
      end;
end;
  
function fergSprayer:onLeave()
      if self.deactivateOnLeave then
          fergSprayer.onDeactivate(self);
      else
          fergSprayer.onDeactivateSounds(self);
      end;
end;
  
function fergSprayer:onDeactivate()
      self.speedViolationTimer = self.speedViolationMaxTime;
      self.showFieldNotOwnedWarning = false;
      self:setIsTurnedOn(false, true)
      fergSprayer.onDeactivateSounds(self);
      for _, part in pairs(self.chainUVScrollParts) do
          setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
      end;
end;
  
function fergSprayer:onDeactivateSounds()
      if self.spraySoundEnabled then
          stopSample(self.spraySound);
          self.spraySoundEnabled = false;
      end;
end;
  
function fergSprayer:getIsTurnedOnAllowed(isTurnedOn)
      if not isTurnedOn or self.fillLevel > 0 or self.capacity == 0 or self:getIsHired() then
          return true;
      end;
      -- try to find tank
      local fillType = self.currentFillType;
      if fillType == Fillable.FILLTYPE_UNKNOWN then
          fillType = self:getFirstEnabledFillType();
      end
      local sprayerTank = fergSprayer.findAttachedSprayerTank(self:getRootAttacherVehicle(), fillType);
      if sprayerTank ~= nil then
          return true;
      end
  
      return false;
end;
  
function fergSprayer:setIsTurnedOn(isTurnedOn, noEventSend)
      if isTurnedOn ~= self.isTurnedOn then
          if self:getIsTurnedOnAllowed(isTurnedOn) then
              SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend)
  
              self.isTurnedOn = isTurnedOn;
              if self.isClient then
                  self.lastSprayValveUpdateFoldTime = nil;
                  if not self.isTurnedOn or self.foldAnimTime == nil then
                      -- If the sprayer is foldable, the spray valves are only turned on within the update loop
                      for _,sprayValve in pairs(self.sprayValves) do
                          Utils.setEmittingState(sprayValve.particleSystems, self.isTurnedOn);
                      end
                  end
  
                  if not self.isTurnedOn and self.spraySoundEnabled then
                      stopSample(self.spraySound);
                      self.spraySoundEnabled = false;
                  end;
              end;
              self.speedViolationTimer = self.speedViolationMaxTime;
          end;
      end;
      for _, part in pairs(self.chainUVScrollParts) do
  		if self.isTurnedOn then
			setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
  		else
  			setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
  		end;
      end;
end;
  
function fergSprayer:setIsSprayerFilling(isFilling, noEventSend)
      SprayerSetIsFillingEvent.sendEvent(self, isFilling, noEventSend)
      if self.isSprayerFilling ~= isFilling then
          self.isSprayerFilling = isFilling;
          if isFilling then
              -- find the first trigger which is activable
              self.sprayerFillTrigger = nil;
              for i=1, table.getn(self.sprayerFillTriggers) do
                  local trigger = self.sprayerFillTriggers[i];
                  if trigger:getIsActivatable(self) then
                      self.sprayerFillTrigger = trigger;
                      break;
                  end;
              end;
          end
      end;
end;
  
function fergSprayer:addSprayerFillTrigger(trigger)
      if table.getn(self.sprayerFillTriggers) == 0 then
          g_currentMission:addActivatableObject(self.sprayerFillActivatable);
      end;
      table.insert(self.sprayerFillTriggers, trigger);
end;
  
function fergSprayer:removeSprayerFillTrigger(trigger)
      for i=1, table.getn(self.sprayerFillTriggers) do
          if self.sprayerFillTriggers[i] == trigger then
              table.remove(self.sprayerFillTriggers, i);
              break;
          end;
      end;
      if table.getn(self.sprayerFillTriggers) == 0 or trigger == self.sprayerFillTrigger then
          if self.isServer then
              self:setIsSprayerFilling(false);
          end;
          if table.getn(self.sprayerFillTriggers) == 0 then
              g_currentMission:removeActivatableObject(self.sprayerFillActivatable);
          end
      end;
end;
  
function fergSprayer.findAttachedSprayerTank(currentVehicle, fillType)
      if currentVehicle.isSprayerTank and currentVehicle.getFillLevel ~= nil and currentVehicle.setFillLevel ~= nil and currentVehicle:getFillLevel(fillType) > 0 then
          return currentVehicle;
      end
      for _,implement in pairs(currentVehicle.attachedImplements) do
          if implement.object ~= nil then
              local ret = fergSprayer.findAttachedSprayerTank(implement.object, fillType);
              if ret ~= nil then
                  return ret;
              end
          end
      end
      return nil;
end
  
  SprayerFillActivatable = {}
  local SprayerFillActivatable_mt = Class(SprayerFillActivatable);
  
function SprayerFillActivatable:new(sprayer)
      local self = {};
      setmetatable(self, SprayerFillActivatable_mt);
  
      self.sprayer = sprayer;
      self.activateText = "unknown";
  
      return self;
end;
  
  
function SprayerFillActivatable:getIsActivatable()
      if self.sprayer:getIsActiveForInput() and self.sprayer.fillLevel < self.sprayer.capacity then
          -- find the first trigger which is activable
          for i=1, table.getn(self.sprayer.sprayerFillTriggers) do
              local trigger = self.sprayer.sprayerFillTriggers[i];
              if trigger:getIsActivatable(self.sprayer) then
                  self:updateActivateText();
                  return true;
              end;
          end;
      end
      return false;
end;
  
function SprayerFillActivatable:onActivateObject()
      self.sprayer:setIsSprayerFilling(not self.sprayer.isSprayerFilling);
      self:updateActivateText();
      g_currentMission:addActivatableObject(self);
end;
  
function SprayerFillActivatable:drawActivate()
      -- TODO draw icon
end;
  
function SprayerFillActivatable:updateActivateText()
      if self.sprayer.isSprayerFilling then
          self.activateText = string.format(g_i18n:getText("stop_refill_OBJECT"), self.sprayer.typeDesc);
      else
          self.activateText = string.format(g_i18n:getText("refill_OBJECT"), self.sprayer.typeDesc);
      end;
end;
  
   
function fergSprayer:setTransRot(isTransRot,noEventSend)
	SetTransRotEvent.sendEvent(self, isTransRot, noEventSend);
	-- Play TransRot animation --
	self.isTransRotOn = isTransRot;
	if self.isTransRotOn then
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, 1, nil, true);
			self.TransRot = true;
		end;
	else
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, -1, nil, true);
			self.TransRot = false;
		end;
	end;	
end
