--
-- henly 20 (Ls_uk Modteam)
-- 28.11.2010
--
-- > www.LS-UK.info

dropbed = {};

function dropbed.prerequisitesPresent(specializations)
    return true;
end;

function dropbed:load(xmlFile)

	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	self.setRotationMax1 = SpecializationUtil.callSpecializationsFunction("setRotationMax1");
	
	local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
		if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;	

	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;

end;

function dropbed:delete()
end;

function dropbed:readStream(streamId, connection)
      if self.rotationPart1 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
          setRotation(self.rotationPart1.node, x, y, z);
      end;
end;

function dropbed:writeStream(streamId, connection)
	  streamWriteBool(streamId, self.rotateMax1);
		if self.rotationPart1 ~= nil then
          local x, y, z = getRotation(self.rotationPart1.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function dropbed:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dropbed:keyEvent(unicode, sym, modifier, isDown)
end;

function dropbed:update(dt)

      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				self:setRotationMax1(not self.rotationMax1);
          end;
      end;

end;

function dropbed:updateTick(dt)
	if self:getIsActive() then

		if self.rotationPart1 ~= nil then
			local x, y, z = getRotation(self.rotationPart1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart1.maxRot, self.rotationPart1.minRot, 3, self.rotationPart1.rotTime, dt, not self.rotationMax1);
			setRotation(self.rotationPart1.node, unpack(newRot));
		end;
				
		for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;		
		self.setHydraulicTime = 30;	


		if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
		end;
	end;
	
end;

function dropbed:draw()
	if self:getIsActive() then
		if self.rotationMax1 then	
			g_currentMission:addHelpButtonText(g_i18n:getText("raise_trailer"), InputBinding.LOWER_IMPLEMENT);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("lower_trailer"), InputBinding.LOWER_IMPLEMENT);
		end;
	end;
end;

function dropbed:setRotationMax1(rotationMax1, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetRotationEvent:new(self, rotationMax1), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetRotationEvent:new(self, rotationMax1));
          end;
      end;
      self.rotationMax1 = rotationMax1;
end;

function dropbed:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;


function dropbed:validateAttacherJoint(implement, jointDesc, dt)
        return true;

end;

function dropbed:onDetach()

end;

function dropbed:onAttach(attacherVehicle)

end;

SetRotationEvent = {};
SetRotationEvent_mt = Class(SetRotationEvent, Event);
 
InitEventClass(SetRotationEvent, "SetRotationEvent");

function SetRotationEvent:emptyNew()
      local self = Event:new(SetRotationEvent_mt);
      self.className="SetRotationEvent";
      return self;
end;
 
function SetRotationEvent:new(object, rotationMax1)
     local self = SetRotationEvent:emptyNew()
     self.object = object;
     self.rotationMax1 = rotationMax1;
      return self;
end;

function SetRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
     self.rotationMax1 = streamReadBool(streamId);
     self.object = networkGetObject(id);
      self:run(connection);
end;
 
function SetRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax1);
end;

function SetRotationEvent:run(connection)
     self.object:setRotationMax1(self.rotationMax1, true);
     if not connection:getIsServer() then
          g_server:broadcastEvent(SetRotationEvent:new(self.object, self.rotationMax1), nil, connection, self.object);
     end;
end;
